<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if logged in and is admin
if (!isset($_SESSION['user_id']) || $_SESSION['role_code'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

require_once dirname(__DIR__, 1) . '/includes/con_database.php';

$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="lo" data-theme="dark">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?= $page_title ?? 'Admin' ?> - EPCommerce
    </title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        :root {
            --primary: #001E3F;
            --primary-light: #003366;
            --primary-dark: #001529;
            --accent: #4A90D9;
            --accent-light: #6BA3E0;
            --accent-soft: #2D5A87;

            --light-bg: #F5F7FA;
            --light-card: #FFFFFF;
            --light-text: #1A1A2E;
            --light-text-secondary: #5A6370;
            --light-border: #E1E5EB;

            --dark-bg: #001E3F;
            --dark-bg-secondary: #00152B;
            --dark-card: rgba(255, 255, 255, 0.05);
            --dark-text: #FFFFFF;
            --dark-text-secondary: rgba(255, 255, 255, 0.7);
            --dark-border: rgba(255, 255, 255, 0.1);

            --success: #28A745;
            --warning: #FFC107;
            --danger: #DC3545;
            --info: #17A2B8;
        }

        [data-theme="dark"] {
            --bg-primary: var(--dark-bg);
            --bg-secondary: var(--dark-bg-secondary);
            --card-bg: var(--dark-card);
            --text-primary: var(--dark-text);
            --text-secondary: var(--dark-text-secondary);
            --border-color: var(--dark-border);
            --sidebar-bg: var(--dark-bg-secondary);
        }

        [data-theme="light"] {
            --bg-primary: var(--light-bg);
            --bg-secondary: #E8ECF1;
            --card-bg: var(--light-card);
            --text-primary: var(--light-text);
            --text-secondary: var(--light-text-secondary);
            --border-color: var(--light-border);
            --sidebar-bg: var(--primary);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Noto Sans Lao', sans-serif;
            background: var(--bg-primary);
            color: var(--text-primary);
            min-height: 100vh;
            transition: all 0.3s ease;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            width: 260px;
            height: 100vh;
            background: var(--sidebar-bg);
            border-right: 1px solid var(--border-color);
            z-index: 100;
            transition: all 0.3s ease;
        }

        .sidebar.collapsed {
            width: 70px;
        }

        .sidebar.collapsed .sidebar-brand,
        .sidebar.collapsed .menu-label,
        .sidebar.collapsed .menu-item a span,
        .sidebar.collapsed .submenu,
        .sidebar.collapsed .menu-arrow {
            display: none;
        }

        .sidebar.collapsed .sidebar-header {
            justify-content: center;
            padding: 15px;
        }

        .sidebar.collapsed .sidebar-logo {
            width: 40px;
            height: 40px;
        }

        .sidebar.collapsed .menu-item>a {
            justify-content: center;
            padding: 12px;
        }

        .sidebar.collapsed .menu-item a i {
            width: auto;
            font-size: 18px;
        }

        /* Sidebar Toggle Button */
        .sidebar-toggle {
            position: absolute;
            right: -14px;
            top: 35px;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            background: var(--accent);
            border: 3px solid var(--bg-primary);
            color: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 11px;
            transition: all 0.3s ease;
            z-index: 101;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        .sidebar-toggle:hover {
            background: var(--accent-light);
            transform: scale(1.15);
        }

        .sidebar.collapsed .sidebar-toggle {
            top: 32px;
        }

        .sidebar.collapsed .sidebar-toggle i {
            transform: rotate(180deg);
        }

        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .sidebar-logo {
            width: 45px;
            height: 45px;
            background: linear-gradient(135deg, var(--accent), var(--accent-soft));
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
        }

        .sidebar-brand {
            color: white;
        }

        .sidebar-brand h2 {
            font-size: 18px;
            font-weight: 700;
        }

        .sidebar-brand span {
            font-size: 11px;
            color: rgba(255, 255, 255, 0.6);
        }

        .sidebar-menu {
            padding: 15px 0;
            list-style: none;
            overflow-y: auto;
            height: calc(100vh - 85px);
        }

        .menu-label {
            padding: 10px 20px;
            font-size: 11px;
            text-transform: uppercase;
            color: rgba(255, 255, 255, 0.4);
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        .menu-item {
            margin: 2px 10px;
        }

        .menu-item>a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 15px;
            color: rgba(255, 255, 255, 0.7);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s ease;
            font-size: 14px;
        }

        .menu-item>a:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
        }

        .menu-item>a.active {
            background: var(--accent);
            color: white;
        }

        .menu-item a i {
            width: 20px;
            text-align: center;
        }

        .menu-arrow {
            margin-left: auto;
            transition: transform 0.3s ease;
        }

        .menu-item.open .menu-arrow {
            transform: rotate(90deg);
        }

        /* Submenu */
        .submenu {
            display: none;
            list-style: none;
            padding-left: 15px;
            margin-top: 5px;
        }

        .menu-item.open .submenu {
            display: block;
        }

        .submenu li a {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px 15px;
            color: rgba(255, 255, 255, 0.6);
            text-decoration: none;
            font-size: 13px;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .submenu li a:hover {
            color: white;
            background: rgba(255, 255, 255, 0.05);
        }

        .submenu li a.active {
            color: var(--accent);
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            min-height: 100vh;
            transition: all 0.3s ease;
        }

        body.sidebar-collapsed .main-content {
            margin-left: 70px;
        }

        /* Top Header */
        .top-header {
            position: sticky;
            top: 0;
            background: var(--bg-primary);
            border-bottom: 1px solid var(--border-color);
            padding: 15px 25px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            z-index: 50;
        }

        .page-title {
            font-size: 20px;
            font-weight: 600;
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .theme-toggle {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            color: var(--text-primary);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }

        .theme-toggle:hover {
            background: var(--accent);
            color: white;
        }

        .user-dropdown {
            position: relative;
        }

        .user-btn {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 8px 15px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 10px;
            color: var(--text-primary);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .user-btn:hover {
            border-color: var(--accent);
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            border-radius: 8px;
            background: var(--accent);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 14px;
        }

        .user-info {
            text-align: left;
        }

        .user-info .name {
            font-size: 13px;
            font-weight: 600;
        }

        .user-info .role {
            font-size: 11px;
            color: var(--text-secondary);
        }

        .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            margin-top: 8px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 10px;
            min-width: 180px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            display: none;
            overflow: hidden;
        }

        .dropdown-menu.show {
            display: block;
        }

        .dropdown-menu a {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 15px;
            color: var(--text-primary);
            text-decoration: none;
            font-size: 13px;
            transition: all 0.3s ease;
        }

        .dropdown-menu a:hover {
            background: var(--accent);
            color: white;
        }

        .dropdown-menu a.danger {
            color: var(--danger);
        }

        .dropdown-menu a.danger:hover {
            background: var(--danger);
            color: white;
        }

        /* Content Area */
        .content {
            padding: 25px;
        }

        /* Cards */
        .card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            overflow: hidden;
        }

        .card-header {
            padding: 18px 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .card-title {
            font-size: 16px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .card-body {
            padding: 20px;
        }

        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 18px;
            border: none;
            border-radius: 8px;
            font-size: 13px;
            font-weight: 500;
            font-family: inherit;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--accent), var(--accent-soft));
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(74, 144, 217, 0.3);
        }

        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 25px;
        }

        .stat-card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .stat-icon {
            width: 55px;
            height: 55px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 22px;
            color: white;
        }

        .stat-icon.blue {
            background: linear-gradient(135deg, #4A90D9, #2D5A87);
        }

        .stat-icon.green {
            background: linear-gradient(135deg, #28A745, #1E7B33);
        }

        .stat-icon.orange {
            background: linear-gradient(135deg, #FD7E14, #E06B10);
        }

        .stat-icon.purple {
            background: linear-gradient(135deg, #6C7AE0, #4A5BC7);
        }

        .stat-info h3 {
            font-size: 24px;
            font-weight: 700;
        }

        .stat-info p {
            font-size: 13px;
            color: var(--text-secondary);
        }

        /* Modal */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.6);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 1000;
        }

        .modal-overlay.show {
            display: flex;
        }

        .modal {
            background: var(--bg-primary);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            width: 100%;
            max-width: 550px;
            max-height: 90vh;
            overflow-y: auto;
        }

        .modal-header {
            padding: 18px 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .modal-title {
            font-size: 18px;
            font-weight: 600;
        }

        .modal-close {
            width: 35px;
            height: 35px;
            border: none;
            background: var(--card-bg);
            border-radius: 8px;
            color: var(--text-primary);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .modal-close:hover {
            background: var(--danger);
            color: white;
        }

        .modal-body {
            padding: 20px;
        }

        .modal-footer {
            padding: 15px 20px;
            border-top: 1px solid var(--border-color);
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        /* Forms */
        .form-group {
            margin-bottom: 18px;
        }

        .form-label {
            display: block;
            font-size: 13px;
            font-weight: 500;
            color: var(--text-secondary);
            margin-bottom: 8px;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 8px;
            color: var(--text-primary);
            font-size: 14px;
            font-family: inherit;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--accent);
            box-shadow: 0 0 0 3px rgba(74, 144, 217, 0.15);
        }

        /* Responsive */
        @media (max-width: 991px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }
        }
    </style>
</head>

<body>
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <button class="sidebar-toggle" onclick="toggleSidebar()" title="ພັບ/ຂະຫຍາຍເມນູ">
            <i class="fas fa-chevron-left"></i>
        </button>
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <i class="fas fa-store"></i>
            </div>
            <div class="sidebar-brand">
                <h2>EPCommerce</h2>
                <span>Admin Panel</span>
            </div>
        </div>

        <ul class="sidebar-menu">
            <li class="menu-item">
                <a href="dashboard.php" class="<?= $current_page === 'dashboard' ? 'active' : '' ?>">
                    <i class="fas fa-home"></i>
                    <span>ໜ້າຫຼັກ</span>
                </a>
            </li>

            <li class="menu-item <?= in_array($current_page, ['products', 'categories', 'units']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-edit"></i>
                    <span>ປ້ອນຂໍ້ມູນ</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="products.php" class="<?= $current_page === 'products' ? 'active' : '' ?>"><i
                                class="fas fa-box"></i> ສິນຄ້າ</a></li>
                    <li><a href="categories.php" class="<?= $current_page === 'categories' ? 'active' : '' ?>"><i
                                class="fas fa-tags"></i> ປະເພດສິນຄ້າ</a></li>
                    <li><a href="units.php" class="<?= $current_page === 'units' ? 'active' : '' ?>"><i
                                class="fas fa-balance-scale"></i> ໜ່ວຍນັບ</a></li>
                </ul>
            </li>

            <li class="menu-item <?= in_array($current_page, ['add_stock', 'add_customer']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-plus-circle"></i>
                    <span>ເພີ່ມຂໍ້ມູນ</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="add_stock.php" class="<?= $current_page === 'add_stock' ? 'active' : '' ?>"><i
                                class="fas fa-boxes"></i> ເພີ່ມສະຕ໊ອກ</a></li>
                    <li><a href="add_customer.php" class="<?= $current_page === 'add_customer' ? 'active' : '' ?>"><i
                                class="fas fa-user-plus"></i> ເພີ່ມລູກຄ້າ</a></li>
                </ul>
            </li>

            <li
                class="menu-item <?= in_array($current_page, ['report_sales', 'report_stock', 'report_customer']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-chart-bar"></i>
                    <span>ສະຫຼຸບຂໍ້ມູນ</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="report_sales.php" class="<?= $current_page === 'report_sales' ? 'active' : '' ?>"><i
                                class="fas fa-file-invoice-dollar"></i> ລາຍງານຂາຍ</a></li>
                    <li><a href="report_stock.php" class="<?= $current_page === 'report_stock' ? 'active' : '' ?>"><i
                                class="fas fa-warehouse"></i> ລາຍງານສະຕ໊ອກ</a></li>
                    <li><a href="report_customer.php"
                            class="<?= $current_page === 'report_customer' ? 'active' : '' ?>"><i
                                class="fas fa-users"></i> ລາຍງານລູກຄ້າ</a></li>
                </ul>
            </li>

            <li class="menu-item <?= in_array($current_page, ['create_order', 'order_history']) ? 'open' : '' ?>">
                <a href="#" onclick="toggleSubmenu(this); return false;">
                    <i class="fas fa-file-alt"></i>
                    <span>ສ້າງລາຍການສັ່ງຊື້</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <ul class="submenu">
                    <li><a href="create_order.php" class="<?= $current_page === 'create_order' ? 'active' : '' ?>"><i
                                class="fas fa-cart-plus"></i> ສ້າງລາຍການໃໝ່</a></li>
                    <li><a href="order_history.php" class="<?= $current_page === 'order_history' ? 'active' : '' ?>"><i
                                class="fas fa-history"></i> ປະຫວັດການສັ່ງ</a></li>
                </ul>
            </li>

            <li class="menu-item" style="margin-top: auto;">
                <a href="settings.php" class="<?= $current_page === 'settings' ? 'active' : '' ?>">
                    <i class="fas fa-cog"></i>
                    <span>ການຕັ້ງຄ່າ</span>
                </a>
            </li>

            <li class="menu-item">
                <a href="../logout.php" class="danger">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>ອອກຈາກລະບົບ</span>
                </a>
            </li>
        </ul>
    </aside>

    <!-- Main Content -->
    <main class="main-content">
        <!-- Top Header -->
        <header class="top-header">
            <h1 class="page-title">
                <?= $page_title ?? 'Dashboard' ?>
            </h1>

            <div class="header-actions">
                <button class="theme-toggle" onclick="toggleTheme()" title="ສະຫຼັບໂໝດສີ">
                    <i class="fas fa-moon" id="theme-icon"></i>
                </button>

                <div class="user-dropdown">
                    <button class="user-btn" onclick="toggleDropdown()">
                        <div class="user-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="user-info">
                            <div class="name">
                                <?= htmlspecialchars($_SESSION['username'] ?? 'Admin') ?>
                            </div>
                            <div class="role">
                                <?= htmlspecialchars($_SESSION['role_name'] ?? 'Admin') ?>
                            </div>
                        </div>
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="dropdown-menu" id="userDropdown">
                        <a href="profile.php"><i class="fas fa-user-circle"></i> ໂປຣໄຟລ໌</a>
                        <a href="settings.php"><i class="fas fa-cog"></i> ຕັ້ງຄ່າ</a>
                        <a href="../logout.php" class="danger"><i class="fas fa-sign-out-alt"></i> ອອກຈາກລະບົບ</a>
                    </div>
                </div>
            </div>
        </header>

        <!-- Page Content -->
        <div class="content">