<?php
$page_title = 'Dashboard';
require_once 'includes/header.php';

// Get shop info for this admin
$shop_stmt = $pdo->prepare("
    SELECT s.* FROM shops s 
    INNER JOIN shop_users su ON s.shop_id = su.shop_id 
    WHERE su.user_id = ? AND su.is_active = 1 
    LIMIT 1
");
$shop_stmt->execute([$_SESSION['user_id']]);
$shop = $shop_stmt->fetch();

// Get statistics if shop exists
$stats = [
    'products' => 0,
    'orders' => 0,
    'customers' => 0,
    'revenue' => 0
];

if ($shop) {
    // Count products
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM products WHERE shop_id = ? AND deleted_at IS NULL");
    $stmt->execute([$shop['shop_id']]);
    $stats['products'] = $stmt->fetchColumn();

    // Add more stats queries as needed
}
?>

<!-- Stats Cards -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon blue">
            <i class="fas fa-box"></i>
        </div>
        <div class="stat-info">
            <h3>
                <?= number_format($stats['products']) ?>
            </h3>
            <p>ສິນຄ້າທັງໝົດ</p>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-icon green">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="stat-info">
            <h3>
                <?= number_format($stats['orders']) ?>
            </h3>
            <p>ອໍເດີ້ທັງໝົດ</p>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-icon orange">
            <i class="fas fa-users"></i>
        </div>
        <div class="stat-info">
            <h3>
                <?= number_format($stats['customers']) ?>
            </h3>
            <p>ລູກຄ້າທັງໝົດ</p>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-icon purple">
            <i class="fas fa-money-bill-wave"></i>
        </div>
        <div class="stat-info">
            <h3>
                <?= number_format($stats['revenue']) ?> ₭
            </h3>
            <p>ລາຍຮັບທັງໝົດ</p>
        </div>
    </div>
</div>

<!-- Shop Info -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-store"></i> ຂໍ້ມູນຮ້ານຄ້າ</h3>
    </div>
    <div class="card-body">
        <?php if ($shop): ?>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px;">
                <div>
                    <p style="color: var(--text-secondary); font-size: 13px;">ຊື່ຮ້ານ</p>
                    <p style="font-size: 16px; font-weight: 600;">
                        <?= htmlspecialchars($shop['shop_name']) ?>
                    </p>
                </div>
                <div>
                    <p style="color: var(--text-secondary); font-size: 13px;">ລະຫັດຮ້ານ</p>
                    <p style="font-size: 16px; font-weight: 600;">
                        <?= htmlspecialchars($shop['shop_code']) ?>
                    </p>
                </div>
                <div>
                    <p style="color: var(--text-secondary); font-size: 13px;">ເບີໂທ</p>
                    <p style="font-size: 16px; font-weight: 600;">
                        <?= htmlspecialchars($shop['phone'] ?? '-') ?>
                    </p>
                </div>
                <div>
                    <p style="color: var(--text-secondary); font-size: 13px;">ສະຖານະ</p>
                    <span class="status <?= $shop['status'] ?>">
                        <?= ucfirst($shop['status']) ?>
                    </span>
                </div>
            </div>
        <?php else: ?>
            <div style="text-align: center; padding: 40px; color: var(--text-secondary);">
                <i class="fas fa-store-slash" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i>
                <p>ທ່ານຍັງບໍ່ທັນເຊື່ອມຕໍ່ກັບຮ້ານຄ້າໃດ</p>
                <p style="font-size: 13px;">ກະລຸນາຕິດຕໍ່ Super Admin</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>