<?php
$page_title = 'ຈັດການຜູ້ໃຊ້';
require_once 'includes/header.php';

$message = '';
$error = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // Create User
    if ($action === 'create') {
        $username = trim($_POST['username'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $password = $_POST['password'] ?? '';
        $confirm_password = $_POST['confirm_password'] ?? '';
        $first_name = trim($_POST['first_name'] ?? '');
        $last_name = trim($_POST['last_name'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $role_id = intval($_POST['role_id'] ?? 0);
        $status = $_POST['status'] ?? 'pending';

        // Comprehensive Validation
        if (empty($username) || empty($email) || empty($password) || empty($role_id)) {
            $error = 'ກະລຸນາກຣອກຂໍ້ມູນທີ່ຈໍາເປັນໃຫ້ຄົບຖ້ວນ';
        } elseif (strlen($username) < 3) {
            $error = 'Username ຕ້ອງມີຢ່າງໜ້ອຍ 3 ຕົວອັກສອນ';
        } elseif (strlen($username) > 50) {
            $error = 'Username ຕ້ອງບໍ່ເກີນ 50 ຕົວອັກສອນ';
        } elseif (!preg_match('/^[a-zA-Z0-9_]+$/', $username)) {
            $error = 'Username ໃຊ້ໄດ້ສະເພາະ a-z, A-Z, 0-9 ແລະ _ ເທົ່ານັ້ນ';
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = 'ຮູບແບບ Email ບໍ່ຖືກຕ້ອງ';
        } elseif (strlen($password) < 8) {
            $error = 'Password ຕ້ອງມີຢ່າງໜ້ອຍ 8 ຕົວອັກສອນ';
        } elseif (!preg_match('/[A-Z]/', $password)) {
            $error = 'Password ຕ້ອງມີຕົວອັກສອນໃຫຍ່ຢ່າງໜ້ອຍ 1 ຕົວ (A-Z)';
        } elseif (!preg_match('/[a-z]/', $password)) {
            $error = 'Password ຕ້ອງມີຕົວອັກສອນນ້ອຍຢ່າງໜ້ອຍ 1 ຕົວ (a-z)';
        } elseif (!preg_match('/[0-9]/', $password)) {
            $error = 'Password ຕ້ອງມີຕົວເລກຢ່າງໜ້ອຍ 1 ຕົວ (0-9)';
        } elseif (!preg_match('/[!@#$%^&*(),.?":{}|<>]/', $password)) {
            $error = 'Password ຕ້ອງມີສັນຍາລັກພິເສດຢ່າງໜ້ອຍ 1 ຕົວ (!@#$%^&*...)';
        } elseif ($password !== $confirm_password) {
            $error = 'Password ບໍ່ກົງກັນ';
        } elseif (!empty($phone) && !preg_match('/^[0-9+\-\s]+$/', $phone)) {
            $error = 'ເບີໂທລະສັບບໍ່ຖືກຕ້ອງ';
        } else {
            // Check if username exists
            $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ? AND deleted_at IS NULL");
            $stmt->execute([$username]);
            if ($stmt->fetch()) {
                $error = 'Username ນີ້ຖືກໃຊ້ງານແລ້ວ';
            } else {
                // Check if email exists
                $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ? AND deleted_at IS NULL");
                $stmt->execute([$email]);
                if ($stmt->fetch()) {
                    $error = 'Email ນີ້ຖືກໃຊ້ງານແລ້ວ';
                } else {
                    // Verify role is valid
                    $stmt = $pdo->prepare("SELECT role_id FROM user_roles WHERE role_id = ?");
                    $stmt->execute([$role_id]);
                    if (!$stmt->fetch()) {
                        $error = 'ປະເພດຜູ້ໃຊ້ບໍ່ຖືກຕ້ອງ';
                    } else {
                        // Insert new user
                        try {
                            $hashed = password_hash($password, PASSWORD_DEFAULT);
                            $stmt = $pdo->prepare("
                                INSERT INTO users (username, email, password, first_name, last_name, phone, role_id, status)
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?)
                            ");
                            $stmt->execute([$username, $email, $hashed, $first_name, $last_name, $phone, $role_id, $status]);
                            $message = 'ສ້າງຜູ້ໃຊ້ສໍາເລັດ!';
                        } catch (PDOException $e) {
                            $error = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
                        }
                    }
                }
            }
        }
    }

    // Update User
    if ($action === 'update') {
        $user_id = intval($_POST['user_id'] ?? 0);
        $first_name = trim($_POST['first_name'] ?? '');
        $last_name = trim($_POST['last_name'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $role_id = intval($_POST['role_id'] ?? 0);
        $status = $_POST['status'] ?? 'pending';
        $new_password = $_POST['new_password'] ?? '';
        $confirm_new_password = $_POST['confirm_new_password'] ?? '';

        $has_error = false;

        // Validate phone if provided
        if (!empty($phone) && !preg_match('/^[0-9+\-\s]+$/', $phone)) {
            $error = 'ເບີໂທລະສັບບໍ່ຖືກຕ້ອງ';
            $has_error = true;
        }

        // Validate new password if provided
        if (!empty($new_password) && !$has_error) {
            if (strlen($new_password) < 8) {
                $error = 'Password ໃໝ່ຕ້ອງມີຢ່າງໜ້ອຍ 8 ຕົວອັກສອນ';
                $has_error = true;
            } elseif (!preg_match('/[A-Z]/', $new_password)) {
                $error = 'Password ໃໝ່ຕ້ອງມີຕົວອັກສອນໃຫຍ່ຢ່າງໜ້ອຍ 1 ຕົວ (A-Z)';
                $has_error = true;
            } elseif (!preg_match('/[a-z]/', $new_password)) {
                $error = 'Password ໃໝ່ຕ້ອງມີຕົວອັກສອນນ້ອຍຢ່າງໜ້ອຍ 1 ຕົວ (a-z)';
                $has_error = true;
            } elseif (!preg_match('/[0-9]/', $new_password)) {
                $error = 'Password ໃໝ່ຕ້ອງມີຕົວເລກຢ່າງໜ້ອຍ 1 ຕົວ (0-9)';
                $has_error = true;
            } elseif (!preg_match('/[!@#$%^&*(),.?":{}|<>]/', $new_password)) {
                $error = 'Password ໃໝ່ຕ້ອງມີສັນຍາລັກພິເສດຢ່າງໜ້ອຍ 1 ຕົວ (!@#$%^&*...)';
                $has_error = true;
            } elseif ($new_password !== $confirm_new_password) {
                $error = 'Password ໃໝ່ບໍ່ກົງກັນ';
                $has_error = true;
            }
        }

        if (!$has_error) {
            try {
                $sql = "UPDATE users SET first_name = ?, last_name = ?, phone = ?, role_id = ?, status = ?";
                $params = [$first_name, $last_name, $phone, $role_id, $status];

                if (!empty($new_password)) {
                    $sql .= ", password = ?";
                    $params[] = password_hash($new_password, PASSWORD_DEFAULT);
                }

                $sql .= " WHERE id = ?";
                $params[] = $user_id;

                $stmt = $pdo->prepare($sql);
                $stmt->execute($params);
                $message = 'ອັບເດດຂໍ້ມູນຜູ້ໃຊ້ສໍາເລັດ!';
            } catch (PDOException $e) {
                $error = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
            }
        }
    }

    // Delete User
    if ($action === 'delete') {
        $user_id = intval($_POST['user_id'] ?? 0);
        $stmt = $pdo->prepare("UPDATE users SET deleted_at = NOW() WHERE id = ?");
        $stmt->execute([$user_id]);
        $message = 'ລົບຜູ້ໃຊ້ສໍາເລັດ!';
    }

    // Update Status
    if ($action === 'update_status') {
        $user_id = intval($_POST['user_id'] ?? 0);
        $status = $_POST['status'] ?? '';
        $stmt = $pdo->prepare("UPDATE users SET status = ? WHERE id = ?");
        $stmt->execute([$status, $user_id]);
        $message = 'ອັບເດດສະຖານະສໍາເລັດ!';
    }
}

// Get roles
$stmt = $pdo->query("SELECT * FROM user_roles ORDER BY role_id");
$roles = $stmt->fetchAll();

// Get users with filters
$search = $_GET['search'] ?? '';
$role_filter = $_GET['role'] ?? '';
$status_filter = $_GET['status'] ?? '';

$sql = "
    SELECT u.*, r.role_name, r.role_code 
    FROM users u 
    LEFT JOIN user_roles r ON u.role_id = r.role_id 
    WHERE u.deleted_at IS NULL
";
$params = [];

if (!empty($search)) {
    $sql .= " AND (u.username LIKE ? OR u.email LIKE ? OR u.first_name LIKE ? OR u.last_name LIKE ?)";
    $searchTerm = "%{$search}%";
    $params = array_merge($params, [$searchTerm, $searchTerm, $searchTerm, $searchTerm]);
}

if (!empty($role_filter)) {
    $sql .= " AND u.role_id = ?";
    $params[] = $role_filter;
}

if (!empty($status_filter)) {
    $sql .= " AND u.status = ?";
    $params[] = $status_filter;
}

$sql .= " ORDER BY u.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$users = $stmt->fetchAll();
?>

<?php if ($message): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            Swal.fire({
                icon: 'success',
                title: 'ສໍາເລັດ!',
                text: '<?= addslashes($message) ?>',
                confirmButtonColor: '#28A745',
                background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
                color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
            });
        });
    </script>
<?php endif; ?>

<?php if ($error): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            Swal.fire({
                icon: 'error',
                title: 'ຂໍ້ຜິດພາດ',
                text: '<?= addslashes($error) ?>',
                confirmButtonColor: '#4A90D9',
                background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
                color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
            });
        });
    </script>
<?php endif; ?>

<!-- Filters & Actions -->
<div class="card" style="margin-bottom: 20px;">
    <div class="card-body">
        <form method="GET" style="display: flex; gap: 15px; flex-wrap: wrap; align-items: flex-end;">
            <div class="form-group" style="margin: 0; flex: 1; min-width: 200px;">
                <label class="form-label">ຄົ້ນຫາ</label>
                <input type="text" name="search" class="form-control" placeholder="ຄົ້ນຫາ username, email, ຊື່..."
                    value="<?= htmlspecialchars($search) ?>">
            </div>
            <div class="form-group" style="margin: 0; width: 150px;">
                <label class="form-label">Role</label>
                <select name="role" class="form-control">
                    <option value="">ທັງໝົດ</option>
                    <?php foreach ($roles as $role): ?>
                        <option value="<?= $role['role_id'] ?>" <?= $role_filter == $role['role_id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($role['role_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group" style="margin: 0; width: 150px;">
                <label class="form-label">ສະຖານະ</label>
                <select name="status" class="form-control">
                    <option value="">ທັງໝົດ</option>
                    <option value="active" <?= $status_filter === 'active' ? 'selected' : '' ?>>Active</option>
                    <option value="pending" <?= $status_filter === 'pending' ? 'selected' : '' ?>>Pending</option>
                    <option value="inactive" <?= $status_filter === 'inactive' ? 'selected' : '' ?>>Inactive</option>
                    <option value="suspended" <?= $status_filter === 'suspended' ? 'selected' : '' ?>>Suspended</option>
                </select>
            </div>
            <button type="submit" class="btn btn-secondary"><i class="fas fa-search"></i> ຄົ້ນຫາ</button>
            <a href="users.php" class="btn btn-secondary"><i class="fas fa-refresh"></i></a>
            <button type="button" class="btn btn-primary" onclick="openModal('createModal')"><i class="fas fa-plus"></i>
                ເພີ່ມຜູ້ໃຊ້</button>
        </form>
    </div>
</div>

<!-- Users Table -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-users"></i> ລາຍການຜູ້ໃຊ້ (
            <?= count($users) ?>)
        </h3>
    </div>
    <div class="card-body" style="padding: 0;">
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>US_ID</th>
                        <th>ຜູ້ໃຊ້</th>
                        <th>Email</th>
                        <th>ເບີໂທ</th>
                        <th>Role</th>
                        <th>ສະຖານະ</th>
                        <th>ສ້າງເມື່ອ</th>
                        <th style="width: 120px;">ຈັດການ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($users)): ?>
                        <tr>
                            <td colspan="8" style="text-align: center; padding: 40px; color: var(--text-secondary);">
                                ບໍ່ພົບຂໍ້ມູນຜູ້ໃຊ້</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($users as $user): ?>
                            <tr>
                                <td><code
                                        style="font-size: 11px; color: var(--accent);"><?= htmlspecialchars($user['US_id']) ?></code>
                                </td>
                                <td>
                                    <div style="display: flex; align-items: center; gap: 10px;">
                                        <div class="user-avatar" style="width: 38px; height: 38px; font-size: 14px;">
                                            <?= strtoupper(substr($user['username'], 0, 1)) ?>
                                        </div>
                                        <div>
                                            <strong>
                                                <?= htmlspecialchars($user['username']) ?>
                                            </strong>
                                            <?php if ($user['first_name'] || $user['last_name']): ?>
                                                <div style="font-size: 12px; color: var(--text-secondary);">
                                                    <?= htmlspecialchars(trim($user['first_name'] . ' ' . $user['last_name'])) ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <?= htmlspecialchars($user['email']) ?>
                                </td>
                                <td>
                                    <?= htmlspecialchars($user['phone'] ?: '-') ?>
                                </td>
                                <td><span class="role-badge <?= $user['role_code'] ?>">
                                        <?= htmlspecialchars($user['role_name']) ?>
                                    </span></td>
                                <td>
                                    <select class="form-control" style="width: auto; padding: 5px 10px; font-size: 12px;"
                                        onchange="updateStatus(<?= $user['id'] ?>, this.value)">
                                        <option value="active" <?= $user['status'] === 'active' ? 'selected' : '' ?>>Active
                                        </option>
                                        <option value="pending" <?= $user['status'] === 'pending' ? 'selected' : '' ?>>Pending
                                        </option>
                                        <option value="inactive" <?= $user['status'] === 'inactive' ? 'selected' : '' ?>>Inactive
                                        </option>
                                        <option value="suspended" <?= $user['status'] === 'suspended' ? 'selected' : '' ?>>
                                            Suspended</option>
                                    </select>
                                </td>
                                <td style="font-size: 12px; color: var(--text-secondary);">
                                    <?= date('d/m/Y H:i', strtotime($user['created_at'])) ?>
                                </td>
                                <td>
                                    <button class="btn btn-secondary btn-sm"
                                        onclick="editUser(<?= htmlspecialchars(json_encode($user)) ?>)" title="ແກ້ໄຂ"><i
                                            class="fas fa-edit"></i></button>
                                    <button class="btn btn-danger btn-sm"
                                        onclick="deleteUser(<?= $user['id'] ?>, '<?= htmlspecialchars($user['username']) ?>')"
                                        title="ລົບ"><i class="fas fa-trash"></i></button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Create User Modal -->
<div class="modal-overlay" id="createModal">
    <div class="modal">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-user-plus"></i> ເພີ່ມຜູ້ໃຊ້ໃໝ່</h3>
            <button class="modal-close" onclick="closeModal('createModal')"><i class="fas fa-times"></i></button>
        </div>
        <form method="POST" id="createUserForm" onsubmit="return validateCreateForm()">
            <input type="hidden" name="action" value="create">
            <div class="modal-body">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label class="form-label">ຊື່</label>
                        <input type="text" name="first_name" id="create_first_name" class="form-control"
                            placeholder="ຊື່ຈິງ">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ນາມສະກຸນ</label>
                        <input type="text" name="last_name" id="create_last_name" class="form-control"
                            placeholder="ນາມສະກຸນ">
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label">Username *</label>
                    <input type="text" name="username" id="create_username" class="form-control"
                        placeholder="ຊື່ຜູ້ໃຊ້ (3-50 ຕົວ, a-z, 0-9, _)" required>
                    <small id="create_username_error" class="error-msg"
                        style="color: #DC3545; font-size: 11px; display: none;"></small>
                </div>
                <div class="form-group">
                    <label class="form-label">Email *</label>
                    <input type="email" name="email" id="create_email" class="form-control"
                        placeholder="email@example.com" required>
                    <small id="create_email_error" class="error-msg"
                        style="color: #DC3545; font-size: 11px; display: none;"></small>
                </div>
                <div class="form-group">
                    <label class="form-label">ເບີໂທລະສັບ</label>
                    <input type="tel" name="phone" id="create_phone" class="form-control" placeholder="0812345678">
                    <small id="create_phone_error" class="error-msg"
                        style="color: #DC3545; font-size: 11px; display: none;"></small>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label class="form-label">Password *</label>
                        <input type="password" name="password" id="create_password" class="form-control"
                            placeholder="ລະຫັດຜ່ານ" required oninput="checkPasswordStrength(this.value, 'create')">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ຢືນຢັນ Password *</label>
                        <input type="password" name="confirm_password" id="create_confirm_password" class="form-control"
                            placeholder="ຢືນຢັນລະຫັດຜ່ານ" required oninput="checkPasswordMatch('create')">
                    </div>
                </div>
                <!-- Password Strength Indicator -->
                <div id="create_password_strength" style="margin-bottom: 15px;">
                    <div style="display: flex; gap: 5px; margin-bottom: 8px;">
                        <div id="create_str1"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                        <div id="create_str2"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                        <div id="create_str3"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                        <div id="create_str4"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                        <div id="create_str5"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                    </div>
                    <div style="font-size: 11px; display: flex; flex-wrap: wrap; gap: 8px;">
                        <span id="create_chk_len" style="color: var(--text-secondary);">❌ 8 ຕົວ+</span>
                        <span id="create_chk_upper" style="color: var(--text-secondary);">❌ A-Z</span>
                        <span id="create_chk_lower" style="color: var(--text-secondary);">❌ a-z</span>
                        <span id="create_chk_num" style="color: var(--text-secondary);">❌ 0-9</span>
                        <span id="create_chk_special" style="color: var(--text-secondary);">❌ !@#$</span>
                        <span id="create_chk_match" style="color: var(--text-secondary);">❌ ກົງກັນ</span>
                    </div>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label class="form-label">Role *</label>
                        <select name="role_id" class="form-control" required>
                            <option value="">-- ເລືອກ Role --</option>
                            <?php foreach ($roles as $role): ?>
                                <option value="<?= $role['role_id'] ?>">
                                    <?= htmlspecialchars($role['role_name']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ສະຖານະ *</label>
                        <select name="status" class="form-control" required>
                            <option value="active">Active</option>
                            <option value="pending">Pending</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('createModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<!-- Edit User Modal -->
<div class="modal-overlay" id="editModal">
    <div class="modal">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-user-edit"></i> ແກ້ໄຂຜູ້ໃຊ້</h3>
            <button class="modal-close" onclick="closeModal('editModal')"><i class="fas fa-times"></i></button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="update">
            <input type="hidden" name="user_id" id="edit_user_id">
            <div class="modal-body">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label class="form-label">ຊື່</label>
                        <input type="text" name="first_name" id="edit_first_name" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ນາມສະກຸນ</label>
                        <input type="text" name="last_name" id="edit_last_name" class="form-control">
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label">Username</label>
                    <input type="text" id="edit_username" class="form-control" disabled>
                </div>
                <div class="form-group">
                    <label class="form-label">Email</label>
                    <input type="email" id="edit_email" class="form-control" disabled>
                </div>
                <div class="form-group">
                    <label class="form-label">ເບີໂທລະສັບ</label>
                    <input type="tel" name="phone" id="edit_phone" class="form-control">
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label class="form-label">Password ໃໝ່</label>
                        <input type="password" name="new_password" id="edit_password" class="form-control"
                            placeholder="ລະຫັດຜ່ານໃໝ່" oninput="checkPasswordStrength(this.value, 'edit')">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ຢືນຢັນ Password ໃໝ່</label>
                        <input type="password" name="confirm_new_password" id="edit_confirm_password"
                            class="form-control" placeholder="ຢືນຢັນລະຫັດຜ່ານໃໝ່" oninput="checkPasswordMatch('edit')">
                    </div>
                </div>
                <!-- Password Strength Indicator for Edit -->
                <div id="edit_password_strength" style="margin-bottom: 15px;">
                    <div style="display: flex; gap: 5px; margin-bottom: 8px;">
                        <div id="edit_str1"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                        <div id="edit_str2"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                        <div id="edit_str3"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                        <div id="edit_str4"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                        <div id="edit_str5"
                            style="flex: 1; height: 4px; background: var(--border-color); border-radius: 2px;"></div>
                    </div>
                    <div style="font-size: 11px; display: flex; flex-wrap: wrap; gap: 8px;">
                        <span id="edit_chk_len" style="color: var(--text-secondary);">❌ 8 ຕົວ+</span>
                        <span id="edit_chk_upper" style="color: var(--text-secondary);">❌ A-Z</span>
                        <span id="edit_chk_lower" style="color: var(--text-secondary);">❌ a-z</span>
                        <span id="edit_chk_num" style="color: var(--text-secondary);">❌ 0-9</span>
                        <span id="edit_chk_special" style="color: var(--text-secondary);">❌ !@#$</span>
                        <span id="edit_chk_match" style="color: var(--text-secondary);">❌ ກົງກັນ</span>
                        <span style="color: var(--accent); font-style: italic;">(ເວົ້ນວ່າງຖ້າບໍ່ປ່ຽນ)</span>
                    </div>
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label class="form-label">Role</label>
                        <select name="role_id" id="edit_role_id" class="form-control" required>
                            <?php foreach ($roles as $role): ?>
                                <option value="<?= $role['role_id'] ?>">
                                    <?= htmlspecialchars($role['role_name']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ສະຖານະ</label>
                        <select name="status" id="edit_status" class="form-control" required>
                            <option value="active">Active</option>
                            <option value="pending">Pending</option>
                            <option value="inactive">Inactive</option>
                            <option value="suspended">Suspended</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('editModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<!-- Delete Form (Hidden) -->
<form method="POST" id="deleteForm" style="display: none;">
    <input type="hidden" name="action" value="delete">
    <input type="hidden" name="user_id" id="delete_user_id">
</form>

<!-- Status Form (Hidden) -->
<form method="POST" id="statusForm" style="display: none;">
    <input type="hidden" name="action" value="update_status">
    <input type="hidden" name="user_id" id="status_user_id">
    <input type="hidden" name="status" id="status_value">
</form>

<script>
    function editUser(user) {
        document.getElementById('edit_user_id').value = user.id;
        document.getElementById('edit_username').value = user.username;
        document.getElementById('edit_email').value = user.email;
        document.getElementById('edit_first_name').value = user.first_name || '';
        document.getElementById('edit_last_name').value = user.last_name || '';
        document.getElementById('edit_phone').value = user.phone || '';
        document.getElementById('edit_role_id').value = user.role_id;
        document.getElementById('edit_status').value = user.status;
        openModal('editModal');
    }

    function deleteUser(id, username) {
        Swal.fire({
            title: 'ຢືນຢັນການລົບ',
            html: 'ຕ້ອງການລົບຜູ້ໃຊ້ "<strong>' + username + '</strong>" ຫຼືບໍ່?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DC3545',
            cancelButtonColor: '#6C757D',
            confirmButtonText: '<i class="fas fa-trash"></i> ລົບ',
            cancelButtonText: 'ຍົກເລີກ',
            background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
            color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete_user_id').value = id;
                document.getElementById('deleteForm').submit();
            }
        });
    }

    function updateStatus(userId, status) {
        document.getElementById('status_user_id').value = userId;
        document.getElementById('status_value').value = status;
        document.getElementById('statusForm').submit();
    }

    // Password Strength Checker
    function checkPasswordStrength(password, prefix) {
        const checks = {
            len: password.length >= 8,
            upper: /[A-Z]/.test(password),
            lower: /[a-z]/.test(password),
            num: /[0-9]/.test(password),
            special: /[!@#$%^&*(),.?":{}|<>]/.test(password)
        };

        let strength = 0;

        // Update checkmarks
        Object.keys(checks).forEach(key => {
            const el = document.getElementById(prefix + '_chk_' + key);
            if (el) {
                if (checks[key]) {
                    el.innerHTML = '✅ ' + el.innerHTML.substring(2);
                    el.style.color = '#28A745';
                    strength++;
                } else {
                    el.innerHTML = '❌ ' + el.innerHTML.substring(2);
                    el.style.color = 'var(--text-secondary)';
                }
            }
        });

        // Update strength bars
        const colors = ['#DC3545', '#FD7E14', '#FFC107', '#28A745', '#20C997'];
        for (let i = 1; i <= 5; i++) {
            const bar = document.getElementById(prefix + '_str' + i);
            if (bar) {
                if (i <= strength) {
                    bar.style.background = colors[strength - 1];
                } else {
                    bar.style.background = 'var(--border-color)';
                }
            }
        }

        // Check match
        checkPasswordMatch(prefix);
    }

    function checkPasswordMatch(prefix) {
        const password = document.getElementById(prefix + '_password');
        const confirm = document.getElementById(prefix + '_confirm_password');
        const matchEl = document.getElementById(prefix + '_chk_match');

        if (password && confirm && matchEl) {
            if (confirm.value && password.value === confirm.value) {
                matchEl.innerHTML = '✅ ກົງກັນ';
                matchEl.style.color = '#28A745';
            } else {
                matchEl.innerHTML = '❌ ກົງກັນ';
                matchEl.style.color = 'var(--text-secondary)';
            }
        }
    }

    // For edit modal - new password
    function checkEditPasswordStrength(password) {
        checkPasswordStrength(password, 'edit');
    }

    // Clear all error messages
    function clearErrors() {
        document.querySelectorAll('.error-msg').forEach(el => {
            el.style.display = 'none';
            el.textContent = '';
        });
        document.querySelectorAll('.form-control').forEach(el => {
            el.style.borderColor = '';
        });
    }

    // Show error on specific field
    function showError(fieldId, message) {
        const field = document.getElementById(fieldId);
        const errorEl = document.getElementById(fieldId + '_error');
        if (field) {
            field.style.borderColor = '#DC3545';
            field.focus();
        }
        if (errorEl) {
            errorEl.textContent = message;
            errorEl.style.display = 'block';
        }
    }

    // Show SweetAlert2 Error
    function showSwalError(message) {
        Swal.fire({
            icon: 'error',
            title: 'ຂໍ້ຜິດພາດ',
            text: message,
            confirmButtonColor: '#4A90D9',
            background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
            color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
        });
    }

    // Show SweetAlert2 Success
    function showSwalSuccess(message) {
        Swal.fire({
            icon: 'success',
            title: 'ສໍາເລັດ',
            text: message,
            confirmButtonColor: '#28A745',
            background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
            color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
        });
    }

    // Validate Create Form
    function validateCreateForm() {
        clearErrors();

        const username = document.getElementById('create_username').value.trim();
        const email = document.getElementById('create_email').value.trim();
        const phone = document.getElementById('create_phone').value.trim();
        const password = document.getElementById('create_password').value;
        const confirmPassword = document.getElementById('create_confirm_password').value;
        const roleId = document.querySelector('#createUserForm select[name="role_id"]').value;

        // Username validation
        if (username.length < 3) {
            showError('create_username', 'Username ຕ້ອງມີຢ່າງໜ້ອຍ 3 ຕົວອັກສອນ');
            return false;
        }
        if (username.length > 50) {
            showError('create_username', 'Username ຕ້ອງບໍ່ເກີນ 50 ຕົວອັກສອນ');
            return false;
        }
        if (!/^[a-zA-Z0-9_]+$/.test(username)) {
            showError('create_username', 'Username ໃຊ້ໄດ້ສະເພາະ a-z, A-Z, 0-9 ແລະ _ ເທົ່ານັ້ນ');
            return false;
        }

        // Email validation
        if (!email || !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
            showError('create_email', 'ຮູບແບບ Email ບໍ່ຖືກຕ້ອງ');
            return false;
        }

        // Phone validation (if provided)
        if (phone && !/^[0-9+\-\s]+$/.test(phone)) {
            showError('create_phone', 'ເບີໂທລະສັບບໍ່ຖືກຕ້ອງ');
            return false;
        }

        // Password validation
        if (password.length < 8) {
            showSwalError('Password ຕ້ອງມີຢ່າງໜ້ອຍ 8 ຕົວອັກສອນ');
            document.getElementById('create_password').focus();
            return false;
        }
        if (!/[A-Z]/.test(password)) {
            showSwalError('Password ຕ້ອງມີຕົວອັກສອນໃຫຍ່ຢ່າງໜ້ອຍ 1 ຕົວ (A-Z)');
            document.getElementById('create_password').focus();
            return false;
        }
        if (!/[a-z]/.test(password)) {
            showSwalError('Password ຕ້ອງມີຕົວອັກສອນນ້ອຍຢ່າງໜ້ອຍ 1 ຕົວ (a-z)');
            document.getElementById('create_password').focus();
            return false;
        }
        if (!/[0-9]/.test(password)) {
            showSwalError('Password ຕ້ອງມີຕົວເລກຢ່າງໜ້ອຍ 1 ຕົວ (0-9)');
            document.getElementById('create_password').focus();
            return false;
        }
        if (!/[!@#$%^&*(),.?":{}|<>]/.test(password)) {
            showSwalError('Password ຕ້ອງມີສັນຍາລັກພິເສດຢ່າງໜ້ອຍ 1 ຕົວ (!@#$%^&*...)');
            document.getElementById('create_password').focus();
            return false;
        }
        if (password !== confirmPassword) {
            showSwalError('Password ບໍ່ກົງກັນ');
            document.getElementById('create_confirm_password').focus();
            return false;
        }

        // Role validation
        if (!roleId) {
            showSwalError('ກະລຸນາເລືອກ Role');
            return false;
        }

        return true;
    }
</script>

<?php require_once 'includes/footer.php'; ?>