<?php
$page_title = 'ຈັດການຮ້ານຄ້າ';
require_once 'includes/header.php';

$message = '';
$error = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // Create Shop
    if ($action === 'create') {
        $shop_name = trim($_POST['shop_name'] ?? '');
        $province = trim($_POST['province'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $whatsapp = trim($_POST['whatsapp'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $address = trim($_POST['address'] ?? '');
        $facebook = trim($_POST['facebook'] ?? '');
        $tiktok = trim($_POST['tiktok'] ?? '');
        $instagram = trim($_POST['instagram'] ?? '');
        $website = trim($_POST['website'] ?? '');
        $owner_user_id = intval($_POST['owner_user_id'] ?? 0);
        $status = $_POST['status'] ?? 'pending';
        $plan_type = $_POST['plan_type'] ?? 'free';

        if (empty($shop_name) || empty($owner_user_id)) {
            $error = 'ກະລຸນາກຣອກຊື່ຮ້ານແລະເລືອກເຈົ້າຂອງຮ້ານ';
        } else {
            $stmt = $pdo->prepare("
                INSERT INTO shops (shop_name, province, phone, whatsapp, email, address, facebook, tiktok, instagram, website, owner_user_id, status, plan_type)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            ");
            $stmt->execute([$shop_name, $province, $phone, $whatsapp, $email, $address, $facebook, $tiktok, $instagram, $website, $owner_user_id, $status, $plan_type]);
            $message = 'ສ້າງຮ້ານຄ້າສໍາເລັດ!';
        }
    }

    // Update Shop
    if ($action === 'update') {
        $shop_id = intval($_POST['shop_id'] ?? 0);
        $shop_name = trim($_POST['shop_name'] ?? '');
        $province = trim($_POST['province'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $whatsapp = trim($_POST['whatsapp'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $address = trim($_POST['address'] ?? '');
        $facebook = trim($_POST['facebook'] ?? '');
        $tiktok = trim($_POST['tiktok'] ?? '');
        $instagram = trim($_POST['instagram'] ?? '');
        $website = trim($_POST['website'] ?? '');
        $owner_user_id = intval($_POST['owner_user_id'] ?? 0);
        $status = $_POST['status'] ?? 'pending';
        $plan_type = $_POST['plan_type'] ?? 'free';

        $stmt = $pdo->prepare("
            UPDATE shops SET 
                shop_name = ?, province = ?, phone = ?, whatsapp = ?, email = ?, 
                address = ?, facebook = ?, tiktok = ?, instagram = ?, website = ?,
                owner_user_id = ?, status = ?, plan_type = ?
            WHERE id = ?
        ");
        $stmt->execute([$shop_name, $province, $phone, $whatsapp, $email, $address, $facebook, $tiktok, $instagram, $website, $owner_user_id, $status, $plan_type, $shop_id]);
        $message = 'ອັບເດດຮ້ານຄ້າສໍາເລັດ!';
    }

    // Delete Shop
    if ($action === 'delete') {
        $shop_id = intval($_POST['shop_id'] ?? 0);
        $stmt = $pdo->prepare("UPDATE shops SET deleted_at = NOW() WHERE id = ?");
        $stmt->execute([$shop_id]);
        $message = 'ລົບຮ້ານຄ້າສໍາເລັດ!';
    }
}

// Get users (for owner selection)
$stmt = $pdo->query("SELECT id, US_id, username, email FROM users WHERE deleted_at IS NULL ORDER BY username");
$users = $stmt->fetchAll();

// Get shops with filters
$search = $_GET['search'] ?? '';
$status_filter = $_GET['status'] ?? '';
$plan_filter = $_GET['plan'] ?? '';

$sql = "
    SELECT s.*, u.username as owner_username, u.email as owner_email 
    FROM shops s 
    LEFT JOIN users u ON s.owner_user_id = u.id 
    WHERE s.deleted_at IS NULL
";
$params = [];

if (!empty($search)) {
    $sql .= " AND (s.shop_name LIKE ? OR s.province LIKE ? OR u.username LIKE ?)";
    $searchTerm = "%{$search}%";
    $params = array_merge($params, [$searchTerm, $searchTerm, $searchTerm]);
}

if (!empty($status_filter)) {
    $sql .= " AND s.status = ?";
    $params[] = $status_filter;
}

if (!empty($plan_filter)) {
    $sql .= " AND s.plan_type = ?";
    $params[] = $plan_filter;
}

$sql .= " ORDER BY s.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$shops = $stmt->fetchAll();
?>

<?php if ($message): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            Swal.fire({
                icon: 'success',
                title: 'ສໍາເລັດ!',
                text: '<?= addslashes($message) ?>',
                confirmButtonColor: '#28A745',
                background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
                color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
            });
        });
    </script>
<?php endif; ?>

<?php if ($error): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            Swal.fire({
                icon: 'error',
                title: 'ຂໍ້ຜິດພາດ',
                text: '<?= addslashes($error) ?>',
                confirmButtonColor: '#4A90D9',
                background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
                color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
            });
        });
    </script>
<?php endif; ?>

<!-- Filters & Actions -->
<div class="card" style="margin-bottom: 20px;">
    <div class="card-body">
        <form method="GET" style="display: flex; gap: 15px; flex-wrap: wrap; align-items: flex-end;">
            <div class="form-group" style="margin: 0; flex: 1; min-width: 200px;">
                <label class="form-label">ຄົ້ນຫາ</label>
                <input type="text" name="search" class="form-control" placeholder="ຄົ້ນຫາຊື່ຮ້ານ, ແຂວງ, ເຈົ້າຂອງ..."
                    value="<?= htmlspecialchars($search) ?>">
            </div>
            <div class="form-group" style="margin: 0; width: 150px;">
                <label class="form-label">ສະຖານະ</label>
                <select name="status" class="form-control">
                    <option value="">ທັງໝົດ</option>
                    <option value="active" <?= $status_filter === 'active' ? 'selected' : '' ?>>Active</option>
                    <option value="pending" <?= $status_filter === 'pending' ? 'selected' : '' ?>>Pending</option>
                    <option value="inactive" <?= $status_filter === 'inactive' ? 'selected' : '' ?>>Inactive</option>
                    <option value="suspended" <?= $status_filter === 'suspended' ? 'selected' : '' ?>>Suspended</option>
                </select>
            </div>
            <div class="form-group" style="margin: 0; width: 150px;">
                <label class="form-label">ແພລນ</label>
                <select name="plan" class="form-control">
                    <option value="">ທັງໝົດ</option>
                    <option value="free" <?= $plan_filter === 'free' ? 'selected' : '' ?>>Free</option>
                    <option value="basic" <?= $plan_filter === 'basic' ? 'selected' : '' ?>>Basic</option>
                    <option value="pro" <?= $plan_filter === 'pro' ? 'selected' : '' ?>>Pro</option>
                    <option value="enterprise" <?= $plan_filter === 'enterprise' ? 'selected' : '' ?>>Enterprise</option>
                </select>
            </div>
            <button type="submit" class="btn btn-secondary"><i class="fas fa-search"></i> ຄົ້ນຫາ</button>
            <a href="shops.php" class="btn btn-secondary"><i class="fas fa-refresh"></i></a>
            <button type="button" class="btn btn-primary" onclick="openModal('createModal')"><i class="fas fa-plus"></i>
                ເພີ່ມຮ້ານຄ້າ</button>
        </form>
    </div>
</div>

<!-- Shops Table -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-store"></i> ລາຍການຮ້ານຄ້າ (
            <?= count($shops) ?>)
        </h3>
    </div>
    <div class="card-body" style="padding: 0;">
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>SH_ID</th>
                        <th>ຮ້ານຄ້າ</th>
                        <th>ເຈົ້າຂອງ</th>
                        <th>ຕິດຕໍ່</th>
                        <th>ແພລນ</th>
                        <th>ສະຖານະ</th>
                        <th>ສ້າງເມື່ອ</th>
                        <th style="width: 120px;">ຈັດການ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($shops)): ?>
                        <tr>
                            <td colspan="8" style="text-align: center; padding: 40px; color: var(--text-secondary);">
                                ບໍ່ພົບຂໍ້ມູນຮ້ານຄ້າ</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($shops as $shop): ?>
                            <tr>
                                <td><code
                                        style="font-size: 11px; color: var(--accent);"><?= htmlspecialchars($shop['SH_id']) ?></code>
                                </td>
                                <td>
                                    <div style="display: flex; align-items: center; gap: 10px;">
                                        <div class="user-avatar"
                                            style="width: 40px; height: 40px; font-size: 14px; background: var(--accent-soft);">
                                            <i class="fas fa-store"></i>
                                        </div>
                                        <div>
                                            <strong>
                                                <?= htmlspecialchars($shop['shop_name']) ?>
                                            </strong>
                                            <div style="font-size: 12px; color: var(--text-secondary);">
                                                <i class="fas fa-map-marker-alt"></i>
                                                <?= htmlspecialchars($shop['province'] ?: 'ບໍ່ລະບຸ') ?>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <strong>
                                            <?= htmlspecialchars($shop['owner_username'] ?: '-') ?>
                                        </strong>
                                        <div style="font-size: 11px; color: var(--text-secondary);">
                                            <?= htmlspecialchars($shop['owner_email'] ?? '') ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div style="font-size: 12px;">
                                        <?php if ($shop['phone']): ?>
                                            <div><i class="fas fa-phone"></i>
                                                <?= htmlspecialchars($shop['phone']) ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if ($shop['whatsapp']): ?>
                                            <div style="color: #25D366;"><i class="fab fa-whatsapp"></i>
                                                <?= htmlspecialchars($shop['whatsapp']) ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="status" style="background: rgba(74, 144, 217, 0.15); color: var(--accent);">
                                        <?= strtoupper($shop['plan_type']) ?>
                                    </span>
                                </td>
                                <td><span class="status <?= $shop['status'] ?>">
                                        <?= ucfirst($shop['status']) ?>
                                    </span></td>
                                <td style="font-size: 12px; color: var(--text-secondary);">
                                    <?= date('d/m/Y', strtotime($shop['created_at'])) ?>
                                </td>
                                <td>
                                    <button class="btn btn-secondary btn-sm"
                                        onclick="editShop(<?= htmlspecialchars(json_encode($shop)) ?>)" title="ແກ້ໄຂ"><i
                                            class="fas fa-edit"></i></button>
                                    <button class="btn btn-danger btn-sm"
                                        onclick="deleteShop(<?= $shop['id'] ?>, '<?= htmlspecialchars($shop['shop_name']) ?>')"
                                        title="ລົບ"><i class="fas fa-trash"></i></button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Create Shop Modal -->
<div class="modal-overlay" id="createModal">
    <div class="modal" style="max-width: 700px;">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-store"></i> ເພີ່ມຮ້ານຄ້າໃໝ່</h3>
            <button class="modal-close" onclick="closeModal('createModal')"><i class="fas fa-times"></i></button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="create">
            <div class="modal-body">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group" style="grid-column: 1 / -1;">
                        <label class="form-label">ຊື່ຮ້ານ *</label>
                        <input type="text" name="shop_name" class="form-control" placeholder="ຊື່ຮ້ານຄ້າ" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ເຈົ້າຂອງຮ້ານ *</label>
                        <select name="owner_user_id" class="form-control" required>
                            <option value="">-- ເລືອກເຈົ້າຂອງຮ້ານ --</option>
                            <?php foreach ($users as $user): ?>
                                <option value="<?= $user['id'] ?>">
                                    <?= htmlspecialchars($user['username']) ?> (
                                    <?= htmlspecialchars($user['email']) ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ແຂວງ</label>
                        <input type="text" name="province" class="form-control" placeholder="ແຂວງ">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ເບີໂທລະສັບ</label>
                        <input type="tel" name="phone" class="form-control" placeholder="0812345678">
                    </div>
                    <div class="form-group">
                        <label class="form-label">WhatsApp</label>
                        <input type="tel" name="whatsapp" class="form-control" placeholder="0812345678">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control" placeholder="shop@email.com">
                    </div>
                    <div class="form-group" style="grid-column: 1 / -1;">
                        <label class="form-label">ທີ່ຢູ່</label>
                        <textarea name="address" class="form-control" rows="2" placeholder="ທີ່ຢູ່ຮ້ານຄ້າ"></textarea>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Facebook</label>
                        <input type="text" name="facebook" class="form-control" placeholder="ຊື່ Facebook">
                    </div>
                    <div class="form-group">
                        <label class="form-label">TikTok</label>
                        <input type="text" name="tiktok" class="form-control" placeholder="@username">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Instagram</label>
                        <input type="text" name="instagram" class="form-control" placeholder="@username">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Website</label>
                        <input type="url" name="website" class="form-control" placeholder="https://example.com">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ແພລນ</label>
                        <select name="plan_type" class="form-control">
                            <option value="free">Free</option>
                            <option value="basic">Basic</option>
                            <option value="pro">Pro</option>
                            <option value="enterprise">Enterprise</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ສະຖານະ</label>
                        <select name="status" class="form-control">
                            <option value="active">Active</option>
                            <option value="pending">Pending</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('createModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<!-- Edit Shop Modal -->
<div class="modal-overlay" id="editModal">
    <div class="modal" style="max-width: 700px;">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-store"></i> ແກ້ໄຂຮ້ານຄ້າ</h3>
            <button class="modal-close" onclick="closeModal('editModal')"><i class="fas fa-times"></i></button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="update">
            <input type="hidden" name="shop_id" id="edit_shop_id">
            <div class="modal-body">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group" style="grid-column: 1 / -1;">
                        <label class="form-label">ຊື່ຮ້ານ *</label>
                        <input type="text" name="shop_name" id="edit_shop_name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ເຈົ້າຂອງຮ້ານ *</label>
                        <select name="owner_user_id" id="edit_owner_user_id" class="form-control" required>
                            <?php foreach ($users as $user): ?>
                                <option value="<?= $user['id'] ?>">
                                    <?= htmlspecialchars($user['username']) ?> (
                                    <?= htmlspecialchars($user['email']) ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ແຂວງ</label>
                        <input type="text" name="province" id="edit_province" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ເບີໂທລະສັບ</label>
                        <input type="tel" name="phone" id="edit_phone" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">WhatsApp</label>
                        <input type="tel" name="whatsapp" id="edit_whatsapp" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" id="edit_email" class="form-control">
                    </div>
                    <div class="form-group" style="grid-column: 1 / -1;">
                        <label class="form-label">ທີ່ຢູ່</label>
                        <textarea name="address" id="edit_address" class="form-control" rows="2"></textarea>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Facebook</label>
                        <input type="text" name="facebook" id="edit_facebook" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">TikTok</label>
                        <input type="text" name="tiktok" id="edit_tiktok" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Instagram</label>
                        <input type="text" name="instagram" id="edit_instagram" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Website</label>
                        <input type="url" name="website" id="edit_website" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ແພລນ</label>
                        <select name="plan_type" id="edit_plan_type" class="form-control">
                            <option value="free">Free</option>
                            <option value="basic">Basic</option>
                            <option value="pro">Pro</option>
                            <option value="enterprise">Enterprise</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ສະຖານະ</label>
                        <select name="status" id="edit_status" class="form-control">
                            <option value="active">Active</option>
                            <option value="pending">Pending</option>
                            <option value="inactive">Inactive</option>
                            <option value="suspended">Suspended</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('editModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<!-- Delete Form (Hidden) -->
<form method="POST" id="deleteForm" style="display: none;">
    <input type="hidden" name="action" value="delete">
    <input type="hidden" name="shop_id" id="delete_shop_id">
</form>

<script>
    function editShop(shop) {
        document.getElementById('edit_shop_id').value = shop.id;
        document.getElementById('edit_shop_name').value = shop.shop_name || '';
        document.getElementById('edit_owner_user_id').value = shop.owner_user_id;
        document.getElementById('edit_province').value = shop.province || '';
        document.getElementById('edit_phone').value = shop.phone || '';
        document.getElementById('edit_whatsapp').value = shop.whatsapp || '';
        document.getElementById('edit_email').value = shop.email || '';
        document.getElementById('edit_address').value = shop.address || '';
        document.getElementById('edit_facebook').value = shop.facebook || '';
        document.getElementById('edit_tiktok').value = shop.tiktok || '';
        document.getElementById('edit_instagram').value = shop.instagram || '';
        document.getElementById('edit_website').value = shop.website || '';
        document.getElementById('edit_plan_type').value = shop.plan_type || 'free';
        document.getElementById('edit_status').value = shop.status || 'pending';
        openModal('editModal');
    }

    function deleteShop(id, name) {
        Swal.fire({
            title: 'ຢືນຢັນການລົບ',
            html: 'ຕ້ອງການລົບຮ້ານຄ້າ "<strong>' + name + '</strong>" ຫຼືບໍ່?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DC3545',
            cancelButtonColor: '#6C757D',
            confirmButtonText: '<i class="fas fa-trash"></i> ລົບ',
            cancelButtonText: 'ຍົກເລີກ',
            background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
            color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete_shop_id').value = id;
                document.getElementById('deleteForm').submit();
            }
        });
    }
</script>

<?php require_once 'includes/footer.php'; ?>