<?php
$page_title = 'ເຊື່ອມຕໍ່ User-Shop';
require_once 'includes/header.php';

$message = '';
$error = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // Add Staff to Shop
    if ($action === 'add_staff') {
        $shop_id = intval($_POST['shop_id'] ?? 0);
        $user_id = intval($_POST['user_id'] ?? 0);
        $position = trim($_POST['position'] ?? '');

        if (empty($shop_id) || empty($user_id)) {
            $error = 'ກະລຸນາເລືອກຮ້ານຄ້າແລະພະນັກງານ';
        } else {
            // Check if already exists
            $stmt = $pdo->prepare("SELECT id FROM shop_users WHERE shop_id = ? AND user_id = ?");
            $stmt->execute([$shop_id, $user_id]);
            if ($stmt->fetch()) {
                $error = 'ພະນັກງານນີ້ຢູ່ໃນຮ້ານນີ້ແລ້ວ';
            } else {
                $stmt = $pdo->prepare("
                    INSERT INTO shop_users (shop_id, user_id, position, invited_by)
                    VALUES (?, ?, ?, ?)
                ");
                $stmt->execute([$shop_id, $user_id, $position, $_SESSION['user_id']]);
                $message = 'ເພີ່ມພະນັກງານເຂົ້າຮ້ານສໍາເລັດ!';
            }
        }
    }

    // Add Representative to Shop
    if ($action === 'add_representative') {
        $shop_id = intval($_POST['shop_id'] ?? 0);
        $user_id = intval($_POST['user_id'] ?? 0);
        $discount_percent = floatval($_POST['discount_percent'] ?? 0);
        $commission_percent = floatval($_POST['commission_percent'] ?? 0);
        $rep_code = trim($_POST['rep_code'] ?? '');

        if (empty($shop_id) || empty($user_id)) {
            $error = 'ກະລຸນາເລືອກຮ້ານຄ້າແລະຕົວແທນ';
        } else {
            // Check if already exists
            $stmt = $pdo->prepare("SELECT id FROM shop_representatives WHERE shop_id = ? AND user_id = ?");
            $stmt->execute([$shop_id, $user_id]);
            if ($stmt->fetch()) {
                $error = 'ຕົວແທນນີ້ຢູ່ໃນຮ້ານນີ້ແລ້ວ';
            } else {
                // Generate rep_code if empty
                if (empty($rep_code)) {
                    $rep_code = 'REP' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT);
                }

                $stmt = $pdo->prepare("
                    INSERT INTO shop_representatives (shop_id, user_id, discount_percent, commission_percent, rep_code, status, approved_by, approved_at)
                    VALUES (?, ?, ?, ?, ?, 'active', ?, NOW())
                ");
                $stmt->execute([$shop_id, $user_id, $discount_percent, $commission_percent, $rep_code, $_SESSION['user_id']]);
                $message = 'ເພີ່ມຕົວແທນເຂົ້າຮ້ານສໍາເລັດ!';
            }
        }
    }

    // Remove Staff
    if ($action === 'remove_staff') {
        $id = intval($_POST['id'] ?? 0);
        $stmt = $pdo->prepare("DELETE FROM shop_users WHERE id = ?");
        $stmt->execute([$id]);
        $message = 'ລົບພະນັກງານອອກຈາກຮ້ານສໍາເລັດ!';
    }

    // Remove Representative
    if ($action === 'remove_representative') {
        $id = intval($_POST['id'] ?? 0);
        $stmt = $pdo->prepare("DELETE FROM shop_representatives WHERE id = ?");
        $stmt->execute([$id]);
        $message = 'ລົບຕົວແທນອອກຈາກຮ້ານສໍາເລັດ!';
    }

    // Update Staff
    if ($action === 'update_staff') {
        $id = intval($_POST['id'] ?? 0);
        $position = trim($_POST['position'] ?? '');
        $is_active = intval($_POST['is_active'] ?? 1);

        $stmt = $pdo->prepare("UPDATE shop_users SET position = ?, is_active = ? WHERE id = ?");
        $stmt->execute([$position, $is_active, $id]);
        $message = 'ອັບເດດຂໍ້ມູນພະນັກງານສໍາເລັດ!';
    }

    // Update Representative
    if ($action === 'update_representative') {
        $id = intval($_POST['id'] ?? 0);
        $discount_percent = floatval($_POST['discount_percent'] ?? 0);
        $commission_percent = floatval($_POST['commission_percent'] ?? 0);
        $status = $_POST['status'] ?? 'active';

        $stmt = $pdo->prepare("UPDATE shop_representatives SET discount_percent = ?, commission_percent = ?, status = ? WHERE id = ?");
        $stmt->execute([$discount_percent, $commission_percent, $status, $id]);
        $message = 'ອັບເດດຂໍ້ມູນຕົວແທນສໍາເລັດ!';
    }
}

// Get shops
$stmt = $pdo->query("SELECT id, SH_id, shop_name FROM shops WHERE deleted_at IS NULL ORDER BY shop_name");
$shops = $stmt->fetchAll();

// Get staff users (including admin as shop owners)
$stmt = $pdo->query("
    SELECT u.id, u.US_id, u.username, u.email, r.role_code, r.role_name 
    FROM users u 
    LEFT JOIN user_roles r ON u.role_id = r.role_id
    WHERE u.deleted_at IS NULL AND r.role_code IN ('admin', 'staff')
    ORDER BY r.role_id, u.username
");
$staff_users = $stmt->fetchAll();

// Get representative users
$stmt = $pdo->query("
    SELECT u.id, u.US_id, u.username, u.email, r.role_code 
    FROM users u 
    LEFT JOIN user_roles r ON u.role_id = r.role_id
    WHERE u.deleted_at IS NULL AND r.role_code = 'representative'
    ORDER BY u.username
");
$rep_users = $stmt->fetchAll();

// Get current shop staff
$stmt = $pdo->query("
    SELECT su.*, s.shop_name, s.SH_id, u.username, u.email, u.first_name, u.last_name
    FROM shop_users su
    INNER JOIN shops s ON su.shop_id = s.id
    INNER JOIN users u ON su.user_id = u.id
    WHERE s.deleted_at IS NULL AND u.deleted_at IS NULL
    ORDER BY s.shop_name, su.created_at DESC
");
$shop_staff = $stmt->fetchAll();

// Get current shop representatives
$stmt = $pdo->query("
    SELECT sr.*, s.shop_name, s.SH_id, u.username, u.email, u.first_name, u.last_name
    FROM shop_representatives sr
    INNER JOIN shops s ON sr.shop_id = s.id
    INNER JOIN users u ON sr.user_id = u.id
    WHERE s.deleted_at IS NULL AND u.deleted_at IS NULL
    ORDER BY s.shop_name, sr.created_at DESC
");
$shop_reps = $stmt->fetchAll();
?>

<?php if ($message): ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            icon: 'success',
            title: 'ສໍາເລັດ!',
            text: '<?= addslashes($message) ?>',
            confirmButtonColor: '#28A745',
            background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
            color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
        });
    });
</script>
<?php endif; ?>

<?php if ($error): ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            icon: 'error',
            title: 'ຂໍ້ຜິດພາດ',
            text: '<?= addslashes($error) ?>',
            confirmButtonColor: '#4A90D9',
            background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
            color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
        });
    });
</script>
<?php endif; ?>

<!-- Action Buttons -->
<div style="display: flex; gap: 10px; margin-bottom: 20px;">
    <button class="btn btn-primary" onclick="openModal('addStaffModal')">
        <i class="fas fa-user-plus"></i> ເພີ່ມພະນັກງານເຂົ້າຮ້ານ
    </button>
    <button class="btn btn-success" onclick="openModal('addRepModal')">
        <i class="fas fa-handshake"></i> ເພີ່ມຕົວແທນເຂົ້າຮ້ານ
    </button>
</div>

<!-- Tabs -->
<div style="display: flex; gap: 10px; margin-bottom: 20px;">
    <button class="btn btn-secondary" id="tabStaff" onclick="showTab('staff')"
        style="background: var(--accent); color: white;">
        <i class="fas fa-user-tie"></i> ພະນັກງານ (
        <?= count($shop_staff) ?>)
    </button>
    <button class="btn btn-secondary" id="tabRep" onclick="showTab('rep')">
        <i class="fas fa-handshake"></i> ຕົວແທນ (
        <?= count($shop_reps) ?>)
    </button>
</div>

<!-- Staff Table -->
<div class="card" id="staffSection">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-user-tie"></i> ພະນັກງານໃນຮ້ານຄ້າ</h3>
    </div>
    <div class="card-body" style="padding: 0;">
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>ຮ້ານຄ້າ</th>
                        <th>ພະນັກງານ</th>
                        <th>ຕໍາແໜ່ງ</th>
                        <th>ເຂົ້າຮ່ວມເມື່ອ</th>
                        <th>ສະຖານະ</th>
                        <th style="width: 120px;">ຈັດການ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($shop_staff)): ?>
                        <tr>
                            <td colspan="6" style="text-align: center; padding: 40px; color: var(--text-secondary);">
                                ບໍ່ມີຂໍ້ມູນ</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($shop_staff as $staff): ?>
                            <tr>
                                <td>
                                    <div>
                                        <strong>
                                            <?= htmlspecialchars($staff['shop_name']) ?>
                                        </strong>
                                        <div style="font-size: 11px; color: var(--text-secondary);">
                                            <?= htmlspecialchars($staff['SH_id']) ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div style="display: flex; align-items: center; gap: 10px;">
                                        <div class="user-avatar"
                                            style="width: 35px; height: 35px; font-size: 12px; background: #50B5A9;">
                                            <?= strtoupper(substr($staff['username'], 0, 1)) ?>
                                        </div>
                                        <div>
                                            <strong>
                                                <?= htmlspecialchars($staff['username']) ?>
                                            </strong>
                                            <div style="font-size: 11px; color: var(--text-secondary);">
                                                <?= htmlspecialchars($staff['email']) ?>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <?= htmlspecialchars($staff['position'] ?: '-') ?>
                                </td>
                                <td style="font-size: 12px; color: var(--text-secondary);">
                                    <?= date('d/m/Y', strtotime($staff['joined_at'])) ?>
                                </td>
                                <td>
                                    <span class="status <?= $staff['is_active'] ? 'active' : 'inactive' ?>">
                                        <?= $staff['is_active'] ? 'Active' : 'Inactive' ?>
                                    </span>
                                </td>
                                <td>
                                    <button class="btn btn-secondary btn-sm"
                                        onclick="editStaff(<?= htmlspecialchars(json_encode($staff)) ?>)" title="ແກ້ໄຂ"><i
                                            class="fas fa-edit"></i></button>
                                    <button class="btn btn-danger btn-sm"
                                        onclick="removeStaff(<?= $staff['id'] ?>, '<?= htmlspecialchars($staff['username']) ?>')"
                                        title="ລົບ"><i class="fas fa-trash"></i></button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Representatives Table -->
<div class="card" id="repSection" style="display: none;">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-handshake"></i> ຕົວແທນໃນຮ້ານຄ້າ</h3>
    </div>
    <div class="card-body" style="padding: 0;">
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>ຮ້ານຄ້າ</th>
                        <th>ຕົວແທນ</th>
                        <th>ລະຫັດຕົວແທນ</th>
                        <th>ສ່ວນຫຼຸດ %</th>
                        <th>ຄ່າຄອມ %</th>
                        <th>ສະຖານະ</th>
                        <th style="width: 120px;">ຈັດການ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($shop_reps)): ?>
                        <tr>
                            <td colspan="7" style="text-align: center; padding: 40px; color: var(--text-secondary);">
                                ບໍ່ມີຂໍ້ມູນ</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($shop_reps as $rep): ?>
                            <tr>
                                <td>
                                    <div>
                                        <strong>
                                            <?= htmlspecialchars($rep['shop_name']) ?>
                                        </strong>
                                        <div style="font-size: 11px; color: var(--text-secondary);">
                                            <?= htmlspecialchars($rep['SH_id']) ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div style="display: flex; align-items: center; gap: 10px;">
                                        <div class="user-avatar"
                                            style="width: 35px; height: 35px; font-size: 12px; background: #E8A838;">
                                            <?= strtoupper(substr($rep['username'], 0, 1)) ?>
                                        </div>
                                        <div>
                                            <strong>
                                                <?= htmlspecialchars($rep['username']) ?>
                                            </strong>
                                            <div style="font-size: 11px; color: var(--text-secondary);">
                                                <?= htmlspecialchars($rep['email']) ?>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td><code style="color: var(--accent);"><?= htmlspecialchars($rep['rep_code']) ?></code></td>
                                <td style="color: #28A745; font-weight: 600;">
                                    <?= number_format($rep['discount_percent'], 2) ?>%
                                </td>
                                <td style="color: #FD7E14; font-weight: 600;">
                                    <?= number_format($rep['commission_percent'], 2) ?>%
                                </td>
                                <td><span class="status <?= $rep['status'] ?>">
                                        <?= ucfirst($rep['status']) ?>
                                    </span></td>
                                <td>
                                    <button class="btn btn-secondary btn-sm"
                                        onclick="editRep(<?= htmlspecialchars(json_encode($rep)) ?>)" title="ແກ້ໄຂ"><i
                                            class="fas fa-edit"></i></button>
                                    <button class="btn btn-danger btn-sm"
                                        onclick="removeRep(<?= $rep['id'] ?>, '<?= htmlspecialchars($rep['username']) ?>')"
                                        title="ລົບ"><i class="fas fa-trash"></i></button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add Staff Modal -->
<div class="modal-overlay" id="addStaffModal">
    <div class="modal">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-user-plus"></i> ເພີ່ມພະນັກງານເຂົ້າຮ້ານ</h3>
            <button class="modal-close" onclick="closeModal('addStaffModal')"><i class="fas fa-times"></i></button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="add_staff">
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">ເລືອກຮ້ານຄ້າ *</label>
                    <select name="shop_id" class="form-control" required>
                        <option value="">-- ເລືອກຮ້ານຄ້າ --</option>
                        <?php foreach ($shops as $shop): ?>
                            <option value="<?= $shop['id'] ?>">
                                <?= htmlspecialchars($shop['shop_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">ເລືອກຜູ້ໃຊ້ (Admin/Staff) *</label>
                    <select name="user_id" class="form-control" required>
                        <option value="">-- ເລືອກຜູ້ໃຊ້ --</option>
                        <?php foreach ($staff_users as $user): ?>
                            <option value="<?= $user['id'] ?>">
                                [<?= htmlspecialchars($user['role_name']) ?>] <?= htmlspecialchars($user['username']) ?> (<?= htmlspecialchars($user['email']) ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <?php if (empty($staff_users)): ?>
                        <small style="color: var(--warning);">* ບໍ່ມີ user ທີ່ເປັນ Admin ຫຼື Staff ກະລຸນາສ້າງ user ກ່ອນ</small>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <label class="form-label">ຕໍາແໜ່ງ</label>
                    <input type="text" name="position" class="form-control" placeholder="ເຊັ່ນ ເຈົ້າຂອງຮ້ານ, ຜູ້ຈັດການ, ພະນັກງານຂາຍ">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('addStaffModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<!-- Add Representative Modal -->
<div class="modal-overlay" id="addRepModal">
    <div class="modal">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-handshake"></i> ເພີ່ມຕົວແທນເຂົ້າຮ້ານ</h3>
            <button class="modal-close" onclick="closeModal('addRepModal')"><i class="fas fa-times"></i></button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="add_representative">
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">ເລືອກຮ້ານຄ້າ *</label>
                    <select name="shop_id" class="form-control" required>
                        <option value="">-- ເລືອກຮ້ານຄ້າ --</option>
                        <?php foreach ($shops as $shop): ?>
                            <option value="<?= $shop['id'] ?>">
                                <?= htmlspecialchars($shop['shop_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">ເລືອກຕົວແທນ (Representative) *</label>
                    <select name="user_id" class="form-control" required>
                        <option value="">-- ເລືອກຕົວແທນ --</option>
                        <?php foreach ($rep_users as $user): ?>
                            <option value="<?= $user['id'] ?>">
                                <?= htmlspecialchars($user['username']) ?> (
                                <?= htmlspecialchars($user['email']) ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <?php if (empty($rep_users)): ?>
                        <small style="color: var(--warning);">* ບໍ່ມີ user ທີ່ເປັນ Representative ກະລຸນາສ້າງ user ທີ່ມີ role
                            ເປັນ Representative ກ່ອນ</small>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <label class="form-label">ລະຫັດຕົວແທນ (ຖ້າບໍ່ລະບຸຈະສ້າງອັດຕະໂນມັດ)</label>
                    <input type="text" name="rep_code" class="form-control" placeholder="ເຊັ່ນ REP001">
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label class="form-label">ສ່ວນຫຼຸດ (%)</label>
                        <input type="number" name="discount_percent" class="form-control" value="0" step="0.01" min="0"
                            max="100">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ຄ່າຄອມມິຊຊັນ (%)</label>
                        <input type="number" name="commission_percent" class="form-control" value="0" step="0.01"
                            min="0" max="100">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('addRepModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<!-- Edit Staff Modal -->
<div class="modal-overlay" id="editStaffModal">
    <div class="modal">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-user-edit"></i> ແກ້ໄຂຂໍ້ມູນພະນັກງານ</h3>
            <button class="modal-close" onclick="closeModal('editStaffModal')"><i class="fas fa-times"></i></button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="update_staff">
            <input type="hidden" name="id" id="edit_staff_id">
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">ຕໍາແໜ່ງ</label>
                    <input type="text" name="position" id="edit_staff_position" class="form-control">
                </div>
                <div class="form-group">
                    <label class="form-label">ສະຖານະ</label>
                    <select name="is_active" id="edit_staff_active" class="form-control">
                        <option value="1">Active</option>
                        <option value="0">Inactive</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('editStaffModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<!-- Edit Representative Modal -->
<div class="modal-overlay" id="editRepModal">
    <div class="modal">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-user-edit"></i> ແກ້ໄຂຂໍ້ມູນຕົວແທນ</h3>
            <button class="modal-close" onclick="closeModal('editRepModal')"><i class="fas fa-times"></i></button>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="update_representative">
            <input type="hidden" name="id" id="edit_rep_id">
            <div class="modal-body">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label class="form-label">ສ່ວນຫຼຸດ (%)</label>
                        <input type="number" name="discount_percent" id="edit_rep_discount" class="form-control"
                            step="0.01" min="0" max="100">
                    </div>
                    <div class="form-group">
                        <label class="form-label">ຄ່າຄອມມິຊຊັນ (%)</label>
                        <input type="number" name="commission_percent" id="edit_rep_commission" class="form-control"
                            step="0.01" min="0" max="100">
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label">ສະຖານະ</label>
                    <select name="status" id="edit_rep_status" class="form-control">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                        <option value="pending">Pending</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('editRepModal')">ຍົກເລີກ</button>
                <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </form>
    </div>
</div>

<!-- Hidden Forms -->
<form method="POST" id="removeStaffForm" style="display: none;">
    <input type="hidden" name="action" value="remove_staff">
    <input type="hidden" name="id" id="remove_staff_id">
</form>

<form method="POST" id="removeRepForm" style="display: none;">
    <input type="hidden" name="action" value="remove_representative">
    <input type="hidden" name="id" id="remove_rep_id">
</form>

<script>
    function showTab(tab) {
        document.getElementById('tabStaff').style.background = '';
        document.getElementById('tabStaff').style.color = '';
        document.getElementById('tabRep').style.background = '';
        document.getElementById('tabRep').style.color = '';

        if (tab === 'staff') {
            document.getElementById('staffSection').style.display = 'block';
            document.getElementById('repSection').style.display = 'none';
            document.getElementById('tabStaff').style.background = 'var(--accent)';
            document.getElementById('tabStaff').style.color = 'white';
        } else {
            document.getElementById('staffSection').style.display = 'none';
            document.getElementById('repSection').style.display = 'block';
            document.getElementById('tabRep').style.background = 'var(--accent)';
            document.getElementById('tabRep').style.color = 'white';
        }
    }

    function editStaff(staff) {
        document.getElementById('edit_staff_id').value = staff.id;
        document.getElementById('edit_staff_position').value = staff.position || '';
        document.getElementById('edit_staff_active').value = staff.is_active;
        openModal('editStaffModal');
    }

    function editRep(rep) {
        document.getElementById('edit_rep_id').value = rep.id;
        document.getElementById('edit_rep_discount').value = rep.discount_percent || 0;
        document.getElementById('edit_rep_commission').value = rep.commission_percent || 0;
        document.getElementById('edit_rep_status').value = rep.status || 'active';
        openModal('editRepModal');
    }

    function removeStaff(id, name) {
        Swal.fire({
            title: 'ຢືນຢັນການລົບ',
            html: 'ຕ້ອງການລົບຜູ້ໃຊ້ "<strong>' + name + '</strong>" ອອກຈາກຮ້ານຫຼືບໍ່?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DC3545',
            cancelButtonColor: '#6C757D',
            confirmButtonText: '<i class="fas fa-trash"></i> ລົບ',
            cancelButtonText: 'ຍົກເລີກ',
            background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
            color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('remove_staff_id').value = id;
                document.getElementById('removeStaffForm').submit();
            }
        });
    }

    function removeRep(id, name) {
        Swal.fire({
            title: 'ຢືນຢັນການລົບ',
            html: 'ຕ້ອງການລົບຕົວແທນ "<strong>' + name + '</strong>" ອອກຈາກຮ້ານຫຼືບໍ່?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DC3545',
            cancelButtonColor: '#6C757D',
            confirmButtonText: '<i class="fas fa-trash"></i> ລົບ',
            cancelButtonText: 'ຍົກເລີກ',
            background: getComputedStyle(document.documentElement).getPropertyValue('--bg-primary'),
            color: getComputedStyle(document.documentElement).getPropertyValue('--text-primary')
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('remove_rep_id').value = id;
                document.getElementById('removeRepForm').submit();
            }
        });
    }
</script>

<?php require_once 'includes/footer.php'; ?>