<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if logged in and is super_admin
if (!isset($_SESSION['user_id']) || $_SESSION['role_code'] !== 'super_admin') {
    header('Location: ../login.php');
    exit;
}

require_once dirname(__DIR__, 2) . '/includes/con_database.php';

$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="lo" data-theme="dark">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?? 'Super Admin' ?> - EPCommerce</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Prevent sidebar flash on page load -->
    <script>
        (function () {
            if (localStorage.getItem('epcommerce_sidebar_collapsed') === 'true') {
                document.documentElement.classList.add('sidebar-preload-collapsed');
            }
            if (localStorage.getItem('epcommerce_theme') === 'light') {
                document.documentElement.setAttribute('data-theme', 'light');
            }
        })();
    </script>
    <style>
        /* Prevent flash - apply collapsed state immediately */
        .sidebar-preload-collapsed .sidebar {
            width: 70px !important;
        }

        .sidebar-preload-collapsed .main-content {
            margin-left: 70px !important;
        }

        .sidebar-preload-collapsed .sidebar-brand,
        .sidebar-preload-collapsed .menu-label,
        .sidebar-preload-collapsed .menu-item a span,
        .sidebar-preload-collapsed .menu-item .badge {
            display: none !important;
        }

        @media (max-width: 991px) {
            .sidebar-preload-collapsed .main-content {
                margin-left: 0 !important;
            }
        }
    </style>
    <style>
        :root {
            --primary: #001E3F;
            --primary-light: #003366;
            --primary-dark: #001529;
            --accent: #4A90D9;
            --accent-light: #6BA3E0;
            --accent-soft: #2D5A87;

            --light-bg: #F5F7FA;
            --light-card: #FFFFFF;
            --light-text: #1A1A2E;
            --light-text-secondary: #5A6370;
            --light-border: #E1E5EB;

            --dark-bg: #001E3F;
            --dark-bg-secondary: #00152B;
            --dark-card: rgba(255, 255, 255, 0.05);
            --dark-text: #FFFFFF;
            --dark-text-secondary: rgba(255, 255, 255, 0.7);
            --dark-border: rgba(255, 255, 255, 0.1);

            --success: #28A745;
            --warning: #FFC107;
            --danger: #DC3545;
            --info: #17A2B8;
        }

        [data-theme="dark"] {
            --bg-primary: var(--dark-bg);
            --bg-secondary: var(--dark-bg-secondary);
            --card-bg: var(--dark-card);
            --text-primary: var(--dark-text);
            --text-secondary: var(--dark-text-secondary);
            --border-color: var(--dark-border);
            --sidebar-bg: var(--dark-bg-secondary);
        }

        [data-theme="light"] {
            --bg-primary: var(--light-bg);
            --bg-secondary: #E8ECF1;
            --card-bg: var(--light-card);
            --text-primary: var(--light-text);
            --text-secondary: var(--light-text-secondary);
            --border-color: var(--light-border);
            --sidebar-bg: var(--primary);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Noto Sans Lao', sans-serif;
            background: var(--bg-primary);
            color: var(--text-primary);
            min-height: 100vh;
            transition: all 0.3s ease;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            width: 260px;
            height: 100vh;
            background: var(--sidebar-bg);
            border-right: 1px solid var(--border-color);
            z-index: 100;
            transition: all 0.3s ease;
        }

        /* Sidebar Collapsed State */
        .sidebar.collapsed {
            width: 70px;
        }

        .sidebar.collapsed .sidebar-brand,
        .sidebar.collapsed .menu-label,
        .sidebar.collapsed .menu-item a span,
        .sidebar.collapsed .menu-item .badge {
            display: none;
        }

        .sidebar.collapsed .sidebar-header {
            justify-content: center;
            padding: 15px;
        }

        .sidebar.collapsed .sidebar-logo {
            width: 40px;
            height: 40px;
        }

        .sidebar.collapsed .menu-item a {
            justify-content: center;
            padding: 12px;
        }

        .sidebar.collapsed .menu-item a i {
            width: auto;
            font-size: 18px;
        }

        /* Sidebar Toggle Button - Floating Sidebar Edge */
        .sidebar-toggle {
            position: absolute;
            right: -14px;
            top: 35px;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            background: var(--accent);
            border: 3px solid var(--bg-primary);
            color: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 11px;
            transition: all 0.3s ease;
            z-index: 101;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        .sidebar-toggle:hover {
            background: var(--accent-light);
            transform: scale(1.15);
            box-shadow: 0 4px 12px rgba(74, 144, 217, 0.4);
        }

        .sidebar.collapsed .sidebar-toggle {
            top: 32px;
            /* ຂະຍັບຂຶ້ນໃຫ້ຢູ່ກາງ logo ເມື່ອ collapsed */
        }

        .sidebar.collapsed .sidebar-toggle i {
            transform: rotate(180deg);
        }

        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .sidebar-logo {
            width: 45px;
            height: 45px;
            background: linear-gradient(135deg, var(--accent), var(--accent-soft));
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
        }

        .sidebar-brand {
            color: white;
        }

        .sidebar-brand h2 {
            font-size: 20px;
            font-weight: 700;
        }

        .sidebar-brand span {
            font-size: 13px;
            color: rgba(255, 255, 255, 0.6);
        }

        .sidebar-menu {
            padding: 15px 0;
            list-style: none;
        }

        .menu-label {
            padding: 10px 20px;
            font-size: 13px;
            text-transform: uppercase;
            color: rgba(255, 255, 255, 0.4);
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        .menu-item {
            margin: 2px 10px;
        }

        .menu-item a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 15px;
            color: rgba(255, 255, 255, 0.7);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s ease;
            font-size: 16px;
        }

        .menu-item a:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
        }

        .menu-item a.active {
            background: var(--accent);
            color: white;
        }

        .menu-item a i {
            width: 20px;
            text-align: center;
        }

        .menu-item .badge {
            margin-left: auto;
            background: var(--danger);
            color: white;
            font-size: 12px;
            padding: 2px 8px;
            border-radius: 10px;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            min-height: 100vh;
            transition: all 0.3s ease;
        }

        .sidebar.collapsed~.main-content,
        body.sidebar-collapsed .main-content {
            margin-left: 70px;
        }

        /* Top Header */
        .top-header {
            position: sticky;
            top: 0;
            background: var(--bg-primary);
            border-bottom: 1px solid var(--border-color);
            padding: 15px 25px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            z-index: 50;
        }

        .page-title {
            font-size: 24px;
            font-weight: 600;
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .theme-toggle {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            color: var(--text-primary);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }

        .theme-toggle:hover {
            background: var(--accent);
            color: white;
        }

        .user-dropdown {
            position: relative;
        }

        .user-btn {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 8px 15px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 10px;
            color: var(--text-primary);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .user-btn:hover {
            border-color: var(--accent);
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            border-radius: 8px;
            background: var(--accent);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 14px;
        }

        .user-info {
            text-align: left;
        }

        .user-info .name {
            font-size: 15px;
            font-weight: 600;
        }

        .user-info .role {
            font-size: 13px;
            color: var(--text-secondary);
        }

        .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            margin-top: 8px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 10px;
            min-width: 180px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            display: none;
            overflow: hidden;
        }

        .dropdown-menu.show {
            display: block;
        }

        .dropdown-menu a {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 15px;
            color: var(--text-primary);
            text-decoration: none;
            font-size: 15px;
            transition: all 0.3s ease;
        }

        .dropdown-menu a:hover {
            background: var(--accent);
            color: white;
        }

        .dropdown-menu a.danger {
            color: var(--danger);
        }

        .dropdown-menu a.danger:hover {
            background: var(--danger);
            color: white;
        }

        /* Content Area */
        .content {
            padding: 25px;
        }

        /* Cards */
        .card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            overflow: hidden;
        }

        .card-header {
            padding: 18px 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .card-title {
            font-size: 18px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .card-body {
            padding: 20px;
        }

        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 18px;
            border: none;
            border-radius: 8px;
            font-size: 15px;
            font-weight: 500;
            font-family: inherit;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--accent), var(--accent-soft));
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(74, 144, 217, 0.3);
        }

        .btn-success {
            background: var(--success);
            color: white;
        }

        .btn-warning {
            background: var(--warning);
            color: #000;
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-secondary {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            color: var(--text-primary);
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 14px;
        }

        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 25px;
        }

        .stat-card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .stat-icon {
            width: 55px;
            height: 55px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 22px;
            color: white;
        }

        .stat-icon.blue {
            background: linear-gradient(135deg, #4A90D9, #2D5A87);
        }

        .stat-icon.green {
            background: linear-gradient(135deg, #28A745, #1E7B33);
        }

        .stat-icon.orange {
            background: linear-gradient(135deg, #FD7E14, #E06B10);
        }

        .stat-icon.purple {
            background: linear-gradient(135deg, #6C7AE0, #4A5BC7);
        }

        .stat-info h3 {
            font-size: 28px;
            font-weight: 700;
        }

        .stat-info p {
            font-size: 15px;
            color: var(--text-secondary);
        }

        /* Tables */
        .table-responsive {
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 14px 15px;
            text-align: left;
            border-bottom: 1px solid var(--border-color);
            font-size: 15px;
        }

        th {
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            color: var(--text-secondary);
            background: var(--bg-secondary);
        }

        td {
            font-size: 16px;
        }

        tr:hover {
            background: rgba(74, 144, 217, 0.05);
        }

        /* Status Badge */
        .status {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
        }

        .status.active {
            background: rgba(40, 167, 69, 0.15);
            color: #28A745;
        }

        .status.pending {
            background: rgba(255, 193, 7, 0.15);
            color: #D4A106;
        }

        .status.inactive {
            background: rgba(108, 117, 125, 0.15);
            color: #6C757D;
        }

        .status.suspended {
            background: rgba(220, 53, 69, 0.15);
            color: #DC3545;
        }

        /* Role Badge */
        .role-badge {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
        }

        .role-badge.super_admin {
            background: rgba(74, 144, 217, 0.15);
            color: #4A90D9;
        }

        .role-badge.admin {
            background: rgba(108, 122, 224, 0.15);
            color: #6C7AE0;
        }

        .role-badge.staff {
            background: rgba(80, 181, 169, 0.15);
            color: #50B5A9;
        }

        .role-badge.representative {
            background: rgba(232, 168, 56, 0.15);
            color: #E8A838;
        }

        /* Forms */
        .form-group {
            margin-bottom: 18px;
        }

        .form-label {
            display: block;
            font-size: 15px;
            font-weight: 500;
            color: var(--text-secondary);
            margin-bottom: 8px;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 8px;
            color: var(--text-primary);
            font-size: 16px;
            font-family: inherit;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--accent);
            box-shadow: 0 0 0 3px rgba(74, 144, 217, 0.15);
        }

        .form-control::placeholder {
            color: var(--text-secondary);
            opacity: 0.7;
        }

        select.form-control {
            cursor: pointer;
        }

        /* Modal */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.6);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 1000;
        }

        .modal-overlay.show {
            display: flex;
        }

        .modal {
            background: var(--bg-primary);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            width: 100%;
            max-width: 550px;
            max-height: 90vh;
            overflow-y: auto;
        }

        .modal-header {
            padding: 18px 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .modal-title {
            font-size: 20px;
            font-weight: 600;
        }

        .modal-close {
            width: 35px;
            height: 35px;
            border: none;
            background: var(--card-bg);
            border-radius: 8px;
            color: var(--text-primary);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .modal-close:hover {
            background: var(--danger);
            color: white;
        }

        .modal-body {
            padding: 20px;
        }

        .modal-footer {
            padding: 15px 20px;
            border-top: 1px solid var(--border-color);
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        /* Alert */
        .alert {
            padding: 14px 18px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 16px;
        }

        .alert-success {
            background: rgba(40, 167, 69, 0.15);
            border: 1px solid rgba(40, 167, 69, 0.3);
            color: #28A745;
        }

        .alert-error {
            background: rgba(220, 53, 69, 0.15);
            border: 1px solid rgba(220, 53, 69, 0.3);
            color: #DC3545;
        }

        .alert-warning {
            background: rgba(255, 193, 7, 0.15);
            border: 1px solid rgba(255, 193, 7, 0.3);
            color: #D4A106;
        }

        /* Responsive */
        @media (max-width: 991px) {
            .sidebar {
                transform: translateX(-100%);
                z-index: 1000;
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .sidebar-toggle {
                display: none;
            }

            .main-content {
                margin-left: 0;
            }

            body.sidebar-collapsed .main-content {
                margin-left: 0;
            }

            .mobile-menu-toggle {
                display: flex;
            }

            .sidebar-overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
                z-index: 999;
            }

            .sidebar-overlay.show {
                display: block;
            }

            .top-header {
                padding: 12px 15px;
            }

            .page-title {
                font-size: 18px;
            }

            .content {
                padding: 15px;
            }

            .stats-grid {
                grid-template-columns: 1fr;
                gap: 12px;
            }

            .stat-card {
                padding: 15px;
            }

            .stat-icon {
                width: 45px;
                height: 45px;
                font-size: 18px;
            }

            .stat-info h3 {
                font-size: 22px;
            }

            .stat-info p {
                font-size: 13px;
            }

            .card {
                border-radius: 12px;
            }

            .card-header {
                padding: 14px 15px;
                flex-wrap: wrap;
                gap: 10px;
            }

            .card-title {
                font-size: 16px;
            }

            .card-body {
                padding: 15px;
            }

            .btn {
                padding: 8px 14px;
                font-size: 14px;
            }

            .user-info {
                display: none;
            }

            .user-btn {
                padding: 8px 10px;
            }

            .header-actions {
                gap: 10px;
            }

            .theme-toggle {
                width: 36px;
                height: 36px;
            }

            .modal {
                margin: 15px;
                max-width: calc(100% - 30px);
            }

            .modal-header {
                padding: 14px 15px;
            }

            .modal-body {
                padding: 15px;
            }

            .modal-footer {
                padding: 12px 15px;
                flex-wrap: wrap;
            }

            .form-control {
                padding: 10px 12px;
                font-size: 15px;
            }

            /* Table responsive */
            .table-responsive {
                margin: 0 -15px;
                padding: 0 15px;
            }

            th,
            td {
                padding: 10px 12px;
                font-size: 14px;
            }

            th {
                font-size: 12px;
            }
        }

        @media (max-width: 576px) {
            .page-title {
                font-size: 16px;
            }

            .stat-card {
                padding: 12px;
            }

            .stat-icon {
                width: 40px;
                height: 40px;
                font-size: 16px;
            }

            .stat-info h3 {
                font-size: 20px;
            }

            .btn {
                padding: 8px 12px;
                font-size: 13px;
            }

            .card-header {
                padding: 12px;
            }

            .card-body {
                padding: 12px;
            }

            .dropdown-menu {
                min-width: 150px;
            }

            .dropdown-menu a {
                padding: 10px 12px;
                font-size: 14px;
            }

            th,
            td {
                padding: 8px 10px;
                font-size: 13px;
            }
        }

        /* Mobile Menu Toggle Button */
        .mobile-menu-toggle {
            display: none;
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            color: var(--text-primary);
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            transition: all 0.3s ease;
            flex-shrink: 0;
        }

        .mobile-menu-toggle:hover {
            background: var(--accent);
            color: white;
        }

        @media (max-width: 991px) {
            .mobile-menu-toggle {
                display: flex !important;
            }
        }
    </style>
</head>

<body>
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <button class="sidebar-toggle" onclick="toggleSidebar()" title="ພັບ/ຂະຫຍາຍເມນູ">
            <i class="fas fa-chevron-left"></i>
        </button>
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <i class="fas fa-shield-halved"></i>
            </div>
            <div class="sidebar-brand">
                <h2>EPCommerce</h2>
                <span>Super Admin Panel</span>
            </div>
        </div>

        <ul class="sidebar-menu">
            <li class="menu-label">ເມນູຫຼັກ</li>
            <li class="menu-item">
                <a href="dashboard.php" class="<?= $current_page === 'dashboard' ? 'active' : '' ?>">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </li>

            <li class="menu-label">ຈັດການລະບົບ</li>
            <li class="menu-item">
                <a href="users.php" class="<?= $current_page === 'users' ? 'active' : '' ?>">
                    <i class="fas fa-users"></i>
                    <span>ຈັດການຜູ້ໃຊ້</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="shops.php" class="<?= $current_page === 'shops' ? 'active' : '' ?>">
                    <i class="fas fa-store"></i>
                    <span>ຈັດການຮ້ານຄ້າ</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="shop_users.php" class="<?= $current_page === 'shop_users' ? 'active' : '' ?>">
                    <i class="fas fa-user-group"></i>
                    <span>ເຊື່ອມຕໍ່ User-Shop</span>
                </a>
            </li>

            <li class="menu-label">ອື່ນໆ</li>
            <li class="menu-item">
                <a href="activity_logs.php" class="<?= $current_page === 'activity_logs' ? 'active' : '' ?>">
                    <i class="fas fa-clock-rotate-left"></i>
                    <span>Activity Logs</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="../logout.php" class="danger">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>ອອກຈາກລະບົບ</span>
                </a>
            </li>
        </ul>
    </aside>

    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay" onclick="closeMobileSidebar()"></div>

    <!-- Main Content -->
    <main class="main-content">
        <!-- Top Header -->
        <header class="top-header">
            <!-- Mobile Menu Toggle -->
            <button class="mobile-menu-toggle" onclick="toggleMobileSidebar()" title="ເມນູ">
                <i class="fas fa-bars"></i>
            </button>

            <h1 class="page-title"><?= $page_title ?? 'Dashboard' ?></h1>

            <div class="header-actions">
                <button class="theme-toggle" onclick="toggleTheme()" title="ສະຫຼັບໂໝດສີ">
                    <i class="fas fa-moon" id="theme-icon"></i>
                </button>

                <div class="user-dropdown">
                    <button class="user-btn" onclick="toggleDropdown()">
                        <div class="user-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="user-info">
                            <div class="name"><?= htmlspecialchars($_SESSION['username'] ?? 'Admin') ?></div>
                            <div class="role"><?= htmlspecialchars($_SESSION['role_name'] ?? 'Super Admin') ?></div>
                        </div>
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="dropdown-menu" id="userDropdown">
                        <a href="profile.php"><i class="fas fa-user"></i> ໂປຣໄຟລ໌</a>
                        <a href="settings.php"><i class="fas fa-cog"></i> ຕັ້ງຄ່າ</a>
                        <a href="../logout.php" class="danger"><i class="fas fa-sign-out-alt"></i> ອອກຈາກລະບົບ</a>
                    </div>
                </div>
            </div>
        </header>

        <!-- Content -->
        <div class="content">