</div>
</main>

<script>
    // Theme Management
    function getTheme() {
        return localStorage.getItem('epcommerce_theme') || 'dark';
    }

    function setTheme(theme) {
        document.documentElement.setAttribute('data-theme', theme);
        localStorage.setItem('epcommerce_theme', theme);
        updateThemeIcon(theme);
    }

    function updateThemeIcon(theme) {
        const icon = document.getElementById('theme-icon');
        if (theme === 'dark') {
            icon.className = 'fas fa-moon';
        } else {
            icon.className = 'fas fa-sun';
        }
    }

    function toggleTheme() {
        const currentTheme = getTheme();
        const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
        setTheme(newTheme);
    }

    // Dropdown
    function toggleDropdown() {
        document.getElementById('userDropdown').classList.toggle('show');
    }

    // Close dropdown when clicking outside
    document.addEventListener('click', function (e) {
        if (!e.target.closest('.user-dropdown')) {
            document.getElementById('userDropdown').classList.remove('show');
        }
    });

    // Modal functions
    function openModal(modalId) {
        document.getElementById(modalId).classList.add('show');
    }

    function closeModal(modalId) {
        document.getElementById(modalId).classList.remove('show');
    }

    // Initialize theme on page load
    document.addEventListener('DOMContentLoaded', function () {
        setTheme(getTheme());

        // Restore sidebar state
        const sidebarCollapsed = localStorage.getItem('epcommerce_sidebar_collapsed') === 'true';
        if (sidebarCollapsed) {
            document.getElementById('sidebar').classList.add('collapsed');
            document.body.classList.add('sidebar-collapsed');
        }

        // Remove preload class to enable transitions
        document.documentElement.classList.remove('sidebar-preload-collapsed');
    });

    // Sidebar Toggle
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('collapsed');
        document.body.classList.toggle('sidebar-collapsed');

        // Save state
        const isCollapsed = sidebar.classList.contains('collapsed');
        localStorage.setItem('epcommerce_sidebar_collapsed', isCollapsed);
    }

    // Mobile Sidebar Toggle
    function toggleMobileSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        sidebar.classList.toggle('show');
        overlay.classList.toggle('show');
        document.body.style.overflow = sidebar.classList.contains('show') ? 'hidden' : '';
    }

    function closeMobileSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        sidebar.classList.remove('show');
        overlay.classList.remove('show');
        document.body.style.overflow = '';
    }

    // Close mobile sidebar on window resize (if going to desktop)
    window.addEventListener('resize', function () {
        if (window.innerWidth > 991) {
            closeMobileSidebar();
        }
    });
</script>
</body>

</html>