<?php
$page_title = 'Dashboard';
require_once 'includes/header.php';

// Get statistics
$stats = [];

// Total Users
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE deleted_at IS NULL");
$stats['total_users'] = $stmt->fetchColumn();

// Total Shops
$stmt = $pdo->query("SELECT COUNT(*) FROM shops WHERE deleted_at IS NULL");
$stats['total_shops'] = $stmt->fetchColumn();

// Pending Users
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE status = 'pending' AND deleted_at IS NULL");
$stats['pending_users'] = $stmt->fetchColumn();

// Pending Shops
$stmt = $pdo->query("SELECT COUNT(*) FROM shops WHERE status = 'pending' AND deleted_at IS NULL");
$stats['pending_shops'] = $stmt->fetchColumn();

// Recent Users
$stmt = $pdo->query("
    SELECT u.*, r.role_name, r.role_code 
    FROM users u 
    LEFT JOIN user_roles r ON u.role_id = r.role_id 
    WHERE u.deleted_at IS NULL 
    ORDER BY u.created_at DESC 
    LIMIT 5
");
$recent_users = $stmt->fetchAll();

// Recent Shops
$stmt = $pdo->query("
    SELECT s.*, u.username as owner_username 
    FROM shops s 
    LEFT JOIN users u ON s.owner_user_id = u.id 
    WHERE s.deleted_at IS NULL 
    ORDER BY s.created_at DESC 
    LIMIT 5
");
$recent_shops = $stmt->fetchAll();
?>

<!-- Stats Cards -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon blue">
            <i class="fas fa-users"></i>
        </div>
        <div class="stat-info">
            <h3><?= number_format($stats['total_users']) ?></h3>
            <p>ຜູ້ໃຊ້ທັງໝົດ</p>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-icon green">
            <i class="fas fa-store"></i>
        </div>
        <div class="stat-info">
            <h3><?= number_format($stats['total_shops']) ?></h3>
            <p>ຮ້ານຄ້າທັງໝົດ</p>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-icon orange">
            <i class="fas fa-user-clock"></i>
        </div>
        <div class="stat-info">
            <h3><?= number_format($stats['pending_users']) ?></h3>
            <p>ຜູ້ໃຊ້ລໍຖ້າອະນຸມັດ</p>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-icon purple">
            <i class="fas fa-store-slash"></i>
        </div>
        <div class="stat-info">
            <h3><?= number_format($stats['pending_shops']) ?></h3>
            <p>ຮ້ານຄ້າລໍຖ້າອະນຸມັດ</p>
        </div>
    </div>
</div>

<!-- Recent Data -->
<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
    <!-- Recent Users -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-users"></i> ຜູ້ໃຊ້ຫຼ້າສຸດ</h3>
            <a href="users.php" class="btn btn-secondary btn-sm">ເບິ່ງທັງໝົດ</a>
        </div>
        <div class="card-body" style="padding: 0;">
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>ຜູ້ໃຊ້</th>
                            <th>Role</th>
                            <th>ສະຖານະ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($recent_users)): ?>
                            <tr>
                                <td colspan="3" style="text-align: center; color: var(--text-secondary);">ບໍ່ມີຂໍ້ມູນ</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($recent_users as $user): ?>
                                <tr>
                                    <td>
                                        <div style="display: flex; align-items: center; gap: 10px;">
                                            <div class="user-avatar" style="width: 35px; height: 35px; font-size: 12px;">
                                                <?= strtoupper(substr($user['username'], 0, 1)) ?>
                                            </div>
                                            <div>
                                                <strong><?= htmlspecialchars($user['username']) ?></strong>
                                                <div style="font-size: 11px; color: var(--text-secondary);">
                                                    <?= htmlspecialchars($user['email']) ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td><span
                                            class="role-badge <?= $user['role_code'] ?>"><?= htmlspecialchars($user['role_name']) ?></span>
                                    </td>
                                    <td><span class="status <?= $user['status'] ?>"><?= ucfirst($user['status']) ?></span></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Recent Shops -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-store"></i> ຮ້ານຄ້າຫຼ້າສຸດ</h3>
            <a href="shops.php" class="btn btn-secondary btn-sm">ເບິ່ງທັງໝົດ</a>
        </div>
        <div class="card-body" style="padding: 0;">
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>ຮ້ານຄ້າ</th>
                            <th>ເຈົ້າຂອງ</th>
                            <th>ສະຖານະ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($recent_shops)): ?>
                            <tr>
                                <td colspan="3" style="text-align: center; color: var(--text-secondary);">ບໍ່ມີຂໍ້ມູນ</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($recent_shops as $shop): ?>
                                <tr>
                                    <td>
                                        <div style="display: flex; align-items: center; gap: 10px;">
                                            <div class="user-avatar"
                                                style="width: 35px; height: 35px; font-size: 12px; background: var(--accent-soft);">
                                                <i class="fas fa-store"></i>
                                            </div>
                                            <div>
                                                <strong><?= htmlspecialchars($shop['shop_name']) ?></strong>
                                                <div style="font-size: 11px; color: var(--text-secondary);">
                                                    <?= htmlspecialchars($shop['province'] ?? '-') ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?= htmlspecialchars($shop['owner_username'] ?? '-') ?></td>
                                    <td><span class="status <?= $shop['status'] ?>"><?= ucfirst($shop['status']) ?></span></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>