<?php
session_start();
require_once 'includes/con_database.php';

$error = '';

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = trim($_POST['login'] ?? ''); // username or email
    $password = $_POST['password'] ?? '';
    $remember = isset($_POST['remember']);

    if (empty($login) || empty($password)) {
        $error = 'ກະລຸນາກຣອກ Username/Email ແລະ Password';
    } else {
        // Find user by username or email
        $stmt = $pdo->prepare("
            SELECT u.*, r.role_code, r.role_name, r.can_access_admin
            FROM users u
            INNER JOIN user_roles r ON u.role_id = r.role_id
            WHERE (u.username = ? OR u.email = ?) AND u.deleted_at IS NULL
        ");
        $stmt->execute([$login, $login]);
        $user = $stmt->fetch();

        if (!$user) {
            $error = 'Username/Email ຫຼື Password ບໍ່ຖືກຕ້ອງ';
        } elseif ($user['status'] === 'suspended') {
            $error = 'ບັນຊີຂອງທ່ານຖືກລະງັບການໃຊ້ງານ ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບ';
        } elseif ($user['status'] === 'pending') {
            $error = 'ບັນຊີຂອງທ່ານຍັງລໍການອະນຸມັດ ກະລຸນາລໍການກວດສອບຈາກຜູ້ເບິ່ງແຍງລະບົບ';
        } elseif ($user['status'] === 'inactive') {
            $error = 'ບັນຊີຂອງທ່ານຖືກປິດໃຊ້ງານ ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບ';
        } elseif ($user['locked_until'] && strtotime($user['locked_until']) > time()) {
            $remaining = ceil((strtotime($user['locked_until']) - time()) / 60);
            $error = "ບັນຊີຖືກລັອກຊົ່ວຄາວ ກະລຸນາລອງໃໝ່ໃນ {$remaining} ນາທີ";
        } elseif (!password_verify($password, $user['password'])) {
            // Increment login attempts
            $attempts = $user['login_attempts'] + 1;
            $locked_until = null;

            // Lock account after 5 failed attempts
            if ($attempts >= 5) {
                $locked_until = date('Y-m-d H:i:s', time() + (15 * 60)); // 15 minutes
                $attempts = 0;
            }

            $stmt = $pdo->prepare("UPDATE users SET login_attempts = ?, locked_until = ? WHERE id = ?");
            $stmt->execute([$attempts, $locked_until, $user['id']]);

            if ($locked_until) {
                $error = 'ເຂົ້າສູ່ລະບົບຜິດພາດຫຼາຍຄັ້ງ ບັນຊີຖືກລັອກ 15 ນາທີ';
            } else {
                $remaining = 5 - $attempts;
                $error = "Password ບໍ່ຖືກຕ້ອງ (ເຫຼືອສິດອີກ {$remaining} ຄັ້ງ)";
            }
        } else {
            // Login successful!
            // Reset login attempts
            $stmt = $pdo->prepare("UPDATE users SET login_attempts = 0, locked_until = NULL, last_login = NOW() WHERE id = ?");
            $stmt->execute([$user['id']]);

            // Set session
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['US_id'] = $user['US_id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['first_name'] = $user['first_name'];
            $_SESSION['last_name'] = $user['last_name'];
            $_SESSION['role_id'] = $user['role_id'];
            $_SESSION['role_code'] = $user['role_code'];
            $_SESSION['role_name'] = $user['role_name'];
            $_SESSION['can_access_admin'] = $user['can_access_admin'];
            $_SESSION['avatar'] = $user['avatar'];

            // Set shop_id for multi-tenancy
            $shop_id = null;
            if (!empty($user['shop_id'])) {
                // User has shop_id assigned directly
                $shop_id = $user['shop_id'];
            } else {
                // Check if user owns a shop
                $shopStmt = $pdo->prepare("SELECT id FROM shops WHERE owner_user_id = ? AND deleted_at IS NULL LIMIT 1");
                $shopStmt->execute([$user['id']]);
                $shop = $shopStmt->fetch();
                if ($shop) {
                    $shop_id = $shop['id'];
                }
            }
            $_SESSION['shop_id'] = $shop_id;

            // Log activity
            $stmt = $pdo->prepare("
                INSERT INTO user_activity_logs (user_id, action, description, ip_address, user_agent)
                VALUES (?, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', ?, ?)
            ");
            $stmt->execute([$user['id'], $_SERVER['REMOTE_ADDR'] ?? '', $_SERVER['HTTP_USER_AGENT'] ?? '']);

            // Create session record
            $session_token = bin2hex(random_bytes(32));
            $expires_at = date('Y-m-d H:i:s', time() + ($remember ? 30 * 24 * 60 * 60 : 24 * 60 * 60));

            $stmt = $pdo->prepare("
                INSERT INTO user_sessions (user_id, session_token, ip_address, user_agent, expires_at)
                VALUES (?, ?, ?, ?, ?)
            ");
            $stmt->execute([$user['id'], $session_token, $_SERVER['REMOTE_ADDR'] ?? '', $_SERVER['HTTP_USER_AGENT'] ?? '', $expires_at]);

            $_SESSION['session_token'] = $session_token;

            // Redirect based on role_code
            switch ($user['role_code']) {
                case 'super_admin':
                    header('Location: super_admin/dashboard.php');
                    break;
                case 'admin':
                    header('Location: admin/dashboard.php');
                    break;
                case 'staff':
                    header('Location: staff/dashboard.php');
                    break;
                case 'representative':
                    header('Location: representative/dashboard.php');
                    break;
                default:
                    header('Location: index.php');
                    break;
            }
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="lo" data-theme="dark">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ເຂົ້າສູ່ລະບົບ - EPCommerce</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root {
            /* Primary Navy Theme */
            --primary: #001E3F;
            --primary-light: #003366;
            --primary-dark: #001529;
            --accent: #4A90D9;
            --accent-light: #6BA3E0;
            --accent-soft: #2D5A87;

            /* Light Mode Colors */
            --light-bg: #F5F7FA;
            --light-card: #FFFFFF;
            --light-text: #1A1A2E;
            --light-text-secondary: #5A6370;
            --light-border: #E1E5EB;
            --light-input-bg: #F8F9FB;

            /* Dark Mode Colors */
            --dark-bg: #001E3F;
            --dark-card: rgba(255, 255, 255, 0.05);
            --dark-text: #FFFFFF;
            --dark-text-secondary: rgba(255, 255, 255, 0.7);
            --dark-border: rgba(255, 255, 255, 0.1);
            --dark-input-bg: rgba(255, 255, 255, 0.05);
        }

        /* Dark Theme (Default) */
        [data-theme="dark"] {
            --bg-primary: var(--dark-bg);
            --bg-secondary: #00152B;
            --card-bg: var(--dark-card);
            --text-primary: var(--dark-text);
            --text-secondary: var(--dark-text-secondary);
            --border-color: var(--dark-border);
            --input-bg: var(--dark-input-bg);
        }

        /* Light Theme */
        [data-theme="light"] {
            --bg-primary: var(--light-bg);
            --bg-secondary: #E8ECF1;
            --card-bg: var(--light-card);
            --text-primary: var(--light-text);
            --text-secondary: var(--light-text-secondary);
            --border-color: var(--light-border);
            --input-bg: var(--light-input-bg);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Noto Sans Lao', sans-serif;
            min-height: 100vh;
            background: var(--bg-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            transition: background 0.3s ease;
        }

        .container {
            width: 100%;
            max-width: 420px;
        }

        /* Theme Toggle */
        .theme-toggle {
            position: fixed;
            top: 20px;
            right: 20px;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            color: var(--text-primary);
            font-size: 20px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            z-index: 100;
        }

        .theme-toggle:hover {
            background: var(--accent);
            color: white;
            transform: scale(1.1);
        }

        .login-card {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 45px 40px;
            border: 1px solid var(--border-color);
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
            transition: all 0.3s ease;
        }

        [data-theme="light"] .login-card {
            box-shadow: 0 10px 40px rgba(0, 30, 63, 0.08);
        }

        .logo {
            text-align: center;
            margin-bottom: 35px;
        }

        .logo-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, var(--accent) 0%, var(--accent-soft) 100%);
            border-radius: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 18px;
            font-size: 32px;
            color: white;
        }

        .logo h1 {
            color: var(--text-primary);
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .logo p {
            color: var(--text-secondary);
            font-size: 16px;
        }

        .alert {
            padding: 14px 16px;
            border-radius: 10px;
            margin-bottom: 22px;
            font-size: 16px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .alert-error {
            background: rgba(220, 53, 69, 0.12);
            border: 1px solid rgba(220, 53, 69, 0.25);
            color: #DC3545;
        }

        [data-theme="dark"] .alert-error {
            color: #FF6B7A;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            color: var(--text-secondary);
            font-size: 16px;
            font-weight: 500;
            margin-bottom: 10px;
        }

        .input-wrapper {
            position: relative;
        }

        .input-wrapper i:first-of-type {
            position: absolute;
            left: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            font-size: 16px;
        }

        input[type="text"],
        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 15px 16px 15px 48px;
            background: var(--input-bg);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            color: var(--text-primary);
            font-size: 17px;
            font-family: inherit;
            transition: all 0.3s ease;
        }

        input:focus {
            outline: none;
            border-color: var(--accent);
            box-shadow: 0 0 0 3px rgba(74, 144, 217, 0.15);
        }

        input::placeholder {
            color: var(--text-secondary);
            opacity: 0.7;
        }

        .password-toggle {
            position: absolute;
            right: 33px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            cursor: pointer;
            padding: 5px;
            transition: color 0.3s;
        }

        .password-toggle:hover {
            color: var(--accent);
        }

        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            font-size: 16px;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 10px;
            color: var(--text-secondary);
            cursor: pointer;
        }

        .remember-me input {
            width: 18px;
            height: 18px;
            accent-color: var(--accent);
            cursor: pointer;
        }

        .forgot-password {
            color: var(--accent);
            text-decoration: none;
            transition: color 0.3s;
        }

        .forgot-password:hover {
            color: var(--accent-light);
        }

        .btn-login {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, var(--accent) 0%, var(--accent-soft) 100%);
            border: none;
            border-radius: 12px;
            color: white;
            font-size: 18px;
            font-weight: 600;
            font-family: inherit;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(74, 144, 217, 0.35);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .divider {
            display: flex;
            align-items: center;
            margin: 28px 0;
            color: var(--text-secondary);
            font-size: 16px;
        }

        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background: var(--border-color);
        }

        .divider span {
            padding: 0 18px;
        }

        .register-link {
            text-align: center;
            color: var(--text-secondary);
            font-size: 17px;
        }

        .register-link a {
            color: var(--accent);
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s;
        }

        .register-link a:hover {
            color: var(--accent-light);
        }

        /* Role badges */
        .role-badges {
            display: flex;
            justify-content: center;
            gap: 8px;
            margin-top: 25px;
            flex-wrap: wrap;
        }

        .role-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 5px;
            background: var(--input-bg);
            border: 1px solid var(--border-color);
            color: var(--text-secondary);
        }

        .role-badge i {
            font-size: 12px;
        }

        .role-badge.super-admin i {
            color: #4A90D9;
        }

        .role-badge.admin i {
            color: #6C7AE0;
        }

        .role-badge.staff i {
            color: #50B5A9;
        }

        .role-badge.rep i {
            color: #E8A838;
        }

        @media (max-width: 480px) {
            .login-card {
                padding: 35px 25px;
            }

            .form-options {
                flex-direction: column;
                gap: 15px;
                align-items: flex-start;
            }
        }
    </style>
</head>

<body>
    <!-- Theme Toggle Button -->
    <button class="theme-toggle" onclick="toggleTheme()" title="ສະຫຼັບໂໝດສີ">
        <i class="fas fa-moon" id="theme-icon"></i>
    </button>

    <div class="container">
        <div class="login-card">
            <div class="logo">
                <div class="logo-icon">
                    <i class="fas fa-store"></i>
                </div>
                <h1>EPCommerce</h1>
                <p>ເຂົ້າສູ່ລະບົບເພື່ອຈັດການຮ້ານຄ້າຂອງທ່ານ</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="form-group">
                    <label>Username ຫຼື Email</label>
                    <div class="input-wrapper">
                        <i class="fas fa-user"></i>
                        <input type="text" name="login" placeholder="ກຣອກ username ຫຼື email" required
                            value="<?= htmlspecialchars($_POST['login'] ?? '') ?>">
                    </div>
                </div>

                <div class="form-group">
                    <label>Password</label>
                    <div class="input-wrapper">
                        <i class="fas fa-lock"></i>
                        <input type="password" name="password" id="password" placeholder="ກຣອກລະຫັດຜ່ານ" required>
                        <span class="password-toggle" onclick="togglePassword()">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>
                </div>

                <div class="form-options">
                    <label class="remember-me">
                        <input type="checkbox" name="remember">
                        ຈົດຈໍາການເຂົ້າສູ່ລະບົບ
                    </label>
                    <a href="forgot_password.php" class="forgot-password">ລືມລະຫັດຜ່ານ?</a>
                </div>

                <button type="submit" class="btn-login">
                    <i class="fas fa-sign-in-alt"></i> ເຂົ້າສູ່ລະບົບ
                </button>
            </form>

            <div class="role-badges">
                <span class="role-badge super-admin"><i class="fas fa-shield-halved"></i> Super Admin</span>
                <span class="role-badge admin"><i class="fas fa-crown"></i> Admin</span>
                <span class="role-badge staff"><i class="fas fa-user-tie"></i> Staff</span>
                <span class="role-badge rep"><i class="fas fa-handshake"></i> Representative</span>
            </div>
        </div>
    </div>

    <script>
        // Theme Management
        function getTheme() {
            return localStorage.getItem('epcommerce_theme') || 'dark';
        }

        function setTheme(theme) {
            document.documentElement.setAttribute('data-theme', theme);
            localStorage.setItem('epcommerce_theme', theme);
            updateThemeIcon(theme);
        }

        function updateThemeIcon(theme) {
            const icon = document.getElementById('theme-icon');
            if (theme === 'dark') {
                icon.className = 'fas fa-moon';
            } else {
                icon.className = 'fas fa-sun';
            }
        }

        function toggleTheme() {
            const currentTheme = getTheme();
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            setTheme(newTheme);
        }

        // Initialize theme on page load
        document.addEventListener('DOMContentLoaded', function () {
            setTheme(getTheme());
        });

        // Toggle password visibility
        function togglePassword() {
            const input = document.getElementById('password');
            const icon = document.querySelector('.password-toggle i');

            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }
    </script>
</body>

</html>