<?php
/**
 * Helper functions to get secondary IDs (US_id, CU_id, PR_id, etc.)
 * Used throughout admin pages to store secondary IDs instead of auto-increment ids
 */

require_once __DIR__ . '/con_database.php';

/**
 * Get user's US_id from session user_id
 */
function getUserSecondaryId($conn, $user_id)
{
    if (!$user_id)
        return null;
    $stmt = $conn->prepare("SELECT US_id FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        return $row['US_id'];
    }
    return null;
}

/**
 * Get customer CU_id from customer id
 */
function getCustomerSecondaryId($conn, $customer_id)
{
    if (!$customer_id)
        return null;
    $stmt = $conn->prepare("SELECT CU_id FROM customers WHERE id = ?");
    $stmt->bind_param("i", $customer_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        return $row['CU_id'];
    }
    return null;
}

/**
 * Get product PR_id from product id
 */
function getProductSecondaryId($conn, $product_id)
{
    if (!$product_id)
        return null;
    $stmt = $conn->prepare("SELECT PR_id FROM products WHERE id = ?");
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        return $row['PR_id'];
    }
    return null;
}

/**
 * Get shipping company SC_id from company id 
 */
function getShippingCompanySecondaryId($conn, $company_id)
{
    if (!$company_id)
        return null;
    $stmt = $conn->prepare("SELECT SC_id FROM shipping_companies WHERE id = ?");
    $stmt->bind_param("i", $company_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        return $row['SC_id'];
    }
    return null;
}

/**
 * Get shipping branch SB_id from branch id
 */
function getShippingBranchSecondaryId($conn, $branch_id)
{
    if (!$branch_id)
        return null;
    $stmt = $conn->prepare("SELECT SB_id FROM shipping_branches WHERE id = ?");
    $stmt->bind_param("i", $branch_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        return $row['SB_id'];
    }
    return null;
}

/**
 * Get category CA_id from category id
 */
function getCategorySecondaryId($conn, $category_id)
{
    if (!$category_id)
        return null;
    $stmt = $conn->prepare("SELECT CA_id FROM product_categories WHERE id = ?");
    $stmt->bind_param("i", $category_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        return $row['CA_id'];
    }
    return null;
}

/**
 * Get unit UN_id from unit id
 */
function getUnitSecondaryId($conn, $unit_id)
{
    if (!$unit_id)
        return null;
    $stmt = $conn->prepare("SELECT UN_id FROM units WHERE id = ?");
    $stmt->bind_param("i", $unit_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        return $row['UN_id'];
    }
    return null;
}

/**
 * Get color CO_id from color id
 */
function getColorSecondaryId($conn, $color_id)
{
    if (!$color_id)
        return null;
    $stmt = $conn->prepare("SELECT CO_id FROM colors WHERE id = ?");
    $stmt->bind_param("i", $color_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        return $row['CO_id'];
    }
    return null;
}

/**
 * Get shop SH_id from shop id
 */
function getShopSecondaryId($conn, $shop_id)
{
    if (!$shop_id)
        return null;
    $stmt = $conn->prepare("SELECT SH_id FROM shops WHERE id = ?");
    $stmt->bind_param("i", $shop_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        return $row['SH_id'];
    }
    return null;
}
