-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Jan 12, 2026 at 11:51 PM
-- Server version: 10.11.14-MariaDB-cll-lve-log
-- PHP Version: 8.4.16

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `zfhfpsz1_sokxay`
--

-- --------------------------------------------------------

--
-- Table structure for table `audit_log`
--

CREATE TABLE `audit_log` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `event` varchar(50) NOT NULL,
  `ip` varchar(45) NOT NULL,
  `created_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data for table `audit_log`
--

INSERT INTO `audit_log` (`id`, `user_id`, `event`, `ip`, `created_at`) VALUES
(1, 1, 'logout', '115.84.101.173', '2025-12-10 11:54:18'),
(2, 1, 'login_success', '115.84.101.173', '2025-12-10 11:54:21'),
(3, 1, 'login_success', '115.84.101.173', '2025-12-10 13:09:52'),
(4, 1, 'login_success', '183.182.115.109', '2025-12-10 16:59:29'),
(5, 1, 'login_success', '183.182.115.109', '2025-12-10 17:04:21'),
(6, 1, 'login_success', '115.84.101.173', '2025-12-11 08:59:01'),
(7, 1, 'logout', '115.84.101.173', '2025-12-11 10:24:13'),
(8, 1, 'login_success', '115.84.101.173', '2025-12-11 10:24:15'),
(9, 1, 'login_success', '115.84.101.173', '2025-12-11 11:30:00'),
(10, 1, 'logout', '115.84.101.173', '2025-12-11 12:02:08'),
(11, 1, 'login_success', '115.84.101.173', '2025-12-11 12:02:09'),
(12, 1, 'login_success', '115.84.101.173', '2025-12-11 13:23:09'),
(13, 1, 'login_success', '115.84.101.173', '2025-12-11 14:58:39'),
(14, 1, 'login_success', '115.84.101.173', '2025-12-12 09:15:04'),
(15, 1, 'login_success', '115.84.101.173', '2025-12-12 09:42:37'),
(16, 1, 'logout', '115.84.101.173', '2025-12-12 10:01:40'),
(17, 1, 'login_success', '115.84.101.173', '2025-12-12 10:01:42'),
(18, NULL, 'login_failed', '185.191.171.5', '2025-12-13 09:53:24'),
(19, NULL, 'login_failed', '51.195.183.192', '2025-12-15 19:31:14'),
(20, NULL, 'login_failed', '54.38.147.250', '2025-12-16 03:52:09'),
(21, 1, 'login_success', '183.182.115.109', '2025-12-16 07:50:59'),
(22, 1, 'login_success', '115.84.101.173', '2025-12-16 09:25:23'),
(23, 1, 'logout', '115.84.101.173', '2025-12-16 09:53:50'),
(24, 1, 'login_success', '115.84.101.173', '2025-12-16 09:53:52'),
(25, 1, 'logout', '115.84.101.173', '2025-12-16 09:56:08'),
(26, 1, 'login_success', '115.84.101.173', '2025-12-16 09:56:09'),
(27, NULL, 'login_failed', '185.191.171.17', '2025-12-16 14:31:08'),
(28, NULL, 'login_failed', '205.185.116.215', '2025-12-16 20:49:08'),
(29, NULL, 'login_failed', '205.185.116.215', '2025-12-16 20:49:12'),
(30, NULL, 'login_failed', '205.185.116.215', '2025-12-16 20:49:16'),
(31, NULL, 'login_failed', '205.185.116.215', '2025-12-16 20:49:19'),
(32, NULL, 'login_failed', '205.185.116.215', '2025-12-16 20:49:23'),
(33, NULL, 'login_failed', '54.38.147.239', '2025-12-23 16:43:38'),
(34, NULL, 'login_failed', '51.89.129.131', '2025-12-23 19:01:42'),
(35, NULL, 'login_failed', '198.244.226.202', '2025-12-29 13:14:24'),
(36, NULL, 'login_failed', '198.244.183.204', '2025-12-30 02:52:28'),
(37, 1, 'login_success', '115.84.101.170', '2026-01-05 13:59:31'),
(38, 1, 'logout', '115.84.101.170', '2026-01-05 14:08:00'),
(39, 1, 'login_success', '115.84.101.170', '2026-01-05 14:08:14'),
(40, 1, 'logout', '115.84.101.170', '2026-01-05 14:10:12'),
(41, 1, 'login_success', '115.84.101.170', '2026-01-05 14:10:19'),
(42, 1, 'logout', '115.84.101.170', '2026-01-05 14:15:33'),
(43, NULL, 'login_failed', '198.244.240.203', '2026-01-06 18:53:57'),
(44, NULL, 'login_failed', '51.195.183.176', '2026-01-07 09:25:49'),
(45, NULL, 'login_failed', '51.89.129.174', '2026-01-12 03:46:24'),
(46, NULL, 'login_failed', '5.39.1.242', '2026-01-12 20:13:27'),
(47, 1, 'login_success', '183.182.110.14', '2026-01-12 21:46:30');

-- --------------------------------------------------------

--
-- Table structure for table `currencys`
--

CREATE TABLE `currencys` (
  `id` int(11) NOT NULL,
  `currencys_id` varchar(20) DEFAULT NULL,
  `currencys_name` varchar(100) DEFAULT NULL,
  `currencys_fullname` varchar(150) DEFAULT NULL,
  `currencys_symbol` varchar(10) DEFAULT NULL,
  `base_currency` enum('YES','NO') DEFAULT 'NO'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currencys`
--

INSERT INTO `currencys` (`id`, `currencys_id`, `currencys_name`, `currencys_fullname`, `currencys_symbol`, `base_currency`) VALUES
(1, 'CUR_1', 'Lao Kip', 'ກີບລາວ', '₭', 'NO'),
(2, 'CUR_2', 'Thai Baht', 'ບາດໄທ', '฿', 'NO'),
(3, 'CUR_3', 'US Dollar', 'ໂດລາສະຫະລັດ', '$', 'NO');

--
-- Triggers `currencys`
--
DELIMITER $$
CREATE TRIGGER `trg_currencys_before_insert` BEFORE INSERT ON `currencys` FOR EACH ROW BEGIN
    IF NEW.currencys_id IS NULL THEN
        SET NEW.currencys_id = CONCAT('CUR_', 
            (SELECT IFNULL(MAX(SUBSTRING(currencys_id,5)+0),0)+1 FROM currencys)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `id` int(11) NOT NULL,
  `cus_id` varchar(20) DEFAULT NULL,
  `cus_name` varchar(255) DEFAULT NULL,
  `cus_address` text DEFAULT NULL,
  `cus_tel` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `cus_id`, `cus_name`, `cus_address`, `cus_tel`) VALUES
(1, 'CUS_1', 'MSIG', '', ''),
(2, 'CUS_2', 'cafe', '', ''),
(3, 'CUS_3', 'Sokxay-cafe', '', '');

--
-- Triggers `customers`
--
DELIMITER $$
CREATE TRIGGER `trg_customers_before_insert` BEFORE INSERT ON `customers` FOR EACH ROW BEGIN
    IF NEW.cus_id IS NULL THEN
        SET NEW.cus_id = CONCAT('CUS_', 
            (SELECT IFNULL(MAX(SUBSTRING(cus_id,5)+0),0)+1 FROM customers)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `detail_product`
--

CREATE TABLE `detail_product` (
  `id` int(11) NOT NULL,
  `detail_product_id` varchar(20) DEFAULT NULL,
  `detail_text` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `detail_product`
--

INSERT INTO `detail_product` (`id`, `detail_product_id`, `detail_text`) VALUES
(3, 'DP_1', 'CPU ( 8Cores ) \r\nRAM ( 64GB ) \r\nDISK SSD ( 800GB )'),
(4, 'DP_2', 'SUSE Linux Enterprise Server'),
(5, 'DP_3', 'CPU ( 4Cores ) \r\nRAM ( 16GB ) \r\nDISK SSD ( 700GB )'),
(6, 'DP_4', 'Windows Server 2025 Standard'),
(7, 'DP_5', 'cat6 Indoor');

--
-- Triggers `detail_product`
--
DELIMITER $$
CREATE TRIGGER `trg_detail_product_before_insert` BEFORE INSERT ON `detail_product` FOR EACH ROW BEGIN
    IF NEW.detail_product_id IS NULL THEN
        SET NEW.detail_product_id = CONCAT('DP_', 
            (SELECT IFNULL(MAX(SUBSTRING(detail_product_id,4)+0),0)+1 
             FROM detail_product)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `id` int(11) NOT NULL,
  `notification_id` varchar(50) DEFAULT NULL,
  `order_id` varchar(50) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `notifications`
--

INSERT INTO `notifications` (`id`, `notification_id`, `order_id`, `user_id`, `type`, `message`, `data`, `created_at`) VALUES
(9, 'NOT_1', 'ODR_1', 1, 'quotation_rejected', 'ໃບສະເໜີລາຄາ ODR_1 ຖືກປະຕິເສດ: CVsgags', NULL, '2025-12-12 10:02:05'),
(10, 'NOT_2', 'ODR_1', 1, 'invoice_rejected', 'ໃບເກັບເງິນ ODR_1 ຖືກປະຕິເສດ: Bxbdbdg', NULL, '2025-12-12 10:03:01');

--
-- Triggers `notifications`
--
DELIMITER $$
CREATE TRIGGER `trg_notifications_before_insert` BEFORE INSERT ON `notifications` FOR EACH ROW BEGIN
    IF NEW.notification_id IS NULL THEN
        SET NEW.notification_id = CONCAT('NOT_', (SELECT IFNULL(MAX(SUBSTRING(notification_id,5)+0),0)+1 FROM notifications));
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `notifications_read`
--

CREATE TABLE `notifications_read` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `order_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `notifications_read`
--

INSERT INTO `notifications_read` (`id`, `user_id`, `order_id`, `read_at`) VALUES
(8, 1, 'ODR_1_quotation', '2025-12-12 10:02:10'),
(9, 1, 'ODR_1_invoice', '2025-12-12 10:03:13'),
(10, 1, 'ODR_2_quotation', '2025-12-12 10:11:20');

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` int(11) NOT NULL,
  `order_id` varchar(20) DEFAULT NULL,
  `quotation_no` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(50) DEFAULT NULL,
  `order_date` date DEFAULT NULL,
  `section` varchar(255) DEFAULT NULL,
  `order_payment_status` varchar(50) DEFAULT NULL,
  `payment_status` enum('unpaid','partial_paid','paid') DEFAULT NULL,
  `order_payment_method` varchar(50) DEFAULT NULL,
  `payment_type` enum('cash','bank_transfer','cheque','other') DEFAULT NULL,
  `order_discount` decimal(20,2) DEFAULT 0.00,
  `order_subtotal` decimal(20,2) DEFAULT 0.00,
  `order_tax_percent` decimal(5,2) DEFAULT NULL,
  `order_tax_amount` decimal(20,2) DEFAULT 0.00,
  `order_total` decimal(20,2) DEFAULT 0.00,
  `approval_status` enum('approved','pending','rejected') DEFAULT NULL,
  `not_approve_reason` text DEFAULT NULL,
  `approval_changed_at` datetime DEFAULT NULL,
  `cus_id` varchar(20) DEFAULT NULL,
  `currencys_id` varchar(20) DEFAULT NULL,
  `rate_id` varchar(20) DEFAULT NULL,
  `print_quotation` enum('YES','NO') DEFAULT 'NO',
  `print_invoice` enum('YES','NO') DEFAULT 'NO',
  `invoice_approval_status` enum('approved','pending','rejected') DEFAULT NULL,
  `invoice_not_approve_reason` text DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `remark_id` varchar(20) DEFAULT NULL,
  `detail_product_id` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `orders`
--

INSERT INTO `orders` (`id`, `order_id`, `quotation_no`, `invoice_no`, `order_date`, `section`, `order_payment_status`, `payment_status`, `order_payment_method`, `payment_type`, `order_discount`, `order_subtotal`, `order_tax_percent`, `order_tax_amount`, `order_total`, `approval_status`, `not_approve_reason`, `approval_changed_at`, `cus_id`, `currencys_id`, `rate_id`, `print_quotation`, `print_invoice`, `invoice_approval_status`, `invoice_not_approve_reason`, `user_id`, `remark_id`, `detail_product_id`) VALUES
(1, 'ODR_1', 'QT001/WST26', 'INV001/WST26', '2025-12-11', 'Estimate Price for MSIG Server', NULL, NULL, NULL, NULL, 0.00, 5764.47, 10.00, 576.45, 6340.92, NULL, NULL, '2025-12-16 07:52:31', 'CUS_1', 'CUR_3', 'RATE_5', 'NO', 'NO', NULL, NULL, 1, 'REM_1', 'DP_1'),
(2, 'ODR_2', 'QT002/WST26', 'INV002/WST26', '2025-12-11', 'ຕິດຕັ້ງ ສາຍ LAN', NULL, NULL, NULL, NULL, 0.00, 500000.00, 0.00, 0.00, 500000.00, 'approved', NULL, '2025-12-13 22:21:18', 'CUS_2', 'CUR_1', NULL, 'NO', 'NO', 'approved', NULL, 1, NULL, NULL),
(3, 'ODR_3', 'QT003/WST26', 'INV003/WST26', '2025-12-11', 'ຕິດຕັ້ງ ສາຍ LAN', NULL, NULL, NULL, NULL, 0.00, 34.56, 0.00, 0.00, 34.56, NULL, NULL, NULL, 'CUS_3', 'CUR_3', 'RATE_5', 'NO', 'NO', NULL, NULL, 1, NULL, NULL);

--
-- Triggers `orders`
--
DELIMITER $$
CREATE TRIGGER `trg_orders_before_insert` BEFORE INSERT ON `orders` FOR EACH ROW BEGIN
    IF NEW.order_id IS NULL THEN
        SET NEW.order_id = CONCAT('ODR_', 
            (SELECT IFNULL(MAX(SUBSTRING(order_id,5)+0),0)+1 FROM orders)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_detail`
--

CREATE TABLE `orders_detail` (
  `id` int(11) NOT NULL,
  `order_detail_id` varchar(20) DEFAULT NULL,
  `order_id` varchar(20) DEFAULT NULL,
  `pro_id` varchar(20) DEFAULT NULL,
  `order_qty` int(11) DEFAULT NULL,
  `pro_price` decimal(20,2) DEFAULT 0.00,
  `tax_percent` decimal(5,2) DEFAULT 0.00,
  `tax_amount` decimal(20,2) DEFAULT 0.00,
  `total` decimal(20,2) DEFAULT 0.00,
  `total_with_tax` decimal(20,2) DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `orders_detail`
--

INSERT INTO `orders_detail` (`id`, `order_detail_id`, `order_id`, `pro_id`, `order_qty`, `pro_price`, `tax_percent`, `tax_amount`, `total`, `total_with_tax`) VALUES
(11, 'OEL_6', 'ODR_2', 'PRO_6', 30, 10000.00, 0.00, 0.00, 300000.00, 0.00),
(12, 'OEL_7', 'ODR_2', 'PRO_7', 1, 200000.00, 0.00, 0.00, 200000.00, 0.00),
(79, 'OEL_16', 'ODR_3', 'PRO_6', 30, 0.47, 0.00, 0.00, 14.10, 0.00),
(80, 'OEL_17', 'ODR_3', 'PRO_8', 2, 0.93, 0.00, 0.00, 1.86, 0.00),
(81, 'OEL_18', 'ODR_3', 'PRO_7', 1, 9.30, 0.00, 0.00, 9.30, 0.00),
(82, 'OEL_19', 'ODR_3', 'PRO_7', 1, 9.30, 0.00, 0.00, 9.30, 0.00),
(93, 'OEL_20', 'ODR_1', 'PRO_1', 1, 139.51, 0.00, 0.00, 139.51, 0.00),
(94, 'OEL_21', 'ODR_1', 'PRO_2', 1, 3179.04, 0.00, 0.00, 3179.04, 0.00),
(95, 'OEL_22', 'ODR_1', 'PRO_4', 1, 55.80, 0.00, 0.00, 55.80, 0.00),
(96, 'OEL_23', 'ODR_1', 'PRO_5', 1, 1290.04, 0.00, 0.00, 1290.04, 0.00),
(97, 'OEL_24', 'ODR_1', 'PRO_3', 2, 550.04, 0.00, 0.00, 1100.08, 0.00);

--
-- Triggers `orders_detail`
--
DELIMITER $$
CREATE TRIGGER `trg_orders_detail_before_insert` BEFORE INSERT ON `orders_detail` FOR EACH ROW BEGIN
    IF NEW.order_detail_id IS NULL THEN
        SET NEW.order_detail_id = CONCAT('OEL_', 
            (SELECT IFNULL(MAX(SUBSTRING(order_detail_id,5)+0),0)+1 FROM orders_detail)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `id` int(11) NOT NULL,
  `pro_id` varchar(20) DEFAULT NULL,
  `pro_name` varchar(255) DEFAULT NULL,
  `pro_price` decimal(20,2) DEFAULT 0.00,
  `pro_img` varchar(255) DEFAULT NULL,
  `types_id` varchar(20) DEFAULT NULL,
  `unit_id` varchar(20) DEFAULT NULL,
  `remark_id` varchar(20) DEFAULT NULL,
  `detail_product_id` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `pro_id`, `pro_name`, `pro_price`, `pro_img`, `types_id`, `unit_id`, `remark_id`, `detail_product_id`) VALUES
(1, 'PRO_1', 'Server SAP and Backup service', 3000000.00, '', 'TYP_1', 'UT_1', 'REM_1', 'DP_1'),
(2, 'PRO_2', 'OS License', 68362000.00, '', 'TYP_2', 'UT_2', 'REM_2', 'DP_2'),
(4, 'PRO_3', 'Anti-virus', 11828000.00, 'product_693b8a0468fa2.jpg', 'TYP_3', 'UT_4', 'REM_3', NULL),
(5, 'PRO_4', 'Server SAP and Backup service', 1200000.00, '', 'TYP_1', 'UT_1', 'REM_1', 'DP_3'),
(6, 'PRO_5', 'OS License 2', 27741000.00, '', 'TYP_2', 'UT_2', 'REM_4', 'DP_4'),
(8, 'PRO_6', 'ສາຍ LAN', 10000.00, '', 'TYP_4', 'UT_5', NULL, 'DP_5'),
(9, 'PRO_7', 'ຄ່າເເຮງງານ', 200000.00, '', 'TYP_5', 'UT_6', NULL, NULL),
(10, 'PRO_8', 'ຫົວ RJ 45', 20000.00, '', 'TYP_4', 'UT_7', NULL, NULL);

--
-- Triggers `products`
--
DELIMITER $$
CREATE TRIGGER `trg_products_before_insert` BEFORE INSERT ON `products` FOR EACH ROW BEGIN
    IF NEW.pro_id IS NULL THEN
        SET NEW.pro_id = CONCAT('PRO_', 
            (SELECT IFNULL(MAX(SUBSTRING(pro_id,5)+0),0)+1 FROM products)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `rates`
--

CREATE TABLE `rates` (
  `id` int(11) NOT NULL,
  `rate_id` varchar(20) DEFAULT NULL,
  `currencys_id` varchar(20) DEFAULT NULL,
  `rate_amount` decimal(10,2) DEFAULT NULL,
  `rate_date` date DEFAULT NULL,
  `rate_datetime` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `rates`
--

INSERT INTO `rates` (`id`, `rate_id`, `currencys_id`, `rate_amount`, `rate_date`, `rate_datetime`) VALUES
(1, 'RATE_1', 'CUR_1', 1.00, '2025-12-10', '2025-12-10 04:18:40'),
(2, 'RATE_2', 'CUR_2', 674.52, '2025-12-10', '2025-12-10 04:18:54'),
(3, 'RATE_3', 'CUR_3', 21504.00, '2025-12-10', '2025-12-10 04:19:09'),
(4, 'RATE_4', 'CUR_3', 21770.00, '2025-12-11', '2025-12-11 06:38:45'),
(5, 'RATE_5', 'CUR_3', 21504.00, '2025-12-11', '2025-12-11 06:45:01');

--
-- Triggers `rates`
--
DELIMITER $$
CREATE TRIGGER `trg_rates_before_insert` BEFORE INSERT ON `rates` FOR EACH ROW BEGIN
    IF NEW.rate_id IS NULL THEN
        SET NEW.rate_id = CONCAT('RATE_', 
            (SELECT IFNULL(MAX(SUBSTRING(rate_id,6)+0),0)+1 FROM rates)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `remark`
--

CREATE TABLE `remark` (
  `id` int(11) NOT NULL,
  `remark_id` varchar(20) DEFAULT NULL,
  `remark_text` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `remark`
--

INSERT INTO `remark` (`id`, `remark_id`, `remark_text`) VALUES
(1, 'REM_1', 'Monthly charge'),
(2, 'REM_2', 'Subscription, 1 Year'),
(3, 'REM_3', 'per-server, per-year'),
(4, 'REM_4', 'Windows License Key'),
(5, 'REM_5', 'Bitdefender .  1 Year');

--
-- Triggers `remark`
--
DELIMITER $$
CREATE TRIGGER `trg_remark_before_insert` BEFORE INSERT ON `remark` FOR EACH ROW BEGIN
    IF NEW.remark_id IS NULL THEN
        SET NEW.remark_id = CONCAT('REM_', 
            (SELECT IFNULL(MAX(SUBSTRING(remark_id,5)+0),0)+1 FROM remark)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `types_product`
--

CREATE TABLE `types_product` (
  `id` int(11) NOT NULL,
  `types_id` varchar(20) DEFAULT NULL,
  `types_name` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `types_product`
--

INSERT INTO `types_product` (`id`, `types_id`, `types_name`) VALUES
(1, 'TYP_1', 'ເຄື່ອງ server'),
(2, 'TYP_2', 'License'),
(3, 'TYP_3', 'Program'),
(4, 'TYP_4', 'ອຸປະກອນ'),
(5, 'TYP_5', 'ເເຮງງານ'),
(6, 'TYP_6', 'หหหห');

--
-- Triggers `types_product`
--
DELIMITER $$
CREATE TRIGGER `trg_types_product_before_insert` BEFORE INSERT ON `types_product` FOR EACH ROW BEGIN
    IF NEW.types_id IS NULL THEN
        SET NEW.types_id = CONCAT('TYP_', 
            (SELECT IFNULL(MAX(SUBSTRING(types_id,5)+0),0)+1 FROM types_product)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `units`
--

CREATE TABLE `units` (
  `id` int(11) NOT NULL,
  `unit_id` varchar(20) DEFAULT NULL,
  `unit_name` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `units`
--

INSERT INTO `units` (`id`, `unit_id`, `unit_name`) VALUES
(1, 'UT_1', 'ຊຸດ'),
(2, 'UT_2', 'ອັນ'),
(3, 'UT_3', 'ໜ່ວຍ'),
(4, 'UT_4', 'Program'),
(5, 'UT_5', 'ເເມັດ'),
(6, 'UT_6', 'lot'),
(7, 'UT_7', 'ຫົວ');

--
-- Triggers `units`
--
DELIMITER $$
CREATE TRIGGER `trg_units_before_insert` BEFORE INSERT ON `units` FOR EACH ROW BEGIN
    IF NEW.unit_id IS NULL THEN
        SET NEW.unit_id = CONCAT('UT_', 
            (SELECT IFNULL(MAX(SUBSTRING(unit_id,4)+0),0)+1 FROM units)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `id` int(11) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `full_name` varchar(255) DEFAULT NULL,
  `role` enum('admin','user') DEFAULT 'user',
  `language` varchar(10) DEFAULT 'la',
  `trial_expire` date DEFAULT NULL,
  `last_login` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `user`
--

INSERT INTO `user` (`id`, `username`, `password`, `full_name`, `role`, `language`, `trial_expire`, `last_login`) VALUES
(1, 'anou', '$2y$10$abq7smsBWdI4Y5JExxFeMu/sEIDwgG6d4pnQIFvUjsLYJ6aIfodZy', 'kty', 'user', 'la', NULL, '2026-01-12 14:46:30'),
(2, 'joey', '$2y$10$eciIYo.m9HPQEKRznky/ZOILJCNz6wwBxb5AnX.MsIgDDp3SXLlq.', 'joey', 'user', 'la', NULL, '2025-11-26 03:57:20');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `audit_log`
--
ALTER TABLE `audit_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `currencys`
--
ALTER TABLE `currencys`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `currencys_id` (`currencys_id`);

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `cus_id` (`cus_id`);

--
-- Indexes for table `detail_product`
--
ALTER TABLE `detail_product`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `detail_product_id` (`detail_product_id`);

--
-- Indexes for table `notifications`
--
ALTER TABLE `notifications`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `notification_id` (`notification_id`);

--
-- Indexes for table `notifications_read`
--
ALTER TABLE `notifications_read`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `user_id` (`user_id`,`order_id`);

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `order_id` (`order_id`),
  ADD KEY `cus_id` (`cus_id`),
  ADD KEY `currencys_id` (`currencys_id`),
  ADD KEY `rate_id` (`rate_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `remark_id` (`remark_id`),
  ADD KEY `idx_detail_product_id` (`detail_product_id`);

--
-- Indexes for table `orders_detail`
--
ALTER TABLE `orders_detail`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `order_detail_id` (`order_detail_id`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `pro_id` (`pro_id`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `pro_id` (`pro_id`),
  ADD KEY `types_id` (`types_id`),
  ADD KEY `remark_id` (`remark_id`),
  ADD KEY `idx_detail_product_id` (`detail_product_id`);

--
-- Indexes for table `rates`
--
ALTER TABLE `rates`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `rate_id` (`rate_id`),
  ADD KEY `idx_rate_datetime` (`rate_datetime`),
  ADD KEY `idx_currencys_id_datetime` (`currencys_id`,`rate_datetime`);

--
-- Indexes for table `remark`
--
ALTER TABLE `remark`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `remark_id` (`remark_id`);

--
-- Indexes for table `types_product`
--
ALTER TABLE `types_product`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `types_id` (`types_id`);

--
-- Indexes for table `units`
--
ALTER TABLE `units`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unit_id` (`unit_id`);

--
-- Indexes for table `user`
--
ALTER TABLE `user`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `audit_log`
--
ALTER TABLE `audit_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=48;

--
-- AUTO_INCREMENT for table `currencys`
--
ALTER TABLE `currencys`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `detail_product`
--
ALTER TABLE `detail_product`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `notifications`
--
ALTER TABLE `notifications`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `notifications_read`
--
ALTER TABLE `notifications_read`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `orders_detail`
--
ALTER TABLE `orders_detail`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=98;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `rates`
--
ALTER TABLE `rates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `remark`
--
ALTER TABLE `remark`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `types_product`
--
ALTER TABLE `types_product`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `units`
--
ALTER TABLE `units`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `user`
--
ALTER TABLE `user`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `fk_orders_detail_product` FOREIGN KEY (`detail_product_id`) REFERENCES `detail_product` (`detail_product_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`cus_id`) REFERENCES `customers` (`cus_id`);

--
-- Constraints for table `orders_detail`
--
ALTER TABLE `orders_detail`
  ADD CONSTRAINT `orders_detail_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`order_id`),
  ADD CONSTRAINT `orders_detail_ibfk_2` FOREIGN KEY (`pro_id`) REFERENCES `products` (`pro_id`);

--
-- Constraints for table `products`
--
ALTER TABLE `products`
  ADD CONSTRAINT `fk_products_detail_product` FOREIGN KEY (`detail_product_id`) REFERENCES `detail_product` (`detail_product_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `products_ibfk_1` FOREIGN KEY (`types_id`) REFERENCES `types_product` (`types_id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
