-- POS System Migration
-- Adds columns to orders table for VAT and currency tracking

-- Add VAT and currency columns to orders table
ALTER TABLE `orders`
    ADD COLUMN IF NOT EXISTS `vat_enabled` TINYINT(1) DEFAULT 1 COMMENT 'Whether VAT was applied to this order',
    ADD COLUMN IF NOT EXISTS `currencys_id` VARCHAR(20) DEFAULT NULL COMMENT 'Currency ID from currencys table',
    ADD COLUMN IF NOT EXISTS `rate_id` VARCHAR(20) DEFAULT NULL COMMENT 'Exchange rate snapshot ID',
    ADD COLUMN IF NOT EXISTS `subtotal_lak` DECIMAL(20,2) DEFAULT NULL COMMENT 'Subtotal in LAK (base currency)',
    ADD COLUMN IF NOT EXISTS `vat_amount_lak` DECIMAL(20,2) DEFAULT NULL COMMENT 'VAT amount in LAK',
    ADD COLUMN IF NOT EXISTS `total_amount_lak` DECIMAL(20,2) DEFAULT NULL COMMENT 'Total in LAK (base currency)',
    ADD COLUMN IF NOT EXISTS `discount_lak` DECIMAL(20,2) DEFAULT 0.00 COMMENT 'Discount in LAK',
    ADD COLUMN IF NOT EXISTS `currency_rate` DECIMAL(15,4) DEFAULT 1.0000 COMMENT 'Exchange rate used';

-- Add index for faster lookups
ALTER TABLE `orders`
    ADD INDEX IF NOT EXISTS `idx_currencys_id` (`currencys_id`);
