-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Jan 23, 2026 at 01:35 AM
-- Server version: 10.11.14-MariaDB-cll-lve-log
-- PHP Version: 8.4.16

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `zfhfpsz1_epgroups`
--

-- --------------------------------------------------------

--
-- Table structure for table `colors`
--

CREATE TABLE `colors` (
  `id` int(11) NOT NULL,
  `CO_id` varchar(30) NOT NULL COMMENT 'Color ID เช่น CO_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `color_name` varchar(100) NOT NULL COMMENT 'ชื่อสี',
  `color_code` varchar(20) DEFAULT NULL COMMENT 'รหัสสี HEX',
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `colors`
--

INSERT INTO `colors` (`id`, `CO_id`, `shop_id`, `color_name`, `color_code`, `description`, `is_active`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'CO_1768078193213', 1, 'test', '#ba1212', NULL, 1, '3', '3', '3', '2026-01-10 20:49:53', '2026-01-11 18:23:25', '2026-01-11 18:23:25'),
(2, 'CO_1768155812068', 1, 'test', '#00ffb3', NULL, 1, '3', '3', NULL, '2026-01-11 18:23:32', '2026-01-11 18:45:54', NULL),
(3, 'CO_1768337112429', 2, 'addy', '#000000', NULL, 1, 'US_1768243718774', NULL, NULL, '2026-01-13 20:45:12', '2026-01-13 20:45:12', NULL),
(4, 'CO_1768681373750', 1, 'ເຫລືອງ', '#e4f500', NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-17 20:22:53', '2026-01-17 20:22:53', NULL);

--
-- Triggers `colors`
--
DELIMITER $$
CREATE TRIGGER `trg_colors_before_insert` BEFORE INSERT ON `colors` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 10;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 10;
    SET NEW.CO_id = CONCAT('CO_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL,
  `CR_id` varchar(30) NOT NULL COMMENT 'Currency ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `currency_code` varchar(10) NOT NULL COMMENT 'LAK, THB, USD',
  `currency_name` varchar(50) NOT NULL,
  `symbol` varchar(10) DEFAULT NULL COMMENT '₭, ฿, $',
  `exchange_rate` decimal(15,6) DEFAULT 1.000000 COMMENT 'อัตราแลกเปลี่ยน',
  `is_default` tinyint(1) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` (`id`, `CR_id`, `shop_id`, `currency_code`, `currency_name`, `symbol`, `exchange_rate`, `is_default`, `is_active`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'CR_1768156033287', 1, 'trtr', 'wdsf', 'trt', 1.000000, 0, 1, 'US_1767899049934', NULL, NULL, '2026-01-11 18:27:13', '2026-01-12 18:43:09', NULL);

--
-- Triggers `currencies`
--
DELIMITER $$
CREATE TRIGGER `trg_currencies_before_insert` BEFORE INSERT ON `currencies` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 14;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 14;
    SET NEW.CR_id = CONCAT('CR_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `currencys`
--

CREATE TABLE `currencys` (
  `id` int(11) NOT NULL,
  `currencys_id` varchar(20) DEFAULT NULL,
  `currencys_name` varchar(100) DEFAULT NULL,
  `currencys_fullname` varchar(150) DEFAULT NULL,
  `currencys_symbol` varchar(10) DEFAULT NULL,
  `base_currency` enum('YES','NO') DEFAULT 'NO',
  `shop_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currencys`
--

INSERT INTO `currencys` (`id`, `currencys_id`, `currencys_name`, `currencys_fullname`, `currencys_symbol`, `base_currency`, `shop_id`) VALUES
(3, 'CUR_1', 'Lao Kip', 'Lao Kip', '₭', 'NO', 1),
(4, 'CUR_2', 'Thai Baht', 'Thai Baht', '฿', 'NO', 1),
(5, 'CUR_3', 'US Dollar', 'United States Dollar', '$', 'NO', 1);

--
-- Triggers `currencys`
--
DELIMITER $$
CREATE TRIGGER `trg_currencys_before_insert` BEFORE INSERT ON `currencys` FOR EACH ROW BEGIN
    IF NEW.currencys_id IS NULL THEN
        SET NEW.currencys_id = CONCAT('CUR_', 
            (SELECT COALESCE(MAX(CAST(SUBSTRING(currencys_id,5) AS UNSIGNED)),0)+1 FROM currencys)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `id` int(11) NOT NULL,
  `CU_id` varchar(30) NOT NULL COMMENT 'Customer ID เช่น CU_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `customer_code` varchar(20) DEFAULT NULL COMMENT 'รหัสลูกค้า',
  `name` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `province` varchar(100) DEFAULT NULL,
  `tax_id` varchar(20) DEFAULT NULL COMMENT 'เลขประจำตัวผู้เสียภาษี',
  `customer_type` enum('regular','wholesale','representative') DEFAULT 'regular',
  `discount_percent` decimal(5,2) DEFAULT 0.00,
  `credit_limit` decimal(12,2) DEFAULT 0.00,
  `notes` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `CU_id`, `shop_id`, `customer_code`, `name`, `phone`, `email`, `address`, `province`, `tax_id`, `customer_type`, `discount_percent`, `credit_limit`, `notes`, `is_active`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(4, 'CU_1768243525576', 1, NULL, 'Anouluck khantharyot', '99887766', NULL, NULL, NULL, NULL, 'regular', 0.00, 0.00, NULL, 1, 'US_1767815269493', NULL, NULL, '2026-01-12 18:45:25', '2026-01-12 18:45:25', NULL),
(5, 'CU_1768245172890', 1, NULL, 'zaem', '44556677', NULL, NULL, NULL, NULL, 'regular', 0.00, 0.00, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-12 19:12:52', '2026-01-12 19:12:52', NULL),
(6, 'CU_1768327665407', 1, NULL, 'testt', '00998877', NULL, NULL, NULL, NULL, 'regular', 0.00, 0.00, NULL, 1, 'US_1767815269493', NULL, NULL, '2026-01-13 18:07:45', '2026-01-13 18:07:45', NULL),
(7, 'CU_1768328376156', 1, NULL, 'anouluck', '91603424', NULL, NULL, NULL, NULL, 'regular', 0.00, 0.00, NULL, 1, 'US_1767815269493', NULL, NULL, '2026-01-13 18:19:36', '2026-01-13 18:19:36', NULL),
(8, 'CU_1768331137490', 1, NULL, 'sa', '99887766', NULL, NULL, NULL, NULL, 'regular', 0.00, 0.00, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 19:05:37', '2026-01-13 19:05:37', NULL),
(9, 'CU_1768337784991', 1, NULL, 'ดหดกห', 'ภ_ภภภ/', NULL, NULL, NULL, NULL, 'regular', 0.00, 0.00, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 20:56:24', '2026-01-13 20:56:24', NULL),
(10, 'CU_1768338277864', 1, NULL, 'eyyy', '99887700', NULL, NULL, NULL, NULL, 'regular', 0.00, 0.00, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 21:04:37', '2026-01-13 21:04:37', NULL);

--
-- Triggers `customers`
--
DELIMITER $$
CREATE TRIGGER `trg_customers_before_insert` BEFORE INSERT ON `customers` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 3;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 3;
    SET NEW.CU_id = CONCAT('CU_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `expenses`
--

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL,
  `EX_id` varchar(30) NOT NULL COMMENT 'Expense ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `expense_code` varchar(20) DEFAULT NULL,
  `expense_date` date NOT NULL,
  `category` varchar(100) DEFAULT NULL COMMENT 'หมวดหมู่ค่าใช้จ่าย',
  `description` text DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `currency_id` int(11) DEFAULT NULL COMMENT 'FK → currencies.id',
  `payment_method_id` int(11) DEFAULT NULL COMMENT 'FK → payment_methods.id',
  `receipt_image` varchar(255) DEFAULT NULL COMMENT 'รูปใบเสร็จ',
  `is_recurring` tinyint(1) DEFAULT 0,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `expenses`
--

INSERT INTO `expenses` (`id`, `EX_id`, `shop_id`, `expense_code`, `expense_date`, `category`, `description`, `amount`, `currency_id`, `payment_method_id`, `receipt_image`, `is_recurring`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'EX_1768160351047', 1, NULL, '2026-01-11', 'undefined', '', 40000.00, NULL, NULL, NULL, 0, '3', '3', 'US_1767899049934', '2026-01-11 19:39:11', '2026-01-14 19:16:25', '2026-01-14 19:16:25'),
(2, 'EX_1768160515497', 1, NULL, '2026-01-11', 'ปห', '', 33333.00, NULL, NULL, NULL, 0, '3', NULL, '3', '2026-01-11 19:41:55', '2026-01-11 19:42:41', '2026-01-11 19:42:41'),
(3, 'EX_1768501254349', 1, NULL, '2026-01-15', 'ຄ່ານໍ້າ', '', 100000.00, NULL, NULL, NULL, 0, 'US_1767899049934', NULL, NULL, '2026-01-15 18:20:54', '2026-01-15 18:20:54', NULL);

--
-- Triggers `expenses`
--
DELIMITER $$
CREATE TRIGGER `trg_expenses_before_insert` BEFORE INSERT ON `expenses` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 7;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 7;
    SET NEW.EX_id = CONCAT('EX_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` int(11) NOT NULL,
  `OR_id` varchar(30) NOT NULL COMMENT 'Order ID เช่น OR_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `order_code` varchar(30) DEFAULT NULL COMMENT 'รหัสออเดอร์ที่ร้านกำหนด',
  `customer_id` varchar(30) DEFAULT NULL,
  `order_date` datetime NOT NULL DEFAULT current_timestamp(),
  `order_type` enum('pos','online','wholesale') DEFAULT 'pos',
  `order_status` enum('pending','processing','shipped','delivered','returned','cancelled') NOT NULL DEFAULT 'pending' COMMENT 'Order status',
  `payment_status` enum('pending','partial','paid','partial_refund','refunded') DEFAULT 'pending',
  `payment_method_id` int(11) DEFAULT NULL COMMENT 'FK → payment_methods.id',
  `currency_id` int(11) DEFAULT NULL COMMENT 'FK → currencies.id',
  `shipping_company_id` varchar(30) DEFAULT NULL,
  `shipping_branch_id` varchar(30) DEFAULT NULL,
  `shipping_code` varchar(100) DEFAULT NULL COMMENT 'เลข tracking',
  `subtotal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `discount_amount` decimal(12,2) DEFAULT 0.00,
  `discount_percent` decimal(5,2) DEFAULT 0.00,
  `shipping_fee` decimal(12,2) DEFAULT 0.00,
  `tax_amount` decimal(12,2) DEFAULT 0.00,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deposit_amount` decimal(12,2) DEFAULT 0.00 COMMENT 'เงินมัดจำ',
  `refund_amount` decimal(12,2) DEFAULT 0.00,
  `cash_received` decimal(12,2) DEFAULT NULL,
  `cash_change` decimal(12,2) DEFAULT NULL,
  `cod_amount` decimal(12,2) DEFAULT NULL COMMENT 'ยอด COD',
  `notes` text DEFAULT NULL,
  `internal_notes` text DEFAULT NULL COMMENT 'หมายเหตุภายใน',
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `vat_enabled` tinyint(1) DEFAULT 1 COMMENT 'Whether VAT was applied to this order',
  `currencys_id` varchar(20) DEFAULT NULL COMMENT 'Currency ID from currencys table',
  `rate_id` varchar(20) DEFAULT NULL COMMENT 'Exchange rate snapshot ID',
  `subtotal_lak` decimal(20,2) DEFAULT NULL COMMENT 'Subtotal in LAK (base currency)',
  `vat_amount_lak` decimal(20,2) DEFAULT NULL COMMENT 'VAT amount in LAK',
  `total_amount_lak` decimal(20,2) DEFAULT NULL COMMENT 'Total in LAK (base currency)',
  `discount_lak` decimal(20,2) DEFAULT 0.00 COMMENT 'Discount in LAK',
  `currency_rate` decimal(15,4) DEFAULT 1.0000 COMMENT 'Exchange rate used',
  `printed_count_online` int(11) DEFAULT 0 COMMENT 'จำนวนครั้งที่พิมพ์ออนไลน์',
  `printed_count_shop` int(11) DEFAULT 0 COMMENT 'จำนวนครั้งที่พิมพ์หน้าร้าน',
  `printed_shop` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'สถานะพิมพ์หน้าร้าน (0=ยังไม่พิมพ์, 1=พิมพ์แล้ว)',
  `printed_online` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'สถานะพิมพ์ออนไลน์ (0=ยังไม่พิมพ์, 1=พิมพ์แล้ว)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `orders`
--

INSERT INTO `orders` (`id`, `OR_id`, `shop_id`, `order_code`, `customer_id`, `order_date`, `order_type`, `order_status`, `payment_status`, `payment_method_id`, `currency_id`, `shipping_company_id`, `shipping_branch_id`, `shipping_code`, `subtotal`, `discount_amount`, `discount_percent`, `shipping_fee`, `tax_amount`, `total_amount`, `deposit_amount`, `refund_amount`, `cash_received`, `cash_change`, `cod_amount`, `notes`, `internal_notes`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`, `vat_enabled`, `currencys_id`, `rate_id`, `subtotal_lak`, `vat_amount_lak`, `total_amount_lak`, `discount_lak`, `currency_rate`, `printed_count_online`, `printed_count_shop`, `printed_shop`, `printed_online`) VALUES
(59, 'OR_1769102422701', 1, NULL, NULL, '2026-01-23 00:20:22', 'pos', 'delivered', 'paid', NULL, NULL, NULL, NULL, NULL, 3769.00, 18.00, 0.00, 0.00, 376.00, 4126.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, 'US_1767899049934', NULL, NULL, '2026-01-22 17:20:22', '2026-01-22 17:20:22', NULL, 1, 'CUR_2', 'RATE_9', 2600000.00, 258758.00, 2846338.00, 12420.00, 690.0000, 0, 0, 0, 0),
(60, 'OR_1769102943554', 1, NULL, NULL, '2026-01-23 00:29:03', 'pos', 'delivered', 'paid', NULL, NULL, NULL, NULL, NULL, 3769.00, 18.00, 0.00, 0.00, 376.00, 4126.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, 'US_1767899049934', NULL, NULL, '2026-01-22 17:29:03', '2026-01-22 17:29:03', NULL, 1, 'CUR_2', 'RATE_9', 2600000.00, 258765.50, 2846420.50, 12345.00, 690.0000, 0, 0, 0, 0),
(61, 'OR_1769103833717', 1, NULL, NULL, '2026-01-23 00:43:53', 'pos', 'delivered', 'paid', NULL, NULL, NULL, NULL, NULL, 3769.00, 145.00, 0.00, 0.00, 363.00, 3986.00, 0.00, 0.00, 5000.00, 1014.00, NULL, NULL, NULL, 'US_1767899049934', NULL, NULL, '2026-01-22 17:43:53', '2026-01-22 17:43:53', NULL, 1, 'CUR_2', 'RATE_9', 2600000.00, 250000.00, 2750000.00, 100000.00, 690.0000, 0, 0, 0, 0),
(62, 'OR_1769106534933', 1, NULL, NULL, '2026-01-23 01:28:54', 'pos', 'delivered', 'paid', NULL, NULL, NULL, NULL, NULL, 59.89, 5.69, 0.00, 0.00, 5.42, 59.62, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, 'US_1767899049934', NULL, NULL, '2026-01-22 18:28:54', '2026-01-22 18:28:54', NULL, 1, 'CUR_3', 'RATE_3', 1300000.00, 117654.40, 1294198.40, 123456.00, 21710.0000, 0, 0, 0, 0),
(63, 'OR_1769106740846', 1, NULL, NULL, '2026-01-23 01:32:20', 'pos', 'delivered', 'paid', NULL, NULL, NULL, NULL, NULL, 7682.00, 179.00, 0.00, 0.00, 751.00, 8253.00, 0.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, 'US_1767899049934', NULL, NULL, '2026-01-22 18:32:20', '2026-01-22 18:32:20', NULL, 1, 'CUR_2', 'RATE_9', 5300000.00, 517654.40, 5694198.40, 123456.00, 690.0000, 0, 0, 0, 0);

--
-- Triggers `orders`
--
DELIMITER $$
CREATE TRIGGER `trg_orders_before_insert` BEFORE INSERT ON `orders` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 6;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 6;
    SET NEW.OR_id = CONCAT('OR_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `order_items`
--

CREATE TABLE `order_items` (
  `id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL COMMENT 'FK → orders.id',
  `product_id` varchar(30) NOT NULL,
  `product_name` varchar(255) DEFAULT NULL COMMENT 'ชื่อสินค้า ณ ตอนขาย',
  `quantity` decimal(10,2) NOT NULL,
  `unit_price` decimal(12,2) NOT NULL COMMENT 'ราคาต่อหน่วย',
  `discount_amount` decimal(12,2) DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `order_items`
--

INSERT INTO `order_items` (`id`, `order_id`, `product_id`, `product_name`, `quantity`, `unit_price`, `discount_amount`, `total`, `notes`, `created_at`) VALUES
(351, 59, 'PR_1768681396277', 'printer', 1.00, 1160.00, 0.00, 1160.00, NULL, '2026-01-22 17:20:22'),
(352, 59, 'PR_1768245075665', 'ກະຕິກຂຽວ 1 ລິດ', 1.00, 725.00, 0.00, 725.00, NULL, '2026-01-22 17:20:22'),
(353, 59, 'PR_1768681260760', 'ຖັງນໍ້າກ້ອນ 13 ລິດ (ສີແດງ)', 1.00, 290.00, 0.00, 290.00, NULL, '2026-01-22 17:20:22'),
(354, 59, 'PR_1768155846416', 'ປິນໂຕ', 1.00, 290.00, 0.00, 290.00, NULL, '2026-01-22 17:20:22'),
(355, 59, 'PR_1768681306945', 'ໝໍ້ຫຸງເຂົ້ານ້ອຍ1ລິດ ດຳ', 1.00, 725.00, 0.00, 725.00, NULL, '2026-01-22 17:20:22'),
(356, 59, 'PR_1768681438425', 'ເຊັດໝໍ້ 3 ໜ່ວຍ ', 1.00, 580.00, 0.00, 580.00, NULL, '2026-01-22 17:20:22'),
(357, 60, 'PR_1768681396277', 'printer', 1.00, 1160.00, 0.00, 1160.00, NULL, '2026-01-22 17:29:03'),
(358, 60, 'PR_1768245075665', 'ກະຕິກຂຽວ 1 ລິດ', 1.00, 725.00, 0.00, 725.00, NULL, '2026-01-22 17:29:03'),
(359, 60, 'PR_1768681260760', 'ຖັງນໍ້າກ້ອນ 13 ລິດ (ສີແດງ)', 1.00, 290.00, 0.00, 290.00, NULL, '2026-01-22 17:29:03'),
(360, 60, 'PR_1768155846416', 'ປິນໂຕ', 1.00, 290.00, 0.00, 290.00, NULL, '2026-01-22 17:29:03'),
(361, 60, 'PR_1768681306945', 'ໝໍ້ຫຸງເຂົ້ານ້ອຍ1ລິດ ດຳ', 1.00, 725.00, 0.00, 725.00, NULL, '2026-01-22 17:29:03'),
(362, 60, 'PR_1768681438425', 'ເຊັດໝໍ້ 3 ໜ່ວຍ ', 1.00, 580.00, 0.00, 580.00, NULL, '2026-01-22 17:29:03'),
(363, 61, 'PR_1768681396277', 'printer', 1.00, 1160.00, 0.00, 1160.00, NULL, '2026-01-22 17:43:53'),
(364, 61, 'PR_1768245075665', 'ກະຕິກຂຽວ 1 ລິດ', 1.00, 725.00, 0.00, 725.00, NULL, '2026-01-22 17:43:53'),
(365, 61, 'PR_1768681260760', 'ຖັງນໍ້າກ້ອນ 13 ລິດ (ສີແດງ)', 1.00, 290.00, 0.00, 290.00, NULL, '2026-01-22 17:43:53'),
(366, 61, 'PR_1768155846416', 'ປິນໂຕ', 1.00, 290.00, 0.00, 290.00, NULL, '2026-01-22 17:43:53'),
(367, 61, 'PR_1768681306945', 'ໝໍ້ຫຸງເຂົ້ານ້ອຍ1ລິດ ດຳ', 1.00, 725.00, 0.00, 725.00, NULL, '2026-01-22 17:43:53'),
(368, 61, 'PR_1768681438425', 'ເຊັດໝໍ້ 3 ໜ່ວຍ ', 1.00, 580.00, 0.00, 580.00, NULL, '2026-01-22 17:43:53'),
(369, 62, 'PR_1768681396277', 'printer', 1.00, 36.85, 0.00, 36.85, NULL, '2026-01-22 18:28:54'),
(370, 62, 'PR_1768245075665', 'ກະຕິກຂຽວ 1 ລິດ', 1.00, 23.04, 0.00, 23.04, NULL, '2026-01-22 18:28:54'),
(371, 63, 'PR_1768681396277', 'printer', 3.00, 1160.00, 0.00, 3480.00, NULL, '2026-01-22 18:32:20'),
(372, 63, 'PR_1768681438425', 'ເຊັດໝໍ້ 3 ໜ່ວຍ ', 2.00, 580.00, 0.00, 1160.00, NULL, '2026-01-22 18:32:20'),
(373, 63, 'PR_1768245075665', 'ກະຕິກຂຽວ 1 ລິດ', 2.00, 725.00, 0.00, 1450.00, NULL, '2026-01-22 18:32:20'),
(374, 63, 'PR_1768681260760', 'ຖັງນໍ້າກ້ອນ 13 ລິດ (ສີແດງ)', 1.00, 290.00, 0.00, 290.00, NULL, '2026-01-22 18:32:20'),
(375, 63, 'PR_1768681306945', 'ໝໍ້ຫຸງເຂົ້ານ້ອຍ1ລິດ ດຳ', 1.00, 725.00, 0.00, 725.00, NULL, '2026-01-22 18:32:20'),
(376, 63, 'PR_1768155846416', 'ປິນໂຕ', 2.00, 290.00, 0.00, 580.00, NULL, '2026-01-22 18:32:20');

-- --------------------------------------------------------

--
-- Table structure for table `other_income`
--

CREATE TABLE `other_income` (
  `id` int(11) NOT NULL,
  `IN_id` varchar(30) NOT NULL COMMENT 'Income ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `income_code` varchar(20) DEFAULT NULL,
  `income_date` date NOT NULL,
  `category` varchar(100) DEFAULT NULL COMMENT 'หมวดหมู่รายรับ',
  `description` text DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `currency_id` int(11) DEFAULT NULL COMMENT 'FK → currencies.id',
  `payment_method_id` int(11) DEFAULT NULL COMMENT 'FK → payment_methods.id',
  `receipt_image` varchar(255) DEFAULT NULL,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `other_income`
--

INSERT INTO `other_income` (`id`, `IN_id`, `shop_id`, `income_code`, `income_date`, `category`, `description`, `amount`, `currency_id`, `payment_method_id`, `receipt_image`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'IN_1768160780845', 1, NULL, '2026-01-11', 'undefined', '', 400000.00, NULL, NULL, NULL, '3', '3', 'US_1767899049934', '2026-01-11 19:46:20', '2026-01-14 19:16:21', '2026-01-14 19:16:21'),
(2, 'IN_1768160797873', 1, NULL, '2026-01-11', 'dsds', '', 33333.00, NULL, NULL, NULL, '3', NULL, 'US_1767899049934', '2026-01-11 19:46:37', '2026-01-14 19:16:18', '2026-01-14 19:16:18'),
(3, 'IN_1768501227309', 1, NULL, '2026-01-15', 'ຄ່າສົ່ງ', '', 100000.00, NULL, NULL, NULL, 'US_1767899049934', NULL, NULL, '2026-01-15 18:20:27', '2026-01-15 18:20:27', NULL),
(4, 'IN_1768845930916', 1, NULL, '2026-01-19', 'test', '', 400000.00, NULL, NULL, NULL, 'US_1767899049934', NULL, NULL, '2026-01-19 18:05:30', '2026-01-19 18:05:30', NULL);

--
-- Triggers `other_income`
--
DELIMITER $$
CREATE TRIGGER `trg_other_income_before_insert` BEFORE INSERT ON `other_income` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 8;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 8;
    SET NEW.IN_id = CONCAT('IN_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `id` int(11) NOT NULL,
  `email` varchar(100) NOT NULL,
  `token` varchar(255) NOT NULL,
  `expires_at` timestamp NOT NULL,
  `used` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `id` int(11) NOT NULL,
  `PR_id` varchar(30) NOT NULL COMMENT 'Product ID เช่น PR_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `product_code` varchar(50) DEFAULT NULL COMMENT 'รหัสสินค้า (SKU)',
  `barcode` varchar(50) DEFAULT NULL COMMENT 'บาร์โค้ด',
  `product_name` varchar(255) NOT NULL,
  `category_id` int(11) DEFAULT NULL COMMENT 'FK → product_categories.id',
  `unit_id` int(11) DEFAULT NULL COMMENT 'FK → units.id',
  `color_id` int(11) DEFAULT NULL COMMENT 'FK → colors.id',
  `quantity` decimal(10,2) NOT NULL DEFAULT 0.00 COMMENT 'จำนวนในสต็อก',
  `low_stock_threshold` int(11) DEFAULT 10 COMMENT 'เตือนเมื่อต่ำกว่า',
  `cost_price` decimal(12,2) NOT NULL DEFAULT 0.00 COMMENT 'ราคาทุน',
  `selling_price` decimal(12,2) NOT NULL DEFAULT 0.00 COMMENT 'ราคาขาย',
  `wholesale_price` decimal(12,2) DEFAULT NULL COMMENT 'ราคาส่ง',
  `representative_price` decimal(12,2) DEFAULT NULL COMMENT 'ราคาตัวแทน',
  `product_image` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `supplier_name` varchar(150) DEFAULT NULL,
  `supplier_phone` varchar(20) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `PR_id`, `shop_id`, `product_code`, `barcode`, `product_name`, `category_id`, `unit_id`, `color_id`, `quantity`, `low_stock_threshold`, `cost_price`, `selling_price`, `wholesale_price`, `representative_price`, `product_image`, `description`, `supplier_name`, `supplier_phone`, `is_active`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'PR_1768155846416', 1, 'ຸ5566', '12233445', 'ປິນໂຕ', 2, 4, 2, 50.00, 10, 100000.00, 200000.00, NULL, 150000.00, 'img/products/product_1768341056_6966be40d5c06.jpeg', '0', NULL, NULL, 1, 'US_1767899049934', 'US_1767899049934', NULL, '2026-01-11 18:24:06', '2026-01-22 18:32:20', NULL),
(2, 'PR_1768245075665', 1, 'ຸ5566', '12233445', 'ກະຕິກຂຽວ 1 ລິດ', 2, 4, 2, 56.00, 10, 400000.00, 500000.00, NULL, NULL, 'img/products/product_1768340966_6966bde64878b.jpg', '', NULL, NULL, 1, 'US_1767899049934', 'US_1767899049934', NULL, '2026-01-12 19:11:15', '2026-01-22 18:32:20', NULL),
(3, 'PR_1768337142326', 2, 'addy', 'addy', 'addy', 3, 5, 3, 10.00, 10, 1000000.00, 2000000.00, NULL, NULL, NULL, '', NULL, NULL, 1, 'US_1768243718774', NULL, NULL, '2026-01-13 20:45:42', '2026-01-13 20:45:42', NULL),
(4, 'PR_1768681260760', 1, '', '', 'ຖັງນໍ້າກ້ອນ 13 ລິດ (ສີແດງ)', 2, 4, 2, 81.00, 10, 100000.00, 200000.00, NULL, 150000.00, 'img/products/product_1768681260_696bef2cb07a0.jpg', '', NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-17 20:21:00', '2026-01-22 18:32:20', NULL),
(5, 'PR_1768681306945', 1, '', '', 'ໝໍ້ຫຸງເຂົ້ານ້ອຍ1ລິດ ດຳ', 2, 4, 2, 81.00, 10, 400000.00, 500000.00, NULL, 460000.00, 'img/products/product_1768681306_696bef5ae55e8.jpeg', '', NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-17 20:21:46', '2026-01-22 18:32:20', NULL),
(6, 'PR_1768681396277', 1, '', '', 'printer', 4, 6, 4, 78.00, 10, 500000.00, 800000.00, NULL, 750000.00, 'img/products/product_1768681396_696befb44227d.jpeg', '', NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-17 20:23:16', '2026-01-22 18:32:20', NULL),
(7, 'PR_1768681438425', 1, '', '', 'ເຊັດໝໍ້ 3 ໜ່ວຍ ', 2, 4, 4, 79.00, 10, 300000.00, 400000.00, NULL, 350000.00, 'img/products/product_1768681438_696befde65db6.jpg', '', NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-17 20:23:58', '2026-01-22 18:32:20', NULL);

--
-- Triggers `products`
--
DELIMITER $$
CREATE TRIGGER `trg_products_before_insert` BEFORE INSERT ON `products` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 4;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 4;
    SET NEW.PR_id = CONCAT('PR_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `product_categories`
--

CREATE TABLE `product_categories` (
  `id` int(11) NOT NULL,
  `CA_id` varchar(30) NOT NULL COMMENT 'Category ID เช่น CA_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `category_name` varchar(100) NOT NULL,
  `category_code` varchar(20) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL COMMENT 'หมวดหมู่แม่',
  `description` text DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `sort_order` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `product_categories`
--

INSERT INTO `product_categories` (`id`, `CA_id`, `shop_id`, `category_name`, `category_code`, `parent_id`, `description`, `image`, `sort_order`, `is_active`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'CA_1768155710950', 1, 'ເຄື່ອງບໍ່ໃຊ້ໄຟຟ້າ', NULL, NULL, NULL, NULL, 0, 1, 'US_1767899049934', 'US_1767899049934', 'US_1767899049934', '2026-01-11 18:21:50', '2026-01-12 18:43:09', '2026-01-11 18:22:01'),
(2, 'CA_1768155797276', 1, 'ເຄື່ອງບໍ່ໃຊ້ໄຟຟ້າ', NULL, NULL, NULL, NULL, 0, 1, 'US_1767899049934', 'US_1767899049934', NULL, '2026-01-11 18:23:17', '2026-01-12 18:43:09', NULL),
(3, 'CA_1768337105969', 2, 'addy', NULL, NULL, NULL, NULL, 0, 1, 'US_1768243718774', NULL, NULL, '2026-01-13 20:45:05', '2026-01-13 20:45:05', NULL),
(4, 'CA_1768681340453', 1, 'printer', NULL, NULL, NULL, NULL, 0, 1, 'US_1767899049934', NULL, NULL, '2026-01-17 20:22:20', '2026-01-17 20:22:20', NULL);

--
-- Triggers `product_categories`
--
DELIMITER $$
CREATE TRIGGER `trg_product_categories_before_insert` BEFORE INSERT ON `product_categories` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 5;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 5;
    SET NEW.CA_id = CONCAT('CA_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `purchase_orders`
--

CREATE TABLE `purchase_orders` (
  `id` int(11) NOT NULL,
  `PO_id` varchar(30) NOT NULL COMMENT 'Purchase Order ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `order_code` varchar(30) DEFAULT NULL,
  `order_date` date NOT NULL,
  `supplier_name` varchar(150) DEFAULT NULL,
  `supplier_phone` varchar(20) DEFAULT NULL,
  `supplier_address` text DEFAULT NULL,
  `status` enum('draft','pending','ordered','partial','received','cancelled') DEFAULT 'draft',
  `expected_date` date DEFAULT NULL COMMENT 'วันที่คาดว่าจะได้รับ',
  `received_date` date DEFAULT NULL COMMENT 'วันที่ได้รับจริง',
  `subtotal` decimal(12,2) DEFAULT 0.00,
  `discount_amount` decimal(12,2) DEFAULT 0.00,
  `shipping_fee` decimal(12,2) DEFAULT 0.00,
  `total_amount` decimal(12,2) DEFAULT 0.00,
  `currency_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `purchase_orders`
--

INSERT INTO `purchase_orders` (`id`, `PO_id`, `shop_id`, `order_code`, `order_date`, `supplier_name`, `supplier_phone`, `supplier_address`, `status`, `expected_date`, `received_date`, `subtotal`, `discount_amount`, `shipping_fee`, `total_amount`, `currency_id`, `notes`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(2, 'PO_1768501326056', 1, NULL, '2026-01-15', 'ຕຸກ', NULL, NULL, 'pending', NULL, NULL, 0.00, 0.00, 0.00, 5000000.00, NULL, '', '3', NULL, NULL, '2026-01-15 18:22:06', '2026-01-15 18:22:06', NULL);

--
-- Triggers `purchase_orders`
--
DELIMITER $$
CREATE TRIGGER `trg_purchase_orders_before_insert` BEFORE INSERT ON `purchase_orders` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 13;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 13;
    SET NEW.PO_id = CONCAT('PO_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `purchase_order_items`
--

CREATE TABLE `purchase_order_items` (
  `id` int(11) NOT NULL,
  `purchase_order_id` int(11) NOT NULL COMMENT 'FK → purchase_orders.id',
  `product_id` varchar(30) DEFAULT NULL,
  `product_name` varchar(255) DEFAULT NULL,
  `quantity_ordered` decimal(10,2) NOT NULL,
  `quantity_received` decimal(10,2) DEFAULT 0.00,
  `unit_price` decimal(12,2) NOT NULL,
  `total` decimal(12,2) NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `purchase_order_items`
--

INSERT INTO `purchase_order_items` (`id`, `purchase_order_id`, `product_id`, `product_name`, `quantity_ordered`, `quantity_received`, `unit_price`, `total`, `notes`, `created_at`) VALUES
(2, 2, '2', 'ກະຕິກຂຽວ 1 ລິດ', 10.00, 0.00, 400000.00, 4000000.00, NULL, '2026-01-15 18:22:06'),
(3, 2, '1', 'ປິນໂຕ', 10.00, 0.00, 100000.00, 1000000.00, NULL, '2026-01-15 18:22:06');

-- --------------------------------------------------------

--
-- Table structure for table `rates`
--

CREATE TABLE `rates` (
  `id` int(11) NOT NULL,
  `rate_id` varchar(20) DEFAULT NULL,
  `currencys_id` varchar(20) DEFAULT NULL,
  `rate_amount` decimal(10,2) DEFAULT NULL,
  `rate_date` date DEFAULT NULL,
  `rate_datetime` datetime DEFAULT NULL,
  `shop_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `rates`
--

INSERT INTO `rates` (`id`, `rate_id`, `currencys_id`, `rate_amount`, `rate_date`, `rate_datetime`, `shop_id`) VALUES
(1, 'RATE_1', 'CUR_1', 1.00, '2026-01-12', '2026-01-12 15:18:04', 1),
(2, 'RATE_2', 'CUR_2', 692.00, '2026-01-12', '2026-01-12 15:19:39', 1),
(3, 'RATE_3', 'CUR_3', 21710.00, '2026-01-12', '2026-01-12 15:20:03', 1),
(4, 'RATE_4', 'CUR_2', 700.00, '2026-01-12', '2026-01-12 15:20:41', 1),
(5, 'RATE_5', 'CUR_2', 770.00, '2026-01-14', '2026-01-14 20:08:58', 1),
(6, 'RATE_6', 'CUR_2', 700.00, '2026-01-14', '2026-01-14 20:22:52', 1),
(7, 'RATE_7', 'CUR_2', 687.00, '2026-01-15', '2026-01-15 18:57:45', 1),
(8, 'RATE_8', 'CUR_2', 712.00, '2026-01-15', '2026-01-15 18:58:54', 1),
(9, 'RATE_9', 'CUR_2', 690.00, '2026-01-17', '2026-01-17 18:30:09', 1);

--
-- Triggers `rates`
--
DELIMITER $$
CREATE TRIGGER `trg_rates_before_insert` BEFORE INSERT ON `rates` FOR EACH ROW BEGIN
    IF NEW.rate_id IS NULL THEN
        SET NEW.rate_id = CONCAT('RATE_', 
            (SELECT COALESCE(MAX(CAST(SUBSTRING(rate_id,6) AS UNSIGNED)),0)+1 FROM rates)
        );
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `shipping_branches`
--

CREATE TABLE `shipping_branches` (
  `id` int(11) NOT NULL,
  `SB_id` varchar(30) NOT NULL COMMENT 'Shipping Branch ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `company_id` varchar(30) NOT NULL,
  `branch_name` varchar(150) NOT NULL,
  `branch_code` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `contact_person` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `shipping_branches`
--

INSERT INTO `shipping_branches` (`id`, `SB_id`, `shop_id`, `company_id`, `branch_name`, `branch_code`, `address`, `phone`, `contact_person`, `is_active`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'SB_1768160077314', 1, 'SC_1768160017111', 'dsd', NULL, 'dsd', '2091603424', NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-11 19:34:37', '2026-01-12 18:43:09', NULL),
(2, 'SB_1768240134521', 1, 'SC_1768240118006', 'dfdd', NULL, NULL, NULL, NULL, 1, 'US_1767815269493', NULL, NULL, '2026-01-12 17:48:54', '2026-01-12 18:43:09', NULL),
(3, 'SB_1768243501654', 1, 'SC_1768160017111', 'test', NULL, NULL, NULL, NULL, 1, 'US_1767815269493', NULL, NULL, '2026-01-12 18:45:01', '2026-01-12 18:45:01', NULL),
(4, 'SB_1768245134510', 1, 'SC_1768160017111', 'rrrr', NULL, NULL, NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-12 19:12:14', '2026-01-12 19:12:14', NULL),
(5, 'SB_1768328351156', 1, 'SC_1768328337601', 'ສາຂາ ວຽງຈະເລີນ', NULL, NULL, NULL, NULL, 1, 'US_1767815269493', NULL, NULL, '2026-01-13 18:19:11', '2026-01-13 18:19:11', NULL),
(6, 'SB_1768331128173', 1, 'SC_1768160017111', 'rrrrr', NULL, NULL, NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 19:05:28', '2026-01-13 19:05:28', NULL),
(7, 'SB_1768336367726', 1, 'SC_1768160017111', 'พพพพพ', NULL, NULL, NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 20:32:47', '2026-01-13 20:32:47', NULL),
(8, 'SB_1768337285325', 1, 'SC_1768327034985', '22222', NULL, NULL, NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 20:48:05', '2026-01-13 20:48:05', NULL),
(9, 'SB_1768337774333', 1, 'SC_1768337767181', 'กหกหกหกกหก', NULL, NULL, NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 20:56:14', '2026-01-13 20:56:14', NULL);

--
-- Triggers `shipping_branches`
--
DELIMITER $$
CREATE TRIGGER `trg_shipping_branches_before_insert` BEFORE INSERT ON `shipping_branches` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 12;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 12;
    SET NEW.SB_id = CONCAT('SB_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `shipping_companies`
--

CREATE TABLE `shipping_companies` (
  `id` int(11) NOT NULL,
  `SC_id` varchar(30) NOT NULL COMMENT 'Shipping Company ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `company_name` varchar(150) NOT NULL,
  `company_code` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `shipping_companies`
--

INSERT INTO `shipping_companies` (`id`, `SC_id`, `shop_id`, `company_name`, `company_code`, `phone`, `website`, `logo`, `is_active`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'SC_1768160017111', 1, 'test', NULL, '66778899', 'https://epgroups.com/epcommerce/admin/shipping_companies.php', NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-11 19:33:37', '2026-01-12 18:43:09', NULL),
(2, 'SC_1768240118006', 1, 'กกก', NULL, NULL, NULL, NULL, 1, 'US_1767815269493', NULL, NULL, '2026-01-12 17:48:38', '2026-01-12 18:43:09', NULL),
(3, 'SC_1768327034985', 1, 'testt', NULL, NULL, NULL, NULL, 1, 'US_1767815269493', NULL, NULL, '2026-01-13 17:57:14', '2026-01-13 17:57:14', NULL),
(4, 'SC_1768328337601', 1, 'ອານຸສິດ', NULL, NULL, NULL, NULL, 1, 'US_1767815269493', NULL, NULL, '2026-01-13 18:18:57', '2026-01-13 18:18:57', NULL),
(5, 'SC_1768337591491', 1, 'ำำำำำ', NULL, NULL, NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 20:53:11', '2026-01-13 20:53:11', NULL),
(6, 'SC_1768337634033', 1, 'ำำำำำำ', NULL, NULL, NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 20:53:54', '2026-01-13 20:53:54', NULL),
(7, 'SC_1768337767181', 1, 'กหหกกหก', NULL, NULL, NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-13 20:56:07', '2026-01-13 20:56:07', NULL);

--
-- Triggers `shipping_companies`
--
DELIMITER $$
CREATE TRIGGER `trg_shipping_companies_before_insert` BEFORE INSERT ON `shipping_companies` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 11;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 11;
    SET NEW.SC_id = CONCAT('SC_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `shops`
--

CREATE TABLE `shops` (
  `id` int(11) NOT NULL,
  `SH_id` varchar(30) NOT NULL COMMENT 'Shop ID เช่น SH_1736290000123',
  `shop_name` varchar(150) NOT NULL COMMENT 'ชื่อร้าน',
  `shop_slug` varchar(150) DEFAULT NULL COMMENT 'URL-friendly name',
  `province` varchar(100) DEFAULT NULL COMMENT 'จังหวัด',
  `logo` varchar(255) DEFAULT NULL COMMENT 'โลโก้ร้าน',
  `cover_image` varchar(255) DEFAULT NULL COMMENT 'รูปปก',
  `phone` varchar(20) DEFAULT NULL COMMENT 'เบอร์โทรศัพท์',
  `whatsapp` varchar(20) DEFAULT NULL COMMENT 'เบอร์ WhatsApp',
  `email` varchar(100) DEFAULT NULL COMMENT 'Email ร้าน',
  `address` text DEFAULT NULL COMMENT 'ที่อยู่',
  `facebook` varchar(150) DEFAULT NULL COMMENT 'ชื่อ Facebook',
  `facebook_url` varchar(255) DEFAULT NULL COMMENT 'URL Facebook',
  `tiktok` varchar(100) DEFAULT NULL COMMENT 'ชื่อ TikTok',
  `tiktok_url` varchar(255) DEFAULT NULL COMMENT 'URL TikTok',
  `instagram` varchar(100) DEFAULT NULL COMMENT 'ชื่อ Instagram',
  `instagram_url` varchar(255) DEFAULT NULL COMMENT 'URL Instagram',
  `line_id` varchar(100) DEFAULT NULL COMMENT 'Line ID',
  `website` varchar(255) DEFAULT NULL COMMENT 'Website URL',
  `description` text DEFAULT NULL COMMENT 'รายละเอียดร้าน',
  `business_type` varchar(100) DEFAULT NULL COMMENT 'ประเภทธุรกิจ',
  `status` enum('active','inactive','suspended','pending') DEFAULT 'pending',
  `plan_type` enum('free','basic','pro','enterprise') DEFAULT 'free',
  `plan_expires_at` timestamp NULL DEFAULT NULL COMMENT 'วันหมดอายุ plan',
  `owner_user_id` int(11) NOT NULL COMMENT 'User ID ของเจ้าของร้าน',
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'การตั้งค่าร้าน' CHECK (json_valid(`settings`)),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL COMMENT 'Soft delete'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `shops`
--

INSERT INTO `shops` (`id`, `SH_id`, `shop_name`, `shop_slug`, `province`, `logo`, `cover_image`, `phone`, `whatsapp`, `email`, `address`, `facebook`, `facebook_url`, `tiktok`, `tiktok_url`, `instagram`, `instagram_url`, `line_id`, `website`, `description`, `business_type`, `status`, `plan_type`, `plan_expires_at`, `owner_user_id`, `settings`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'SH_1767902982664', 'Muan Jai', 'muan-jai', 'ນະຄອນຫລວງ', NULL, NULL, '2091603424', '2091603424', 'joeyyy3455@gmail.com', '1011', 'test', '', 'test', NULL, 'test', NULL, '', '', '', NULL, 'active', 'free', NULL, 3, NULL, '2026-01-08 20:09:42', '2026-01-11 18:27:37', NULL),
(2, 'SH_1768243752014', 'comcom', 'comcom', 'ນະຄອນຫລວງ', NULL, NULL, '2091603424', '2091603424', 'add@gmail.com', '1011', 'test', NULL, 'test', NULL, 'test', NULL, NULL, 'https://epgroups.com/epcommerce/admin/shipping_companies.php', NULL, NULL, 'active', 'free', NULL, 4, NULL, '2026-01-12 18:49:12', '2026-01-12 18:49:12', NULL),
(3, 'SH_1768488965233', 'pung_shop', 'pung_shop', 'ນະຄອນຫລວງ', NULL, NULL, '2091603424', '2091603424', 'pung@gmail.com', '1011', 'test', NULL, 'test', NULL, 'test', NULL, NULL, 'https://epgroups.com/epcommerce/admin/shipping_companies.php', NULL, NULL, 'active', 'free', NULL, 5, NULL, '2026-01-15 14:56:05', '2026-01-15 15:01:48', NULL);

--
-- Triggers `shops`
--
DELIMITER $$
CREATE TRIGGER `trg_shops_before_insert` BEFORE INSERT ON `shops` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;

    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 2;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 2;

    SET NEW.SH_id = CONCAT('SH_', v_time + (v_seq MOD 1000));
    
    -- Generate slug if not provided
    IF NEW.shop_slug IS NULL OR NEW.shop_slug = '' THEN
        SET NEW.shop_slug = LOWER(REPLACE(REPLACE(NEW.shop_name, ' ', '-'), '.', ''));
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `shop_representatives`
--

CREATE TABLE `shop_representatives` (
  `id` int(11) NOT NULL,
  `shop_id` int(11) NOT NULL COMMENT 'ID ของร้าน',
  `user_id` int(11) NOT NULL COMMENT 'ID ของ representative',
  `discount_percent` decimal(5,2) DEFAULT 0.00 COMMENT 'ส่วนลดเป็น %',
  `commission_percent` decimal(5,2) DEFAULT 0.00 COMMENT 'ค่าคอมมิชชัน %',
  `rep_code` varchar(20) DEFAULT NULL COMMENT 'รหัสตัวแทน',
  `status` enum('active','inactive','pending') DEFAULT 'pending',
  `approved_by` int(11) DEFAULT NULL COMMENT 'ผู้อนุมัติ',
  `approved_at` timestamp NULL DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shop_users`
--

CREATE TABLE `shop_users` (
  `id` int(11) NOT NULL,
  `shop_id` int(11) NOT NULL COMMENT 'ID ของร้าน',
  `user_id` int(11) NOT NULL COMMENT 'ID ของ user (staff)',
  `position` varchar(100) DEFAULT NULL COMMENT 'ตำแหน่งในร้าน',
  `permissions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'สิทธิ์เฉพาะในร้าน' CHECK (json_valid(`permissions`)),
  `is_active` tinyint(1) DEFAULT 1,
  `joined_at` timestamp NULL DEFAULT current_timestamp(),
  `invited_by` int(11) DEFAULT NULL COMMENT 'ผู้เชิญเข้าร้าน',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `shop_users`
--

INSERT INTO `shop_users` (`id`, `shop_id`, `user_id`, `position`, `permissions`, `is_active`, `joined_at`, `invited_by`, `created_at`, `updated_at`) VALUES
(1, 1, 3, 'ເຈົ້າຂອງຮ້ານ', NULL, 1, '2026-01-08 20:12:03', 2, '2026-01-08 20:12:03', '2026-01-08 20:12:03'),
(2, 2, 4, '', NULL, 1, '2026-01-12 18:49:24', 2, '2026-01-12 18:49:24', '2026-01-12 18:49:24'),
(3, 3, 5, '', NULL, 1, '2026-01-15 14:56:18', 2, '2026-01-15 14:56:18', '2026-01-15 14:56:18');

-- --------------------------------------------------------

--
-- Table structure for table `sys_seq`
--

CREATE TABLE `sys_seq` (
  `id` int(11) NOT NULL,
  `seq` bigint(20) NOT NULL DEFAULT 0,
  `table_name` varchar(50) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sys_seq`
--

INSERT INTO `sys_seq` (`id`, `seq`, `table_name`, `created_at`) VALUES
(1, 4, 'users', '2026-01-07 20:10:23'),
(2, 3, 'shops', '2026-01-07 20:49:54'),
(3, 10, 'customers', '2026-01-10 19:05:59'),
(4, 7, 'products', '2026-01-10 19:05:59'),
(5, 4, 'product_categories', '2026-01-10 19:05:59'),
(6, 60, 'orders', '2026-01-10 19:05:59'),
(7, 3, 'expenses', '2026-01-10 19:05:59'),
(8, 4, 'other_income', '2026-01-10 19:05:59'),
(9, 6, 'units', '2026-01-10 19:05:59'),
(10, 4, 'colors', '2026-01-10 19:05:59'),
(11, 7, 'shipping_companies', '2026-01-10 19:05:59'),
(12, 9, 'shipping_branches', '2026-01-10 19:05:59'),
(13, 2, 'purchase_orders', '2026-01-10 19:05:59'),
(14, 1, 'currencies', '2026-01-10 19:05:59'),
(15, 0, 'payment_methods', '2026-01-10 19:05:59');

-- --------------------------------------------------------

--
-- Table structure for table `tips`
--

CREATE TABLE `tips` (
  `id` int(11) NOT NULL,
  `TIP_id` varchar(30) NOT NULL COMMENT 'Tip ID เช่น TIP_1768xxx',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `order_id` varchar(30) NOT NULL COMMENT 'FK → orders.OR_id',
  `currencys_id` varchar(20) NOT NULL COMMENT 'สกุลเงินที่ใช้ขาย',
  `currency_rate` decimal(15,4) NOT NULL COMMENT 'อัตราแลกเปลี่ยน',
  `original_total` decimal(12,4) NOT NULL COMMENT 'ยอดรวมก่อนปัดเศษ (สกุลเงินต่างประเทศ)',
  `rounded_total` decimal(12,2) NOT NULL COMMENT 'ยอดรวมหลังปัดเศษ (สกุลเงินต่างประเทศ)',
  `tip_amount_foreign` decimal(12,4) NOT NULL COMMENT 'จำนวน tip (สกุลเงินต่างประเทศ)',
  `tip_amount_lak` decimal(20,2) NOT NULL COMMENT 'จำนวน tip (LAK)',
  `calculation_note` text DEFAULT NULL COMMENT 'รายละเอียดการคำนวณ',
  `created_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tips`
--

INSERT INTO `tips` (`id`, `TIP_id`, `shop_id`, `order_id`, `currencys_id`, `currency_rate`, `original_total`, `rounded_total`, `tip_amount_foreign`, `tip_amount_lak`, `calculation_note`, `created_by`, `created_at`, `deleted_at`) VALUES
(1, 'TIP_1768679257536', 1, 'OR_1768679257499', 'CUR_2', 690.0000, 1115.9420, 1116.00, 0.0580, 40.00, 'ยอดเดิม: 1115.9420 ฿ → ปัดเป็น: 1116 ฿ | Tip: 0.0580 ฿ = 40.00 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-17 19:47:37', NULL),
(7, 'TIP_1768684928336', 1, 'OR_1768681761421', 'CUR_2', 690.0000, 4144.9275, 4145.00, 0.0725, 50.00, 'ยอดเดิม: 4144.9275 ฿ → ปัดเป็น: 4145 ฿ | Tip: 0.0725 ฿ = 50.00 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-17 21:22:08', NULL),
(9, 'TIP_1768925961293', 1, 'OR_1768925639131', 'CUR_2', 690.0000, 3985.4275, 3986.00, 0.5725, 395.00, 'ยอดเดิม: 3985.4275 ฿ → ปัดเป็น: 3986 ฿ | Tip: 0.5725 ฿ = 395.00 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-20 16:19:21', NULL),
(10, 'TIP_1768926312944', 1, 'OR_1768926312956', 'CUR_3', 21710.0000, 126.6655, 126.67, 0.0045, 97.11, 'ยอดเดิม: 126.6655 $ → ปัดเป็น: 126.67 $ | Tip: 0.0045 $ = 97.11 ₭ (Rate: 21710)', 'US_1767899049934', '2026-01-20 16:25:12', NULL),
(11, 'TIP_1768926542616', 1, 'OR_1768926542647', 'CUR_3', 21710.0000, 126.6655, 126.67, 0.0045, 97.11, 'ยอดเดิม: 126.6655 $ → ปัดเป็น: 126.67 $ | Tip: 0.0045 $ = 97.11 ₭ (Rate: 21710)', 'US_1767899049934', '2026-01-20 16:29:02', NULL),
(12, 'TIP_1768927189261', 1, 'OR_1768927189290', 'CUR_3', 21710.0000, 126.6655, 126.67, 0.0045, 97.11, 'ยอดเดิม: 126.6655 $ → ปัดเป็น: 126.67 $ | Tip: 0.0045 $ = 97.11 ₭ (Rate: 21710)', 'US_1767899049934', '2026-01-20 16:39:49', NULL),
(13, 'TIP_1768927383665', 1, 'OR_1768927383693', 'CUR_3', 21710.0000, 126.6655, 126.67, 0.0045, 97.11, 'ยอดเดิม: 126.6655 $ → ปัดเป็น: 126.67 $ | Tip: 0.0045 $ = 97.11 ₭ (Rate: 21710)', 'US_1767899049934', '2026-01-20 16:43:03', NULL),
(14, 'TIP_1768928330070', 1, 'OR_1768928330093', 'CUR_2', 690.0000, 4034.9275, 4035.00, 0.0725, 50.00, 'ยอดเดิม: 4034.9275 ฿ → ปัดเป็น: 4035 ฿ | Tip: 0.0725 ฿ = 50.00 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-20 16:58:50', NULL),
(15, 'TIP_1768928392482', 1, 'OR_1768928392500', 'CUR_2', 690.0000, 4034.9275, 4035.00, 0.0725, 50.00, 'ยอดเดิม: 4034.9275 ฿ → ปัดเป็น: 4035 ฿ | Tip: 0.0725 ฿ = 50.00 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-20 16:59:52', NULL),
(16, 'TIP_1768928562661', 1, 'OR_1768928562682', 'CUR_2', 690.0000, 4144.9275, 4145.00, 0.0725, 50.00, 'ยอดเดิม: 4144.9275 ฿ → ปัดเป็น: 4145 ฿ | Tip: 0.0725 ฿ = 50.00 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-20 17:02:42', NULL),
(17, 'TIP_1768928594156', 1, 'OR_1768928594146', 'CUR_2', 690.0000, 4144.9275, 4145.00, 0.0725, 50.00, 'ยอดเดิม: 4144.9275 ฿ → ปัดเป็น: 4145 ฿ | Tip: 0.0725 ฿ = 50.00 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-20 17:03:14', NULL),
(18, 'TIP_1769102422764', 1, 'OR_1769102422701', 'CUR_2', 690.0000, 4125.1275, 4126.00, 0.8725, 602.00, 'ยอดเดิม: 4125.1275 ฿ → ปัดเป็น: 4126 ฿ | Tip: 0.8725 ฿ = 602.00 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-22 17:20:22', NULL),
(19, 'TIP_1769102943592', 1, 'OR_1769102943554', 'CUR_2', 690.0000, 4125.2471, 4126.00, 0.7529, 519.50, 'ยอดเดิม: 4125.2471 ฿ → ปัดเป็น: 4126 ฿ | Tip: 0.7529 ฿ = 519.50 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-22 17:29:03', NULL),
(20, 'TIP_1769103833713', 1, 'OR_1769103833717', 'CUR_2', 690.0000, 3985.5072, 3986.00, 0.4928, 340.00, 'ยอดเดิม: 3985.5072 ฿ → ปัดเป็น: 3986 ฿ | Tip: 0.4928 ฿ = 340.00 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-22 17:43:53', NULL),
(21, 'TIP_1769106534908', 1, 'OR_1769106534933', 'CUR_3', 21710.0000, 59.6130, 59.62, 0.0070, 151.80, 'ยอดเดิม: 59.6130 $ → ปัดเป็น: 59.62 $ | Tip: 0.0070 $ = 151.80 ₭ (Rate: 21710)', 'US_1767899049934', '2026-01-22 18:28:54', NULL),
(22, 'TIP_1769106740824', 1, 'OR_1769106740846', 'CUR_2', 690.0000, 8252.4614, 8253.00, 0.5386, 371.60, 'ยอดเดิม: 8252.4614 ฿ → ปัดเป็น: 8253 ฿ | Tip: 0.5386 ฿ = 371.60 ₭ (Rate: 690)', 'US_1767899049934', '2026-01-22 18:32:20', NULL);

--
-- Triggers `tips`
--
DELIMITER $$
CREATE TRIGGER `trg_tips_before_insert` BEFORE INSERT ON `tips` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    SET NEW.TIP_id = CONCAT('TIP_', v_time);
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `units`
--

CREATE TABLE `units` (
  `id` int(11) NOT NULL,
  `UN_id` varchar(30) NOT NULL COMMENT 'Unit ID เช่น UN_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `unit_name` varchar(100) NOT NULL COMMENT 'ชื่อหน่วย (กล่อง, ชิ้น, กก.)',
  `unit_code` varchar(20) DEFAULT NULL COMMENT 'รหัสย่อ',
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `deleted_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `units`
--

INSERT INTO `units` (`id`, `UN_id`, `shop_id`, `unit_name`, `unit_code`, `description`, `is_active`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'UN_1768078241440', 1, 'ອັນ', 'BOXs', '', 1, 'US_1767899049934', 'US_1767899049934', 'US_1767899049934', '2026-01-10 20:50:41', '2026-01-12 18:43:09', '2026-01-11 16:42:15'),
(2, 'UN_1768154209789', 1, 'ອັນ', 'BOX', '', 1, 'US_1767899049934', 'US_1767899049934', 'US_1767899049934', '2026-01-11 17:56:49', '2026-01-12 18:43:09', '2026-01-11 17:57:44'),
(3, 'UN_1768154234276', 1, 'ໜ່ວຍ', 'BOXs', '', 1, 'US_1767899049934', NULL, 'US_1767899049934', '2026-01-11 17:57:14', '2026-01-12 18:43:09', '2026-01-11 17:57:58'),
(4, 'UN_1768155791053', 1, 'ອັນ', 'BOX', '', 1, 'US_1767899049934', 'US_1767899049934', NULL, '2026-01-11 18:23:11', '2026-01-12 18:43:09', NULL),
(5, 'UN_1768337098085', 2, 'addy', 'addy', '', 1, 'US_1768243718774', NULL, NULL, '2026-01-13 20:44:58', '2026-01-13 20:44:58', NULL),
(6, 'UN_1768681349518', 1, 'ໜ່ວຍ', NULL, NULL, 1, 'US_1767899049934', NULL, NULL, '2026-01-17 20:22:29', '2026-01-17 20:22:29', NULL);

--
-- Triggers `units`
--
DELIMITER $$
CREATE TRIGGER `trg_units_before_insert` BEFORE INSERT ON `units` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 9;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 9;
    SET NEW.UN_id = CONCAT('UN_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `unlock_delete`
--

CREATE TABLE `unlock_delete` (
  `id` int(11) NOT NULL,
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `password_hash` varchar(255) NOT NULL COMMENT 'รหัสผ่านสำหรับปลดล็อค',
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `unlock_delete`
--

INSERT INTO `unlock_delete` (`id`, `shop_id`, `password_hash`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(1, 1, '123', NULL, NULL, '2026-01-20 16:27:17', '2026-01-20 16:27:17');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `US_id` varchar(30) NOT NULL,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `role_id` int(11) NOT NULL,
  `shop_id` int(11) DEFAULT NULL COMMENT 'ร้านที่สังกัด (สำหรับ admin, staff)',
  `parent_user_id` int(11) DEFAULT NULL COMMENT 'ผู้สร้าง user นี้',
  `status` enum('active','inactive','suspended','pending') DEFAULT 'active',
  `last_login` timestamp NULL DEFAULT NULL,
  `login_attempts` int(11) DEFAULT 0,
  `locked_until` timestamp NULL DEFAULT NULL,
  `email_verified` tinyint(1) DEFAULT 0,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL COMMENT 'Soft delete'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `US_id`, `username`, `email`, `password`, `first_name`, `last_name`, `phone`, `avatar`, `role_id`, `shop_id`, `parent_user_id`, `status`, `last_login`, `login_attempts`, `locked_until`, `email_verified`, `email_verified_at`, `remember_token`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'US_1767815269493', 'superadmin', 'superadmin@epcommerce.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Super', 'Admin', '', NULL, 1, NULL, NULL, 'active', NULL, 0, NULL, 1, NULL, NULL, '2026-01-07 19:47:49', '2026-01-08 03:48:48', '2026-01-08 03:48:48'),
(2, 'US_1767816636800', 'joey', 'joeyyy3455@gmail.com', '$2y$10$7hcZbjGEqwqeTo23MIuaVOgWxW2VPvkDCMmj0JzqUwMH3YttPBk8K', 'joey', 'kty', '2091603424', NULL, 1, NULL, NULL, 'active', '2026-01-20 15:00:54', 0, NULL, 0, NULL, NULL, '2026-01-07 20:10:36', '2026-01-20 15:00:54', NULL),
(3, 'US_1767899049934', 'zaem', 'zaem@gmail.com', '$2y$10$TKYnCXhQIsAmEOlJqTktQ.DzA7H2q90JIQ38AMB1GwR2708AXqFRS', 'zaem', 'xay', '2091603424', NULL, 2, NULL, NULL, 'active', '2026-01-22 17:04:58', 0, NULL, 0, NULL, NULL, '2026-01-08 19:04:09', '2026-01-22 17:04:58', NULL),
(4, 'US_1768243718774', 'addy', 'add@gmail.com', '$2y$10$rWfgZY1QN4wu3hkUYxoDDeSdIDAqeOV.xbtbjtCmt6cDyhbtQJqd.', 'addy', 'kty', '2099886677', NULL, 2, NULL, NULL, 'active', '2026-01-18 17:53:07', 0, NULL, 0, NULL, NULL, '2026-01-12 18:48:38', '2026-01-18 17:53:07', NULL),
(5, 'US_1768488933717', 'pung', 'pung@gmail.com', '$2y$10$PL4nIpjQSBz.IaYHC6mRP.6Tzz6gPLr.egRenGJ7X6ZBBk5HplDNy', 'pung', 'kty', '2091603424', NULL, 2, NULL, NULL, 'suspended', '2026-01-15 15:00:57', 0, NULL, 0, NULL, NULL, '2026-01-15 14:55:33', '2026-01-15 15:01:57', NULL);

--
-- Triggers `users`
--
DELIMITER $$
CREATE TRIGGER `trg_users_before_insert` BEFORE INSERT ON `users` FOR EACH ROW BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;

    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 1;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 1;

    SET NEW.US_id = CONCAT('US_', v_time + (v_seq MOD 1000));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `user_activity_logs`
--

CREATE TABLE `user_activity_logs` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`metadata`)),
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `user_activity_logs`
--

INSERT INTO `user_activity_logs` (`id`, `user_id`, `action`, `description`, `ip_address`, `user_agent`, `metadata`, `created_at`) VALUES
(1, 2, 'login', 'เข้าสู่ระบบสำเร็จ', '154.222.5.129', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-07 20:11:45'),
(2, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 03:35:56'),
(3, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 03:49:25'),
(4, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 03:50:40'),
(5, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 03:51:41'),
(6, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 16:38:29'),
(7, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 16:38:49'),
(8, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 16:38:58'),
(9, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 17:53:02'),
(10, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 18:31:48'),
(11, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 19:03:07'),
(12, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 20:00:23'),
(13, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 20:08:24'),
(14, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 20:09:54'),
(15, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 20:11:20'),
(16, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 20:11:37'),
(17, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 20:12:15'),
(18, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-08 21:56:06'),
(19, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-09 14:38:58'),
(20, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-09 14:39:46'),
(21, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-09 15:57:58'),
(22, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', NULL, '2026-01-09 15:58:51'),
(23, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', NULL, '2026-01-09 16:05:25'),
(24, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', NULL, '2026-01-09 16:06:30'),
(25, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-09 16:07:55'),
(26, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', NULL, '2026-01-09 16:11:27'),
(27, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-09 16:25:32'),
(28, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-09 16:28:08'),
(29, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-09 16:57:23'),
(30, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-09 16:57:57'),
(31, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.33', 'Mozilla/5.0 (iPad; CPU OS 18_7_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/141.0.7390.96 Mobile/15E148 Safari/604.1', NULL, '2026-01-09 17:11:54'),
(32, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.5.48', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-09 18:43:58'),
(33, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-10 16:26:51'),
(34, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-10 17:26:16'),
(35, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-10 19:56:57'),
(36, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-10 20:03:38'),
(37, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-10 20:04:41'),
(38, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-10 20:36:05'),
(39, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-11 16:40:21'),
(40, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-11 16:40:44'),
(41, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-11 17:56:39'),
(42, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-11 18:17:42'),
(43, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-11 18:36:24'),
(44, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-11 18:44:40'),
(45, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-11 20:15:39'),
(46, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-11 20:18:22'),
(47, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', NULL, '2026-01-11 20:27:57'),
(48, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-12 14:28:30'),
(49, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-12 14:40:26'),
(50, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-12 18:47:43'),
(51, 4, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-12 18:49:33'),
(52, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-12 18:58:32'),
(53, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-13 10:17:37'),
(54, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-13 15:49:24'),
(55, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', NULL, '2026-01-13 16:25:57'),
(56, 4, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-13 18:53:18'),
(57, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-13 18:54:07'),
(58, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-13 20:02:23'),
(59, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-13 20:40:53'),
(60, 4, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-13 20:44:26'),
(61, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-13 20:47:28'),
(62, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-14 07:55:51'),
(63, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-14 16:45:05'),
(64, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-14 17:49:18'),
(65, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-14 18:15:54'),
(66, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-14 19:06:32'),
(67, 4, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-14 19:12:15'),
(68, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-14 19:13:08'),
(69, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 14:54:09'),
(70, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 14:54:24'),
(71, 5, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 14:56:28'),
(72, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 14:59:33'),
(73, 5, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 15:00:25'),
(74, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 15:00:35'),
(75, 5, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 15:00:57'),
(76, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 15:01:08'),
(77, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 15:04:35'),
(78, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 16:59:43'),
(79, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 20:19:27'),
(80, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 20:59:58'),
(81, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 21:00:53'),
(82, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-15 21:19:49'),
(83, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-16 00:21:26'),
(84, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-17 18:11:47'),
(85, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-17 19:55:11'),
(86, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-17 19:56:00'),
(87, 4, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-17 19:58:25'),
(88, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '115.84.71.114', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36', NULL, '2026-01-17 20:09:38'),
(89, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-17 20:20:06'),
(90, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-18 16:02:55'),
(91, 4, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-18 17:53:07'),
(92, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.112.242', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/144.0.7559.85 Mobile/15E148 Safari/604.1', NULL, '2026-01-19 02:27:58'),
(93, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-19 15:30:35'),
(94, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-19 17:25:05'),
(95, 2, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-20 15:00:54'),
(96, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-20 15:01:12'),
(97, 3, 'login', 'ເຂົ້າສູ່ລະບົບສໍາເລັດ', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', NULL, '2026-01-22 17:04:58');

-- --------------------------------------------------------

--
-- Table structure for table `user_permissions`
--

CREATE TABLE `user_permissions` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `permission_code` varchar(50) NOT NULL,
  `granted` tinyint(1) DEFAULT 1,
  `granted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_roles`
--

CREATE TABLE `user_roles` (
  `role_id` int(11) NOT NULL,
  `role_code` varchar(20) NOT NULL,
  `role_name` varchar(50) NOT NULL,
  `role_description` text DEFAULT NULL,
  `can_access_admin` tinyint(1) DEFAULT 0,
  `can_manage_users` tinyint(1) DEFAULT 0,
  `can_manage_products` tinyint(1) DEFAULT 0,
  `can_view_reports` tinyint(1) DEFAULT 0,
  `can_view_representative_price` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `user_roles`
--

INSERT INTO `user_roles` (`role_id`, `role_code`, `role_name`, `role_description`, `can_access_admin`, `can_manage_users`, `can_manage_products`, `can_view_reports`, `can_view_representative_price`, `created_at`, `updated_at`) VALUES
(1, 'super_admin', 'Super Admin', 'สำหรับ Programmer และผู้ขายระบบให้ลูกค้า - มีสิทธิ์เข้าถึงทุกอย่าง', 1, 1, 1, 1, 1, '2026-01-07 19:47:49', '2026-01-07 19:47:49'),
(2, 'admin', 'Admin', 'สำหรับเจ้าของร้าน - มีสิทธิ์จัดการร้านค้าของตัวเอง', 1, 1, 1, 1, 0, '2026-01-07 19:47:49', '2026-01-07 19:47:49'),
(3, 'staff', 'Staff', 'สำหรับพนักงานร้าน - มีสิทธิ์ตามที่ admin กำหนด', 1, 0, 1, 0, 0, '2026-01-07 19:47:49', '2026-01-07 19:47:49'),
(4, 'representative', 'Representative', 'สำหรับตัวแทนจำหน่าย - ดูสินค้าราคาตัวแทน', 0, 0, 0, 0, 1, '2026-01-07 19:47:49', '2026-01-07 19:47:49');

-- --------------------------------------------------------

--
-- Table structure for table `user_sessions`
--

CREATE TABLE `user_sessions` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `session_token` varchar(255) NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `expires_at` timestamp NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `user_sessions`
--

INSERT INTO `user_sessions` (`id`, `user_id`, `session_token`, `ip_address`, `user_agent`, `expires_at`, `created_at`) VALUES
(1, 2, 'fec99d7eb52beb78394851c158e094461d511ff199f275b454a2a7a2173ba6f9', '154.222.5.129', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-08 13:11:45', '2026-01-07 20:11:45'),
(2, 2, '48bb8f504cf160032335872a9edfb22b3745cdbf446ea38c480e20ac0a515762', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-08 20:35:56', '2026-01-08 03:35:56'),
(3, 2, 'e3c91dd28614fb1948e1ae822a1960da2a59d0a61ed9bdfb2e5dfd006b772540', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-08 20:49:25', '2026-01-08 03:49:25'),
(4, 2, '70f19b329bf346df39eff2af64765dec85dc90c39d4c6abd8d4da21a806ee1df', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-08 20:50:40', '2026-01-08 03:50:40'),
(5, 2, 'ab6a613cbee21430ab263b1a7144ed6ea1754b5a1d3ae206b29c9543aef180bb', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-08 20:51:41', '2026-01-08 03:51:41'),
(6, 2, '73296008905ee8b6b8caf14f50fa1fac668347ef90fdd73b05fceeb845ba1477', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 09:38:29', '2026-01-08 16:38:29'),
(7, 2, '7abc378b84f78abb17c63766e5fbd85e76aec5006e93843f9d6a6785d79c9dfc', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-02-07 09:38:49', '2026-01-08 16:38:49'),
(8, 2, '2d83c7f83beea5efff051788c98267f8f1d910190d34a9c03a2cae17d7f404f4', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 09:38:58', '2026-01-08 16:38:58'),
(9, 2, '1daa55478ed628a9cff5a99bf6954d1de6487a8573a4e449f3d65b6652224d88', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 10:53:02', '2026-01-08 17:53:02'),
(10, 2, '878f6dc1d91ee243f8de8200ced1ff994acfded5219f4d8d30af1bd36891fce0', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 11:31:48', '2026-01-08 18:31:48'),
(11, 2, '7b1541a0cb7558101e0b0fe28c99c3fba270f561263bd6e4336085c0829eed06', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 12:03:07', '2026-01-08 19:03:07'),
(12, 3, '8f38e3eaef671504584101833fa143e90086bc9d7e912b3260ddf12e72280aa9', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 13:00:23', '2026-01-08 20:00:23'),
(13, 2, '48b15bef6259b6f492fbb48dddac385ab7f4257e64bffc6ed3690619b85b6177', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 13:08:24', '2026-01-08 20:08:24'),
(14, 3, '0f434b930c2aec1e54440e682089c107ebfd697dc3e6a99bc2f33fa3d30f8120', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 13:09:54', '2026-01-08 20:09:54'),
(15, 3, 'd006454dbe79cc982348e19529076776e8c82be9e171b0ce139c74fe60bf187d', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 13:11:20', '2026-01-08 20:11:20'),
(16, 2, '447a93ec6a07254e2c8a99a58e3133148f86468a161d50ee66d5ad9e8ae79650', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 13:11:37', '2026-01-08 20:11:37'),
(17, 3, '73ada75b24fa1e79363227d391cd65e0d0180868401ed2eb307ec3c29fb6c36a', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 13:12:15', '2026-01-08 20:12:15'),
(18, 3, '71a0966afaaa7e8a0f60e10a12ca562658106600148afdd9544c7ddb2237e192', '183.182.114.193', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-09 14:56:06', '2026-01-08 21:56:06'),
(19, 2, '6205dc11bdccd66058b774dbc351e115618694e6e9d354ee96d16223ac01b422', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-10 07:38:58', '2026-01-09 14:38:58'),
(20, 3, '148004b10be48a5c9f7798a8a9f58c657a1a97f378a7be779076f61b2040507f', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-10 07:39:46', '2026-01-09 14:39:46'),
(21, 3, '3b9d6fc8fefcebd9bc65b6afd64786677ca9304509d8fe80bf569bfa29719492', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-10 08:57:58', '2026-01-09 15:57:58'),
(22, 3, '283cbc1225ee5bf979926a76d50d5826b649e0f40679633c6962c29907401b7c', '183.182.112.15', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', '2026-02-08 08:58:51', '2026-01-09 15:58:51'),
(23, 3, '3e1504e8da474cd5be76a36479166337c1dc73688a6c92920b1b7d70256bf9ed', '183.182.112.15', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', '2026-01-10 09:05:25', '2026-01-09 16:05:25'),
(24, 3, '8508773ae01bf44a00f8f50aab196c0fce414265a68ad033d9a3d7f832defe71', '183.182.112.15', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', '2026-01-10 09:06:30', '2026-01-09 16:06:30'),
(25, 3, '4cdb5478f24ef6f401cf4fd5df24520440e1ff92a39c337d0d41c7db0a490e39', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-10 09:07:55', '2026-01-09 16:07:55'),
(26, 3, '8ba34f5e7798ec15912dba75bb0dca7b08c95f0703903e1acef06d07c17bdd3b', '183.182.112.15', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', '2026-01-10 09:11:27', '2026-01-09 16:11:27'),
(27, 2, 'dadb4e9f14080f7ee43c899d4d9d2b14aada5c395e90eb9cdf6b81ad3ae9be8c', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-10 09:25:32', '2026-01-09 16:25:32'),
(28, 3, 'f2436ca4ce5ed49e1a400f97fe7849f6f648fb1919427cc55c23d038b7cb98c1', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-10 09:28:08', '2026-01-09 16:28:08'),
(29, 2, 'b72bba6b80e72c3ba74ecd04065b8e09571c6a6e74c4c9f8c2a19cd94cb92074', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-10 09:57:23', '2026-01-09 16:57:23'),
(30, 3, 'b09b77965f9564c83be6f16fecb8d79df1b19cd2be373f30d24db9ee4aa3fa6e', '183.182.112.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-10 09:57:57', '2026-01-09 16:57:57'),
(31, 3, 'd19ed239679156ea8c809884cd7327915a1c7f5829812cc3da1fb922266fbcf4', '183.182.112.33', 'Mozilla/5.0 (iPad; CPU OS 18_7_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/141.0.7390.96 Mobile/15E148 Safari/604.1', '2026-01-10 10:11:54', '2026-01-09 17:11:54'),
(32, 3, '7636842f02434282d7ac5f7c5ec3213166e960985f426c6521f38d40fbbf7709', '154.222.5.48', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-10 11:43:58', '2026-01-09 18:43:58'),
(33, 3, '62e08c1a64c9eef39b08cfe0bf5c1f7ce92de7b75d424ff2be896eb65103e0c9', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-11 09:26:51', '2026-01-10 16:26:51'),
(34, 3, '10ee4e5802c73f79d030de3588a466dc1b7bc0888cbc2b85cf8109d9e7647cb5', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-11 10:26:16', '2026-01-10 17:26:16'),
(35, 3, '6f74bf17b7d3ffaa97b5ace0bec9b2f684bccf308af8332cba225e76904dbbee', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-11 12:56:57', '2026-01-10 19:56:57'),
(36, 3, 'd4be826d9b79e8ccc4578a61afd334c47f029953c269a8d5e2b41793f6296bf8', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-11 13:03:38', '2026-01-10 20:03:38'),
(37, 3, '53d9e17333bf33f10dcf978f4b9b6ae06f1a7f77fc3e293f6ba5f709e6e810ad', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-11 13:04:41', '2026-01-10 20:04:41'),
(38, 3, '8b93ec410d374c293a9bb3892477db99fbdfca9d2edcfdcc5f142a41198adb99', '154.222.5.77', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-11 13:36:05', '2026-01-10 20:36:05'),
(39, 2, 'b807358566a6228219e8c2befbe027b6a642c094f51cb26f57cffe0fcf6a90e1', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-12 09:40:21', '2026-01-11 16:40:21'),
(40, 3, '0e559d3ffdff2fe847821b8f7596c8dd81f2d7fefecac9d3732e9766d9cf3f93', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-12 09:40:44', '2026-01-11 16:40:44'),
(41, 3, '7d35556ad995e7c02cb9afeac4549624d57d569f05b3cd9d07b6e31bfb0f081b', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-12 10:56:39', '2026-01-11 17:56:39'),
(42, 3, 'd91e8b65bd1064d4d41c4dc741b2f13d78f84e7d743856ce8e3db3372071a858', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-12 11:17:42', '2026-01-11 18:17:42'),
(43, 3, '5407e1f00d431eca066bfe7c83e690172fa07bc583291a3761926ec51ed0ae48', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-12 11:36:24', '2026-01-11 18:36:24'),
(44, 3, 'c76cf41bc23e5e9a2663fb7f3a3c3ef95f3cd90467c18f7a10dfa41fedd8fc5a', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-12 11:44:40', '2026-01-11 18:44:40'),
(45, 3, '777850a661bf2915dddcbc2695579413334832ea29c6417f82ef2036c738629b', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-12 13:15:39', '2026-01-11 20:15:39'),
(46, 3, '1cceafcdd422ada20959f82793e7353ce102c744c8ec801ff01357a939f5d2d0', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-12 13:18:22', '2026-01-11 20:18:22'),
(47, 3, 'd42b8f707874af61b95c33e0d84b0260eb3bb92541e6b79c88ba62b650b86bce', '183.182.110.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', '2026-01-12 13:27:57', '2026-01-11 20:27:57'),
(48, 3, '0d4e183b15fdf12bc9e2db9a1a7a975b082be1f18f6dd9d6db5438a2b26f0b7c', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-13 07:28:30', '2026-01-12 14:28:30'),
(49, 3, '3975d17c327e62a541a4a2b7842d7e43b4b8a728e8ba347938dafe5352972814', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-13 07:40:26', '2026-01-12 14:40:26'),
(50, 2, 'fcf7e738506f27ed1000ba7932aed686d460934be4b63d8ad1cd619113ffa31a', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-13 11:47:43', '2026-01-12 18:47:43'),
(51, 4, '9032f80abf739a4532ffa2b9e896c8e49dcdc6bac4bd56c7746702af9b727fd0', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-13 11:49:33', '2026-01-12 18:49:33'),
(52, 3, 'd2464977c4d9c84f67ade4a82bdeaef34837b745d238884eb227553f22b80ff0', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-13 11:58:32', '2026-01-12 18:58:32'),
(53, 3, '16385f42b2ff82c34af493580b41387be38263a59fa4abeb65be7c14b1834caf', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-14 03:17:37', '2026-01-13 10:17:37'),
(54, 3, '78a7f64a1db6d95a570c8c9be228424906879c2782d82a6cb9e4c21430c25a25', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-14 08:49:24', '2026-01-13 15:49:24'),
(55, 3, 'b62c1508e6ba4e4d1e61cbf98fb0c208b638a1125ebe3755199a6a8354c16e4e', '183.182.110.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/143.0.7499.151 Mobile/15E148 Safari/604.1', '2026-01-14 09:25:57', '2026-01-13 16:25:57'),
(56, 4, '92978072d93f4741913fc38efeaf983a6c839ce495f3e473844a8c9e99de45d1', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-14 11:53:18', '2026-01-13 18:53:18'),
(57, 3, '1f04aa7de933a2fb44deb7d899a5bb4a8e8d098e6e89bdee4da2f16daedc64fa', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-14 11:54:07', '2026-01-13 18:54:07'),
(58, 3, 'b966de84ff087e81938af1a3e3503134dfaa6077bcbeeb736ccc7183d53ca031', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-14 13:02:23', '2026-01-13 20:02:23'),
(59, 3, 'b927ad84041a10d505b2fb30dbc2bc0a09d42cd76854d6cde531d802e55cacce', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-14 13:40:53', '2026-01-13 20:40:53'),
(60, 4, '58288247d4bd787a0228f3069e569a8fc188677a403eeb994a9966cabe74f8e3', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-14 13:44:26', '2026-01-13 20:44:26'),
(61, 3, 'c13adc41345ae0b446f70186eceac0dcc5b55dc8ffcdfa52499785e88fdef324', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-14 13:47:28', '2026-01-13 20:47:29'),
(62, 3, '807bff443bb91f34dbddbbf4c654c5a6b2a12243e5fed3be28a362242e920ee6', '115.84.101.170', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-15 00:55:51', '2026-01-14 07:55:51'),
(63, 3, '7e5591e27258f6a34c6c85dab37abecf0f21877bb05d5c5c0aeeac627c1e1821', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-15 09:45:05', '2026-01-14 16:45:05'),
(64, 3, 'd655ae6c5404d09b9b3087c135e05dbd6f0f12f1908d112d002f323dc082e0db', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-15 10:49:18', '2026-01-14 17:49:18'),
(65, 3, 'f943d35fa3fdad15659fded0926c2bcf471dcb4b49464945737cbf6e4c9970e4', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-15 11:15:54', '2026-01-14 18:15:54'),
(66, 3, '215ef86c9973deb8707737c5e294bbe0f50a9701d0065f24cc68b12ebc41718b', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-15 12:06:32', '2026-01-14 19:06:32'),
(67, 4, '4451cd852ac592160f8c2582c04b624185a0d2b0acb8d51342d175f527d03e70', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-15 12:12:15', '2026-01-14 19:12:15'),
(68, 3, 'a2b8cd019af3447d170b3ec1f3343a02f7daddeb124943817c65dc903ae16f1a', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-15 12:13:08', '2026-01-14 19:13:08'),
(69, 3, '8fb934e30db8ef78a1c7304f2c866cb7c56bd09f80e7e81ed968f48e75607641', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 07:54:09', '2026-01-15 14:54:09'),
(70, 2, '5994c86d0480ea2c128c44fbad21c01bbaae659a8a10d51a73fb4c9e6b5d480a', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 07:54:24', '2026-01-15 14:54:24'),
(71, 5, '483cdcaea0b8158345af72c6543e4bbf8e57124f7b4d81d6e0debb0f1ae76782', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 07:56:28', '2026-01-15 14:56:28'),
(72, 2, 'ba1a49a378cde0a8ab8f02085bdc9de5a1cbbf3a6fe89567b7d0e64254168049', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 07:59:33', '2026-01-15 14:59:33'),
(73, 5, 'e417d5223220af6b76b313129f359d63e99de1be2547a598a081675685035efd', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 08:00:25', '2026-01-15 15:00:25'),
(74, 2, '16307cdac03d6c0a5ff038d1a498d94e928905d2e71188f51feb4570ca8b5352', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 08:00:35', '2026-01-15 15:00:35'),
(75, 5, 'e47ea06bb7d1ba426c0fd954ae1d78a04709fd676652ef954a69dbd6bbe0dfcc', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 08:00:57', '2026-01-15 15:00:57'),
(76, 2, 'ffe2531781747b45b19dd5cebc399f5541b123b659436b5ae993f9e0023ecd26', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 08:01:08', '2026-01-15 15:01:08'),
(77, 3, 'd2970de15b4606beef0931356ccf6dec3064917b4e226ee8e88f52218f55adfa', '154.222.4.28', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 08:04:35', '2026-01-15 15:04:35'),
(78, 3, '799417c246fe430a370fa5f43b4084565ca04549d7f198202b85ab46a3aebe29', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 09:59:43', '2026-01-15 16:59:43'),
(79, 3, '28b3f57257b7d82368673a5b6243877d1f57c1c404e799836cf38e3c9a8b21d3', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 13:19:27', '2026-01-15 20:19:27'),
(80, 3, '2cad0170d540423fa6069141a0c6b7d4198929bf9a6870799ad94e1903d6a558', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 13:59:58', '2026-01-15 20:59:58'),
(81, 3, 'e82119e0bdd65493ea403a193e34650fbf868dc31443c4958f381b5134657c9a', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 14:00:53', '2026-01-15 21:00:53'),
(82, 2, '3a1c30a6a52010a5582333fb58c9cf8d4fbbad64259258a2feeb5e108b694544', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 14:19:49', '2026-01-15 21:19:49'),
(83, 3, '62a93d27b827ac026d4532148c949ae89f6832112452c3543e69948a57aa3c6a', '183.182.112.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-16 17:21:26', '2026-01-16 00:21:26'),
(84, 3, 'f99552a22f6c7c2eaaeff068a986c7a912ed13e391f3ae747c068cec25dc7397', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-18 11:11:47', '2026-01-17 18:11:47'),
(85, 2, 'd789943f047c67d17693fa3f6037c3a869a01d035010625800a9107a5b703973', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-18 12:55:11', '2026-01-17 19:55:11'),
(86, 3, 'abb0cca58bfed998b58ef68f1513370393fc472d32c1132fe740a48fa13dd1e7', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-18 12:56:00', '2026-01-17 19:56:00'),
(87, 4, '0fe6e477c6fb7516d367d0fe8e882c5a8ba3be2eac70e0989d2f7036085a63f5', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-18 12:58:25', '2026-01-17 19:58:25'),
(88, 3, '2e3d397dad2d827bba0556fc552e51a9c4bc3069af6506bd868781ba406c14af', '115.84.71.114', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36', '2026-01-18 13:09:38', '2026-01-17 20:09:38'),
(89, 3, '80c2fef626e82e48ca44b092bdeb42d56d1282e995cb63868d67e26dac1c2ddf', '183.182.112.64', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-18 13:20:07', '2026-01-17 20:20:07'),
(90, 3, '2b4f936ac4ce48957d457525847a8631a186c31b169af8ba592b768a51380e6a', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-19 09:02:55', '2026-01-18 16:02:55'),
(91, 4, '6dcfc25b63b6537d938a94f203b12a315a9ca556a6d60add3aff4be290961606', '183.182.110.14', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-19 10:53:07', '2026-01-18 17:53:07'),
(92, 3, 'cca57d8e1f972bda9abd11c85bdf656a4ab889c69c49fb23a75d535f326eba7c', '183.182.112.242', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/144.0.7559.85 Mobile/15E148 Safari/604.1', '2026-01-19 19:27:58', '2026-01-19 02:27:58'),
(93, 3, '1bd307e9cd684196d53715b0e22f83756ff55a725c6045761ff0333dac8bab47', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-20 08:30:35', '2026-01-19 15:30:35'),
(94, 3, 'ec842799c3064c615a2ffa46b81f2beeaf2858e9dd3798ea65b6e5d6550a8254', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-20 10:25:05', '2026-01-19 17:25:05'),
(95, 2, '36256423c170281c073e5b7396c0db590257f65e0b573c0caee3b228ae850036', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-21 08:00:54', '2026-01-20 15:00:54'),
(96, 3, 'f2b0a9d238193dd40ea1a7d776e417a352cd7324c0f92a44b37f881a29f5a0dd', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-21 08:01:12', '2026-01-20 15:01:12'),
(97, 3, '701f813df54872fdf363656bd98f0aab6bb43cafec98432390777fb9e9d732e4', '183.182.114.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', '2026-01-23 10:04:58', '2026-01-22 17:04:58');

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_active_users`
-- (See below for the actual view)
--
CREATE TABLE `v_active_users` (
`id` int(11)
,`US_id` varchar(30)
,`username` varchar(50)
,`email` varchar(100)
,`first_name` varchar(100)
,`last_name` varchar(100)
,`phone` varchar(20)
,`avatar` varchar(255)
,`status` enum('active','inactive','suspended','pending')
,`last_login` timestamp
,`created_at` timestamp
,`role_code` varchar(20)
,`role_name` varchar(50)
,`can_access_admin` tinyint(1)
,`can_manage_users` tinyint(1)
,`can_manage_products` tinyint(1)
,`can_view_reports` tinyint(1)
,`can_view_representative_price` tinyint(1)
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_shops_with_owner`
-- (See below for the actual view)
--
CREATE TABLE `v_shops_with_owner` (
`id` int(11)
,`SH_id` varchar(30)
,`shop_name` varchar(150)
,`shop_slug` varchar(150)
,`logo` varchar(255)
,`province` varchar(100)
,`phone` varchar(20)
,`whatsapp` varchar(20)
,`address` text
,`facebook` varchar(150)
,`tiktok` varchar(100)
,`instagram` varchar(100)
,`website` varchar(255)
,`status` enum('active','inactive','suspended','pending')
,`plan_type` enum('free','basic','pro','enterprise')
,`plan_expires_at` timestamp
,`created_at` timestamp
,`owner_US_id` varchar(30)
,`owner_username` varchar(50)
,`owner_email` varchar(100)
,`owner_name` varchar(201)
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_shop_representatives`
-- (See below for the actual view)
--
CREATE TABLE `v_shop_representatives` (
`id` int(11)
,`shop_id` int(11)
,`discount_percent` decimal(5,2)
,`commission_percent` decimal(5,2)
,`rep_code` varchar(20)
,`rep_status` enum('active','inactive','pending')
,`joined_at` timestamp
,`shop_name` varchar(150)
,`SH_id` varchar(30)
,`user_id` int(11)
,`US_id` varchar(30)
,`username` varchar(50)
,`email` varchar(100)
,`first_name` varchar(100)
,`last_name` varchar(100)
,`phone` varchar(20)
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_shop_staff`
-- (See below for the actual view)
--
CREATE TABLE `v_shop_staff` (
`id` int(11)
,`shop_id` int(11)
,`position` varchar(100)
,`is_active` tinyint(1)
,`joined_at` timestamp
,`shop_name` varchar(150)
,`SH_id` varchar(30)
,`user_id` int(11)
,`US_id` varchar(30)
,`username` varchar(50)
,`email` varchar(100)
,`first_name` varchar(100)
,`last_name` varchar(100)
,`phone` varchar(20)
,`avatar` varchar(255)
);

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_users_with_roles`
-- (See below for the actual view)
--
CREATE TABLE `v_users_with_roles` (
`id` int(11)
,`US_id` varchar(30)
,`username` varchar(50)
,`email` varchar(100)
,`first_name` varchar(100)
,`last_name` varchar(100)
,`phone` varchar(20)
,`avatar` varchar(255)
,`status` enum('active','inactive','suspended','pending')
,`last_login` timestamp
,`created_at` timestamp
,`role_code` varchar(20)
,`role_name` varchar(50)
,`can_access_admin` tinyint(1)
,`can_manage_users` tinyint(1)
,`can_manage_products` tinyint(1)
,`can_view_reports` tinyint(1)
,`can_view_representative_price` tinyint(1)
);

--
-- Indexes for dumped tables
--

--
-- Indexes for table `colors`
--
ALTER TABLE `colors`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `CO_id` (`CO_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_colors_updated_by` (`updated_by`),
  ADD KEY `fk_colors_deleted_by` (`deleted_by`);

--
-- Indexes for table `currencies`
--
ALTER TABLE `currencies`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `CR_id` (`CR_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_currency_code` (`currency_code`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_currencies_updated_by` (`updated_by`),
  ADD KEY `fk_currencies_deleted_by` (`deleted_by`);

--
-- Indexes for table `currencys`
--
ALTER TABLE `currencys`
  ADD PRIMARY KEY (`id`),
  ADD KEY `shop_id` (`shop_id`);

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `CU_id` (`CU_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_phone` (`phone`),
  ADD KEY `idx_email` (`email`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_customers_updated_by` (`updated_by`),
  ADD KEY `fk_customers_deleted_by` (`deleted_by`);

--
-- Indexes for table `expenses`
--
ALTER TABLE `expenses`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `EX_id` (`EX_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_expense_date` (`expense_date`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_expenses_currency` (`currency_id`),
  ADD KEY `fk_expenses_payment_method` (`payment_method_id`),
  ADD KEY `fk_expenses_updated_by` (`updated_by`),
  ADD KEY `fk_expenses_deleted_by` (`deleted_by`);

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `OR_id` (`OR_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_customer_id` (`customer_id`),
  ADD KEY `idx_order_date` (`order_date`),
  ADD KEY `idx_order_status` (`order_status`),
  ADD KEY `idx_payment_status` (`payment_status`),
  ADD KEY `idx_payment_method_id` (`payment_method_id`),
  ADD KEY `idx_shipping_company_id` (`shipping_company_id`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_orders_currency` (`currency_id`),
  ADD KEY `fk_orders_shipping_branch` (`shipping_branch_id`),
  ADD KEY `fk_orders_updated_by` (`updated_by`),
  ADD KEY `fk_orders_deleted_by` (`deleted_by`),
  ADD KEY `idx_currencys_id` (`currencys_id`);

--
-- Indexes for table `order_items`
--
ALTER TABLE `order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_order_id` (`order_id`),
  ADD KEY `idx_product_id` (`product_id`);

--
-- Indexes for table `other_income`
--
ALTER TABLE `other_income`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `IN_id` (`IN_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_income_date` (`income_date`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_other_income_currency` (`currency_id`),
  ADD KEY `fk_other_income_payment_method` (`payment_method_id`),
  ADD KEY `fk_other_income_updated_by` (`updated_by`),
  ADD KEY `fk_other_income_deleted_by` (`deleted_by`);

--
-- Indexes for table `password_resets`
--
ALTER TABLE `password_resets`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_email` (`email`),
  ADD KEY `idx_token` (`token`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `PR_id` (`PR_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_category_id` (`category_id`),
  ADD KEY `idx_unit_id` (`unit_id`),
  ADD KEY `idx_color_id` (`color_id`),
  ADD KEY `idx_barcode` (`barcode`),
  ADD KEY `idx_product_code` (`product_code`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_products_updated_by` (`updated_by`),
  ADD KEY `fk_products_deleted_by` (`deleted_by`);

--
-- Indexes for table `product_categories`
--
ALTER TABLE `product_categories`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `CA_id` (`CA_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_parent_id` (`parent_id`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_categories_updated_by` (`updated_by`),
  ADD KEY `fk_categories_deleted_by` (`deleted_by`);

--
-- Indexes for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `PO_id` (`PO_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_order_date` (`order_date`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_purchase_orders_currency` (`currency_id`),
  ADD KEY `fk_purchase_orders_updated_by` (`updated_by`),
  ADD KEY `fk_purchase_orders_deleted_by` (`deleted_by`);

--
-- Indexes for table `purchase_order_items`
--
ALTER TABLE `purchase_order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_purchase_order_id` (`purchase_order_id`),
  ADD KEY `idx_product_id` (`product_id`);

--
-- Indexes for table `rates`
--
ALTER TABLE `rates`
  ADD PRIMARY KEY (`id`),
  ADD KEY `shop_id` (`shop_id`),
  ADD KEY `currencys_id` (`currencys_id`);

--
-- Indexes for table `shipping_branches`
--
ALTER TABLE `shipping_branches`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `SB_id` (`SB_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_company_id` (`company_id`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_shipping_branches_updated_by` (`updated_by`),
  ADD KEY `fk_shipping_branches_deleted_by` (`deleted_by`);

--
-- Indexes for table `shipping_companies`
--
ALTER TABLE `shipping_companies`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `SC_id` (`SC_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `fk_shipping_companies_updated_by` (`updated_by`),
  ADD KEY `fk_shipping_companies_deleted_by` (`deleted_by`);

--
-- Indexes for table `shops`
--
ALTER TABLE `shops`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `SH_id` (`SH_id`),
  ADD UNIQUE KEY `shop_slug` (`shop_slug`),
  ADD KEY `idx_SH_id` (`SH_id`),
  ADD KEY `idx_shop_name` (`shop_name`),
  ADD KEY `idx_shop_slug` (`shop_slug`),
  ADD KEY `idx_province` (`province`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_plan_type` (`plan_type`),
  ADD KEY `idx_owner_user_id` (`owner_user_id`);

--
-- Indexes for table `shop_representatives`
--
ALTER TABLE `shop_representatives`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_shop_rep` (`shop_id`,`user_id`),
  ADD UNIQUE KEY `rep_code` (`rep_code`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_rep_code` (`rep_code`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `approved_by` (`approved_by`);

--
-- Indexes for table `shop_users`
--
ALTER TABLE `shop_users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_shop_user` (`shop_id`,`user_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_is_active` (`is_active`),
  ADD KEY `invited_by` (`invited_by`);

--
-- Indexes for table `sys_seq`
--
ALTER TABLE `sys_seq`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tips`
--
ALTER TABLE `tips`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `order_id` (`order_id`),
  ADD KEY `idx_tips_shop_id` (`shop_id`),
  ADD KEY `idx_tips_currencys_id` (`currencys_id`);

--
-- Indexes for table `units`
--
ALTER TABLE `units`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `UN_id` (`UN_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `idx_updated_by` (`updated_by`),
  ADD KEY `idx_deleted_by` (`deleted_by`);

--
-- Indexes for table `unlock_delete`
--
ALTER TABLE `unlock_delete`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `fk_unlock_delete_created_by` (`created_by`),
  ADD KEY `fk_unlock_delete_updated_by` (`updated_by`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `US_id` (`US_id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `idx_US_id` (`US_id`),
  ADD KEY `idx_username` (`username`),
  ADD KEY `idx_email` (`email`),
  ADD KEY `idx_role_id` (`role_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_status` (`status`);

--
-- Indexes for table `user_activity_logs`
--
ALTER TABLE `user_activity_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_action` (`action`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `user_permissions`
--
ALTER TABLE `user_permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_user_permission` (`user_id`,`permission_code`),
  ADD KEY `granted_by` (`granted_by`);

--
-- Indexes for table `user_roles`
--
ALTER TABLE `user_roles`
  ADD PRIMARY KEY (`role_id`),
  ADD UNIQUE KEY `role_code` (`role_code`);

--
-- Indexes for table `user_sessions`
--
ALTER TABLE `user_sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_session_token` (`session_token`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_expires_at` (`expires_at`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `colors`
--
ALTER TABLE `colors`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `currencies`
--
ALTER TABLE `currencies`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `currencys`
--
ALTER TABLE `currencys`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `expenses`
--
ALTER TABLE `expenses`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=64;

--
-- AUTO_INCREMENT for table `order_items`
--
ALTER TABLE `order_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=377;

--
-- AUTO_INCREMENT for table `other_income`
--
ALTER TABLE `other_income`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `password_resets`
--
ALTER TABLE `password_resets`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `product_categories`
--
ALTER TABLE `product_categories`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `purchase_order_items`
--
ALTER TABLE `purchase_order_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `rates`
--
ALTER TABLE `rates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `shipping_branches`
--
ALTER TABLE `shipping_branches`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `shipping_companies`
--
ALTER TABLE `shipping_companies`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `shops`
--
ALTER TABLE `shops`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `shop_representatives`
--
ALTER TABLE `shop_representatives`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `shop_users`
--
ALTER TABLE `shop_users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `sys_seq`
--
ALTER TABLE `sys_seq`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT for table `tips`
--
ALTER TABLE `tips`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT for table `units`
--
ALTER TABLE `units`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `unlock_delete`
--
ALTER TABLE `unlock_delete`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `user_activity_logs`
--
ALTER TABLE `user_activity_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=98;

--
-- AUTO_INCREMENT for table `user_permissions`
--
ALTER TABLE `user_permissions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_roles`
--
ALTER TABLE `user_roles`
  MODIFY `role_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `user_sessions`
--
ALTER TABLE `user_sessions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=98;

-- --------------------------------------------------------

--
-- Structure for view `v_active_users`
--
DROP TABLE IF EXISTS `v_active_users`;

CREATE ALGORITHM=UNDEFINED DEFINER=`zfhfpsz1`@`localhost` SQL SECURITY DEFINER VIEW `v_active_users`  AS SELECT `v_users_with_roles`.`id` AS `id`, `v_users_with_roles`.`US_id` AS `US_id`, `v_users_with_roles`.`username` AS `username`, `v_users_with_roles`.`email` AS `email`, `v_users_with_roles`.`first_name` AS `first_name`, `v_users_with_roles`.`last_name` AS `last_name`, `v_users_with_roles`.`phone` AS `phone`, `v_users_with_roles`.`avatar` AS `avatar`, `v_users_with_roles`.`status` AS `status`, `v_users_with_roles`.`last_login` AS `last_login`, `v_users_with_roles`.`created_at` AS `created_at`, `v_users_with_roles`.`role_code` AS `role_code`, `v_users_with_roles`.`role_name` AS `role_name`, `v_users_with_roles`.`can_access_admin` AS `can_access_admin`, `v_users_with_roles`.`can_manage_users` AS `can_manage_users`, `v_users_with_roles`.`can_manage_products` AS `can_manage_products`, `v_users_with_roles`.`can_view_reports` AS `can_view_reports`, `v_users_with_roles`.`can_view_representative_price` AS `can_view_representative_price` FROM `v_users_with_roles` WHERE `v_users_with_roles`.`status` = 'active' ;

-- --------------------------------------------------------

--
-- Structure for view `v_shops_with_owner`
--
DROP TABLE IF EXISTS `v_shops_with_owner`;

CREATE ALGORITHM=UNDEFINED DEFINER=`zfhfpsz1`@`localhost` SQL SECURITY DEFINER VIEW `v_shops_with_owner`  AS SELECT `s`.`id` AS `id`, `s`.`SH_id` AS `SH_id`, `s`.`shop_name` AS `shop_name`, `s`.`shop_slug` AS `shop_slug`, `s`.`logo` AS `logo`, `s`.`province` AS `province`, `s`.`phone` AS `phone`, `s`.`whatsapp` AS `whatsapp`, `s`.`address` AS `address`, `s`.`facebook` AS `facebook`, `s`.`tiktok` AS `tiktok`, `s`.`instagram` AS `instagram`, `s`.`website` AS `website`, `s`.`status` AS `status`, `s`.`plan_type` AS `plan_type`, `s`.`plan_expires_at` AS `plan_expires_at`, `s`.`created_at` AS `created_at`, `u`.`US_id` AS `owner_US_id`, `u`.`username` AS `owner_username`, `u`.`email` AS `owner_email`, concat(`u`.`first_name`,' ',`u`.`last_name`) AS `owner_name` FROM (`shops` `s` join `users` `u` on(`s`.`owner_user_id` = `u`.`id`)) WHERE `s`.`deleted_at` is null ;

-- --------------------------------------------------------

--
-- Structure for view `v_shop_representatives`
--
DROP TABLE IF EXISTS `v_shop_representatives`;

CREATE ALGORITHM=UNDEFINED DEFINER=`zfhfpsz1`@`localhost` SQL SECURITY DEFINER VIEW `v_shop_representatives`  AS SELECT `sr`.`id` AS `id`, `sr`.`shop_id` AS `shop_id`, `sr`.`discount_percent` AS `discount_percent`, `sr`.`commission_percent` AS `commission_percent`, `sr`.`rep_code` AS `rep_code`, `sr`.`status` AS `rep_status`, `sr`.`created_at` AS `joined_at`, `s`.`shop_name` AS `shop_name`, `s`.`SH_id` AS `SH_id`, `u`.`id` AS `user_id`, `u`.`US_id` AS `US_id`, `u`.`username` AS `username`, `u`.`email` AS `email`, `u`.`first_name` AS `first_name`, `u`.`last_name` AS `last_name`, `u`.`phone` AS `phone` FROM ((`shop_representatives` `sr` join `shops` `s` on(`sr`.`shop_id` = `s`.`id`)) join `users` `u` on(`sr`.`user_id` = `u`.`id`)) WHERE `s`.`deleted_at` is null AND `u`.`deleted_at` is null ;

-- --------------------------------------------------------

--
-- Structure for view `v_shop_staff`
--
DROP TABLE IF EXISTS `v_shop_staff`;

CREATE ALGORITHM=UNDEFINED DEFINER=`zfhfpsz1`@`localhost` SQL SECURITY DEFINER VIEW `v_shop_staff`  AS SELECT `su`.`id` AS `id`, `su`.`shop_id` AS `shop_id`, `su`.`position` AS `position`, `su`.`is_active` AS `is_active`, `su`.`joined_at` AS `joined_at`, `s`.`shop_name` AS `shop_name`, `s`.`SH_id` AS `SH_id`, `u`.`id` AS `user_id`, `u`.`US_id` AS `US_id`, `u`.`username` AS `username`, `u`.`email` AS `email`, `u`.`first_name` AS `first_name`, `u`.`last_name` AS `last_name`, `u`.`phone` AS `phone`, `u`.`avatar` AS `avatar` FROM ((`shop_users` `su` join `shops` `s` on(`su`.`shop_id` = `s`.`id`)) join `users` `u` on(`su`.`user_id` = `u`.`id`)) WHERE `s`.`deleted_at` is null AND `u`.`deleted_at` is null ;

-- --------------------------------------------------------

--
-- Structure for view `v_users_with_roles`
--
DROP TABLE IF EXISTS `v_users_with_roles`;

CREATE ALGORITHM=UNDEFINED DEFINER=`zfhfpsz1`@`localhost` SQL SECURITY DEFINER VIEW `v_users_with_roles`  AS SELECT `u`.`id` AS `id`, `u`.`US_id` AS `US_id`, `u`.`username` AS `username`, `u`.`email` AS `email`, `u`.`first_name` AS `first_name`, `u`.`last_name` AS `last_name`, `u`.`phone` AS `phone`, `u`.`avatar` AS `avatar`, `u`.`status` AS `status`, `u`.`last_login` AS `last_login`, `u`.`created_at` AS `created_at`, `r`.`role_code` AS `role_code`, `r`.`role_name` AS `role_name`, `r`.`can_access_admin` AS `can_access_admin`, `r`.`can_manage_users` AS `can_manage_users`, `r`.`can_manage_products` AS `can_manage_products`, `r`.`can_view_reports` AS `can_view_reports`, `r`.`can_view_representative_price` AS `can_view_representative_price` FROM (`users` `u` join `user_roles` `r` on(`u`.`role_id` = `r`.`role_id`)) WHERE `u`.`deleted_at` is null ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `colors`
--
ALTER TABLE `colors`
  ADD CONSTRAINT `fk_colors_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `currencies`
--
ALTER TABLE `currencies`
  ADD CONSTRAINT `fk_currencies_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `customers`
--
ALTER TABLE `customers`
  ADD CONSTRAINT `fk_customers_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `expenses`
--
ALTER TABLE `expenses`
  ADD CONSTRAINT `fk_expenses_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_expenses_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `fk_orders_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_orders_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `order_items`
--
ALTER TABLE `order_items`
  ADD CONSTRAINT `fk_order_items_order` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `other_income`
--
ALTER TABLE `other_income`
  ADD CONSTRAINT `fk_other_income_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_other_income_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `products`
--
ALTER TABLE `products`
  ADD CONSTRAINT `fk_products_category` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_products_color` FOREIGN KEY (`color_id`) REFERENCES `colors` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_products_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_products_unit` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `product_categories`
--
ALTER TABLE `product_categories`
  ADD CONSTRAINT `fk_categories_parent` FOREIGN KEY (`parent_id`) REFERENCES `product_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_categories_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  ADD CONSTRAINT `fk_purchase_orders_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_purchase_orders_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `purchase_order_items`
--
ALTER TABLE `purchase_order_items`
  ADD CONSTRAINT `fk_po_items_purchase_order` FOREIGN KEY (`purchase_order_id`) REFERENCES `purchase_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `shipping_branches`
--
ALTER TABLE `shipping_branches`
  ADD CONSTRAINT `fk_shipping_branches_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `shipping_companies`
--
ALTER TABLE `shipping_companies`
  ADD CONSTRAINT `fk_shipping_companies_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `shops`
--
ALTER TABLE `shops`
  ADD CONSTRAINT `shops_ibfk_1` FOREIGN KEY (`owner_user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `shop_representatives`
--
ALTER TABLE `shop_representatives`
  ADD CONSTRAINT `shop_representatives_ibfk_1` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `shop_representatives_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `shop_representatives_ibfk_3` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `shop_users`
--
ALTER TABLE `shop_users`
  ADD CONSTRAINT `shop_users_ibfk_1` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `shop_users_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `shop_users_ibfk_3` FOREIGN KEY (`invited_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `units`
--
ALTER TABLE `units`
  ADD CONSTRAINT `fk_units_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `unlock_delete`
--
ALTER TABLE `unlock_delete`
  ADD CONSTRAINT `fk_unlock_delete_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_unlock_delete_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_unlock_delete_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `user_roles` (`role_id`) ON UPDATE CASCADE;

--
-- Constraints for table `user_activity_logs`
--
ALTER TABLE `user_activity_logs`
  ADD CONSTRAINT `user_activity_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `user_permissions`
--
ALTER TABLE `user_permissions`
  ADD CONSTRAINT `user_permissions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `user_permissions_ibfk_2` FOREIGN KEY (`granted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `user_sessions`
--
ALTER TABLE `user_sessions`
  ADD CONSTRAINT `user_sessions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
