-- Tips Table for EPCommerce
-- Stores rounding differences when selling in foreign currencies

CREATE TABLE IF NOT EXISTS `tips` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `TIP_id` varchar(30) NOT NULL COMMENT 'Tip ID เช่น TIP_1768xxx',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `order_id` varchar(30) NOT NULL COMMENT 'FK → orders.OR_id',
  `currencys_id` varchar(20) NOT NULL COMMENT 'สกุลเงินที่ใช้ขาย',
  `currency_rate` decimal(15,4) NOT NULL COMMENT 'อัตราแลกเปลี่ยน',
  `original_total` decimal(12,4) NOT NULL COMMENT 'ยอดรวมก่อนปัดเศษ (สกุลเงินต่างประเทศ)',
  `rounded_total` decimal(12,2) NOT NULL COMMENT 'ยอดรวมหลังปัดเศษ (สกุลเงินต่างประเทศ)',
  `tip_amount_foreign` decimal(12,4) NOT NULL COMMENT 'จำนวน tip (สกุลเงินต่างประเทศ)',
  `tip_amount_lak` decimal(20,2) NOT NULL COMMENT 'จำนวน tip (LAK)',
  `calculation_note` text DEFAULT NULL COMMENT 'รายละเอียดการคำนวณ',
  `created_by` varchar(30) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `idx_tips_shop_id` (`shop_id`),
  KEY `idx_tips_currencys_id` (`currencys_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Trigger for auto-generating TIP_id
DELIMITER $$
DROP TRIGGER IF EXISTS `trg_tips_before_insert`$$
CREATE TRIGGER `trg_tips_before_insert` BEFORE INSERT ON `tips` FOR EACH ROW 
BEGIN
    DECLARE v_time BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    SET NEW.TIP_id = CONCAT('TIP_', v_time);
END$$
DELIMITER ;
