-- Migration: Add refund functionality to orders table
-- Run this SQL in your database to add the refund_amount column and update payment_status enum

-- 1. Add refund_amount column (if not exists)
ALTER TABLE `orders` ADD COLUMN IF NOT EXISTS `refund_amount` DECIMAL(12,2) DEFAULT 0.00 COMMENT 'ຈຳນວນເງິນທີ່ຄືນ' AFTER `deposit_amount`;

-- 2. Update payment_status enum to include partial_refund
ALTER TABLE `orders` MODIFY COLUMN `payment_status` ENUM('pending','partial','paid','partial_refund','refunded') DEFAULT 'pending';
