-- =====================================================
-- Migration: Change Foreign Keys from id to Secondary IDs
-- Date: 2026-01-13 (CORRECT VERSION based on actual DB)
-- =====================================================
-- Based on actual database structure exported from server
-- =====================================================

SET FOREIGN_KEY_CHECKS = 0;

-- =====================================================
-- STEP 1: DROP FK constraints that exist (from actual DB)
-- =====================================================

-- product_categories has FK on created_by, updated_by, deleted_by
ALTER TABLE `product_categories` DROP FOREIGN KEY `fk_categories_created_by`;
ALTER TABLE `product_categories` DROP FOREIGN KEY `fk_categories_updated_by`;
ALTER TABLE `product_categories` DROP FOREIGN KEY `fk_categories_deleted_by`;

-- currencies has FK on created_by, updated_by, deleted_by
ALTER TABLE `currencies` DROP FOREIGN KEY `fk_currencies_created_by`;
ALTER TABLE `currencies` DROP FOREIGN KEY `fk_currencies_updated_by`;
ALTER TABLE `currencies` DROP FOREIGN KEY `fk_currencies_deleted_by`;

-- orders has FK on customer_id
ALTER TABLE `orders` DROP FOREIGN KEY `fk_orders_customer`;

-- purchase_order_items has FK on product_id
ALTER TABLE `purchase_order_items` DROP FOREIGN KEY `fk_po_items_product`;

-- =====================================================
-- STEP 2: ALTER columns that are still INT
-- (Skip colors, customers, expenses, orders created_by, other_income - already VARCHAR)
-- =====================================================

-- products table
ALTER TABLE `products` MODIFY `created_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `products` MODIFY `updated_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `products` MODIFY `deleted_by` VARCHAR(30) DEFAULT NULL;

-- product_categories table
ALTER TABLE `product_categories` MODIFY `created_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `product_categories` MODIFY `updated_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `product_categories` MODIFY `deleted_by` VARCHAR(30) DEFAULT NULL;

-- currencies table
ALTER TABLE `currencies` MODIFY `created_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `currencies` MODIFY `updated_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `currencies` MODIFY `deleted_by` VARCHAR(30) DEFAULT NULL;

-- shipping_companies table
ALTER TABLE `shipping_companies` MODIFY `created_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `shipping_companies` MODIFY `updated_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `shipping_companies` MODIFY `deleted_by` VARCHAR(30) DEFAULT NULL;

-- shipping_branches table
ALTER TABLE `shipping_branches` MODIFY `created_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `shipping_branches` MODIFY `updated_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `shipping_branches` MODIFY `deleted_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `shipping_branches` MODIFY `company_id` VARCHAR(30) NOT NULL;

-- units table
ALTER TABLE `units` MODIFY `created_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `units` MODIFY `updated_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `units` MODIFY `deleted_by` VARCHAR(30) DEFAULT NULL;

-- purchase_orders table
ALTER TABLE `purchase_orders` MODIFY `created_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `purchase_orders` MODIFY `updated_by` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `purchase_orders` MODIFY `deleted_by` VARCHAR(30) DEFAULT NULL;

-- orders table - customer_id, shipping IDs
ALTER TABLE `orders` MODIFY `customer_id` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `orders` MODIFY `shipping_company_id` VARCHAR(30) DEFAULT NULL;
ALTER TABLE `orders` MODIFY `shipping_branch_id` VARCHAR(30) DEFAULT NULL;

-- order_items table - product_id
ALTER TABLE `order_items` MODIFY `product_id` VARCHAR(30) NOT NULL;

-- purchase_order_items table - product_id
ALTER TABLE `purchase_order_items` MODIFY `product_id` VARCHAR(30) DEFAULT NULL;

-- =====================================================
-- STEP 3: Update existing data to use secondary IDs
-- =====================================================

-- Update products created_by/updated_by/deleted_by
UPDATE `products` p 
SET p.created_by = (SELECT u.US_id FROM users u WHERE u.id = p.created_by)
WHERE p.created_by IS NOT NULL AND p.created_by REGEXP '^[0-9]+$';

UPDATE `products` p 
SET p.updated_by = (SELECT u.US_id FROM users u WHERE u.id = p.updated_by)
WHERE p.updated_by IS NOT NULL AND p.updated_by REGEXP '^[0-9]+$';

UPDATE `products` p 
SET p.deleted_by = (SELECT u.US_id FROM users u WHERE u.id = p.deleted_by)
WHERE p.deleted_by IS NOT NULL AND p.deleted_by REGEXP '^[0-9]+$';

-- Update product_categories
UPDATE `product_categories` p 
SET p.created_by = (SELECT u.US_id FROM users u WHERE u.id = p.created_by)
WHERE p.created_by IS NOT NULL AND p.created_by REGEXP '^[0-9]+$';

UPDATE `product_categories` p 
SET p.updated_by = (SELECT u.US_id FROM users u WHERE u.id = p.updated_by)
WHERE p.updated_by IS NOT NULL AND p.updated_by REGEXP '^[0-9]+$';

UPDATE `product_categories` p 
SET p.deleted_by = (SELECT u.US_id FROM users u WHERE u.id = p.deleted_by)
WHERE p.deleted_by IS NOT NULL AND p.deleted_by REGEXP '^[0-9]+$';

-- Update currencies
UPDATE `currencies` c 
SET c.created_by = (SELECT u.US_id FROM users u WHERE u.id = c.created_by)
WHERE c.created_by IS NOT NULL AND c.created_by REGEXP '^[0-9]+$';

-- Update shipping_companies
UPDATE `shipping_companies` s 
SET s.created_by = (SELECT u.US_id FROM users u WHERE u.id = s.created_by)
WHERE s.created_by IS NOT NULL AND s.created_by REGEXP '^[0-9]+$';

-- Update shipping_branches (user IDs)
UPDATE `shipping_branches` s 
SET s.created_by = (SELECT u.US_id FROM users u WHERE u.id = s.created_by)
WHERE s.created_by IS NOT NULL AND s.created_by REGEXP '^[0-9]+$';

-- Update shipping_branches.company_id to SC_id
UPDATE `shipping_branches` sb 
SET sb.company_id = (SELECT sc.SC_id FROM shipping_companies sc WHERE sc.id = sb.company_id)
WHERE sb.company_id IS NOT NULL AND sb.company_id REGEXP '^[0-9]+$';

-- Update units
UPDATE `units` u2 
SET u2.created_by = (SELECT u.US_id FROM users u WHERE u.id = u2.created_by)
WHERE u2.created_by IS NOT NULL AND u2.created_by REGEXP '^[0-9]+$';

UPDATE `units` u2 
SET u2.updated_by = (SELECT u.US_id FROM users u WHERE u.id = u2.updated_by)
WHERE u2.updated_by IS NOT NULL AND u2.updated_by REGEXP '^[0-9]+$';

UPDATE `units` u2 
SET u2.deleted_by = (SELECT u.US_id FROM users u WHERE u.id = u2.deleted_by)
WHERE u2.deleted_by IS NOT NULL AND u2.deleted_by REGEXP '^[0-9]+$';

-- Update purchase_orders
UPDATE `purchase_orders` p 
SET p.created_by = (SELECT u.US_id FROM users u WHERE u.id = p.created_by)
WHERE p.created_by IS NOT NULL AND p.created_by REGEXP '^[0-9]+$';

-- Update orders.customer_id to CU_id
UPDATE `orders` o 
SET o.customer_id = (SELECT c.CU_id FROM customers c WHERE c.id = o.customer_id)
WHERE o.customer_id IS NOT NULL AND o.customer_id REGEXP '^[0-9]+$';

-- Update orders.shipping_company_id to SC_id
UPDATE `orders` o 
SET o.shipping_company_id = (SELECT sc.SC_id FROM shipping_companies sc WHERE sc.id = o.shipping_company_id)
WHERE o.shipping_company_id IS NOT NULL AND o.shipping_company_id REGEXP '^[0-9]+$';

-- Update orders.shipping_branch_id to SB_id
UPDATE `orders` o 
SET o.shipping_branch_id = (SELECT sb.SB_id FROM shipping_branches sb WHERE sb.id = o.shipping_branch_id)
WHERE o.shipping_branch_id IS NOT NULL AND o.shipping_branch_id REGEXP '^[0-9]+$';

-- Update order_items.product_id to PR_id
UPDATE `order_items` oi 
SET oi.product_id = (SELECT p.PR_id FROM products p WHERE p.id = oi.product_id)
WHERE oi.product_id IS NOT NULL AND oi.product_id REGEXP '^[0-9]+$';

-- Update purchase_order_items.product_id to PR_id
UPDATE `purchase_order_items` poi 
SET poi.product_id = (SELECT p.PR_id FROM products p WHERE p.id = poi.product_id)
WHERE poi.product_id IS NOT NULL AND poi.product_id REGEXP '^[0-9]+$';

SET FOREIGN_KEY_CHECKS = 1;

-- =====================================================
-- DONE! 
-- FK constraints are removed (no longer needed with secondary IDs)
-- =====================================================
