-- =============================================
-- EPcommerce Business Tables Migration
-- Generated: 2026-01-11
-- Description: Business tables extending now_database.sql
-- =============================================

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

-- =============================================
-- Add sequence entries for new tables
-- =============================================

INSERT INTO `sys_seq` (`id`, `seq`, `table_name`, `created_at`) VALUES
(3, 0, 'customers', NOW()),
(4, 0, 'products', NOW()),
(5, 0, 'product_categories', NOW()),
(6, 0, 'orders', NOW()),
(7, 0, 'expenses', NOW()),
(8, 0, 'other_income', NOW()),
(9, 0, 'units', NOW()),
(10, 0, 'colors', NOW()),
(11, 0, 'shipping_companies', NOW()),
(12, 0, 'shipping_branches', NOW()),
(13, 0, 'purchase_orders', NOW()),
(14, 0, 'currencies', NOW()),
(15, 0, 'payment_methods', NOW());

-- =============================================
-- UNITS (ຫົວໜ່ວຍສິນຄ້າ)
-- =============================================

CREATE TABLE `units` (
  `id` int(11) NOT NULL,
  `UN_id` varchar(30) NOT NULL COMMENT 'Unit ID เช่น UN_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `unit_name` varchar(100) NOT NULL COMMENT 'ชื่อหน่วย (กล่อง, ชิ้น, กก.)',
  `unit_code` varchar(20) DEFAULT NULL COMMENT 'รหัสย่อ',
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL COMMENT 'FK → users.id',
  `updated_by` int(11) DEFAULT NULL COMMENT 'FK → users.id',
  `deleted_by` int(11) DEFAULT NULL COMMENT 'FK → users.id',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Trigger for UN_id
DELIMITER $$
CREATE TRIGGER `trg_units_before_insert` BEFORE INSERT ON `units` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 9;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 9;
    SET NEW.UN_id = CONCAT('UN_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- COLORS (ສີສິນຄ້າ)
-- =============================================

CREATE TABLE `colors` (
  `id` int(11) NOT NULL,
  `CO_id` varchar(30) NOT NULL COMMENT 'Color ID เช่น CO_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `color_name` varchar(100) NOT NULL COMMENT 'ชื่อสี',
  `color_code` varchar(20) DEFAULT NULL COMMENT 'รหัสสี HEX',
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_colors_before_insert` BEFORE INSERT ON `colors` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 10;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 10;
    SET NEW.CO_id = CONCAT('CO_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- PRODUCT CATEGORIES (ປະເພດສິນຄ້າ)
-- =============================================

CREATE TABLE `product_categories` (
  `id` int(11) NOT NULL,
  `CA_id` varchar(30) NOT NULL COMMENT 'Category ID เช่น CA_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `category_name` varchar(100) NOT NULL,
  `category_code` varchar(20) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL COMMENT 'หมวดหมู่แม่',
  `description` text DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `sort_order` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_product_categories_before_insert` BEFORE INSERT ON `product_categories` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 5;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 5;
    SET NEW.CA_id = CONCAT('CA_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- PRODUCTS (ສິນຄ້າ)
-- =============================================

CREATE TABLE `products` (
  `id` int(11) NOT NULL,
  `PR_id` varchar(30) NOT NULL COMMENT 'Product ID เช่น PR_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `product_code` varchar(50) DEFAULT NULL COMMENT 'รหัสสินค้า (SKU)',
  `barcode` varchar(50) DEFAULT NULL COMMENT 'บาร์โค้ด',
  `product_name` varchar(255) NOT NULL,
  `category_id` int(11) DEFAULT NULL COMMENT 'FK → product_categories.id',
  `unit_id` int(11) DEFAULT NULL COMMENT 'FK → units.id',
  `color_id` int(11) DEFAULT NULL COMMENT 'FK → colors.id',
  `quantity` decimal(10,2) NOT NULL DEFAULT 0.00 COMMENT 'จำนวนในสต็อก',
  `low_stock_threshold` int(11) DEFAULT 10 COMMENT 'เตือนเมื่อต่ำกว่า',
  `cost_price` decimal(12,2) NOT NULL DEFAULT 0.00 COMMENT 'ราคาทุน',
  `selling_price` decimal(12,2) NOT NULL DEFAULT 0.00 COMMENT 'ราคาขาย',
  `wholesale_price` decimal(12,2) DEFAULT NULL COMMENT 'ราคาส่ง',
  `representative_price` decimal(12,2) DEFAULT NULL COMMENT 'ราคาตัวแทน',
  `product_image` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `supplier_name` varchar(150) DEFAULT NULL,
  `supplier_phone` varchar(20) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_products_before_insert` BEFORE INSERT ON `products` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 4;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 4;
    SET NEW.PR_id = CONCAT('PR_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- CUSTOMERS (ລູກຄ້າ)
-- =============================================

CREATE TABLE `customers` (
  `id` int(11) NOT NULL,
  `CU_id` varchar(30) NOT NULL COMMENT 'Customer ID เช่น CU_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `customer_code` varchar(20) DEFAULT NULL COMMENT 'รหัสลูกค้า',
  `name` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `province` varchar(100) DEFAULT NULL,
  `tax_id` varchar(20) DEFAULT NULL COMMENT 'เลขประจำตัวผู้เสียภาษี',
  `customer_type` enum('regular','wholesale','representative') DEFAULT 'regular',
  `discount_percent` decimal(5,2) DEFAULT 0.00,
  `credit_limit` decimal(12,2) DEFAULT 0.00,
  `notes` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_customers_before_insert` BEFORE INSERT ON `customers` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 3;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 3;
    SET NEW.CU_id = CONCAT('CU_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- SHIPPING COMPANIES (ບໍລິສັດຂົນສົ່ງ)
-- =============================================

CREATE TABLE `shipping_companies` (
  `id` int(11) NOT NULL,
  `SC_id` varchar(30) NOT NULL COMMENT 'Shipping Company ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `company_name` varchar(150) NOT NULL,
  `company_code` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_shipping_companies_before_insert` BEFORE INSERT ON `shipping_companies` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 11;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 11;
    SET NEW.SC_id = CONCAT('SC_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- SHIPPING BRANCHES (ສາຂາຂົນສົ່ງ)
-- =============================================

CREATE TABLE `shipping_branches` (
  `id` int(11) NOT NULL,
  `SB_id` varchar(30) NOT NULL COMMENT 'Shipping Branch ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `company_id` int(11) NOT NULL COMMENT 'FK → shipping_companies.id',
  `branch_name` varchar(150) NOT NULL,
  `branch_code` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `contact_person` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_shipping_branches_before_insert` BEFORE INSERT ON `shipping_branches` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 12;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 12;
    SET NEW.SB_id = CONCAT('SB_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- CURRENCIES (ສະກຸນເງິນຕາ)
-- =============================================

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL,
  `CR_id` varchar(30) NOT NULL COMMENT 'Currency ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `currency_code` varchar(10) NOT NULL COMMENT 'LAK, THB, USD',
  `currency_name` varchar(50) NOT NULL,
  `symbol` varchar(10) DEFAULT NULL COMMENT '₭, ฿, $',
  `exchange_rate` decimal(15,6) DEFAULT 1.000000 COMMENT 'อัตราแลกเปลี่ยน',
  `is_default` tinyint(1) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_currencies_before_insert` BEFORE INSERT ON `currencies` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 14;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 14;
    SET NEW.CR_id = CONCAT('CR_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- PAYMENT METHODS (ວິທີຊໍາລະເງິນ)
-- =============================================

CREATE TABLE `payment_methods` (
  `id` int(11) NOT NULL,
  `PM_id` varchar(30) NOT NULL COMMENT 'Payment Method ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `method_name` varchar(100) NOT NULL COMMENT 'เงินสด, โอนเงิน, บัตรเครดิต',
  `method_code` varchar(20) DEFAULT NULL,
  `account_name` varchar(150) DEFAULT NULL COMMENT 'ชื่อบัญชี',
  `account_number` varchar(50) DEFAULT NULL COMMENT 'เลขบัญชี',
  `bank_name` varchar(100) DEFAULT NULL COMMENT 'ชื่อธนาคาร',
  `qr_code` varchar(255) DEFAULT NULL COMMENT 'รูป QR Code',
  `instructions` text DEFAULT NULL COMMENT 'คำแนะนำการชำระ',
  `fee_percent` decimal(5,2) DEFAULT 0.00 COMMENT 'ค่าธรรมเนียม %',
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_payment_methods_before_insert` BEFORE INSERT ON `payment_methods` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 15;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 15;
    SET NEW.PM_id = CONCAT('PM_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- ORDERS (ອໍເດີ້)
-- =============================================

CREATE TABLE `orders` (
  `id` int(11) NOT NULL,
  `OR_id` varchar(30) NOT NULL COMMENT 'Order ID เช่น OR_1736290000123',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `order_code` varchar(30) DEFAULT NULL COMMENT 'รหัสออเดอร์ที่ร้านกำหนด',
  `customer_id` int(11) DEFAULT NULL COMMENT 'FK → customers.id',
  `order_date` datetime NOT NULL DEFAULT current_timestamp(),
  `order_type` enum('pos','online','wholesale') DEFAULT 'pos',
  `order_status` enum('pending','confirmed','processing','shipped','delivered','cancelled','refunded') DEFAULT 'pending',
  `payment_status` enum('pending','partial','paid','refunded') DEFAULT 'pending',
  `payment_method_id` int(11) DEFAULT NULL COMMENT 'FK → payment_methods.id',
  `currency_id` int(11) DEFAULT NULL COMMENT 'FK → currencies.id',
  `shipping_company_id` int(11) DEFAULT NULL COMMENT 'FK → shipping_companies.id',
  `shipping_branch_id` int(11) DEFAULT NULL COMMENT 'FK → shipping_branches.id',
  `shipping_code` varchar(100) DEFAULT NULL COMMENT 'เลข tracking',
  `subtotal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `discount_amount` decimal(12,2) DEFAULT 0.00,
  `discount_percent` decimal(5,2) DEFAULT 0.00,
  `shipping_fee` decimal(12,2) DEFAULT 0.00,
  `tax_amount` decimal(12,2) DEFAULT 0.00,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deposit_amount` decimal(12,2) DEFAULT 0.00 COMMENT 'เงินมัดจำ',
  `cash_received` decimal(12,2) DEFAULT NULL,
  `cash_change` decimal(12,2) DEFAULT NULL,
  `cod_amount` decimal(12,2) DEFAULT NULL COMMENT 'ยอด COD',
  `notes` text DEFAULT NULL,
  `internal_notes` text DEFAULT NULL COMMENT 'หมายเหตุภายใน',
  `printed_count` int(11) DEFAULT 0 COMMENT 'จำนวนครั้งที่พิมพ์',
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_orders_before_insert` BEFORE INSERT ON `orders` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 6;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 6;
    SET NEW.OR_id = CONCAT('OR_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- ORDER ITEMS (ລາຍການສິນຄ້າໃນອໍເດີ້)
-- =============================================

CREATE TABLE `order_items` (
  `id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL COMMENT 'FK → orders.id',
  `product_id` int(11) NOT NULL COMMENT 'FK → products.id',
  `product_name` varchar(255) DEFAULT NULL COMMENT 'ชื่อสินค้า ณ ตอนขาย',
  `quantity` decimal(10,2) NOT NULL,
  `unit_price` decimal(12,2) NOT NULL COMMENT 'ราคาต่อหน่วย',
  `discount_amount` decimal(12,2) DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- EXPENSES (ລາຍຈ່າຍ)
-- =============================================

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL,
  `EX_id` varchar(30) NOT NULL COMMENT 'Expense ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `expense_code` varchar(20) DEFAULT NULL,
  `expense_date` date NOT NULL,
  `category` varchar(100) DEFAULT NULL COMMENT 'หมวดหมู่ค่าใช้จ่าย',
  `description` text DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `currency_id` int(11) DEFAULT NULL COMMENT 'FK → currencies.id',
  `payment_method_id` int(11) DEFAULT NULL COMMENT 'FK → payment_methods.id',
  `receipt_image` varchar(255) DEFAULT NULL COMMENT 'รูปใบเสร็จ',
  `is_recurring` tinyint(1) DEFAULT 0,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_expenses_before_insert` BEFORE INSERT ON `expenses` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 7;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 7;
    SET NEW.EX_id = CONCAT('EX_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- OTHER INCOME (ລາຍຮັບອື່ນໆ)
-- =============================================

CREATE TABLE `other_income` (
  `id` int(11) NOT NULL,
  `IN_id` varchar(30) NOT NULL COMMENT 'Income ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `income_code` varchar(20) DEFAULT NULL,
  `income_date` date NOT NULL,
  `category` varchar(100) DEFAULT NULL COMMENT 'หมวดหมู่รายรับ',
  `description` text DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `currency_id` int(11) DEFAULT NULL COMMENT 'FK → currencies.id',
  `payment_method_id` int(11) DEFAULT NULL COMMENT 'FK → payment_methods.id',
  `receipt_image` varchar(255) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_other_income_before_insert` BEFORE INSERT ON `other_income` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 8;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 8;
    SET NEW.IN_id = CONCAT('IN_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- PURCHASE ORDERS (ໃບສັ່ງຊື້ສິນຄ້າ)
-- =============================================

CREATE TABLE `purchase_orders` (
  `id` int(11) NOT NULL,
  `PO_id` varchar(30) NOT NULL COMMENT 'Purchase Order ID',
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `order_code` varchar(30) DEFAULT NULL,
  `order_date` date NOT NULL,
  `supplier_name` varchar(150) DEFAULT NULL,
  `supplier_phone` varchar(20) DEFAULT NULL,
  `supplier_address` text DEFAULT NULL,
  `status` enum('draft','pending','ordered','partial','received','cancelled') DEFAULT 'draft',
  `expected_date` date DEFAULT NULL COMMENT 'วันที่คาดว่าจะได้รับ',
  `received_date` date DEFAULT NULL COMMENT 'วันที่ได้รับจริง',
  `subtotal` decimal(12,2) DEFAULT 0.00,
  `discount_amount` decimal(12,2) DEFAULT 0.00,
  `shipping_fee` decimal(12,2) DEFAULT 0.00,
  `total_amount` decimal(12,2) DEFAULT 0.00,
  `currency_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DELIMITER $$
CREATE TRIGGER `trg_purchase_orders_before_insert` BEFORE INSERT ON `purchase_orders` FOR EACH ROW
BEGIN
    DECLARE v_time BIGINT;
    DECLARE v_seq BIGINT;
    SET v_time = FLOOR(UNIX_TIMESTAMP(NOW(3)) * 1000);
    UPDATE sys_seq SET seq = seq + 1 WHERE id = 13;
    SELECT seq INTO v_seq FROM sys_seq WHERE id = 13;
    SET NEW.PO_id = CONCAT('PO_', v_time + (v_seq MOD 1000));
END$$
DELIMITER ;

-- =============================================
-- PURCHASE ORDER ITEMS (ລາຍການໃບສັ່ງຊື້)
-- =============================================

CREATE TABLE `purchase_order_items` (
  `id` int(11) NOT NULL,
  `purchase_order_id` int(11) NOT NULL COMMENT 'FK → purchase_orders.id',
  `product_id` int(11) DEFAULT NULL COMMENT 'FK → products.id',
  `product_name` varchar(255) DEFAULT NULL,
  `quantity_ordered` decimal(10,2) NOT NULL,
  `quantity_received` decimal(10,2) DEFAULT 0.00,
  `unit_price` decimal(12,2) NOT NULL,
  `total` decimal(12,2) NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- UNLOCK DELETE (ລະຫັດປົດລ໋ອກລົບ)
-- =============================================

CREATE TABLE `unlock_delete` (
  `id` int(11) NOT NULL,
  `shop_id` int(11) NOT NULL COMMENT 'FK → shops.id',
  `password_hash` varchar(255) NOT NULL COMMENT 'รหัสผ่านสำหรับปลดล็อค',
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =============================================
-- INDEXES
-- =============================================

-- units
ALTER TABLE `units`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `UN_id` (`UN_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `idx_updated_by` (`updated_by`),
  ADD KEY `idx_deleted_by` (`deleted_by`);

-- colors
ALTER TABLE `colors`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `CO_id` (`CO_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_created_by` (`created_by`);

-- product_categories
ALTER TABLE `product_categories`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `CA_id` (`CA_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_parent_id` (`parent_id`),
  ADD KEY `idx_created_by` (`created_by`);

-- products
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `PR_id` (`PR_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_category_id` (`category_id`),
  ADD KEY `idx_unit_id` (`unit_id`),
  ADD KEY `idx_color_id` (`color_id`),
  ADD KEY `idx_barcode` (`barcode`),
  ADD KEY `idx_product_code` (`product_code`),
  ADD KEY `idx_created_by` (`created_by`);

-- customers
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `CU_id` (`CU_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_phone` (`phone`),
  ADD KEY `idx_email` (`email`),
  ADD KEY `idx_created_by` (`created_by`);

-- shipping_companies
ALTER TABLE `shipping_companies`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `SC_id` (`SC_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_created_by` (`created_by`);

-- shipping_branches
ALTER TABLE `shipping_branches`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `SB_id` (`SB_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_company_id` (`company_id`),
  ADD KEY `idx_created_by` (`created_by`);

-- currencies
ALTER TABLE `currencies`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `CR_id` (`CR_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_currency_code` (`currency_code`),
  ADD KEY `idx_created_by` (`created_by`);

-- payment_methods
ALTER TABLE `payment_methods`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `PM_id` (`PM_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_created_by` (`created_by`);

-- orders
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `OR_id` (`OR_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_customer_id` (`customer_id`),
  ADD KEY `idx_order_date` (`order_date`),
  ADD KEY `idx_order_status` (`order_status`),
  ADD KEY `idx_payment_status` (`payment_status`),
  ADD KEY `idx_payment_method_id` (`payment_method_id`),
  ADD KEY `idx_shipping_company_id` (`shipping_company_id`),
  ADD KEY `idx_created_by` (`created_by`);

-- order_items
ALTER TABLE `order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_order_id` (`order_id`),
  ADD KEY `idx_product_id` (`product_id`);

-- expenses
ALTER TABLE `expenses`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `EX_id` (`EX_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_expense_date` (`expense_date`),
  ADD KEY `idx_created_by` (`created_by`);

-- other_income
ALTER TABLE `other_income`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `IN_id` (`IN_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_income_date` (`income_date`),
  ADD KEY `idx_created_by` (`created_by`);

-- purchase_orders
ALTER TABLE `purchase_orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `PO_id` (`PO_id`),
  ADD KEY `idx_shop_id` (`shop_id`),
  ADD KEY `idx_order_date` (`order_date`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_created_by` (`created_by`);

-- purchase_order_items
ALTER TABLE `purchase_order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_purchase_order_id` (`purchase_order_id`),
  ADD KEY `idx_product_id` (`product_id`);

-- unlock_delete
ALTER TABLE `unlock_delete`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_shop_id` (`shop_id`);

-- =============================================
-- AUTO_INCREMENT
-- =============================================

ALTER TABLE `units` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `colors` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `product_categories` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `products` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `customers` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `shipping_companies` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `shipping_branches` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `currencies` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `payment_methods` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `orders` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `order_items` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `expenses` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `other_income` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `purchase_orders` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `purchase_order_items` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `unlock_delete` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

-- =============================================
-- FOREIGN KEY CONSTRAINTS
-- =============================================

-- units
ALTER TABLE `units`
  ADD CONSTRAINT `fk_units_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_units_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_units_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_units_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- colors
ALTER TABLE `colors`
  ADD CONSTRAINT `fk_colors_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_colors_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_colors_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_colors_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- product_categories
ALTER TABLE `product_categories`
  ADD CONSTRAINT `fk_categories_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_categories_parent` FOREIGN KEY (`parent_id`) REFERENCES `product_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_categories_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_categories_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_categories_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- products
ALTER TABLE `products`
  ADD CONSTRAINT `fk_products_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_products_category` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_products_unit` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_products_color` FOREIGN KEY (`color_id`) REFERENCES `colors` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_products_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_products_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_products_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- customers
ALTER TABLE `customers`
  ADD CONSTRAINT `fk_customers_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_customers_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_customers_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_customers_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- shipping_companies
ALTER TABLE `shipping_companies`
  ADD CONSTRAINT `fk_shipping_companies_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_shipping_companies_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_shipping_companies_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_shipping_companies_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- shipping_branches
ALTER TABLE `shipping_branches`
  ADD CONSTRAINT `fk_shipping_branches_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_shipping_branches_company` FOREIGN KEY (`company_id`) REFERENCES `shipping_companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_shipping_branches_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_shipping_branches_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_shipping_branches_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- currencies
ALTER TABLE `currencies`
  ADD CONSTRAINT `fk_currencies_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_currencies_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_currencies_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_currencies_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- payment_methods
ALTER TABLE `payment_methods`
  ADD CONSTRAINT `fk_payment_methods_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_payment_methods_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_payment_methods_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_payment_methods_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- orders
ALTER TABLE `orders`
  ADD CONSTRAINT `fk_orders_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_orders_customer` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_orders_payment_method` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_orders_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_orders_shipping_company` FOREIGN KEY (`shipping_company_id`) REFERENCES `shipping_companies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_orders_shipping_branch` FOREIGN KEY (`shipping_branch_id`) REFERENCES `shipping_branches` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_orders_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_orders_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_orders_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- order_items
ALTER TABLE `order_items`
  ADD CONSTRAINT `fk_order_items_order` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_order_items_product` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE;

-- expenses
ALTER TABLE `expenses`
  ADD CONSTRAINT `fk_expenses_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_expenses_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_expenses_payment_method` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_expenses_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_expenses_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_expenses_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- other_income
ALTER TABLE `other_income`
  ADD CONSTRAINT `fk_other_income_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_other_income_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_other_income_payment_method` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_other_income_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_other_income_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_other_income_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- purchase_orders
ALTER TABLE `purchase_orders`
  ADD CONSTRAINT `fk_purchase_orders_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_purchase_orders_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_purchase_orders_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_purchase_orders_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_purchase_orders_deleted_by` FOREIGN KEY (`deleted_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- purchase_order_items
ALTER TABLE `purchase_order_items`
  ADD CONSTRAINT `fk_po_items_purchase_order` FOREIGN KEY (`purchase_order_id`) REFERENCES `purchase_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_po_items_product` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- unlock_delete
ALTER TABLE `unlock_delete`
  ADD CONSTRAINT `fk_unlock_delete_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_unlock_delete_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_unlock_delete_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
