<?php
$page_title = 'ຈັດການผູ້ໃຊ້';

// Handle AJAX requests BEFORE any HTML output
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    @ob_end_clean();
    @ini_set('display_errors', 0);
    @error_reporting(0);
    if (session_status() === PHP_SESSION_NONE)
        @session_start();

    // Try multiple paths for database connection
    $db_paths = [__DIR__ . '/../includes/con_database.php', dirname(__FILE__) . '/../includes/con_database.php', $_SERVER['DOCUMENT_ROOT'] . '/epcommerce/includes/con_database.php'];
    foreach ($db_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            break;
        }
    }

    header('Content-Type: application/json');

    $shop_id = $_SESSION['shop_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;
    $action = $_POST['action'] ?? '';

    if (!$shop_id) {
        echo json_encode(['success' => false, 'message' => 'ກະລຸນາເລືອກຮ້ານກ່ອນ']);
        exit;
    }

    if ($action === 'add') {
        $pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO users (username, email, password, first_name, last_name, phone, role_id, shop_id, parent_user_id, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'active')");
        $stmt->bind_param("ssssssiis", $_POST['username'], $_POST['email'], $pass, $_POST['first_name'], $_POST['last_name'], $_POST['phone'], $_POST['role_id'], $shop_id, $user_id);
        echo json_encode(['success' => $stmt->execute(), 'message' => $stmt->error ?: 'ເພີ່ມສຳເລັດ']);
        exit;
    }

    if ($action === 'edit') {
        $sql = "UPDATE users SET first_name = ?, last_name = ?, phone = ?, role_id = ?";
        $params = [$_POST['first_name'], $_POST['last_name'], $_POST['phone'], $_POST['role_id']];
        $types = "sssi";

        if (!empty($_POST['password'])) {
            $sql .= ", password = ?";
            $params[] = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $types .= "s";
        }

        $sql .= " WHERE id = ? AND shop_id = ?";
        $params[] = $_POST['id'];
        $params[] = $shop_id;
        $types .= "ii";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param($types, ...$params);
        echo json_encode(['success' => $stmt->execute(), 'message' => 'ແກ້ໄຂສຳເລັດ']);
        exit;
    }

    if ($action === 'toggle') {
        $stmt = $conn->prepare("UPDATE users SET status = IF(status='active','inactive','active') WHERE id = ? AND shop_id = ?");
        $stmt->bind_param("ii", $_POST['id'], $shop_id);
        echo json_encode(['success' => $stmt->execute()]);
        exit;
    }

    if ($action === 'delete') {
        $stmt = $conn->prepare("UPDATE users SET deleted_at = NOW() WHERE id = ? AND shop_id = ? AND id != ?");
        $stmt->bind_param("iii", $_POST['id'], $shop_id, $user_id);
        echo json_encode(['success' => $stmt->execute(), 'message' => 'ລຶບສຳເລັດ']);
        exit;
    }
}

require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;

$users = $roles = [];
if ($shop_id) {
    $stmt = $conn->prepare("SELECT u.*, r.role_name FROM users u JOIN user_roles r ON u.role_id = r.id WHERE u.shop_id = ? AND u.deleted_at IS NULL ORDER BY u.created_at DESC");
    $stmt->bind_param("i", $shop_id);
    $stmt->execute();
    $users = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

    $roles = $conn->query("SELECT id, role_name, role_code FROM user_roles WHERE role_code IN ('admin', 'staff') ORDER BY id")->fetch_all(MYSQLI_ASSOC);
}
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 24px
    }

    .mini-stat {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 20px;
        display: flex;
        align-items: center;
        gap: 16px
    }

    .mini-stat .icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: #fff;
        background: linear-gradient(135deg, #6f42c1, #5a32a3)
    }

    .mini-stat .info h3 {
        font-size: 24px;
        margin: 0
    }

    .mini-stat .info p {
        color: var(--text-secondary);
        margin: 0;
        font-size: 13px
    }

    .users-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
        gap: 20px
    }

    .user-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 24px;
        transition: all .3s
    }

    .user-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 10px 30px rgba(0, 0, 0, .15)
    }

    .user-header {
        display: flex;
        align-items: center;
        gap: 16px;
        margin-bottom: 16px
    }

    .user-avatar {
        width: 56px;
        height: 56px;
        border-radius: 50%;
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-weight: 600;
        font-size: 20px
    }

    .user-info h4 {
        margin: 0 0 4px;
        font-size: 16px
    }

    .user-info p {
        margin: 0;
        color: var(--text-secondary);
        font-size: 13px
    }

    .user-meta {
        display: flex;
        flex-direction: column;
        gap: 8px;
        margin-bottom: 16px;
        padding: 12px;
        background: var(--input-bg);
        border-radius: 10px;
        font-size: 13px
    }

    .user-meta div {
        display: flex;
        justify-content: space-between
    }

    .user-meta span {
        color: var(--text-secondary)
    }

    .user-meta strong {
        color: var(--text-primary)
    }

    .role-badge {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600
    }

    .role-badge.admin {
        background: rgba(111, 66, 193, .15);
        color: #6f42c1
    }

    .role-badge.staff {
        background: rgba(23, 162, 184, .15);
        color: #17a2b8
    }

    .status-badge {
        padding: 4px 10px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600
    }

    .status-badge.active {
        background: rgba(40, 167, 69, .15);
        color: #28a745
    }

    .status-badge.inactive {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .user-actions {
        display: flex;
        gap: 8px
    }

    .btn-icon {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all .2s;
        font-size: 14px
    }

    .btn-icon.edit {
        background: rgba(255, 193, 7, .15);
        color: #ffc107
    }

    .btn-icon.edit:hover {
        background: #ffc107;
        color: #000
    }

    .btn-icon.delete {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .btn-icon.delete:hover {
        background: #dc3545;
        color: #fff
    }

    .btn-icon.toggle {
        background: rgba(40, 167, 69, .15);
        color: #28a745
    }

    .btn-icon.toggle:hover {
        background: #28a745;
        color: #fff
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        font-size: 14px
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff
    }

    .pro-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, .6);
        backdrop-filter: blur(4px);
        z-index: 9999;
        align-items: center;
        justify-content: center;
        padding: 20px
    }

    .pro-modal.show {
        display: flex
    }

    .pro-modal-content {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 20px;
        width: 100%;
        max-width: 500px;
        animation: modalSlide .3s ease
    }

    @keyframes modalSlide {
        from {
            opacity: 0;
            transform: translateY(-20px)
        }

        to {
            opacity: 1;
            transform: translateY(0)
        }
    }

    .pro-modal-header {
        padding: 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .pro-modal-header h3 {
        margin: 0;
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .pro-modal-header h3 i {
        color: var(--accent)
    }

    .pro-modal-close {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: none;
        background: rgba(255, 255, 255, .1);
        color: var(--text-secondary);
        cursor: pointer;
        font-size: 18px
    }

    .pro-modal-body {
        padding: 24px
    }

    .pro-modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--border-color);
        display: flex;
        gap: 12px;
        justify-content: flex-end
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 16px
    }

    .form-pro-group {
        margin-bottom: 20px
    }

    .form-pro-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500
    }

    .form-pro-group label span {
        color: #dc3545
    }

    .form-pro-input {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 15px
    }

    .form-pro-input:focus {
        outline: none;
        border-color: var(--accent)
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 64px;
        opacity: .3;
        margin-bottom: 20px
    }

    @media(max-width:768px) {
        .page-header {
            flex-direction: column;
            align-items: flex-start
        }

        .users-grid {
            grid-template-columns: 1fr
        }

        .form-row {
            grid-template-columns: 1fr
        }
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state"><i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
    </div>
<?php else: ?>

    <div class="page-header">
        <h1><i class="fas fa-user-cog"></i> ຈัดການผູ້ໃຊ້</h1>
        <button class="btn-pro primary" onclick="openModal('add')"><i class="fas fa-plus"></i> ເພີ່ມຜູ້ໃຊ້ໃໝ່</button>
    </div>

    <div class="stats-row">
        <div class="mini-stat">
            <div class="icon"><i class="fas fa-users"></i></div>
            <div class="info">
                <h3><?= count($users) ?></h3>
                <p>ຜູ້ໃຊ້ທັງໝົດ</p>
            </div>
        </div>
    </div>

    <?php if (empty($users)): ?>
        <div class="empty-state"><i class="fas fa-users-slash"></i>
            <h4>ຍັງບໍ່ມີຜູ້ໃຊ້</h4>
        </div>
    <?php else: ?>
        <div class="users-grid">
            <?php foreach ($users as $u): ?>
                <div class="user-card">
                    <div class="user-header">
                        <div class="user-avatar"><?= strtoupper(substr($u['first_name'] ?: $u['username'], 0, 1)) ?></div>
                        <div class="user-info">
                            <h4><?= htmlspecialchars($u['first_name'] . ' ' . $u['last_name']) ?: $u['username'] ?></h4>
                            <p>@<?= $u['username'] ?></p>
                        </div>
                    </div>

                    <div class="user-meta">
                        <div><span>ລະຫັດ</span><strong><?= $u['US_id'] ?></strong></div>
                        <div><span>ອີເມວ</span><strong><?= $u['email'] ?></strong></div>
                        <div><span>ບົດບາດ</span><span
                                class="role-badge <?= $u['role_name'] == 'Admin' ? 'admin' : 'staff' ?>"><?= $u['role_name'] ?></span>
                        </div>
                        <div><span>ສະຖານະ</span><span
                                class="status-badge <?= $u['status'] ?>"><?= $u['status'] == 'active' ? 'ໃຊ້ງານ' : 'ປິດ' ?></span>
                        </div>
                    </div>

                    <div class="user-actions">
                        <button class="btn-icon toggle" onclick="toggleUser(<?= $u['id'] ?>)" title="ເປິດ/ປິດ"><i
                                class="fas fa-power-off"></i></button>
                        <button class="btn-icon edit" onclick="openModal('edit', <?= htmlspecialchars(json_encode($u)) ?>)"
                            title="ແກ້ໄຂ"><i class="fas fa-pen"></i></button>
                        <?php if ($u['id'] != $user_id): ?>
                            <button class="btn-icon delete"
                                onclick="confirmDelete(<?= $u['id'] ?>, '<?= htmlspecialchars($u['username']) ?>')" title="ລຶບ"><i
                                    class="fas fa-trash"></i></button>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="pro-modal" id="formModal">
        <div class="pro-modal-content">
            <div class="pro-modal-header">
                <h3><i class="fas fa-user"></i> <span id="modalTitle">ເພີ່ມຜູ້ໃຊ້</span></h3>
                <button class="pro-modal-close" onclick="closeModal()">&times;</button>
            </div>
            <form id="dataForm">
                <div class="pro-modal-body">
                    <input type="hidden" name="action" id="formAction" value="add">
                    <input type="hidden" name="id" id="formId">

                    <div class="form-row">
                        <div class="form-pro-group"><label>Username <span>*</span></label><input type="text" name="username"
                                id="username" class="form-pro-input" required></div>
                        <div class="form-pro-group"><label>Email <span>*</span></label><input type="email" name="email"
                                id="email" class="form-pro-input" required></div>
                    </div>

                    <div class="form-row">
                        <div class="form-pro-group"><label>ຊື່</label><input type="text" name="first_name" id="first_name"
                                class="form-pro-input"></div>
                        <div class="form-pro-group"><label>ນາມສະກຸນ</label><input type="text" name="last_name"
                                id="last_name" class="form-pro-input"></div>
                    </div>

                    <div class="form-row">
                        <div class="form-pro-group"><label>ເບີໂທ</label><input type="text" name="phone" id="phone"
                                class="form-pro-input"></div>
                        <div class="form-pro-group"><label>ບົດບາດ <span>*</span></label>
                            <select name="role_id" id="role_id" class="form-pro-input" required>
                                <?php foreach ($roles as $r): ?>
                                    <option value="<?= $r['id'] ?>"><?= $r['role_name'] ?></option><?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-pro-group"><label>Password <span id="passReq">*</span></label><input type="password"
                            name="password" id="password" class="form-pro-input" minlength="6"></div>
                </div>
                <div class="pro-modal-footer">
                    <button type="button" class="btn-pro" style="background:var(--border-color);color:var(--text-primary)"
                        onclick="closeModal()">ຍົກເລີກ</button>
                    <button type="submit" class="btn-pro primary"><i class="fas fa-save"></i> ບັນທຶກ</button>
                </div>
            </form>
        </div>
    </div>

<?php endif; ?>
<?php require_once 'includes/footer.php'; ?>

<?php if ($shop_id): ?>
    <script>
        function openModal(mode, data = null) {
            const passField = document.getElementById('password');
            const passReq = document.getElementById('passReq');
            document.getElementById('dataForm').reset();
            document.getElementById('formId').value = '';

            if (mode === 'add') {
                document.getElementById('modalTitle').textContent = 'ເພີ່ມຜູ້ໃຊ້ໃໝ່';
                document.getElementById('formAction').value = 'add';
                document.getElementById('username').readOnly = false;
                document.getElementById('email').readOnly = false;
                passField.required = true;
                passReq.style.display = '';
            } else {
                document.getElementById('modalTitle').textContent = 'ແກ້ໄຂຜູ້ໃຊ້';
                document.getElementById('formAction').value = 'edit';
                document.getElementById('formId').value = data.id;
                document.getElementById('username').value = data.username;
                document.getElementById('username').readOnly = true;
                document.getElementById('email').value = data.email;
                document.getElementById('email').readOnly = true;
                document.getElementById('first_name').value = data.first_name || '';
                document.getElementById('last_name').value = data.last_name || '';
                document.getElementById('phone').value = data.phone || '';
                document.getElementById('role_id').value = data.role_id;
                passField.required = false;
                passReq.style.display = 'none';
            }
            document.getElementById('formModal').classList.add('show');
        }

        function closeModal() { document.getElementById('formModal').classList.remove('show'); }
        document.getElementById('formModal').addEventListener('click', function (e) { if (e.target === this) closeModal(); });

        document.getElementById('dataForm').addEventListener('submit', async function (e) {
            e.preventDefault();
            closeModal();
            Swal.fire({ title: 'ກຳລັງບັນທຶກ...', text: 'ກະລຸນາລໍຖ້າ', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
            try {
                const response = await fetch('users.php', { method: 'POST', body: new FormData(this) });
                const data = await response.json();
                if (data.success) {
                    await Swal.fire({ icon: 'success', title: 'ສຳເລັດ!', timer: 1500, timerProgressBar: true, showConfirmButton: false });
                    location.reload();
                } else {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                }
            } catch (error) {
                Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
            }
        });

        async function toggleUser(id) {
            Swal.fire({ title: 'ກຳລັງອັບເດດ...', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
            const fd = new FormData(); fd.append('action', 'toggle'); fd.append('id', id);
            await fetch('users.php', { method: 'POST', body: fd });
            location.reload();
        }

        async function confirmDelete(id, name) {
            const result = await Swal.fire({
                title: 'ຢືນຢັນການລຶບ?', html: `ລຶບ <strong>"${name}"</strong> ແທ້ບໍ?`, icon: 'warning',
                showCancelButton: true, confirmButtonColor: '#dc3545', confirmButtonText: '<i class="fas fa-trash"></i> ລຶບ', cancelButtonText: 'ຍົກເລີກ', reverseButtons: true
            });
            if (result.isConfirmed) {
                Swal.fire({ title: 'ກຳລັງລຶບ...', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
                try {
                    const fd = new FormData(); fd.append('action', 'delete'); fd.append('id', id);
                    const response = await fetch('users.php', { method: 'POST', body: fd });
                    const data = await response.json();
                    if (data.success) {
                        await Swal.fire({ icon: 'success', title: 'ລຶບສຳເລັດ!', timer: 1500, showConfirmButton: false });
                        location.reload();
                    } else {
                        Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                    }
                } catch (error) {
                    Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
                }
            }
        }
    </script>
<?php endif; ?>