<?php
$page_title = 'ຫົວໜ່ວຍສິນຄ້າ';

// Handle AJAX requests BEFORE any HTML output
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    @ob_end_clean();
    @ini_set('display_errors', 0);
    @error_reporting(0);
    if (session_status() === PHP_SESSION_NONE)
        @session_start();

    // Try multiple paths for database connection
    $db_paths = [__DIR__ . '/../includes/con_database.php', dirname(__FILE__) . '/../includes/con_database.php', $_SERVER['DOCUMENT_ROOT'] . '/epcommerce/includes/con_database.php'];
    foreach ($db_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            break;
        }
    }
    require_once __DIR__ . '/../includes/secondary_ids.php';

    header('Content-Type: application/json');

    $shop_id = $_SESSION['shop_id'] ?? null;
    $user_id = $_SESSION['user_id'] ?? null;
    $user_secondary_id = getUserSecondaryId($conn, $user_id);
    $action = $_POST['action'] ?? '';

    if (!$shop_id) {
        echo json_encode(['success' => false, 'message' => 'ກະລຸນາເລືອກຮ້ານກ່ອນ']);
        exit;
    }

    try {
        if ($action === 'add') {
            $stmt = $conn->prepare("INSERT INTO units (shop_id, unit_name, unit_code, description, created_by) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("issss", $shop_id, $_POST['unit_name'], $_POST['unit_code'], $_POST['description'], $user_secondary_id);
            if ($stmt->execute()) {
                echo json_encode(['success' => true, 'message' => 'ເພີ່ມຫົວໜ່ວຍສຳເລັດ']);
            } else {
                echo json_encode(['success' => false, 'message' => $stmt->error]);
            }
            exit;
        }

        if ($action === 'edit') {
            $stmt = $conn->prepare("UPDATE units SET unit_name = ?, unit_code = ?, description = ?, updated_by = ? WHERE id = ? AND shop_id = ?");
            $stmt->bind_param("ssssii", $_POST['unit_name'], $_POST['unit_code'], $_POST['description'], $user_secondary_id, $_POST['id'], $shop_id);
            if ($stmt->execute()) {
                echo json_encode(['success' => true, 'message' => 'ແກ້ໄຂສຳເລັດ']);
            } else {
                echo json_encode(['success' => false, 'message' => $stmt->error]);
            }
            exit;
        }

        if ($action === 'delete') {
            $stmt = $conn->prepare("UPDATE units SET deleted_at = NOW(), deleted_by = ? WHERE id = ? AND shop_id = ?");
            $stmt->bind_param("sii", $user_secondary_id, $_POST['id'], $shop_id);
            if ($stmt->execute()) {
                echo json_encode(['success' => true, 'message' => 'ລຶບສຳເລັດ']);
            } else {
                echo json_encode(['success' => false, 'message' => $stmt->error]);
            }
            exit;
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        exit;
    }
}

require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;

// Fetch units
$units = [];
if ($shop_id) {
    $stmt = $conn->prepare("SELECT * FROM units WHERE shop_id = ? AND deleted_at IS NULL ORDER BY created_at ASC");
    $stmt->bind_param("i", $shop_id);
    $stmt->execute();
    $units = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>

<style>
    /* Page Header */
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    /* Stats */
    .stats-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 24px
    }

    .mini-stat {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        padding: 20px;
        display: flex;
        align-items: center;
        gap: 16px
    }

    .mini-stat .icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: #fff
    }

    .mini-stat .icon.blue {
        background: linear-gradient(135deg, #4A90D9, #2D5A87)
    }

    .mini-stat .icon.green {
        background: linear-gradient(135deg, #28a745, #1e7e34)
    }

    .mini-stat .info h3 {
        font-size: 24px;
        margin: 0
    }

    .mini-stat .info p {
        color: var(--text-secondary);
        margin: 0;
        font-size: 13px
    }

    /* Data Card */
    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden
    }

    .data-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 16px
    }

    .data-card-header h3 {
        font-size: 18px;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .search-box {
        display: flex;
        align-items: center;
        gap: 8px;
        background: var(--input-bg);
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 8px 12px;
        width: 250px;
        max-width: 100%
    }

    .search-box input {
        border: none;
        background: transparent;
        outline: none;
        color: var(--text-primary);
        width: 100%;
        font-size: 14px
    }

    .search-box i {
        color: var(--text-secondary)
    }

    /* Pro Table */
    .pro-table {
        width: 100%;
        border-collapse: collapse
    }

    .pro-table th {
        background: rgba(var(--accent-rgb), 0.1);
        padding: 14px 16px;
        text-align: left;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: .5px;
        color: var(--text-secondary);
        white-space: nowrap
    }

    .pro-table td {
        padding: 16px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle
    }

    .pro-table tbody tr:hover {
        background: rgba(var(--accent-rgb), 0.05)
    }

    .pro-table tbody tr:last-child td {
        border-bottom: none
    }

    /* Badges */
    .badge-pro {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600
    }

    .badge-pro.success {
        background: rgba(40, 167, 69, .15);
        color: #28a745
    }

    .badge-pro.danger {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .code-badge {
        background: rgba(var(--accent-rgb), 0.1);
        color: var(--accent);
        padding: 4px 10px;
        border-radius: 6px;
        font-family: 'Monaco', monospace;
        font-size: 12px
    }

    /* Action Buttons */
    .action-btns {
        display: flex;
        gap: 8px
    }

    .btn-icon {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all .2s;
        font-size: 14px
    }

    .btn-icon.edit {
        background: rgba(255, 193, 7, .15);
        color: #ffc107
    }

    .btn-icon.edit:hover {
        background: #ffc107;
        color: #000
    }

    .btn-icon.delete {
        background: rgba(220, 53, 69, .15);
        color: #dc3545
    }

    .btn-icon.delete:hover {
        background: #dc3545;
        color: #fff
    }

    /* Pro Button */
    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        font-size: 14px
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    .btn-pro.primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(74, 144, 217, .4)
    }

    /* Pro Modal */
    .pro-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, .6);
        backdrop-filter: blur(4px);
        z-index: 9998;
        align-items: center;
        justify-content: center;
        padding: 20px
    }

    .pro-modal.show {
        display: flex
    }

    .pro-modal-content {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 20px;
        width: 100%;
        max-width: 480px;
        max-height: 90vh;
        overflow-y: auto;
        animation: modalSlide .3s ease
    }

    @keyframes modalSlide {
        from {
            opacity: 0;
            transform: translateY(-20px) scale(.95)
        }

        to {
            opacity: 1;
            transform: translateY(0) scale(1)
        }
    }

    .pro-modal-header {
        padding: 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .pro-modal-header h3 {
        margin: 0;
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .pro-modal-header h3 i {
        color: var(--accent)
    }

    .pro-modal-close {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: none;
        background: rgba(255, 255, 255, .1);
        color: var(--text-secondary);
        cursor: pointer;
        font-size: 18px;
        transition: all .2s
    }

    .pro-modal-close:hover {
        background: rgba(220, 53, 69, .2);
        color: #dc3545
    }

    .pro-modal-body {
        padding: 24px
    }

    .pro-modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--border-color);
        display: flex;
        gap: 12px;
        justify-content: flex-end
    }

    /* Form Styles */
    .form-pro-group {
        margin-bottom: 20px
    }

    .form-pro-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500;
        color: var(--text-primary)
    }

    .form-pro-group label span {
        color: #dc3545
    }

    .form-pro-input {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 15px;
        transition: all .2s
    }

    .form-pro-input:focus {
        outline: none;
        border-color: var(--accent);
        box-shadow: 0 0 0 4px rgba(74, 144, 217, .1)
    }

    .form-pro-input::placeholder {
        color: var(--text-secondary);
        opacity: .7
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 64px;
        opacity: .3;
        margin-bottom: 20px
    }

    .empty-state h4 {
        margin: 0 0 8px;
        font-size: 18px
    }

    .empty-state p {
        margin: 0;
        font-size: 14px
    }

    /* Mobile */
    @media(max-width:768px) {
        .page-header {
            flex-direction: column;
            align-items: flex-start
        }

        .search-box {
            width: 100%
        }

        .pro-table {
            display: block;
            overflow-x: auto
        }

        .action-btns {
            flex-wrap: wrap
        }
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state"><i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
        <p>ທ່ານຕ້ອງເຊື່ອມຕໍ່ກັບຮ້ານຄ້າກ່ອນຈຶ່ງສາມາດໃຊ້ງານໄດ້</p>
    </div>
<?php else: ?>

    <div class="page-header">
        <h1><i class="fas fa-balance-scale"></i> ຫົວໜ່ວຍສິນຄ້າ</h1>
        <button class="btn-pro primary" onclick="openModal('add')"><i class="fas fa-plus"></i> ເພີ່ມຫົວໜ່ວຍໃໝ່</button>
    </div>

    <div class="stats-row">
        <div class="mini-stat">
            <div class="icon blue"><i class="fas fa-cubes"></i></div>
            <div class="info">
                <h3><?= count($units) ?></h3>
                <p>ຫົວໜ່ວຍທັງໝົດ</p>
            </div>
        </div>
        <div class="mini-stat">
            <div class="icon green"><i class="fas fa-check-circle"></i></div>
            <div class="info">
                <h3><?= count(array_filter($units, fn($u) => $u['is_active'] ?? true)) ?></h3>
                <p>ກຳລັງໃຊ້ງານ</p>
            </div>
        </div>
    </div>

    <div class="data-card">
        <div class="data-card-header">
            <h3><i class="fas fa-list"></i> ລາຍການຫົວໜ່ວຍ</h3>
            <div class="search-box"><i class="fas fa-search"></i><input type="text" id="searchInput" placeholder="ຄົ້ນຫາ..."
                    onkeyup="filterTable()"></div>
        </div>

        <?php if (empty($units)): ?>
            <div class="empty-state"><i class="fas fa-inbox"></i>
                <h4>ຍັງບໍ່ມີຂໍ້ມູນ</h4>
                <p>ກົດປຸ່ມ "ເພີ່ມຫົວໜ່ວຍໃໝ່" ເພື່ອເລີ່ມຕົ້ນ</p>
            </div>
        <?php else: ?>
            <div style="overflow-x:auto">
                <table class="pro-table" id="dataTable">
                    <thead>
                        <tr>
                            <th style="width:50px">#</th>
                            <th>ລະຫັດ</th>
                            <th>ຊື່ຫົວໜ່ວຍ</th>
                            <th>ລະຫັດຫຍໍ້</th>
                            <th>ລາຍລະອຽດ</th>
                            <th>ສະຖານະ</th>
                            <th style="width:120px">ຈັດການ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($units as $i => $unit): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td><span class="code-badge"><?= htmlspecialchars($unit['UN_id'] ?? 'N/A') ?></span></td>
                                <td><strong><?= htmlspecialchars($unit['unit_name']) ?></strong></td>
                                <td><?= htmlspecialchars($unit['unit_code'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($unit['description'] ?? '-') ?></td>
                                <td><span class="badge-pro <?= ($unit['is_active'] ?? 1) ? 'success' : 'danger' ?>"><i
                                            class="fas fa-<?= ($unit['is_active'] ?? 1) ? 'check' : 'times' ?>-circle"></i>
                                        <?= ($unit['is_active'] ?? 1) ? 'ໃຊ້ງານ' : 'ປິດ' ?></span></td>
                                <td>
                                    <div class="action-btns">
                                        <button class="btn-icon edit" onclick='openModal("edit", <?= json_encode($unit) ?>)'
                                            title="ແກ້ໄຂ"><i class="fas fa-pen"></i></button>
                                        <button class="btn-icon delete"
                                            onclick="confirmDelete(<?= $unit['id'] ?>, '<?= htmlspecialchars(addslashes($unit['unit_name'])) ?>')"
                                            title="ລຶບ"><i class="fas fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <!-- Modal -->
    <div class="pro-modal" id="formModal">
        <div class="pro-modal-content">
            <div class="pro-modal-header">
                <h3><i class="fas fa-edit"></i> <span id="modalTitle">ເພີ່ມຫົວໜ່ວຍ</span></h3>
                <button class="pro-modal-close" onclick="closeModal()">&times;</button>
            </div>
            <form id="dataForm">
                <div class="pro-modal-body">
                    <input type="hidden" name="action" id="formAction" value="add">
                    <input type="hidden" name="id" id="formId">
                    <div class="form-pro-group">
                        <label>ຊື່ຫົວໜ່ວຍ <span>*</span></label>
                        <input type="text" name="unit_name" id="unit_name" class="form-pro-input"
                            placeholder="ເຊັ່ນ: ກ່ອງ, ອັນ, ກິໂລ" required>
                    </div>
                    <div class="form-pro-group">
                        <label>ລະຫັດຫຍໍ້</label>
                        <input type="text" name="unit_code" id="unit_code" class="form-pro-input"
                            placeholder="ເຊັ່ນ: BOX, PCS, KG">
                    </div>
                    <div class="form-pro-group">
                        <label>ລາຍລະອຽດ</label>
                        <textarea name="description" id="description" class="form-pro-input" rows="3"
                            placeholder="ລາຍລະອຽດເພີ່ມເຕີມ..."></textarea>
                    </div>
                </div>
                <div class="pro-modal-footer">
                    <button type="button" class="btn-pro" style="background:var(--border-color);color:var(--text-primary)"
                        onclick="closeModal()">ຍົກເລີກ</button>
                    <button type="submit" class="btn-pro primary" id="submitBtn"><i class="fas fa-save"></i> ບັນທຶກ</button>
                </div>
            </form>
        </div>
    </div>

<?php endif; ?>
<?php require_once 'includes/footer.php'; ?>

<?php if ($shop_id): ?>
    <script>
        // Modal Functions
        function openModal(mode, data = null) {
            const modal = document.getElementById('formModal');
            const title = document.getElementById('modalTitle');
            const form = document.getElementById('dataForm');

            form.reset();
            document.getElementById('formId').value = '';

            if (mode === 'add') {
                title.textContent = 'ເພີ່ມຫົວໜ່ວຍໃໝ່';
                document.getElementById('formAction').value = 'add';
            } else {
                title.textContent = 'ແກ້ໄຂຫົວໜ່ວຍ';
                document.getElementById('formAction').value = 'edit';
                document.getElementById('formId').value = data.id;
                document.getElementById('unit_name').value = data.unit_name || '';
                document.getElementById('unit_code').value = data.unit_code || '';
                document.getElementById('description').value = data.description || '';
            }
            modal.classList.add('show');
        }

        function closeModal() {
            document.getElementById('formModal').classList.remove('show');
        }

        // Close modal on outside click
        document.getElementById('formModal').addEventListener('click', function (e) {
            if (e.target === this) closeModal();
        });

        // Form Submit with improved UX
        document.getElementById('dataForm').addEventListener('submit', async function (e) {
            e.preventDefault();

            const submitBtn = document.getElementById('submitBtn');
            const originalText = submitBtn.innerHTML;

            // Close modal first
            closeModal();

            // Show loading with higher z-index
            Swal.fire({
                title: 'ກຳລັງບັນທຶກ...',
                text: 'ກະລຸນາລໍຖ້າ',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => Swal.showLoading()
            });

            try {
                const response = await fetch('units.php', {
                    method: 'POST',
                    body: new FormData(this)
                });

                const data = await response.json();

                if (data.success) {
                    await Swal.fire({
                        icon: 'success',
                        title: 'ສຳເລັດ!',
                        text: data.message,
                        timer: 1500,
                        timerProgressBar: true,
                        showConfirmButton: false
                    });
                    location.reload();
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'ເກີດຂໍ້ຜິດພາດ',
                        text: data.message || 'ບໍ່ສາມາດບັນທຶກໄດ້',
                        confirmButtonColor: 'var(--accent)'
                    });
                }
            } catch (error) {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'ເກີດຂໍ້ຜິດພາດ',
                    text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ ກະລຸນາລອງໃໝ່',
                    confirmButtonColor: 'var(--accent)'
                });
            }
        });

        // Confirm Delete with improved UX
        function confirmDelete(id, name) {
            Swal.fire({
                title: 'ຢືນຢັນການລຶບ?',
                html: `ທ່ານຕ້ອງການລຶບ <strong>"${name}"</strong> ແທ້ບໍ?<br><small style="color:#dc3545">ຂໍ້ມູນນີ້ຈະບໍ່ສາມາດກູ້ຄືນໄດ້</small>`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: '<i class="fas fa-trash"></i> ລຶບ',
                cancelButtonText: 'ຍົກເລີກ',
                reverseButtons: true
            }).then(async (result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: 'ກຳລັງລຶບ...',
                        allowOutsideClick: false,
                        showConfirmButton: false,
                        didOpen: () => Swal.showLoading()
                    });

                    try {
                        const fd = new FormData();
                        fd.append('action', 'delete');
                        fd.append('id', id);

                        const response = await fetch('units.php', { method: 'POST', body: fd });
                        const data = await response.json();

                        if (data.success) {
                            await Swal.fire({
                                icon: 'success',
                                title: 'ລຶບສຳເລັດ!',
                                timer: 1500,
                                timerProgressBar: true,
                                showConfirmButton: false
                            });
                            location.reload();
                        } else {
                            Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: data.message });
                        }
                    } catch (error) {
                        Swal.fire({ icon: 'error', title: 'ຜິດພາດ', text: 'ການເຊື່ອມຕໍ່ມີປັນຫາ' });
                    }
                }
            });
        }

        // Filter Table
        function filterTable() {
            const filter = document.getElementById('searchInput').value.toLowerCase();
            const rows = document.querySelectorAll('#dataTable tbody tr');
            rows.forEach(row => {
                row.style.display = row.textContent.toLowerCase().includes(filter) ? '' : 'none';
            });
        }
    </script>
<?php endif; ?>