<?php
$page_title = 'ເງິນ Tip (ເສດປັດ)';
require_once 'includes/header.php';

$shop_id = $_SESSION['shop_id'] ?? null;

// Get filter values
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : date('Y-m-01');
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : date('Y-m-d');
?>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px
    }

    .page-header h1 {
        font-size: 24px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 12px;
        margin: 0
    }

    .page-header h1 i {
        color: var(--accent)
    }

    /* Filter Card */
    .filter-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 20px;
        margin-bottom: 20px
    }

    .filter-row {
        display: flex;
        gap: 16px;
        flex-wrap: wrap;
        align-items: center
    }

    .date-input {
        padding: 12px 16px;
        border: 1px solid var(--border-color);
        border-radius: 10px;
        background: var(--input-bg);
        color: var(--text-primary);
        font-size: 16px
    }

    .btn-pro {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 14px 24px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        transition: all .3s;
        font-size: 16px
    }

    .btn-pro.primary {
        background: linear-gradient(135deg, var(--accent), var(--accent-soft));
        color: #fff;
        box-shadow: 0 4px 15px rgba(74, 144, 217, .3)
    }

    /* Summary Cards */
    .summary-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 24px
    }

    .summary-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        padding: 20px;
        text-align: center
    }

    .summary-card h3 {
        font-size: 14px;
        color: var(--text-secondary);
        margin: 0 0 8px 0;
        text-transform: uppercase
    }

    .summary-card .amount {
        font-size: 28px;
        font-weight: 700;
        color: #28a745
    }

    .summary-card .count {
        font-size: 14px;
        color: var(--text-secondary);
        margin-top: 8px
    }

    /* Data Card */
    .data-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden
    }

    .data-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        justify-content: space-between;
        align-items: center
    }

    .data-card-header h3 {
        margin: 0;
        font-size: 18px;
        display: flex;
        align-items: center;
        gap: 10px
    }

    .data-card-header h3 i {
        color: var(--accent)
    }

    /* Pro Table */
    .pro-table {
        width: 100%;
        border-collapse: collapse
    }

    .pro-table th {
        background: rgba(var(--accent-rgb), 0.1);
        padding: 16px 14px;
        text-align: left;
        font-weight: 600;
        font-size: 14px;
        text-transform: uppercase;
        color: var(--text-secondary);
        white-space: nowrap;
        border-bottom: 2px solid var(--accent)
    }

    .pro-table td {
        padding: 16px 14px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle;
        font-size: 15px
    }

    .pro-table tbody tr:hover {
        background: rgba(var(--accent-rgb), 0.05)
    }

    .tip-amount {
        font-weight: 700;
        color: #28a745
    }

    .currency-badge {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 600;
        background: rgba(74, 144, 217, .15);
        color: var(--accent)
    }

    .calculation-note {
        font-size: 12px;
        color: var(--text-secondary);
        background: var(--input-bg);
        padding: 8px 12px;
        border-radius: 8px;
        margin-top: 4px;
        word-break: break-all
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-secondary)
    }

    .empty-state i {
        font-size: 48px;
        opacity: .4;
        margin-bottom: 16px;
        display: block
    }

    .order-link {
        color: var(--accent);
        text-decoration: none;
        font-weight: 600
    }

    .order-link:hover {
        text-decoration: underline
    }

    @media(max-width:768px) {
        .filter-row {
            flex-direction: column
        }
    }
</style>

<?php if (!$shop_id): ?>
    <div class="empty-state">
        <i class="fas fa-store-slash"></i>
        <h4>ກະລຸນາເລືອກຮ້ານກ່ອນ</h4>
    </div>
<?php else: ?>

    <div class="page-header">
        <h1><i class="fas fa-coins"></i> ເງິນ Tip (ເສດປັດເພີ້ມ)</h1>
    </div>

    <!-- Filter Card -->
    <div class="filter-card">
        <form method="GET" action="tips.php" id="filter-form">
            <div class="filter-row">
                <input type="date" name="date_from" class="date-input" value="<?= $date_from ?>">
                <span style="color:var(--text-secondary)">ຫາ</span>
                <input type="date" name="date_to" class="date-input" value="<?= $date_to ?>">
                <button type="submit" class="btn-pro primary">
                    <i class="fas fa-filter"></i> ກັ່ນຕອງ
                </button>
            </div>
        </form>
    </div>

    <?php
    // Get tips with order info (only paid orders)
    $tips_sql = "SELECT t.*, 
                        o.OR_id, o.order_date, o.payment_status, o.total_amount as order_total,
                        cur.currencys_symbol, cur.currencys_name,
                        c.name as customer_name
                 FROM tips t
                 LEFT JOIN orders o ON t.order_id = o.OR_id AND o.shop_id = t.shop_id
                 LEFT JOIN currencys cur ON t.currencys_id = cur.currencys_id AND cur.shop_id = t.shop_id
                 LEFT JOIN customers c ON o.customer_id = c.CU_id
                 WHERE t.shop_id = ? 
                   AND t.deleted_at IS NULL
                   AND o.deleted_at IS NULL
                   AND o.payment_status = 'paid'
                   AND DATE(t.created_at) BETWEEN ? AND ?
                 ORDER BY t.created_at ASC";

    $tips_stmt = $conn->prepare($tips_sql);
    $tips_stmt->bind_param("iss", $shop_id, $date_from, $date_to);
    $tips_stmt->execute();
    $tips_result = $tips_stmt->get_result();
    $tips = $tips_result->fetch_all(MYSQLI_ASSOC);
    $tips_stmt->close();

    // Calculate totals
    $total_tip_lak = 0;
    $total_count = count($tips);
    foreach ($tips as $tip) {
        $total_tip_lak += floatval($tip['tip_amount_lak']);
    }
    ?>

    <!-- Summary Cards -->
    <div class="summary-cards">
        <div class="summary-card">
            <h3>ລວມ Tip ທັງໝົດ</h3>
            <div class="amount">₭
                <?= number_format($total_tip_lak, 0) ?>
            </div>
            <div class="count">
                <?= $total_count ?> ລາຍການ
            </div>
        </div>
    </div>

    <!-- Data Card -->
    <div class="data-card">
        <div class="data-card-header">
            <h3><i class="fas fa-list"></i> ລາຍການ Tip</h3>
        </div>

        <div style="overflow-x:auto">
            <table class="pro-table">
                <thead>
                    <tr>
                        <th>ວັນທີ</th>
                        <th>ເລກທີໃບບິນ</th>
                        <th>ລູກຄ້າ</th>
                        <th>ສະກຸນເງິນ</th>
                        <th>ອັດຕາ</th>
                        <th>ຍອດເດີມ</th>
                        <th>ຍອດປັດ</th>
                        <th>Tip (ສະກຸນເງິນ)</th>
                        <th>Tip (ກີບ)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($tips)): ?>
                        <tr>
                            <td colspan="9" class="empty-state">
                                <i class="fas fa-coins"></i>
                                <p>ບໍ່ພົບ Tip ໃນຊ່ວງເວລານີ້</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($tips as $tip): ?>
                            <tr>
                                <td>
                                    <?= date('d/m/Y H:i', strtotime($tip['created_at'])) ?>
                                </td>
                                <td>
                                    <a href="edit_order.php?order_id=<?= urlencode($tip['order_id']) ?>" class="order-link">
                                        <?= htmlspecialchars($tip['order_id']) ?>
                                    </a>
                                </td>
                                <td>
                                    <?= htmlspecialchars($tip['customer_name'] ?? '-') ?>
                                </td>
                                <td>
                                    <span class="currency-badge">
                                        <?= htmlspecialchars($tip['currencys_symbol'] ?? '') ?>
                                        <?= htmlspecialchars($tip['currencys_name'] ?? $tip['currencys_id']) ?>
                                    </span>
                                </td>
                                <td>
                                    <?= number_format($tip['currency_rate'], 2) ?>
                                </td>
                                <td>
                                    <?= number_format($tip['original_total'], 4) ?>
                                </td>
                                <td>
                                    <?= number_format($tip['rounded_total'], 2) ?>
                                </td>
                                <td class="tip-amount">
                                    <?= htmlspecialchars($tip['currencys_symbol'] ?? '') ?>
                                    <?= number_format($tip['tip_amount_foreign'], 4) ?>
                                </td>
                                <td class="tip-amount">₭
                                    <?= number_format($tip['tip_amount_lak'], 0) ?>
                                </td>
                            </tr>
                            <?php if (!empty($tip['calculation_note'])): ?>
                                <tr>
                                    <td colspan="9">
                                        <div class="calculation-note">
                                            <strong>ວິທີຄຳນວນ:</strong>
                                            <?= htmlspecialchars($tip['calculation_note']) ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

<?php endif; ?>

<?php require_once 'includes/footer.php'; ?>