<?php
$page_title = 'ຕັ້ງສີລະບົບ';
require_once 'includes/header.php';
?>

<style>
    .theme-settings-container {
        max-width: 900px;
        margin: 0 auto;
    }

    .theme-intro {
        margin-bottom: 30px;
    }

    .theme-intro p {
        color: var(--text-secondary);
        font-size: 16px;
        line-height: 1.6;
    }

    .theme-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 20px;
    }

    .theme-card {
        background: var(--card-bg);
        border: 2px solid var(--border-color);
        border-radius: 16px;
        overflow: hidden;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
    }

    .theme-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
    }

    .theme-card.active {
        border-color: var(--accent);
        box-shadow: 0 0 0 3px rgba(74, 144, 217, 0.3);
    }

    .theme-card.active::after {
        content: '\f00c';
        font-family: 'Font Awesome 6 Free';
        font-weight: 900;
        position: absolute;
        top: 12px;
        right: 12px;
        width: 28px;
        height: 28px;
        background: var(--accent);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 14px;
    }

    .theme-preview {
        height: 120px;
        display: flex;
        gap: 0;
    }

    .theme-preview-sidebar {
        width: 60px;
        display: flex;
        flex-direction: column;
        padding: 10px 8px;
        gap: 6px;
    }

    .preview-menu-item {
        height: 8px;
        border-radius: 4px;
        background: rgba(255, 255, 255, 0.3);
    }

    .preview-menu-item.active-item {
        background: var(--theme-accent);
    }

    .theme-preview-content {
        flex: 1;
        padding: 10px;
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .preview-header {
        height: 20px;
        border-radius: 6px;
        background: rgba(255, 255, 255, 0.1);
    }

    .preview-cards {
        display: flex;
        gap: 6px;
        flex: 1;
    }

    .preview-card {
        flex: 1;
        border-radius: 6px;
        background: rgba(255, 255, 255, 0.08);
    }

    .preview-btn {
        height: 16px;
        width: 50px;
        border-radius: 4px;
        align-self: flex-end;
    }

    .theme-info {
        padding: 18px;
        text-align: center;
    }

    .theme-name {
        font-size: 18px;
        font-weight: 600;
        margin-bottom: 6px;
    }

    .theme-colors {
        display: flex;
        justify-content: center;
        gap: 8px;
        margin-top: 10px;
    }

    .color-dot {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        border: 2px solid rgba(255, 255, 255, 0.2);
    }

    /* Theme specific preview colors */
    .theme-card[data-theme="original"] .theme-preview-sidebar,
    .theme-card[data-theme="blue"] .theme-preview-sidebar {
        background: #00152B;
    }

    .theme-card[data-theme="original"] .theme-preview-content,
    .theme-card[data-theme="blue"] .theme-preview-content {
        background: #001E3F;
    }

    .theme-card[data-theme="original"] .preview-menu-item.active-item,
    .theme-card[data-theme="original"] .preview-btn,
    .theme-card[data-theme="blue"] .preview-menu-item.active-item,
    .theme-card[data-theme="blue"] .preview-btn {
        background: #4A90D9;
    }

    .theme-card[data-theme="red"] .theme-preview-sidebar {
        background: #2A0000;
    }

    .theme-card[data-theme="red"] .theme-preview-content {
        background: #3F0000;
    }

    .theme-card[data-theme="red"] .preview-menu-item.active-item,
    .theme-card[data-theme="red"] .preview-btn {
        background: #D94A4A;
    }

    .theme-card[data-theme="yellow"] .theme-preview-sidebar {
        background: #2A2000;
    }

    .theme-card[data-theme="yellow"] .theme-preview-content {
        background: #3F3000;
    }

    .theme-card[data-theme="yellow"] .preview-menu-item.active-item,
    .theme-card[data-theme="yellow"] .preview-btn {
        background: #D9B84A;
    }

    .theme-card[data-theme="green"] .theme-preview-sidebar {
        background: #002A14;
    }

    .theme-card[data-theme="green"] .theme-preview-content {
        background: #003F1E;
    }

    .theme-card[data-theme="green"] .preview-menu-item.active-item,
    .theme-card[data-theme="green"] .preview-btn {
        background: #4AD97A;
    }

    .theme-card[data-theme="orange"] .theme-preview-sidebar {
        background: #2A1600;
    }

    .theme-card[data-theme="orange"] .theme-preview-content {
        background: #3F2100;
    }

    .theme-card[data-theme="orange"] .preview-menu-item.active-item,
    .theme-card[data-theme="orange"] .preview-btn {
        background: #D9874A;
    }

    .theme-card[data-theme="purple"] .theme-preview-sidebar {
        background: #1C002A;
    }

    .theme-card[data-theme="purple"] .theme-preview-content {
        background: #2A003F;
    }

    .theme-card[data-theme="purple"] .preview-menu-item.active-item,
    .theme-card[data-theme="purple"] .preview-btn {
        background: #9A4AD9;
    }

    .theme-card[data-theme="pink"] .theme-preview-sidebar {
        background: #FF1493;
    }

    .theme-card[data-theme="pink"] .theme-preview-content {
        background: #0D0D0D;
    }

    .theme-card[data-theme="pink"] .preview-menu-item.active-item,
    .theme-card[data-theme="pink"] .preview-btn {
        background: #FF69B4;
    }

    .theme-card[data-theme="pink"] .preview-menu-item {
        background: rgba(255, 255, 255, 0.4);
    }

    .theme-card[data-theme="pink"] .preview-header,
    .theme-card[data-theme="pink"] .preview-card {
        background: rgba(255, 20, 147, 0.2);
    }

    .theme-card[data-theme="gray"] .theme-preview-sidebar {
        background: #1A1A1A;
    }

    .theme-card[data-theme="gray"] .theme-preview-content {
        background: #2A2A2A;
    }

    .theme-card[data-theme="gray"] .preview-menu-item.active-item,
    .theme-card[data-theme="gray"] .preview-btn {
        background: #7A7A7A;
    }

    .theme-card[data-theme="white"] .theme-preview-sidebar {
        background: #FFFFFF;
    }

    .theme-card[data-theme="white"] .theme-preview-content {
        background: #FAFAFA;
    }

    .theme-card[data-theme="white"] .preview-menu-item.active-item,
    .theme-card[data-theme="white"] .preview-btn {
        background: #6C757D;
    }

    .theme-card[data-theme="white"] .preview-menu-item {
        background: rgba(0, 0, 0, 0.15);
    }

    .theme-card[data-theme="white"] .preview-header,
    .theme-card[data-theme="white"] .preview-card {
        background: rgba(0, 0, 0, 0.08);
    }

    /* Current theme indicator */
    .current-theme-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 8px 16px;
        background: var(--accent);
        color: white;
        border-radius: 20px;
        font-size: 14px;
        font-weight: 500;
        margin-bottom: 20px;
    }

    @media (max-width: 576px) {
        .theme-grid {
            grid-template-columns: 1fr;
        }

        .theme-preview {
            height: 100px;
        }

        .theme-info {
            padding: 14px;
        }

        .theme-name {
            font-size: 16px;
        }
    }
</style>

<div class="theme-settings-container">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">
                <i class="fas fa-paint-brush"></i>
                ຕັ້ງສີລະບົບ
            </h2>
        </div>
        <div class="card-body">
            <div class="theme-intro">
                <div class="current-theme-badge">
                    <i class="fas fa-palette"></i>
                    <span>ສີປັດຈຸບັນ: <strong id="currentThemeName">Original</strong></span>
                </div>
                <p>ເລືອກສີທີ່ທ່ານຕ້ອງການສຳລັບລະບົບ Admin Panel ການປ່ຽນສີຈະມີຜົນທັນທີ ແລະ
                    ຈະຈື່ຈຳໄວ້ເມື່ອທ່ານກັບເຂົ້າມາອີກ.</p>
            </div>

            <div class="theme-grid">
                <!-- Original Theme -->
                <div class="theme-card" data-theme="original" onclick="selectTheme('original')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">Original</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #001E3F;"></div>
                            <div class="color-dot" style="background: #4A90D9;"></div>
                        </div>
                    </div>
                </div>

                <!-- Red Theme -->
                <div class="theme-card" data-theme="red" onclick="selectTheme('red')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">ສີແດງ (Red)</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #3F0000;"></div>
                            <div class="color-dot" style="background: #D94A4A;"></div>
                        </div>
                    </div>
                </div>

                <!-- Yellow Theme -->
                <div class="theme-card" data-theme="yellow" onclick="selectTheme('yellow')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">ສີເຫຼືອງ (Yellow)</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #3F3000;"></div>
                            <div class="color-dot" style="background: #D9B84A;"></div>
                        </div>
                    </div>
                </div>

                <!-- Green Theme -->
                <div class="theme-card" data-theme="green" onclick="selectTheme('green')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">ສີຂຽວ (Green)</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #003F1E;"></div>
                            <div class="color-dot" style="background: #4AD97A;"></div>
                        </div>
                    </div>
                </div>

                <!-- Blue Theme -->
                <div class="theme-card" data-theme="blue" onclick="selectTheme('blue')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">ສີຟ້າ (Blue)</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #001E3F;"></div>
                            <div class="color-dot" style="background: #4A90D9;"></div>
                        </div>
                    </div>
                </div>

                <!-- Orange Theme -->
                <div class="theme-card" data-theme="orange" onclick="selectTheme('orange')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">ສີສົ້ມ (Orange)</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #3F2100;"></div>
                            <div class="color-dot" style="background: #D9874A;"></div>
                        </div>
                    </div>
                </div>

                <!-- Purple Theme -->
                <div class="theme-card" data-theme="purple" onclick="selectTheme('purple')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">ສີມ້ວງ (Purple)</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #2A003F;"></div>
                            <div class="color-dot" style="background: #9A4AD9;"></div>
                        </div>
                    </div>
                </div>

                <!-- Pink Theme -->
                <div class="theme-card" data-theme="pink" onclick="selectTheme('pink')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">ສີບົວ (Pink)</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #0D0D0D;"></div>
                            <div class="color-dot" style="background: #FF1493;"></div>
                        </div>
                    </div>
                </div>

                <!-- Gray Theme -->
                <div class="theme-card" data-theme="gray" onclick="selectTheme('gray')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">ສີເທົາ (Gray)</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #2A2A2A;"></div>
                            <div class="color-dot" style="background: #7A7A7A;"></div>
                        </div>
                    </div>
                </div>

                <!-- White Theme -->
                <div class="theme-card" data-theme="white" onclick="selectTheme('white')">
                    <div class="theme-preview">
                        <div class="theme-preview-sidebar">
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item active-item"></div>
                            <div class="preview-menu-item"></div>
                            <div class="preview-menu-item"></div>
                        </div>
                        <div class="theme-preview-content">
                            <div class="preview-header"></div>
                            <div class="preview-cards">
                                <div class="preview-card"></div>
                                <div class="preview-card"></div>
                            </div>
                            <div class="preview-btn"></div>
                        </div>
                    </div>
                    <div class="theme-info">
                        <div class="theme-name">ສີຂາວ (White)</div>
                        <div class="theme-colors">
                            <div class="color-dot" style="background: #FFFFFF; border: 1px solid #ccc;"></div>
                            <div class="color-dot" style="background: #6C757D;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    const themeNames = {
        'original': 'Original',
        'red': 'ສີແດງ (Red)',
        'yellow': 'ສີເຫຼືອງ (Yellow)',
        'green': 'ສີຂຽວ (Green)',
        'blue': 'ສີຟ້າ (Blue)',
        'orange': 'ສີສົ້ມ (Orange)',
        'purple': 'ສີມ່ວງ (Purple)',
        'pink': 'ສີຊົມພູ (Pink)',
        'gray': 'ສີເທົາ (Gray)',
        'white': 'ສີຂາວ (White)'
    };

    function selectTheme(theme) {
        // Apply theme
        setColorTheme(theme);

        // Update UI
        updateActiveCard(theme);
        updateCurrentThemeName(theme);

        // Show success toast
        Swal.fire({
            icon: 'success',
            title: 'ປ່ຽນສີສຳເລັດ!',
            text: 'ສີລະບົບຖືກປ່ຽນເປັນ ' + themeNames[theme],
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 2000,
            timerProgressBar: true
        });
    }

    function updateActiveCard(theme) {
        // Remove active from all
        document.querySelectorAll('.theme-card').forEach(card => {
            card.classList.remove('active');
        });

        // Add active to selected
        const activeCard = document.querySelector(`.theme-card[data-theme="${theme}"]`);
        if (activeCard) {
            activeCard.classList.add('active');
        }
    }

    function updateCurrentThemeName(theme) {
        document.getElementById('currentThemeName').textContent = themeNames[theme] || 'Original';
    }

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function () {
        const currentTheme = getColorTheme();
        updateActiveCard(currentTheme);
        updateCurrentThemeName(currentTheme);
    });
</script>

<?php require_once 'includes/footer.php'; ?>