<?php
session_start();
header('Content-Type: application/json');

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'กรุณาเข้าสู่ระบบ']);
    exit();
}

require_once 'includes/db_con.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {

    $conn->begin_transaction();

    $order_id = $_POST['order_id'];
    $order_date = $_POST['order_date'];
    $section = $_POST['section'];
    $cus_id = $_POST['cus_id'];
    $currencys_id = $_POST['currencys_id'];
    // แปลง rate_id ที่เป็นค่าว่างหรือ "0" เป็น NULL
    $rate_id = (!empty($_POST['rate_id']) && $_POST['rate_id'] !== '0') ? $_POST['rate_id'] : null;
    $order_discount = $_POST['order_discount'];
    $order_tax_percent = $_POST['order_tax_percent'];
    $order_subtotal = $_POST['order_subtotal'];
    $order_tax_amount = $_POST['order_tax_amount'];
    $order_total = $_POST['order_total'];

    $products = json_decode($_POST['products'], true);

    // ตรวจสอบประเภทการแก้ไข (quotation/invoice)
    $edit_type = isset($_POST['edit_type']) ? $_POST['edit_type'] : '';

    // เตรียม SQL สำหรับลบ approval fields ตามประเภท
    $clear_approval_sql = '';
    if ($edit_type === 'quotation') {
        $clear_approval_sql = ', approval_status = NULL, not_approve_reason = NULL';
    } elseif ($edit_type === 'invoice') {
        $clear_approval_sql = ', invoice_approval_status = NULL, invoice_not_approve_reason = NULL';
    }

    // อัพเดทข้อมูล Order พร้อมลบ approval fields ตามประเภท
    $update_order = "UPDATE orders SET 
        order_date = ?,
        section = ?,
        cus_id = ?,
        currencys_id = ?,
        rate_id = ?,
        order_discount = ?,
        order_subtotal = ?,
        order_tax_percent = ?,
        order_tax_amount = ?,
        order_total = ?
        $clear_approval_sql
        WHERE order_id = ?";

    $stmt = $conn->prepare($update_order);

    // ถ้า rate_id เป็น null ให้ bind ด้วย set_null
    if ($rate_id === null) {
        $stmt->bind_param(
            "ssssddddds",
            $order_date,
            $section,
            $cus_id,
            $currencys_id,
            $order_discount,
            $order_subtotal,
            $order_tax_percent,
            $order_tax_amount,
            $order_total,
            $order_id
        );
        $stmt->send_long_data(4, null); // index 4 = rate_id (0-based)
    } else {
        $stmt->bind_param(
            "sssssddddds",
            $order_date,
            $section,
            $cus_id,
            $currencys_id,
            $rate_id,
            $order_discount,
            $order_subtotal,
            $order_tax_percent,
            $order_tax_amount,
            $order_total,
            $order_id
        );
    }

    if (!$stmt->execute()) {
        throw new Exception('ไม่สามารถอัพเดท Order ได้');
    }
    
    // ลบรายการสินค้าเก่า
    $delete_items = "DELETE FROM orders_detail WHERE order_id = ?";
    $stmt = $conn->prepare($delete_items);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    
    // เพิ่มรายการสินค้าใหม่
    $insert_item = "INSERT INTO orders_detail (
        order_id,
        pro_id,
        order_qty,
        pro_price,
        tax_percent,
        tax_amount,
        total
    ) VALUES (?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($insert_item);
    
    foreach ($products as $product) {
        $tax_percent = 0;
        $tax_amount = 0;
        
        $stmt->bind_param(
            "ssidddd",
            $order_id,
            $product['pro_id'],
            $product['quantity'],
            $product['price'],
            $tax_percent,
            $tax_amount,
            $product['total']
        );
        
        if (!$stmt->execute()) {
            throw new Exception('ไม่สามารถเพิ่มรายการสินค้าได้');
        }
    }
    
    $conn->commit();
    echo json_encode(['success' => true, 'message' => 'แก้ไข Order สำเร็จ']);
    
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

$conn->close();
?>
