<?php
// register_save.php - SMART MONEY
session_start();
require_once "includes/db_con.php";

// เปิด error display ชั่วคราวเพื่อ debug
// ini_set('display_errors', 1);
// error_reporting(E_ALL);

// ตรวจสอบ request method
if ($_SERVER["REQUEST_METHOD"] != "POST") {
    $_SESSION["error"] = "Invalid request method.";
    header("Location: register");
    exit;
}

// ตรวจสอบ CSRF token
if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    $_SESSION["error"] = "Invalid CSRF token.";
    header("Location: register");
    exit;
}

// ตรวจสอบ input

if (!isset($_POST["username"]) || !isset($_POST["full_name"]) || !isset($_POST["password"]) || !isset($_POST["language"]) || !isset($_POST["role"])) {
    $_SESSION["error"] = "กรุณากรอกข้อมูลให้ครบถ้วน";
    header("Location: register");
    exit;
}

$username = trim($_POST['username']);
$full_name = trim($_POST['full_name']);
$password = $_POST['password'];
$language = $_POST['language'];
$role = $_POST['role'];

// Blacklist รหัสผ่านยอดนิยม
$common_passwords = [
    '123456','password','123456789','12345','12345678','qwerty','abc123','111111','123123','admin','letmein','welcome','monkey','login','passw0rd','starwars'
];
if (in_array(strtolower($password), $common_passwords)) {
    $_SESSION["error"] = "รหัสผ่านนี้ไม่ปลอดภัย กรุณาตั้งรหัสผ่านใหม่";
    header("Location: register"); 
    exit;
}

// ไม่ให้รหัสผ่านซ้ำกับ username หรือชื่อจริง
if (strtolower($password) === strtolower($username) || strtolower($password) === strtolower($full_name)) {
    $_SESSION["error"] = "รหัสผ่านห้ามซ้ำกับชื่อผู้ใช้หรือชื่อจริง";
    header("Location: register");
    exit;
}

// ตรวจสอบกับ HaveIBeenPwned API (เฉพาะ hash prefix)
function isPwned($password) {
    $sha1 = strtoupper(sha1($password));
    $prefix = substr($sha1, 0, 5);
    $suffix = substr($sha1, 5);
    $url = "https://api.pwnedpasswords.com/range/" . $prefix;
    $resp = @file_get_contents($url);
    if ($resp === false) return false; // ถ้าเชื่อมต่อ API ไม่ได้ ให้ผ่าน
    foreach (explode("\n", $resp) as $line) {
        list($hash, $count) = explode(":", $line);
        if (trim($hash) === $suffix) return true;
    }
    return false;
}
if (isPwned($password)) {
    $_SESSION["error"] = "รหัสผ่านนี้เคยรั่วไหล กรุณาตั้งรหัสผ่านใหม่";
    header("Location: register");
    exit;
}

// Validate เดิม
if (!$username || !$full_name || strlen($password) < 6) {
    $_SESSION["error"] = "ข้อมูลไม่ถูกต้องหรือรหัสผ่านสั้นเกินไป (อย่างน้อย 6 ตัว)";
    header("Location: register");
    exit;
}
if (!in_array($role, ['user','admin'])) {
    $_SESSION["error"] = "ค่าสถานะไม่ถูกต้อง";
    header("Location: register");
    exit;
}

// Sanitize
$username = htmlspecialchars($username, ENT_QUOTES, 'UTF-8');
$full_name = htmlspecialchars($full_name, ENT_QUOTES, 'UTF-8');

// ตรวจสอบ username ซ้ำ
$stmt = $conn->prepare("SELECT id FROM `user` WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows > 0) {
    $_SESSION["error"] = "Username นี้ถูกใช้แล้ว";
    $stmt->close();
    header("Location: register");
    exit;
}
$stmt->close();

// Hash password
$hash = password_hash($password, PASSWORD_BCRYPT);

// Insert user
$stmt = $conn->prepare("INSERT INTO `user` (username, password, full_name, role, language) VALUES (?, ?, ?, ?, ?)");
$stmt->bind_param("sssss", $username, $hash, $full_name, $role, $language);
if ($stmt->execute()) {
    $new_user_id = $conn->insert_id;
    // Log register
    $log_stmt = $conn->prepare("INSERT INTO audit_log (user_id, event, ip, created_at) VALUES (?, 'register', ?, NOW())");
    $log_stmt->bind_param("is", $new_user_id, $_SERVER['REMOTE_ADDR']);
    $log_stmt->execute();
    $log_stmt->close();
    // สมัครสมาชิกสำเร็จ กลับไปหน้า register.php
    $_SESSION["success"] = htmlspecialchars("สมัครสมาชิกสำเร็จ กรุณาเข้าสู่ระบบ");
    unset($_SESSION['csrf_token']);
    header("Location: register");
    exit;
} else {
    $_SESSION["error"] = htmlspecialchars("เกิดข้อผิดพลาดในการสมัครสมาชิก");
    header("Location: register");
    exit;
}
$stmt->close();
$conn->close();
?>
