<?php
session_start();
// Reset error message
unset($_SESSION['error']);
// สร้าง CSRF token ໃໝ່ทุกครั้งที่เข้า register page
$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
$csrf_token = $_SESSION['csrf_token']; 
?>
<!DOCTYPE html>
<html lang="la">
<head> 
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EP Money</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/register.css">
    <link rel="stylesheet" href="css/dark-mode.css">
    <style>body{font-family:'Noto Sans Lao',sans-serif;}</style>    
    <link rel="icon" type="image/png" href="/money/favicon.png">
</head> 
<body>
    <!-- Theme Toggle for Register Page -->
    <div style="position: fixed; top: 20px; right: 20px; z-index: 9999;">
        <div class="theme-toggle" id="theme-toggle">
            <div class="cloud cloud-1"></div>
            <div class="cloud cloud-2"></div>
            <div class="star star-1"></div>
            <div class="star star-2"></div>
            <div class="star star-3"></div>
            <div class="star star-4"></div>
            <div class="star star-5"></div>
        </div>
    </div>
    <div class="main-container" style="max-width:400px; margin-top:2em;">
    <h2 style="font-size:2em; margin-top:-10px; text-align:center;font-weight: bold;">ສະໝັກສະມາຊິກໃໝ່</h2>
        <?php
        if (isset($_SESSION["error"])) {
            echo '<div class="alert error"><i class="fas fa-exclamation-circle"></i> '.htmlspecialchars($_SESSION["error"]).'</div>';
            unset($_SESSION["error"]);
        }
        if (isset($_SESSION["success"])) {
            echo '<div class="alert success"><i class="fas fa-check-circle"></i> '.htmlspecialchars($_SESSION["success"]).'</div>';
            unset($_SESSION["success"]);
        }
        ?>
        <form action="register_save.php" method="post" autocomplete="off">
            <div class="mb-3">
                <label for="username" class="form-label">ຊື່ຜູ້ໃຊ້ (Username)</label>
                <input type="text" class="form-control" id="username" name="username" required autofocus>
            </div>
            <div class="mb-3">
                <label for="full_name" class="form-label">ຊື່-ນາມສະກຸນ (Full Name)</label>
                <input type="text" class="form-control" id="full_name" name="full_name" required>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">ລະຫັດຜ່ານ (Password)</label>
                <input type="password" class="form-control" id="password" name="password" required minlength="6" oninput="checkStrength(this.value)">
                <div id="strength-meter" style="margin-top:0.5em;"></div>
            </div>
            <div class="mb-3">
                <label for="role" class="form-label">ສະຖານະ (Role)</label>
                <select class="form-control" id="role" name="role" required>
                    <option value="user">ຜູ້ໃຊ້ (User)</option>
                    <option value="admin">ຜູ້ຄຸ້ມຄອງ (Admin)</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="language" class="form-label">Language</label>
                <select class="form-control" id="language" name="language" required>
                    <option value="la">ລາວ (Lao)</option>
                    <option value="th">ไทย (Thai)</option>
                    <option value="en">English</option>
                </select> 
            </div>
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            
            <button class="button" type="submit" style="width:100%;margin-top:1em;font-family:'Noto Sans Lao',sans-serif;" >ສະໝັກສະມາຊິກ</button>
        </form>
        <div style="margin-top:1.5em;text-align:center;">
            <a href="index" style="color:var(--primary-dark);font-size:1em;">ກັບໄປໜ້າລັອກອິນ</a>
        </div>
    </div>
</body>
<script src="js/register.js"></script>
<script>
// Theme Toggle for Register Page
document.addEventListener('DOMContentLoaded', function() {
    const savedTheme = localStorage.getItem('theme') || 'light';
    document.documentElement.setAttribute('data-theme', savedTheme);
    
    const themeToggle = document.getElementById('theme-toggle');
    if (themeToggle) {
        themeToggle.addEventListener('click', function() {
            const currentTheme = document.documentElement.getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            document.documentElement.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
        });
    }
});
</script>
</html>
