<?php
    session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);
    // ตรวจสอบการล็อกอิน
    if (!isset($_SESSION['user_id'])) {
        header("Location: index.php");
        exit();
    }

    // เชื่อมต่อฐานข้อมูล
    require_once 'includes/db_con.php';

    // ข้อมูลผู้ใช้
    $username = isset($_SESSION['username']) ? $_SESSION['username'] : 'ผู้ใช้';
    $user_id = $_SESSION['user_id'];

    // ดึงข้อมูลสินค้า
    $products_query = "SELECT p.*, t.types_name, u.unit_name, u.unit_id, r.remark_text, d.detail_text FROM products p 
                    LEFT JOIN types_product t ON p.types_id = t.types_id 
                    LEFT JOIN units u ON p.unit_id = u.unit_id
                    LEFT JOIN remark r ON p.remark_id = r.remark_id
                    LEFT JOIN detail_product d ON p.detail_product_id = d.detail_product_id
                    ORDER BY p.pro_name";
    $products_result = $conn->query($products_query);

    // ดึงข้อมูลประเภทสินค้า
    $types_query = "SELECT * FROM types_product ORDER BY types_name";
    $types_result = $conn->query($types_query);

    // ดึงข้อมูลลูกค้า
    $customers_query = "SELECT * FROM customers ORDER BY cus_name";
    $customers_result = $conn->query($customers_query);
    ?>

    <!DOCTYPE html>
    <html lang="lo">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Sokxay Bill - POS ສ້າງໃບບິນ</title>
        
        <!-- Favicon -->
        <link rel="icon" type="image/png" href="/sokxay/wayha.png">
        
        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;500;600;700&display=swap" rel="stylesheet">
        
        <!-- Font Awesome Icons -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        
        <!-- Custom CSS -->
        <link rel="stylesheet" href="css/home.css">
        <link rel="stylesheet" href="css/pos.css">
    </head>
    <body>
        <div class="app-container">
            <?php include 'includes/sidebar.php'; ?>

            <!-- Main Content Area -->
            <main class="main-content">
                <!-- Header -->
                <header class="content-header">
                    <div class="header-left">
                        <h1 class="page-title">POS - ສ້າງໃບບິນ</h1>
                        <p class="page-subtitle">ຈຸດຂາຍ ແລະ ສ້າງໃບບິນ</p>
                    </div>
                    
                    <div class="header-right">
                        <div class="current-date" id="current-time"></div>
                    </div>
                </header>

                <!-- Content Body -->
                <div class="content-body">
                    <div class="pos-container">
                        <!-- Left Panel - Products -->
                        <div class="products-panel">
                            <!-- Search and Filter -->
                            <div class="search-filter-section">
                                <div class="search-box">
                                    <i class="fas fa-search"></i>
                                    <input type="text" id="productSearch" placeholder="ຄົ້ນຫາສິນຄ້າ...">
                                </div>
                                <div class="filter-box">
                                    <select id="categoryFilter">
                                        <option value="">ທຸກປະເພດ</option>
                                        <?php if ($types_result->num_rows > 0): ?>
                                            <?php while ($type = $types_result->fetch_assoc()): ?>
                                                <option value="<?php echo $type['types_id']; ?>"><?php echo htmlspecialchars($type['types_name']); ?></option>
                                            <?php endwhile; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="filter-box">
                                    <select id="currencyFilter">
                                        <option value="LAK">Loading...</option>
                                    </select>
                                </div>
                                <div class="filter-box">
                                    <button id="vatToggle" class="vat-toggle-btn active" onclick="toggleVAT()">
                                        <i class="fas fa-percent"></i> VAT
                                    </button>
                                </div>
                            </div>

                            <!-- Products Grid -->
                            <div class="products-grid" id="productsGrid">
                                <?php if ($products_result->num_rows > 0): ?>
                                    <?php while ($product = $products_result->fetch_assoc()): ?>
                                        <div class="product-card" 
                                            data-id="<?php echo $product['pro_id']; ?>"
                                            data-name="<?php echo htmlspecialchars($product['pro_name']); ?>"
                                            data-price="<?php echo $product['pro_price']; ?>"
                                            data-category="<?php echo $product['types_id']; ?>"
                                            data-unit-id="<?php echo htmlspecialchars($product['unit_id'] ?? ''); ?>"
                                            data-unit-name="<?php echo htmlspecialchars($product['unit_name'] ?? ''); ?>"
                                            data-remark-id="<?php echo htmlspecialchars($product['remark_id'] ?? ''); ?>"
                                            data-detail-product-id="<?php echo htmlspecialchars($product['detail_product_id'] ?? ''); ?>"
                                            data-detail-text="<?php echo htmlspecialchars($product['detail_text'] ?? ''); ?>"
                                            onclick="addToCart(<?php echo htmlspecialchars(json_encode($product['pro_id']), ENT_QUOTES); ?>, <?php echo htmlspecialchars(json_encode($product['pro_name']), ENT_QUOTES); ?>, <?php echo $product['pro_price']; ?>, <?php echo htmlspecialchars(json_encode($product['unit_id'] ?? ''), ENT_QUOTES); ?>, <?php echo htmlspecialchars(json_encode($product['unit_name'] ?? ''), ENT_QUOTES); ?>, <?php echo htmlspecialchars(json_encode($product['remark_id'] ?? ''), ENT_QUOTES); ?>, <?php echo htmlspecialchars(json_encode($product['detail_product_id'] ?? ''), ENT_QUOTES); ?>, <?php echo htmlspecialchars(json_encode($product['detail_text'] ?? ''), ENT_QUOTES); ?>)">
                                            
                                            <?php if (!empty($product['pro_img'])): ?>
                                                <?php 
                                                    // เช็คว่า pro_img เป็น path เต็มหรือแค่ชื่อไฟล์
                                                    $img_path = $product['pro_img'];
                                                    if (strpos($img_path, '/') === false && strpos($img_path, 'http') !== 0) {
                                                        // ถ้าเป็นแค่ชื่อไฟล์ ให้เติม path
                                                        $img_path = 'img/products/' . $img_path;
                                                    }
                                                ?>
                                                <div class="product-image">
                                                    <img src="<?php echo htmlspecialchars($img_path); ?>" alt="<?php echo htmlspecialchars($product['pro_name']); ?>" onerror="this.parentElement.innerHTML='<i class=\\'fas fa-box\\' style=\\'font-size:32px;color:var(--primary-color)\\'></i>'">
                                                </div>
                                            <?php else: ?>
                                                <div class="product-icon">
                                                    <i class="fas fa-box"></i>
                                                </div>
                                            <?php endif; ?>
                                                <div class="product-info">
                                                <h3 class="product-name"><?php echo htmlspecialchars($product['pro_name']); ?></h3>
                                                <div class="product-category"><?php echo htmlspecialchars($product['types_name'] ?? 'ບໍ່ມີປະເພດ'); ?>
                                                <?php if (!empty($product['unit_name'])): ?>
                                                    <span class="product-unit"> • <?php echo htmlspecialchars($product['unit_name']); ?></span>
                                                <?php endif; ?></div>
                                                <?php if (!empty($product['remark_text'])): ?>
                                                    <div class="product-remark" style="font-size: 0.85em; color: #6c757d; margin-top: 4px;">
                                                        <i class="fas fa-sticky-note"></i> <?php echo htmlspecialchars($product['remark_text']); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if (!empty($product['detail_text'])): ?>
                                                    <div class="product-detail" style="font-size: 0.85em; color: #6c757d; margin-top: 2px;">
                                                        <i class="fas fa-info-circle"></i> <?php echo htmlspecialchars($product['detail_text']); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="product-price" data-base-price="<?php echo $product['pro_price']; ?>">₭ <?php echo number_format($product['pro_price'], 0); ?></div>
                                            </div>
                                            <div class="add-btn">
                                                <i class="fas fa-plus"></i>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <div class="no-products">
                                        <i class="fas fa-box-open"></i>
                                        <p>ບໍ່ມີສິນຄ້າໃນລະບົບ</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Right Panel - Cart -->
                        <div class="cart-panel">
                            <div class="cart-header">
                                <h2><i class="fas fa-shopping-cart"></i> ລາຍການສັ່ງຊື້</h2>
                                <button class="clear-cart-btn" onclick="clearCart()">
                                    <i class="fas fa-trash"></i> ລ້າງທັງຫມົດ
                                </button>
                            </div>

                            <!-- Cart Items -->
                            <div class="cart-items" id="cartItems">
                                <div class="empty-cart">
                                    <i class="fas fa-shopping-cart"></i>
                                    <p>ບໍ່ມີສິນຄ້າໃນຕະກຮ້າ</p>
                                </div>
                            </div>

                            <!-- Cart Summary -->
                            <div class="cart-summary">
                                <div class="summary-row">
                                    <span>ຍອດລວມ:</span>
                                    <span id="subtotal">₭ 0</span>
                                </div>
                                <div class="summary-row">
                                    <span>ສ່ວນຫຼຸດ:</span>
                                    <input type="number" id="discountInput" value="0" min="0" onchange="updateTotal()">
                                    <span id="discountSymbol">₭</span>
                                </div>
                                <div class="summary-row" id="vatRow">
                                    <span>VAT (10%):</span>
                                    <span id="vatAmount">₭ 0</span>
                                </div>
                                <div class="summary-row total-row">
                                    <span>ຍອດລວມສຸດທ້າຍ:</span>
                                    <span id="grandTotal">₭ 0</span>
                                </div>
                                <div class="summary-row currency-info">
                                    <small id="currencyNote" style="color: #666; font-size: 12px;">ລາຄາເປັນ: ກີບລາວ</small>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="cart-actions">
                                
                                <button class="btn-primary" onclick="confirmOrder()">
                                    <i class="fas fa-check"></i> ຍືນຍັນອໍເດີ
                                </button>
                            </div>  
                        </div>
                    </div>
                </div>
            </main>
        </div>

        <!-- Order Confirmation Modal -->
        <div id="orderModal" class="modal">
            <div class="modal-content">
                <div class="modal-header">
                    <h2><i class="fas fa-check-circle"></i> ຍືນຍັນການສັ່ງຊື້</h2>
                    <span class="close" onclick="closeModal()">&times;</span>
                </div>
                
                <div class="modal-body">
                    <div class="form-group">
                        <label>ຫົວຂໍ້:</label>
                        <input type="text" id="sectionInput" class="form-control" placeholder="ກະລຸນາລະບຸພາກສ່ວນ">
                    </div>
                    <!-- Customer Selection -->
                    <div class="form-group">
                        <label>ເລືອກລູກຄ້າ:</label>
                        <select id="customerSelect" class="form-control">
                            <option value="">-- ເລືອກລູກຄ້າ --</option>
                            <?php if ($customers_result->num_rows > 0): ?>
                                <?php while ($customer = $customers_result->fetch_assoc()): ?>
                                    <option value="<?php echo $customer['cus_id']; ?>"
                                            data-name="<?php echo htmlspecialchars($customer['cus_name']); ?>"
                                            data-tel="<?php echo htmlspecialchars($customer['cus_tel']); ?>"
                                            data-address="<?php echo htmlspecialchars($customer['cus_address']); ?>">
                                        <?php echo htmlspecialchars($customer['cus_name']); ?> - <?php echo htmlspecialchars($customer['cus_tel']); ?>
                                    </option>
                                <?php endwhile; ?>
                            <?php endif; ?>
                        </select>
                        <button class="btn-link" onclick="showNewCustomerForm()">+ ເພີ່ມລູກຄ້າໃໝ່</button>
                    </div>

                    <!-- New Customer Form (Hidden by default) -->
                    <div id="newCustomerForm" class="new-customer-form" style="display: none;">
                        <h3>ເພີ່ມລູກຄ້າໃໝ່</h3>
                        <div class="form-row">
                            <div class="form-group">
                                <label>ຊື່ລູກຄ້າ:</label>
                                <input type="text" id="newCustomerName" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label>ເບີໂທ:</label>
                                <input type="text" id="newCustomerTel" class="form-control">
                            </div>
                        </div>
                        <div class="form-group">
                            <label>ທີ່ຢູ່:</label>
                            <textarea id="newCustomerAddress" class="form-control" rows="2"></textarea>
                        </div>
                        <button class="btn-success" onclick="addNewCustomer()">ເພີ່ມລູກຄ້າ</button>
                    </div>

                    <!-- Section Information -->
                

                    <!-- Currency Information (Hidden) -->
                    <input type="hidden" id="selectedCurrency" value="LAK">
                    <input type="hidden" id="selectedCurrencyRate" value="1">
                    <input type="hidden" id="selectedCurrencySymbol" value="₭">

                    <!-- Order Summary in Modal -->
                    <div class="modal-summary">
                        <h3>ສະຫຼຸບລາຍການ</h3>
                        <div id="modalOrderItems"></div>
                        <div class="modal-total">
                            <div>ຍອດລວມ: <span id="modalSubtotal">₭ 0</span></div>
                            <div>ສ່ວນຫຼຸດ: <span id="modalDiscount">₭ 0</span></div>
                            <div id="modalVatRow">VAT (10%): <span id="modalVat">₭ 0</span></div>
                            <div class="total-final">ຍອດລວມສຸດທ້າຍ: <span id="modalTotal">₭ 0</span></div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button class="btn-secondary" onclick="closeModal()">ຍົກເລີກ</button>
                    <button class="btn-primary" onclick="submitOrder()">ຢືນຢັນການສັ່ງຊື້</button>
                </div>
            </div>
        </div>

        <!-- Sweet Alert -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        
        <!-- Sidebar JavaScript -->
        <script src="js/sidebar.js"></script>
        
        <!-- POS JavaScript -->
        <script src="js/pos.js"></script>
        
        <script>
            // Update clock
            function updateClock() {
                const now = new Date();
                const options = { 
                    weekday: 'short',
                    day: 'numeric',
                    month: 'short',
                    year: 'numeric',
                    hour: '2-digit',
                    minute: '2-digit'
                };
                
                const clockElement = document.getElementById('current-time');
                if (clockElement) {
                    const dateStr = now.toLocaleDateString('lo-LA', options);
                    clockElement.textContent = dateStr;
                }
            }

            document.addEventListener('DOMContentLoaded', function() {
                updateClock();
                setInterval(updateClock, 1000);
                
                // Initialize POS
                initPOS();
            });
        </script>
    </body>
    </html>
