<?php
/**
 * Generate PDF from print_quotation.php
 * Uses wkhtmltopdf or similar tool
 */

function generateQuotationPDF($order_id) {
    // สร้าง URL ของใบสะเหนี
    $base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
    $quotation_url = $base_url . "/sokxay/print_quotation.php?order_id=" . urlencode($order_id);
    
    // กำหนดชื่อไฟล์ PDF
    $pdf_filename = "quotation_" . $order_id . "_" . date('Ymd_His') . ".pdf";
    $pdf_path = __DIR__ . "/../temp_pdf/" . $pdf_filename;
    
    // ตรวจสอบว่ามีโฟลเดอร์หรือไม่
    if (!file_exists(__DIR__ . "/../temp_pdf/")) {
        mkdir(__DIR__ . "/../temp_pdf/", 0755, true);
    }
    
    // วิธีที่ 1: ใช้ wkhtmltopdf (ถ้า hosting รองรับ)
    $command = "wkhtmltopdf --enable-local-file-access --quiet '$quotation_url' '$pdf_path' 2>&1";
    exec($command, $output, $return_var);
    
    // ถ้า wkhtmltopdf ไม่ได้ผล ใช้วิธีอื่น
    if ($return_var !== 0 || !file_exists($pdf_path)) {
        // วิธีที่ 2: ใช้ DomPDF (PHP library)
        return generatePDFWithDomPDF($order_id, $pdf_path);
    }
    
    return [
        'success' => true,
        'path' => $pdf_path,
        'filename' => $pdf_filename
    ];
}

function generateInvoicePDF($order_id) {
    // สร้าง URL ของใบแจ้งหนี้ (invoice) ใช้ view_invoice.php พร้อม token
    $base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
    $secret_key = 'sokxay_secret_2024';
    $token = md5($order_id . $secret_key);
    $invoice_url = $base_url . "/sokxay/view_invoice.php?order_id=" . urlencode($order_id) . "&token=" . $token;

    // กำหนดชื่อไฟล์ PDF
    $pdf_filename = "invoice_" . $order_id . "_" . date('Ymd_His') . ".pdf";
    $pdf_path = __DIR__ . "/../temp_pdf/" . $pdf_filename;

    if (!file_exists(__DIR__ . "/../temp_pdf/")) {
        mkdir(__DIR__ . "/../temp_pdf/", 0755, true);
    }

    // ใช้ wkhtmltopdf ถ้ามี
    $command = "wkhtmltopdf --enable-local-file-access --quiet '" . $invoice_url . "' '" . $pdf_path . "' 2>&1";
    exec($command, $output, $return_var);

    if ($return_var !== 0 || !file_exists($pdf_path)) {
        // ตกกลับเป็น HTML file ถ้าไม่สำเร็จ
        $html = file_get_contents(__DIR__ . "/../print_invoice.php?order_id=" . urlencode($order_id));
        $html_path = str_replace('.pdf', '.html', $pdf_path);
        file_put_contents($html_path, $html);
        return [
            'success' => true,
            'path' => $html_path,
            'filename' => basename($html_path),
            'type' => 'html'
        ];
    }

    return [
        'success' => true,
        'path' => $pdf_path,
        'filename' => $pdf_filename
    ];
}

function generatePDFWithDomPDF($order_id, $pdf_path) {
    // ดึง HTML จากหน้า print_quotation
    $html = file_get_contents(__DIR__ . "/../print_quotation.php?order_id=" . urlencode($order_id));
    
    // เนื่องจากไม่มี library ให้ใช้ตัวง่ายๆ
    // บันทึกเป็น HTML ชั่วคราว
    $html_path = str_replace('.pdf', '.html', $pdf_path);
    file_put_contents($html_path, $html);
    
    return [
        'success' => true,
        'path' => $html_path,
        'filename' => basename($html_path),
        'type' => 'html'
    ];
}

function attachPDFToEmail($pdf_path, $filename) {
    if (!file_exists($pdf_path)) {
        return false;
    }
    
    $file_content = file_get_contents($pdf_path);
    $encoded_content = chunk_split(base64_encode($file_content));
    
    $boundary = md5(time());
    
    return [
        'boundary' => $boundary,
        'content' => $encoded_content,
        'filename' => $filename,
        'mime_type' => 'application/pdf'
    ];
}
