// register.js - Register page JS functions
// Password strength meter (moved from inline)
function checkStrength(pw) {
  let meter = document.getElementById('strength-meter');
  let score = 0;
  if (pw.length >= 8) score++;
  if (/[A-Z]/.test(pw)) score++;
  if (/[a-z]/.test(pw)) score++;
  if (/[0-9]/.test(pw)) score++;
  if (/[^a-zA-Z0-9]/.test(pw)) score++;
  let text = '';
  let color = '';
  switch(score) {
    case 0:
    case 1:
      text = 'ລະຫັດອ່ອນເເອເເຮງ'; color = '#dc3545'; break;
    case 2:
      text = 'ລະຫັດຍັງອ່ອນເເອຢູ່'; color = '#fd7e14'; break;
    case 3:
      text = 'ລະຫັດເລີ່ມບໍ່ອ່ອນເເອເເລ້ວ'; color = '#ffc107'; break;
    case 4:
      text = 'ລະຫັດເເຂງເເກ໋ງຂື້ນເເລ້ວ'; color = '#198754'; break;
    case 5:
      text = 'ເຈາະຍາກເເບບນີ້'; color = '#0d6efd'; break;
  }
  meter.innerHTML = '<span style="color:'+color+';font-weight:bold;">'+text+'</span>';
}
// Attach to password input
const passwordInput = document.getElementById('password');
if (passwordInput) {
  passwordInput.addEventListener('input', function() {
    checkStrength(passwordInput.value);
  });
}
// Add more register page JS functions here
