// index.js - Login page JS functions
// Toggle password visibility
const toggle = document.querySelector('.toggle');
const passwordInput = document.getElementById('password');
if (toggle && passwordInput) {
  toggle.addEventListener('click', function() {
    if (passwordInput.type === 'password') {
      passwordInput.type = 'text';
      toggle.classList.remove('fa-eye-slash');
      toggle.classList.add('fa-eye');
    } else {
      passwordInput.type = 'password';
      toggle.classList.remove('fa-eye');
      toggle.classList.add('fa-eye-slash');
    }
  });
}
// Countdown for brute force lock
const countdownEl = document.getElementById('countdown');
if (countdownEl) {
  console.log('Countdown element:', countdownEl);
  console.log('Countdown data-wait:', countdownEl.dataset.wait);
  if (countdownEl.dataset.wait) {
    let wait = parseInt(countdownEl.dataset.wait);
    function formatTime(sec) {
      let m = Math.floor(sec/60);
      let s = sec%60;
      return m+" นาที " + (s<10?"0":"") + s + " วินาที";
    }
    function updateCountdown() {
      if (wait <= 0) { location.reload(); return; }
      countdownEl.textContent = formatTime(wait);
      wait--;
    }
    updateCountdown();
    setInterval(updateCountdown, 1000);
  } else {
    console.warn('Countdown data-wait attribute is missing or empty.');
  }
}

