<?php
session_start();
// Reset session เฉพาะค่าที่เกี่ยวกับการ login (ยกเว้น error)
unset($_SESSION['authen']);
unset($_SESSION['user_id']);
unset($_SESSION['username']);
unset($_SESSION['full_name']);
unset($_SESSION['role']);
unset($_SESSION['language']);
unset($_SESSION['trial_expire']);
// unset($_SESSION['login_attempts']);
// *** อย่า unset($_SESSION['error']); ตรงนี้ ***

// สร้าง CSRF token ใหม่ทุกครั้งที่เข้า login page
$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
$csrf_token = $_SESSION['csrf_token'];
?>
<!DOCTYPE html>
<html lang="la">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EP Money</title>
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/dark-mode.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;700&display=swap" rel="stylesheet">
   
    <style>body{font-family:'Noto Sans Lao',sans-serif;}</style>
    <link rel="icon" type="image/png" href="/sokxay/wayha.png">
</head>
<body>
    <!-- Theme Toggle for Login Page -->
    <!--<div style="position: fixed; top: 20px; right: 20px; z-index: 9999;">-->
    <!--    <div class="theme-toggle" id="theme-toggle">-->
    <!--        <div class="cloud cloud-1"></div>-->
    <!--        <div class="cloud cloud-2"></div>-->
    <!--        <div class="star star-1"></div>-->
    <!--        <div class="star star-2"></div>-->
    <!--        <div class="star star-3"></div>-->
    <!--        <div class="star star-4"></div>-->
    <!--        <div class="star star-5"></div>-->
    <!--    </div>-->
    </div>
    <div class="main-container" style="max-width:400px;">
        <img src="img/wayha.png" class="logo" alt="Wayha Logo" >
        <h1 style="font-size: 2em; margin-top: -10px; text-align:center;">ລະບົບສ້າງໃບບິນ Wayha</h1>


        <!-- แสดงข้อความข้อผิดพลาดถ้ามี -->
        <?php
        if (isset($_SESSION["error"])) {
            echo '<div class="alert error"><i class="fas fa-exclamation-circle"></i> '.htmlspecialchars($_SESSION["error"]).'</div>';
            unset($_SESSION["error"]); // ลบ error หลังแสดงผล
        }
        ?>

        <?php 
        $locked = false;
        if (isset($_SESSION['login_attempts']) && isset($_SESSION['lock_time'])) {
            if ($_SESSION['login_attempts'] > 5 && time() - $_SESSION['lock_time'] < 600) {
                $locked = true;
                $wait = 600 - (time() - $_SESSION['lock_time']);
            }
        }
        ?>
        <form action="checklogin.php" method="post" autocomplete="off">
            <label for="username">ຊື່ຜູ້ໃຊ້</label>
            <input class="input" type="text" name="username" id="username" required autofocus <?=($locked?'disabled':'')?> >
            <label for="password">ລະຫັດຜ່ານ</label>
            <div class="password-wrapper" style="position:relative;">
                <input class="input" type="password" name="password" id="password" required spellcheck="false" <?=($locked?'disabled':'')?> >
                <i class="fas fa-eye-slash toggle" style="position:absolute;right:10px;top:50%;transform:translateY(-50%);cursor:pointer;"></i>
            </div>
            <!-- เพิ่ม CSRF Token -->
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            <button class="button" type="submit" style="width:100%;margin-top:1em;font-family:'Noto Sans Lao',sans-serif;" <?=($locked?'disabled':'')?> >ເຂົ້າສູ່ລະບົບ</button>
        </form>
        <?php if ($locked): ?>
        <div class="alert error" style="margin-top:1em;text-align:center;">
            <i class="fas fa-lock"></i> ທ່ານໄດ້ເຂົ້າລະບົບຜິດ ຫຼາຍເທື່ອ ລະບົບໄດ້ທຳການ ລ໋ອກ ກະລຸນາລໍຖ້າ <span id="countdown" data-wait="<?=$wait?>"></span>
        </div>
        <?php endif; ?>
        <div style="margin-top:1.5em;text-align:center;">
            <a href="register" style="color:var(--primary-dark);font-size:1em;">ສະໝັກສະມາຊິກ</a>
        </div>
    </div>
    <script src="js/index.js"></script>
    <script>
    // Theme Toggle for Login Page
    document.addEventListener('DOMContentLoaded', function() {
        const savedTheme = localStorage.getItem('theme') || 'light';
        document.documentElement.setAttribute('data-theme', savedTheme);
        
        const themeToggle = document.getElementById('theme-toggle');
        if (themeToggle) {
            themeToggle.addEventListener('click', function() {
                const currentTheme = document.documentElement.getAttribute('data-theme');
                const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                document.documentElement.setAttribute('data-theme', newTheme);
                localStorage.setItem('theme', newTheme);
            });
        }
    });
    </script>
</body>
</html>
