<?php
// sidebar.php - Shared Sidebar Component
// ตรวจสอบว่ามี session username หรือไม่
$current_username = isset($_SESSION['username']) ? $_SESSION['username'] : 'ผู้ใช้';
?>

<!-- Mobile Sidebar Toggle (แสดงเฉพาะบนมือถือ) -->
<button class="mobile-sidebar-toggle" id="sidebar-toggle" style="display: none;">
    <i class="fas fa-bars"></i>
</button>

<!-- Sidebar Navigation -->
<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <div class="logo">
            <img src="img/wayha.png" alt="Wayha Logo" style ="width: 60px; ">
        </div>
        <h2 class="brand-name">Wayha</h2>
    </div>
    
    <nav class="sidebar-nav">
        <a href="home.php" class="nav-item <?php echo (basename($_SERVER['PHP_SELF']) == 'home.php') ? 'active' : ''; ?>">
            <i class="fas fa-home"></i>
            <span>Dashboard</span>
        </a>
        
        <!-- Dropdown Menu สำหรับ ອອກໃບບິນ -->
        <div class="nav-item-dropdown <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['print_invoice.php', 'pos_to_bill.php', 'history_bill.php']) ? 'active' : ''); ?>">
            <a href="#" class="nav-item dropdown-toggle" onclick="toggleDropdown(this)">
                <i class="fas fa-file-invoice"></i>
                <span>ອອກໃບບິນ</span>
                <i class="fas fa-chevron-down dropdown-arrow"></i>
            </a>
            <div class="dropdown-menu">
                <a href="pos_to_bill.php" class="dropdown-item <?php echo (basename($_SERVER['PHP_SELF']) == 'pos_to_bill.php') ? 'active' : ''; ?>">
                    <i class="fas fa-plus-circle"></i>
                    <span>ສ້າງໃບບິນ</span>
                </a>
                <a href="history_bill.php" class="dropdown-item <?php echo (basename($_SERVER['PHP_SELF']) == 'history_bill.php') ? 'active' : ''; ?>">
                    <i class="fas fa-history"></i>
                    <span>ປະຫວັດໃບບິນ</span>
                </a>
            </div>
        </div>
        
        <!-- Dropdown Menu สำหรับ ຈັດການຂໍ້ມູນ -->
        <div class="nav-item-dropdown <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['add_currencys.php', 'add_rates.php', 'add_types_product.php', 'add_products.php']) ? 'active' : ''); ?>">
            <a href="#" class="nav-item dropdown-toggle" onclick="toggleDropdown(this)">
                <i class="fas fa-database"></i>
                <span>ຈັດການຂໍ້ມູນ</span>
                <i class="fas fa-chevron-down dropdown-arrow"></i>
            </a>
            <div class="dropdown-menu">
                <a href="add_currencys.php" class="dropdown-item <?php echo (basename($_SERVER['PHP_SELF']) == 'add_currencys.php') ? 'active' : ''; ?>">
                    <i class="fas fa-coins"></i>
                    <span>ເພີ່ມສະກຸນເງິນ</span>
                </a>
                <a href="add_rates.php" class="dropdown-item <?php echo (basename($_SERVER['PHP_SELF']) == 'add_rates.php') ? 'active' : ''; ?>">
                    <i class="fas fa-exchange-alt"></i>
                    <span>ເພີ່ມອັດຕາແລກປ່ຽນ</span>
                </a>
                <a href="add_types_product.php" class="dropdown-item <?php echo (basename($_SERVER['PHP_SELF']) == 'add_types_product.php') ? 'active' : ''; ?>">
                    <i class="fas fa-tags"></i>
                    <span>ເພີ່ມປະເພດສິນຄ້າ</span>
                </a>
                <a href="add_unit.php" class="dropdown-item <?php echo (basename($_SERVER['PHP_SELF']) == 'add_unit.php') ? 'active' : ''; ?>">
                    <i class="fas fa-tags"></i>
                    <span>ເພີ່ມຫົວໜ່ວຍສິນຄ້າ</span>
                </a>
                <a href="add_remark.php" class="dropdown-item <?php echo (basename($_SERVER['PHP_SELF']) == 'add_remark.php') ? 'active' : ''; ?>">
                    <i class="fas fa-comment-dots"></i>
                    <span>ເພີ່ມໝາຍເຫດ</span>
                </a>
                <a href="add_detail_pro.php" class="dropdown-item <?php echo (basename($_SERVER['PHP_SELF']) == 'add_detail_pro.php') ? 'active' : ''; ?>">
                    <i class="fas fa-info-circle"></i>
                    <span>ເພີ່ມລາຍລະອຽດສິນຄ້າ</span>
                </a>
                <a href="add_products.php" class="dropdown-item <?php echo (basename($_SERVER['PHP_SELF']) == 'add_products.php') ? 'active' : ''; ?>">
                    <i class="fas fa-box"></i>
                    <span>ເພີ່ມສິນຄ້າ</span>
                </a>
            </div>
        </div>
        
        <a href="#" class="nav-item" onclick="showComingSoon('ສະຫຼຸບ')">
            <i class="fas fa-chart-bar"></i>
            <span>ສະຫຼຸບ</span>
        </a>
        <a href="#" class="nav-item" onclick="showComingSoon('ການຕັ້ງຄ່າ')">
            <i class="fas fa-cog"></i>
            <span>ການຕັ້ງຄ່າ</span>
        </a>
    </nav>
    
    <div class="sidebar-footer">
        <div class="user-info">
            <div class="user-avatar">
                <i class="fas fa-user"></i>
            </div>
            <div class="user-details">
                <span class="user-name"><?php echo htmlspecialchars($current_username); ?></span>
                <span class="user-role">ຜູ້ດູແລລະບົບ</span>
            </div>
        </div>
        <a href="logout.php" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i>
        </a>
    </div>
</aside>