<?php
session_start();
// ini_set('display_errors', 1);
// error_reporting(E_ALL);
// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once 'includes/db_con.php';

// ดึงรายการแจ้งเตือนล่าสุด (7 วันที่ผ่านมา) จากตาราง notifications
$notifications = [];
$check_table = $conn->query("SHOW TABLES LIKE 'notifications'");
$has_notif_table = ($check_table && $check_table->num_rows > 0);

if ($has_notif_table) {
    $notif_query = "SELECT n.*, o.section, o.cus_id, c.cus_name, o.order_date as order_created_date
                    FROM notifications n
                    LEFT JOIN orders o ON n.order_id = o.order_id
                    LEFT JOIN customers c ON o.cus_id = c.cus_id
                    WHERE n.created_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
                    ORDER BY n.created_at DESC
                    LIMIT 20";
    $result = $conn->query($notif_query);
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $notifications[] = $row;
        }
    }
}

// Fallback: ถ้าไม่มีตาราง notifications หรือไม่มีข้อมูลในตาราง (อาจจะเป็นระบบเก่า)
// ให้ดึงจาก orders เหมือนเดิม เพื่อไม่ให้หน้าจอว่างเปล่า
$approved_orders = [];
$approved_invoices = [];

if (empty($notifications)) {
    // ดึงรายการใบเสนอราคาที่ได้รับการอนุมัติล่าสุด
    $orders_query = "SELECT order_id, section, order_date, cus_name 
                     FROM orders o
                     LEFT JOIN customers c ON o.cus_id = c.cus_id
                     WHERE approval_status = 'approved' 
                     AND order_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
                     ORDER BY order_date DESC
                     LIMIT 10";
    $result = $conn->query($orders_query);
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $approved_orders[] = $row;
        }
    }

    // ดึงรายการใบเก็บเงินที่ได้รับการอนุมัติล่าสุด
    $invoices_query = "SELECT order_id, section, order_date, cus_name 
                     FROM orders o
                     LEFT JOIN customers c ON o.cus_id = c.cus_id
                     WHERE invoice_approval_status = 'approved' 
                     AND order_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
                     ORDER BY order_date DESC
                     LIMIT 10";
    $result_inv = $conn->query($invoices_query);
    if ($result_inv) {
        while ($row_inv = $result_inv->fetch_assoc()) {
            $approved_invoices[] = $row_inv;
        }
    }
}

$approved_count = count($approved_orders);
$approved_invoice_count = count($approved_invoices);
$notification_count = count($notifications);

// ข้อมูลผู้ใช้ (สามารถดึงจากฐานข้อมูลได้)
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'ผู้ใช้';
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Sokxay Bill - ລະບົບຈັດການໃບບິນແລະໃບສະເຫນີລາຄາ">
    <meta name="keywords" content="bill, invoice, quotation, sokxay">
    <title>Sokxay Bill - Dashboard</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="/sokxay/wayha.png">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/home.css">
</head>
<body>
    <div class="app-container">
        <?php include 'includes/sidebar.php'; ?>

        <!-- Main Content Area -->
        <main class="main-content">
            <!-- Header -->
            <header class="content-header">
                <div class="header-left">
                    <h1 class="page-title">Dashboard</h1>
                    <p class="page-subtitle">ພາບລວມຂອງລະບົບ Sokxay Bill</p>
                </div>
                
                <div class="header-right">
                    <div class="current-date" id="current-time"></div>
                    <div class="notifications" style="position: relative;">
                        <i class="fas fa-bell"></i>
                        <span class="notification-badge" style="position: absolute; top: 0; right: 0; background: #e74c3c; color: #fff; border-radius: 50%; padding: 2px 7px; font-size: 0.75rem; display: none;"></span>
                        <div class="notification-dropdown">
                            <div class="notification-header">
                                <h3>ການແຈ້ງເຕືອນ</h3>
                            </div>
                            <div class="notification-list">
                                <?php
                                $has_notification = false;
                                
                                // กรณีใช้ระบบ Notifications Table (แสดงประวัติ)
                                if (!empty($notifications)) {
                                    $has_notification = true;
                                    foreach ($notifications as $notif): 
                                        $is_approved = (strpos($notif['type'], 'approved') !== false);
                                        $is_rejected = (strpos($notif['type'], 'rejected') !== false);
                                        $is_invoice = (strpos($notif['type'], 'invoice') !== false);
                                        
                                        $icon_class = $is_approved ? 'fa-check-circle' : ($is_rejected ? 'fa-times-circle' : 'fa-bell');
                                        $item_class = $is_approved ? 'approved' : ($is_rejected ? 'rejected' : '');
                                        $link_page = $is_invoice ? 'print_invoice.php' : 'print_quotation.php';
                                        
                                        // สร้างข้อความหัวเรื่อง
                                        $title = '';
                                        if ($is_approved) {
                                            $title = '✓ ອະນຸມັດແລ້ວ (' . ($is_invoice ? 'ໃບເກັບເງິນ' : 'ໃບສະເໜີ') . ') - ' . htmlspecialchars($notif['order_id']);
                                        } elseif ($is_rejected) {
                                            $title = '✗ ປະຕິເສດ (' . ($is_invoice ? 'ໃບເກັບເງິນ' : 'ໃບສະເໜີ') . ') - ' . htmlspecialchars($notif['order_id']);
                                        } else {
                                            $title = htmlspecialchars($notif['message']);
                                        }
                                        ?>
                                        <a href="<?php echo $link_page; ?>?order_id=<?php echo htmlspecialchars($notif['order_id']); ?>" class="notification-item <?php echo $item_class; ?>" style="text-decoration: none; color: inherit; display: flex;">
                                            <i class="fas <?php echo $icon_class; ?>"></i>
                                            <div class="notification-content">
                                                <strong><?php echo $title; ?></strong>
                                                <p><?php echo htmlspecialchars($notif['section'] ?: 'ບໍ່ມີຫົວຂໍ້'); ?> | <?php echo htmlspecialchars($notif['cus_name']); ?></p>
                                                <span style="font-size: 0.75rem; color: #999;">
                                                    <?php echo date('d/m/Y H:i', strtotime($notif['created_at'])); ?>
                                                    <?php if($is_rejected && !empty($notif['message'])) echo '<br><span style="color:red">'.htmlspecialchars($notif['message']).'</span>'; ?>
                                                </span>
                                            </div>
                                        </a>
                                    <?php endforeach;
                                } 
                                // กรณี Fallback (แสดงสถานะปัจจุบัน)
                                else {
                                    if ($approved_count > 0) {
                                        $has_notification = true;
                                        foreach ($approved_orders as $order): ?>
                                            <a href="print_quotation.php?order_id=<?php echo htmlspecialchars($order['order_id']); ?>" class="notification-item approved" style="text-decoration: none; color: inherit; display: flex;">
                                                <i class="fas fa-check-circle"></i>
                                                <div class="notification-content">
                                                    <strong>✓ ອະນຸມັດແລ້ວ (ໃບສະເໜີ) - <?php echo htmlspecialchars($order['order_id']); ?></strong>
                                                    <p><?php echo htmlspecialchars($order['section'] ?: 'ບໍ່ມີຫົວຂໍ້'); ?> | <?php echo htmlspecialchars($order['cus_name']); ?></p>
                                                    <span style="font-size: 0.75rem; color: #999;"><?php echo date('d/m/Y', strtotime($order['order_date'])); ?></span>
                                                </div>
                                            </a>
                                        <?php endforeach;
                                    }
                                    if ($approved_invoice_count > 0) {
                                        $has_notification = true;
                                        foreach ($approved_invoices as $invoice): ?>
                                            <a href="print_invoice.php?order_id=<?php echo htmlspecialchars($invoice['order_id']); ?>" class="notification-item approved" style="text-decoration: none; color: inherit; display: flex;">
                                                <i class="fas fa-file-invoice"></i>
                                                <div class="notification-content">
                                                    <strong>✓ ອະນຸມັດແລ້ວ (ໃບເກັບເງິນ) - <?php echo htmlspecialchars($invoice['order_id']); ?></strong>
                                                    <p><?php echo htmlspecialchars($invoice['section'] ?: 'ບໍ່ມີຫົວຂໍ້'); ?> | <?php echo htmlspecialchars($invoice['cus_name']); ?></p>
                                                    <span style="font-size: 0.75rem; color: #999;"><?php echo date('d/m/Y', strtotime($invoice['order_date'])); ?></span>
                                                </div>
                                            </a>
                                        <?php endforeach;
                                    }
                                }
                                
                                if (!$has_notification) {
                                    ?>
                                    <div class="notification-item">
                                        <p style="text-align: center; color: #999;">ບໍ່ມີການແຈ້ງເຕືອນ</p>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Content Body -->
            <div class="content-body">
                <!-- Quick Stats -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon primary">
                            <i class="fas fa-file-invoice"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">24</div>
                            <div class="stat-label">ໃບບິນໃນເດືອນນີ້</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon success">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">156</div>
                            <div class="stat-label">ລູກຄ້າທັງຫມົດ</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon warning">
                            <i class="fas fa-dollar-sign"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">₭ 45,890,000</div>
                            <div class="stat-label">ລາຍໄດ້ເດືອນນີ້</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon info">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">+12.5%</div>
                            <div class="stat-label">ເພີ່ມຂຶ້ນຈາກເດືອນກ່ອນ</div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="quick-actions">
                    <h2 class="section-title">ການດຳເນີນງານເດິ່ນ</h2>
                    <div class="actions-grid">
                        <a href="print_invoice.php" class="action-card">
                            <div class="action-icon">
                                <i class="fas fa-plus"></i>
                            </div>
                            <h3>ສ້າງໃບບິນໃໝ່</h3>
                            <p>ສ້າງໃບບິນສຳລັບລູກຄ້າ</p>
                        </a>
                        
                        <a href="print_quotation.php" class="action-card">
                            <div class="action-icon">
                                <i class="fas fa-file-alt"></i>
                            </div>
                            <h3>ສ້າງໃບສະເຫນີລາຄາ</h3>
                            <p>ສ້າງໃບສະເຫນີລາຄາໃໝ່</p>
                        </a>
                        
                        <a href="#" class="action-card" onclick="showComingSoon('ລາຍງານ')">
                            <div class="action-icon">
                                <i class="fas fa-chart-bar"></i>
                            </div>
                            <h3>ເບິ່ງລາຍງານ</h3>
                            <p>ລາຍງານການຂາຍແລະກຳໄລ</p>
                        </a>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="recent-activity">
                    <h2 class="section-title">ກິດຈະກຳລ່າສຸດ</h2>
                    <div class="activity-list">
                        <div class="activity-item">
                            <div class="activity-icon">
                                <i class="fas fa-file-invoice"></i>
                            </div>
                            <div class="activity-content">
                                <p><strong>ໃບບິນ #INV-001</strong> ຖືກສ້າງແລ້ວ</p>
                                <span class="activity-time">ເມື່ອ 2 ຊົ່ວໂມງທີ່ແລ້ວ</span>
                            </div>
                        </div>
                        
                        <div class="activity-item">
                            <div class="activity-icon">
                                <i class="fas fa-user-plus"></i>
                            </div>
                            <div class="activity-content">
                                <p><strong>ລູກຄ້າໃໝ່</strong> ຖືກເພີ່ມແລ້ວ</p>
                                <span class="activity-time">ເມື່ອ 5 ຊົ່ວໂມງທີ່ແລ້ວ</span>
                            </div>
                        </div>
                        
                        <div class="activity-item">
                            <div class="activity-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="activity-content">
                                <p><strong>ລາຍງານລາຍເດືອນ</strong> ພ້ອມແລ້ວ</p>
                                <span class="activity-time">ເມື່ອ 1 ມື້ທີ່ແລ້ວ</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Sweet Alert for Coming Soon -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Sidebar JavaScript -->
    <script src="js/sidebar.js"></script>
    
    <!-- Custom JavaScript -->
    <script src="js/home.js"></script>
</body>
</html>
