<?php
session_start();
header('Content-Type: application/json');

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'ບໍ່ໄດ້ເຂົ້າສູ່ລະບົບ']);
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once 'includes/db_con.php';

// ตรวจสอบว่ามี ID ส่งมาหรือไม่
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'ບໍ່ພົບລະຫັດປະເພດ']);
    exit();
}

$id = intval($_GET['id']);

try {
    // ดึงข้อมูลประเภทสินค้า
    $stmt = $conn->prepare("SELECT * FROM types_product WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $type = $result->fetch_assoc();
        echo json_encode([
            'success' => true,
            'type' => [
                'id' => $type['id'],
                'types_id' => $type['types_id'],
                'types_name' => $type['types_name']
            ]
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'ບໍ່ພົບຂໍ້ມູນປະເພດສິນຄ້າ']);
    }
    
    $stmt->close();
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage()]);
}

$conn->close();
?>