<?php
session_start();
header('Content-Type: application/json');

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'ບໍ່ໄດ້ເຂົ້າສູ່ລະບົບ']);
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once 'includes/db_con.php';

// ตรวจสอบว่ามี ID ส่งมาหรือไม่
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'ບໍ່ພົບລະຫັດໝາຍເຫດ']);
    exit();
}

$id = intval($_GET['id']);

try {
    // ดึงข้อมูล remark
    $stmt = $conn->prepare("SELECT * FROM remark WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $remark = $result->fetch_assoc();
        echo json_encode(['success' => true, 'remark' => $remark]);
    } else {
        echo json_encode(['success' => false, 'message' => 'ບໍ່ພົບຂໍ້ມູນໝາຍເຫດ']);
    }
    
    $stmt->close();
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage()]);
}
?>