<?php
session_start();
header('Content-Type: application/json');

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'ກະລຸນາເຂົ້າສູ່ລະບົບ']);
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once 'includes/db_con.php';

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'ບໍ່ພົບລະຫັດອັດຕາແລກປ່ຽນ']);
    exit();
}

$rate_id = intval($_GET['id']);

try {
    // ดึงข้อมูลอัตราแลกปลี่ยน
    $stmt = $conn->prepare("SELECT *, COALESCE(rate_datetime, CONCAT(rate_date, ' 00:00:00')) as display_datetime FROM rates WHERE id = ?");
    $stmt->bind_param("i", $rate_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $rate = $result->fetch_assoc();
        
        // แยกวันที่และเวลาสำหรับการแก้ไข
        if ($rate['rate_datetime']) {
            $datetime = new DateTime($rate['rate_datetime']);
            $rate['rate_time'] = $datetime->format('H:i');
        } else {
            $rate['rate_time'] = '00:00';
        }
        
        echo json_encode([
            'success' => true,
            'rate' => $rate
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'ບໍ່ພົບຂໍ້ມູນອັດຕາແລກປ່ຽນ'
        ]);
    }
    
    $stmt->close();
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage()
    ]);
}

$conn->close();
?>