<?php
session_start();
header('Content-Type: application/json');

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'กรุณาเข้าสู่ระบบ']);
    exit();
}

require_once 'includes/db_con.php';

if (!isset($_GET['order_id'])) {
    echo json_encode(['success' => false, 'message' => 'ไม่พบ Order ID']);
    exit();
}

$order_id = $_GET['order_id'];

try {
    // ดึงข้อมูล Order
    $order_query = "SELECT * FROM orders WHERE order_id = ?";
    $stmt = $conn->prepare($order_query);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $order_result = $stmt->get_result();
    
    if ($order_result->num_rows === 0) {
        echo json_encode(['success' => false, 'message' => 'ไม่พบ Order นี้']);
        exit();
    }
    
    $order = $order_result->fetch_assoc();
    
    // ดึงข้อมูลรายการสินค้า พร้อม types_id และ unit_id
    $items_query = "SELECT od.*, p.pro_name, p.types_id as product_types_id, p.unit_id as product_unit_id
                    FROM orders_detail od
                    LEFT JOIN products p ON od.pro_id = p.pro_id
                    WHERE od.order_id = ?";
    $stmt = $conn->prepare($items_query);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $items_result = $stmt->get_result();
    
    $items = [];
    while ($item = $items_result->fetch_assoc()) {
        $items[] = $item;
    }
    
    echo json_encode([
        'success' => true,
        'order' => $order,
        'items' => $items
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'เกิดข้อผิดพลาด: ' . $e->getMessage()]);
}

$conn->close();
?>
