<?php
session_start();
header('Content-Type: application/json');

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'ກະລຸນາເຂົ້າສູ່ລະບົບ']);
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once 'includes/db_con.php';

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'ບໍ່ພົບລະຫັດສະກຸນເງິນ']);
    exit();
}

$currency_id = intval($_GET['id']);

try {
    // ดึงข้อมูลสกุลเงิน
    $stmt = $conn->prepare("SELECT * FROM currencys WHERE id = ?");
    $stmt->bind_param("i", $currency_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $currency = $result->fetch_assoc();
        echo json_encode([
            'success' => true,
            'currency' => $currency
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'ບໍ່ພົບຂໍ້ມູນສະກຸນເງິນ'
        ]);
    }
    
    $stmt->close();
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage()
    ]);
}

$conn->close();
?>