<?php
session_start();

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// ข้อมูลผู้ใช้
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'ผู้ใช้';
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Sokxay Bill - ລະບົບຈັດການຂໍ້ມູນ">
    <title>Sokxay Bill - ຈັດການຂໍ້ມູນ</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="/sokxay/wayha.png">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/home.css">
</head>
<body>
    <div class="app-container">
        <?php include 'includes/sidebar.php'; ?>

        <!-- Main Content Area -->
        <main class="main-content">
            <!-- Header -->
            <header class="content-header">
                <div class="header-left">
                    <h1 class="page-title">ຈັດການຂໍ້ມູນ</h1>
                    <p class="page-subtitle">ຈັດການຂໍ້ມູນລູກຄ້າ ສິນຄ້າ ແລະບໍລິການ</p>
                </div>
                
                <div class="header-right">
                    <div class="current-date" id="current-time"></div>
                    <div class="notifications">
                        <i class="fas fa-bell"></i>
                        <span class="notification-badge">3</span>
                    </div>
                </div>
            </header>

            <!-- Content Body -->
            <div class="content-body">
                <div class="quick-actions">
                    <h2 class="section-title">ການຈັດການຂໍ້ມູນ</h2>
                    <div class="actions-grid">
                        <a href="#" class="action-card" onclick="showComingSoon('ຈັດການລູກຄ້າ')">
                            <div class="action-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <h3>ຈັດການລູກຄ້າ</h3>
                            <p>ເພີ່ມ ແກ້ໄຂ ລົບ ຂໍ້ມູນລູກຄ້າ</p>
                        </a>
                        
                        <a href="#" class="action-card" onclick="showComingSoon('ຈັດການສິນຄ້າ')">
                            <div class="action-icon">
                                <i class="fas fa-boxes"></i>
                            </div>
                            <h3>ຈັດການສິນຄ້າ</h3>
                            <p>ເພີ່ມ ແກ້ໄຂ ລົບ ຂໍ້ມູນສິນຄ້າ</p>
                        </a>
                        
                        <a href="#" class="action-card" onclick="showComingSoon('ຈັດການບໍລິການ')">
                            <div class="action-icon">
                                <i class="fas fa-tools"></i>
                            </div>
                            <h3>ຈັດການບໍລິການ</h3>
                            <p>ເພີ່ມ ແກ້ໄຂ ລົບ ຂໍ້ມູນບໍລິການ</p>
                        </a>
                        
                        <a href="#" class="action-card" onclick="showComingSoon('ນຳເຂົ້າຂໍ້ມູນ')">
                            <div class="action-icon">
                                <i class="fas fa-file-import"></i>
                            </div>
                            <h3>ນຳເຂົ້າຂໍ້ມູນ</h3>
                            <p>ນຳເຂົ້າຂໍ້ມູນຈາກ Excel/CSV</p>
                        </a>
                    </div>
                </div>

                <!-- Data Overview -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon primary">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">156</div>
                            <div class="stat-label">ລູກຄ້າທັງຫມົດ</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon success">
                            <i class="fas fa-boxes"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">89</div>
                            <div class="stat-label">ສິນຄ້າທັງຫມົດ</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon warning">
                            <i class="fas fa-tools"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">23</div>
                            <div class="stat-label">བໍລິການທັງຫມົດ</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon info">
                            <i class="fas fa-database"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">268</div>
                            <div class="stat-label">ລາຍການທັງຫມົດ</div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Sweet Alert for Coming Soon -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Sidebar JavaScript -->
    <script src="js/sidebar.js"></script>
    
    <!-- Page specific JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Set active menu item
            if (window.sidebarManager) {
                // Wait for sidebar to initialize
                setTimeout(() => {
                    window.sidebarManager.setActiveMenuItem('data_management');
                }, 100);
            }
            
            // Update clock
            updateClock();
            setInterval(updateClock, 1000);
        });

        function updateClock() {
            const now = new Date();
            const options = { 
                weekday: 'short',
                day: 'numeric',
                month: 'short',
                year: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            };
            
            const clockElement = document.getElementById('current-time');
            if (clockElement) {
                const dateStr = now.toLocaleDateString('lo-LA', options);
                clockElement.textContent = dateStr;
            }
        }
    </script>
</body>
</html>