<?php
// checklogin.php - SMART MONEY
session_start();
require_once "includes/db_con.php";

// ปิด error display ใน production
// ini_set('display_errors', 1);
// error_reporting(E_ALL);

// Force HTTPS (ปิดชั่วคราวเพื่อ testing)
// if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === "off") {
//     $redirect = 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
//     header('HTTP/1.1 301 Moved Permanently');
//     header('Location: ' . $redirect);
//     exit;
// }

// ป้องกัน brute force
if (!isset($_SESSION['login_attempts'])) $_SESSION['login_attempts'] = 0;
if (!isset($_SESSION['lock_time'])) $_SESSION['lock_time'] = 0;
if ($_SESSION['login_attempts'] > 5) {
    // ถ้ายังไม่เคยล็อก ให้ล็อก 10 นาที
    if ($_SESSION['lock_time'] == 0) {
        $_SESSION['lock_time'] = time();
    }
    // ถ้าเวลาล็อกยังไม่ครบ 10 นาที
    if (time() - $_SESSION['lock_time'] < 600) {
        $_SESSION["error"] = "Too many failed attempts. Please try again in 10 minutes.";
        header("Location: index");
        exit;
    } else {
        // ครบ 10 นาทีแล้ว รีเซ็ต
        $_SESSION['login_attempts'] = 0;
        $_SESSION['lock_time'] = 0;
    }
}

// ตรวจสอบ request method
if ($_SERVER["REQUEST_METHOD"] != "POST") {
    $_SESSION["error"] = htmlspecialchars("Invalid request method.");
    // Log login failed
    if (isset($conn)) {
        $log_stmt = $conn->prepare("INSERT INTO audit_log (user_id, event, ip, created_at) VALUES (NULL, 'login_failed', ?, NOW())");
        $log_stmt->bind_param("s", $_SERVER['REMOTE_ADDR']);
        $log_stmt->execute();
        $log_stmt->close();
    }
    header("Location: index");
    exit;
}

// ตรวจสอบ CSRF token
if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    $_SESSION["error"] = "Invalid CSRF token.";
    header("Location: index");
    exit;
}

// ตรวจสอบ input
if (!isset($_POST["username"]) || !isset($_POST["password"])) {
    $_SESSION["error"] = htmlspecialchars("Please enter both username and password.");
    // Log login failed
    if (isset($conn)) {
        $log_stmt = $conn->prepare("INSERT INTO audit_log (user_id, event, ip, created_at) VALUES (NULL, 'login_failed', ?, NOW())");
        $log_stmt->bind_param("s", $_SERVER['REMOTE_ADDR']);
        $log_stmt->execute();
        $log_stmt->close();
    }
    header("Location: index");
    exit;
}

// Validate username
$username = trim($_POST['username']);
$password = $_POST['password'];
if (!$username || strlen($password) < 6) {
    $_SESSION["error"] = htmlspecialchars("Invalid username or password format.");
    // Log login failed
    if (isset($conn)) {
        $log_stmt = $conn->prepare("INSERT INTO audit_log (user_id, event, ip, created_at) VALUES (NULL, 'login_failed', ?, NOW())");
        $log_stmt->bind_param("s", $_SERVER['REMOTE_ADDR']);
        $log_stmt->execute();
        $log_stmt->close();
    }
    header("Location: index");
    exit;
}

// Query SQL Command with prepared statements
$sql = "SELECT * FROM `user` WHERE username = ?";
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    $_SESSION["error"] = "Database error.";
    header("Location: index");
    exit;
}
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result(); 

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    // Verify password with the hashed password in the database
    if (password_verify($password, $row['password'])) {
        // Regenerate session id to prevent session fixation
        session_regenerate_id(true);
        // Set session variables for authenticated user
        $_SESSION['user_id'] = $row['id'];
        $_SESSION['username'] = $row['username'];
        $_SESSION['full_name'] = $row['full_name'];
        $_SESSION['role'] = $row['role'];
        $_SESSION['language'] = $row['language'];
        $_SESSION['trial_expire'] = $row['trial_expire'];
        $_SESSION['authen'] = true;
    // Reset login attempts และ lock_time
    $_SESSION['login_attempts'] = 0;
    $_SESSION['lock_time'] = 0;
    // อัปเดต last_login
    $now = date('Y-m-d H:i:s');
    $update = $conn->prepare("UPDATE `user` SET last_login=? WHERE id=?");
    $update->bind_param("si", $now, $row['id']);
    $update->execute();
    $update->close();
    // ลบ CSRF token หลัง login สำเร็จ
    unset($_SESSION['csrf_token']);
        // Log login success
        $log_stmt = $conn->prepare("INSERT INTO audit_log (user_id, event, ip, created_at) VALUES (?, 'login_success', ?, NOW())");
        $log_stmt->bind_param("is", $row['id'], $_SERVER['REMOTE_ADDR']);
        $log_stmt->execute();
        $log_stmt->close();
        // ตรวจสอบ trial_expire
        if ($row['trial_expire'] && strtotime($row['trial_expire']) < strtotime(date('Y-m-d'))) {
            $_SESSION["error"] = htmlspecialchars("บัญชีหมดอายุทดลองใช้งานแล้ว");
            header("Location: index");
            exit;
        }
        // Redirect by role
        if ($row['role'] === 'admin') {
            header("Location: admin");
        } else {
            header("Location: home");
        }
        exit;
    } else {
        $_SESSION['login_attempts'] += 1;
        $_SESSION["error"] = htmlspecialchars("Incorrect username or password!");
        // Log login failed
        $log_stmt = $conn->prepare("INSERT INTO audit_log (user_id, event, ip, created_at) VALUES (NULL, 'login_failed', ?, NOW())");
        $log_stmt->bind_param("s", $_SERVER['REMOTE_ADDR']);
        $log_stmt->execute();
        $log_stmt->close();
        header("Location: index");
        exit;
    }
} else {
    $_SESSION['login_attempts'] += 1;
    $_SESSION["error"] = htmlspecialchars("Incorrect username or password!");
    // Log login failed
    $log_stmt = $conn->prepare("INSERT INTO audit_log (user_id, event, ip, created_at) VALUES (NULL, 'login_failed', ?, NOW())");
    $log_stmt->bind_param("s", $_SERVER['REMOTE_ADDR']);
    $log_stmt->execute();
    $log_stmt->close();
    header("Location: index");
    exit;
}
$stmt->close();
$conn->close();
?>
