<?php
header('Content-Type: text/html; charset=UTF-8');

// เชื่อมต่อฐานข้อมูล
require_once '../includes/db_con.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $order_id = $_POST['order_id'] ?? '';
    $token = $_POST['token'] ?? '';
    $reason = $_POST['reason'] ?? '';
    
    if (empty($order_id) || empty($token) || empty($reason)) {
        die('ຂໍ້ມູນບໍ່ຄົບຖ້ວນ');
    }
    
    // ตรวจสอบ token
    $secret_key = 'sokxay_secret_2024';
    $expected_token = md5($order_id . $secret_key);
    
    if ($token !== $expected_token) {
        die('Token ບໍ່ຖືກຕ້ອງ');
    }
    
    // ถ้ามีการส่ง type=invoice ให้บันทึกลงฟิลด์ invoice_... มิฉะนั้นใช้ approval_status เดิม
    $type = $_POST['type'] ?? '';
    // บางฐานข้อมูลอาจยังไม่มีคอลัมน์ `approval_changed_at` ดังนั้นตรวจสอบก่อน
    $col_check = $conn->query("SHOW COLUMNS FROM orders LIKE 'approval_changed_at'");
    $has_approval_time = ($col_check && $col_check->num_rows > 0);

    if ($type === 'invoice') {
        if ($has_approval_time) {
            $update_stmt = $conn->prepare("UPDATE orders SET invoice_approval_status = 'rejected', invoice_not_approve_reason = ?, approval_changed_at = NOW() WHERE order_id = ?");
        } else {
            $update_stmt = $conn->prepare("UPDATE orders SET invoice_approval_status = 'rejected', invoice_not_approve_reason = ? WHERE order_id = ?");
        }
        $update_stmt->bind_param("ss", $reason, $order_id);
    } else {
        if ($has_approval_time) {
            $update_stmt = $conn->prepare("UPDATE orders SET approval_status = 'rejected', not_approve_reason = ?, approval_changed_at = NOW() WHERE order_id = ?");
        } else {
            $update_stmt = $conn->prepare("UPDATE orders SET approval_status = 'rejected', not_approve_reason = ? WHERE order_id = ?");
        }
        $update_stmt->bind_param("ss", $reason, $order_id);
    }
    $update_stmt->execute();

    // สร้างการแจ้งเตือนสำหรับผู้ที่เกี่ยวข้อง (ตัวอย่าง: ผู้สร้างออเดอร์)
    try {
        // ดึง user_id ของผู้สร้างออเดอร์
        $owner_stmt = $conn->prepare("SELECT user_id FROM orders WHERE order_id = ? LIMIT 1");
        $owner_stmt->bind_param("s", $order_id);
        $owner_stmt->execute();
        $owner_res = $owner_stmt->get_result();
        $notify_user_id = null;
        if ($owner_res && $owner_res->num_rows > 0) {
            $row = $owner_res->fetch_assoc();
            $notify_user_id = !empty($row['user_id']) ? (int)$row['user_id'] : null;
        }
        $owner_stmt->close();

        // ถ้าไม่พบผู้ใช้เจ้าของ ให้ใช้ admin (id=1) เป็น fallback
        if (empty($notify_user_id)) {
            $notify_user_id = 1;
        }

        if ($type === 'invoice') {
            $notif_type = 'invoice_rejected';
            $notif_message = 'ໃບເກັບເງິນ ' . $order_id . ' ຖືກປະຕິເສດ: ' . $reason;
        } else {
            $notif_type = 'quotation_rejected';
            $notif_message = 'ໃບສະເໜີລາຄາ ' . $order_id . ' ຖືກປະຕິເສດ: ' . $reason;
        }

        // ตรวจสอบว่า table `notifications` มีอยู่ ถ้าไม่มี จะไม่ทำให้เกิด error (แนะนำรัน SQL migration)
        $check_table = $conn->query("SHOW TABLES LIKE 'notifications'");
        if ($check_table && $check_table->num_rows > 0) {
            // ลบ notification เก่าของ order นี้ก่อน (ป้องกันการซ้ำ)
            $del_old = $conn->prepare("DELETE FROM notifications WHERE order_id = ? AND type = ?");
            if ($del_old) {
                $del_old->bind_param("ss", $order_id, $notif_type);
                $del_old->execute();
                $del_old->close();
            }

            // สร้าง notification ใหม่
            $ins = $conn->prepare("INSERT INTO notifications (`order_id`,`user_id`,`type`,`message`,`created_at`) VALUES (?,?,?,?,NOW())");
            if ($ins) {
                $ins->bind_param("siss", $order_id, $notify_user_id, $notif_type, $notif_message);
                $ins->execute();
                $ins->close();

                // ลบสถานะ "อ่านแล้ว" ออก เพื่อให้แจ้งเตือนเด้งใหม่
                // notifications_read ใช้ order_id format: ODR_1_quotation หรือ ODR_1_invoice
                if ($type === 'invoice') {
                    $read_order_id = $order_id . '_invoice';
                } else {
                    $read_order_id = $order_id . '_quotation';
                }
                $del_read = $conn->prepare("DELETE FROM notifications_read WHERE order_id = ? AND user_id = ?");
                if ($del_read) {
                    $del_read->bind_param("si", $read_order_id, $notify_user_id);
                    $del_read->execute();
                    $del_read->close();
                }
            }
        }
    } catch (Exception $e) {
        // ไม่บล็อก flow ถ้ามีปัญหาในการบันทึกแจ้งเตือน
        error_log('Notification insert failed: ' . $e->getMessage());
    }

    // TODO: ส่งอีเมลแจ้งเหตุผลกลับไปยังผู้สร้างออเดอร์
    
    $update_stmt->close();
    $conn->close();
    ?>
    <!DOCTYPE html>
    <html lang="lo">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>ສົ່ງເຫດຜົນສຳເລັດ</title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: 'Noto Sans Lao', Arial, sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .container {
                background: white;
                padding: 40px;
                border-radius: 15px;
                box-shadow: 0 10px 40px rgba(0,0,0,0.2);
                max-width: 500px;
                width: 100%;
                text-align: center;
            }
            .icon {
                width: 80px;
                height: 80px;
                background: #ffc107;
                color: white;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 48px;
                margin: 0 auto 20px;
            }
            h1 { color: #333; margin-bottom: 15px; }
            p { color: #666; line-height: 1.6; }
            .reason {
                background: #f8f9fa;
                padding: 15px;
                border-radius: 5px;
                margin-top: 20px;
                text-align: left;
                color: #333;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="icon">✓</div>
            <h1>ສົ່ງເຫດຜົນສຳເລັດ</h1>
            <p>ຂອບໃຈສຳລັບການແຈ້ງເຫດຜົນ ລະບົບຈະແຈ້ງກັບຜູ້ສ້າງໃບສະເໜີລາຄາ</p>
            <div class="reason">
                <strong>ເຫດຜົນ:</strong><br>
                <?php echo nl2br(htmlspecialchars($reason)); ?>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit();
}
