<?php
session_start();
header('Content-Type: application/json');

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'ກະລຸນາເຂົ້າສູ່ລະບົບກ່ອນ']);
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once '../includes/db_con.php';
require_once '../libs/GmailSMTPMailer.php';
require_once '../libs/PDFGenerator.php';

try {
    // รับ order_id จาก POST
    $input = json_decode(file_get_contents('php://input'), true);
    $order_id = $input['order_id'] ?? '';
    
    if (empty($order_id)) {
        throw new Exception('ບໍ່ພົບເລກທີ່ອໍເດີ');
    }
    
    // ดึงข้อมูลออเดอร์
    $order_query = "SELECT o.*, c.cus_name, c.cus_tel, 
                           cur.currencys_symbol, cur.currencys_name,
                           u.full_name as user_name
                    FROM orders o 
                    LEFT JOIN customers c ON o.cus_id = c.cus_id
                    LEFT JOIN currencys cur ON o.currencys_id = cur.currencys_id
                    LEFT JOIN user u ON o.user_id = u.id
                    WHERE o.order_id = ?";
    
    $stmt = $conn->prepare($order_query);
    $stmt->bind_param("s", $order_id);
    $stmt->execute();
    $order_result = $stmt->get_result();
    
    if ($order_result->num_rows == 0) {
        throw new Exception('ບໍ່ພົບຂໍ້ມູນອໍເດີ');
    }
    
    $order = $order_result->fetch_assoc();
    
    // สร้าง token สำหรับการอนุมัติ
    $secret_key = 'sokxay_secret_2024'; // เปลี่ยนเป็น key ของคุณ
    $token = md5($order_id . $secret_key);
    
    // สร้าง URL สำหรับอนุมัติ
    $base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
    $approve_url = $base_url . "/sokxay/api/approve_order.php?order_id=" . urlencode($order_id) . "&token=" . $token . "&action=approve";
    $reject_url = $base_url . "/sokxay/api/approve_order.php?order_id=" . urlencode($order_id) . "&token=" . $token . "&action=reject";
    $pdf_url = $base_url . "/sokxay/view_quotation.php?order_id=" . urlencode($order_id) . "&token=" . $token;
    
    // สร้างเนื้อหาอีเมล HTML พร้อมลิงก์ PDF
    $email_body = generateEmailHTML($order, $approve_url, $reject_url, $pdf_url);
    
    // โหลดการตั้งค่าอีเมล
    require_once '../includes/email_config.php';
    
    // ตั้งค่าหัวข้ออีเมล
    $subject = 'ໃບສະເໜີລາຄາ - ' . $order_id . ' ລໍຖ້າການອະນຸມັດ';
    
    // ส่งอีเมลผ่าน Gmail SMTP
    $mailer = new GmailSMTPMailer();
    $mail_sent = $mailer->send(TO_EMAIL, $subject, $email_body);
    
    if ($mail_sent) {
        echo json_encode([
            'success' => true,
            'message' => 'ສົ່ງອີເມລສຳເລັດ',
            'order_id' => $order_id
        ]);
    } else {
        throw new Exception('ບໍ່ສາມາດສົ່ງອີເມລໄດ້');
    }
    
    $stmt->close();
    $conn->close();
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

function generateEmailHTML($order, $approve_url, $reject_url, $pdf_url) {
    $currency_symbol = htmlspecialchars($order['currencys_symbol'] ?? '₭');
    $order_id = htmlspecialchars($order['order_id']);
    $cus_name = htmlspecialchars($order['cus_name'] ?? 'ບໍ່ລະບຸ');
    $section = htmlspecialchars($order['section'] ?? '');
    $order_total = number_format($order['order_total'], 2);
    $user_name = htmlspecialchars($order['user_name'] ?? '');
    
    return <<<HTML
<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: 'Noto Sans Lao', Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 30px;
        }
        .greeting {
            font-size: 18px;
            color: #333;
            margin-bottom: 20px;
        }
        .order-info {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .order-info h3 {
            margin-top: 0;
            color: #667eea;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: bold;
            color: #555;
        }
        .info-value {
            color: #333;
        }
        .buttons {
            text-align: center;
            margin: 30px 0;
        }
        .btn {
            display: inline-block;
            padding: 15px 40px;
            margin: 10px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            font-size: 16px;
            transition: all 0.3s;
        }
        .btn-approve {
            background: #28a745;
            color: white;
        }
        .btn-approve:hover {
            background: #218838;
        }
        .btn-reject {
            background: #dc3545;
            color: white;
        }
        .btn-reject:hover {
            background: #c82333;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #666;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h1>🎯 ໃບສະເໜີລາຄາ</h1>
        </div>
        
        <div class="content">
            <div class="greeting">
                <strong>ສະບາຍດີ ຫົວໜ້າ,</strong>
            </div>
            
            <p>ນີ້ເປັນໃບສະເໜີລາຄາ ຊ່ວຍພິຈາລະນາ</p>
            
            <div class="order-info">
                <h3>📋 ໃບສະເໜີລາຄາ</h3>
                <p style="text-align: center; font-size: 16px; color: #666;">
                    ໃບສະເໜີລາຄາເລກທີ່: <strong style="color: #667eea;">$order_id</strong><br>
                    ລູກຄ້າ: <strong>$cus_name</strong><br>
                    ຍອດລວມ: <strong style="color: #28a745;">$currency_symbol $order_total</strong>
                </p>
                <div style="text-align: center; margin: 20px 0;">
                    <a href="$pdf_url" style="display: inline-block; padding: 12px 30px; background: #17a2b8; color: white; text-decoration: none; border-radius: 5px; font-weight: bold;">
                        📄 ເປີດໃບສະເໜີລາຄາ PDF
                    </a>
                </div>
            </div>
            
            <p style="text-align: center; margin: 20px 0; color: #666;">
                ກະລຸນາກົດປຸ່ມຂ້າງລຸ່ມນີ້ເພື່ອອະນຸມັດຫຼືປະຕິເສດໃບສະເໜີລາຄາ
            </p>
            
            <div class="buttons">
                <a href="$approve_url" class="btn btn-approve">✓ ອະນຸມັດ</a>
                <a href="$reject_url" class="btn btn-reject">✗ ບໍ່ອະນຸມັດ</a>
            </div>
        </div>
        
        <div class="footer">
            <p>ອີເມລນີ້ຖືກສົ່ງໂດຍອັດຕະໂນມັດຈາກລະບົບ Sokxay</p>
            <p>© 2024 Wayha Sokxay Technology CO.,LTD</p>
        </div>
    </div>
</body>
</html>
HTML;
}
