<?php
session_start();
header('Content-Type: application/json');

// Enable basic error reporting for debugging (can be turned off in production)
ini_set('display_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'unauthorized']);
    exit();
}
require_once '../includes/db_con.php';
$user_id = $_SESSION['user_id'];
// รับ order_id เป็น array (หรือ mark ทั้งหมด)
$input = json_decode(file_get_contents('php://input'), true);
$order_ids = isset($input['order_ids']) && is_array($input['order_ids']) ? $input['order_ids'] : [];
if (empty($order_ids)) {
    echo json_encode(['error' => 'no_order_ids']);
    exit();
}

$stmt = $conn->prepare("INSERT IGNORE INTO notifications_read (user_id, order_id) VALUES (?, ?)");
if ($stmt === false) {
    echo json_encode(['error' => 'db_prepare_failed', 'db_error' => $conn->error]);
    exit();
}

foreach ($order_ids as $oid) {
    if (!$stmt->bind_param('is', $user_id, $oid)) {
        echo json_encode(['error' => 'db_bind_failed', 'db_error' => $stmt->error]);
        $stmt->close();
        exit();
    }
    if (!$stmt->execute()) {
        echo json_encode(['error' => 'db_execute_failed', 'db_error' => $stmt->error]);
        $stmt->close();
        exit();
    }
}
$stmt->close();
echo json_encode(['success' => true]);
