<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');

session_start();

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'ไม่ได้รับอนุญาต']);
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once '../includes/db_con.php';

try {
    // ดึงข้อมูลสินค้าทั้งหมด พร้อม JOIN กับ detail_product
    $products_query = "
        SELECT 
            p.*,
            COALESCE(t.types_name, 'ບໍ່ມີປະເພດ') as types_name,
            dp.detail_text
        FROM products p 
        LEFT JOIN types_product t ON p.types_id = t.types_id 
        LEFT JOIN detail_product dp ON p.detail_product_id = dp.detail_product_id
        ORDER BY p.pro_name
    ";
    
    $result = $conn->query($products_query);
    $products = [];
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $products[] = [
                'pro_id' => $row['pro_id'],
                'pro_name' => $row['pro_name'],
                'pro_price' => floatval($row['pro_price']),
                'pro_detail' => $row['detail_text'] ?? '',
                'types_id' => $row['types_id'],
                'types_name' => $row['types_name'],
                'unit_id' => $row['unit_id']
            ];
        }
    }
    
    // ดึงข้อมูลประเภทสินค้า
    $types_query = "SELECT * FROM types_product ORDER BY types_name";
    $types_result = $conn->query($types_query);
    $types = [];
    
    if ($types_result->num_rows > 0) {
        while ($row = $types_result->fetch_assoc()) {
            $types[] = [
                'types_id' => $row['types_id'],
                'types_name' => $row['types_name']
            ];
        }
    }
    
    echo json_encode([
        'success' => true,
        'products' => $products,
        'types' => $types
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'products' => [],
        'types' => []
    ]);
} finally {
    $conn->close();
}
?>