<?php
session_start();
header('Content-Type: application/json');

// Enable basic error reporting for debugging (can be turned off in production)
ini_set('display_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'unauthorized']);
    exit();
}

require_once '../includes/db_con.php';

$user_id = $_SESSION['user_id'];

$unread = [];

// 1) If `notifications` table exists, fetch unread notifications for this user
$check_tbl = $conn->query("SHOW TABLES LIKE 'notifications'");
if ($check_tbl && $check_tbl->num_rows > 0) {
    $notif_query = "SELECT n.order_id, n.type, n.message, n.created_at, o.section, o.order_date, o.quotation_no, o.invoice_no, c.cus_name
                    FROM notifications n
                    LEFT JOIN orders o ON o.order_id COLLATE utf8mb4_unicode_ci = n.order_id COLLATE utf8mb4_unicode_ci
                    LEFT JOIN customers c ON o.cus_id = c.cus_id
                    WHERE n.user_id = ?
                      AND NOT EXISTS (
                          SELECT 1 FROM notifications_read nr 
                          WHERE nr.user_id = ? 
                          AND nr.order_id COLLATE utf8mb4_unicode_ci = CASE 
                              WHEN n.type LIKE '%invoice%' THEN CONCAT(n.order_id, '_invoice') 
                              ELSE CONCAT(n.order_id, '_quotation') 
                          END
                      )
                    ORDER BY n.created_at DESC
                    LIMIT 20";

    $stmtN = $conn->prepare($notif_query);
    if ($stmtN) {
        $stmtN->bind_param('ii', $user_id, $user_id);
        if ($stmtN->execute()) {
            $resN = $stmtN->get_result();
            if ($resN) {
                while ($r = $resN->fetch_assoc()) {
                    $suffix = (strpos($r['type'], 'invoice') !== false) ? '_invoice' : '_quotation';
                    // normalize fields for client
                    $unread[] = [
                        'order_id' => $r['order_id'],
                        'quotation_no' => $r['quotation_no'],
                        'invoice_no' => $r['invoice_no'],
                        'read_id' => $r['order_id'] . $suffix,
                        'type' => $r['type'],
                        'message' => $r['message'],
                        'section' => $r['section'],
                        'cus_name' => $r['cus_name'],
                        'order_date' => $r['order_date'] ?: $r['created_at'],
                        'created_at' => $r['created_at']
                    ];
                }
            }
        }
        $stmtN->close();
    }
}

// 2) Also include approved orders (previous behavior) that aren't marked read
$approved_orders = [];
$orders_query = "SELECT o.order_id, o.section, o.order_date, o.quotation_no, o.invoice_no, c.cus_name, o.approval_status, o.invoice_approval_status,
                 (SELECT 1 FROM notifications_read nr WHERE nr.user_id = ? AND nr.order_id COLLATE utf8mb4_unicode_ci = CONCAT(o.order_id, '_invoice')) as read_invoice,
                 (SELECT 1 FROM notifications_read nr WHERE nr.user_id = ? AND nr.order_id COLLATE utf8mb4_unicode_ci = CONCAT(o.order_id, '_quotation')) as read_quotation
                 FROM orders o
                 LEFT JOIN customers c ON o.cus_id = c.cus_id
                 WHERE (o.approval_status = 'approved' OR o.approval_status = 'rejected' OR o.invoice_approval_status = 'approved' OR o.invoice_approval_status = 'rejected')
                 AND o.order_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
                 ORDER BY o.order_date DESC
                 LIMIT 10";

$stmt = $conn->prepare($orders_query);
if ($stmt) {
    $stmt->bind_param('ii', $user_id, $user_id);
    if ($stmt->execute()) {
        $result = $stmt->get_result();
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                // Check if already in unread list (from notifications table) to avoid duplicates
                // We need to check specifically for the type now
                
                // 1. Invoice Status
                if (($row['invoice_approval_status'] == 'approved' || $row['invoice_approval_status'] == 'rejected') && !$row['read_invoice']) {
                    // Check duplicate in unread
                    $is_dup = false;
                    foreach($unread as $u) {
                        if($u['order_id'] == $row['order_id'] && strpos($u['type'], 'invoice') !== false) {
                            $is_dup = true; break;
                        }
                    }
                    if (!$is_dup) {
                        $type = ($row['invoice_approval_status'] == 'approved') ? 'invoice_approved' : 'invoice_rejected';
                        $approved_orders[] = [
                            'order_id' => $row['order_id'],
                            'quotation_no' => $row['quotation_no'],
                            'invoice_no' => $row['invoice_no'],
                            'read_id' => $row['order_id'] . '_invoice',
                            'type' => $type,
                            'message' => null,
                            'section' => $row['section'],
                            'cus_name' => $row['cus_name'],
                            'order_date' => $row['order_date'],
                            'created_at' => $row['order_date']
                        ];
                    }
                }

                // 2. Quotation Status
                if (($row['approval_status'] == 'approved' || $row['approval_status'] == 'rejected') && !$row['read_quotation']) {
                    // Check duplicate in unread
                    $is_dup = false;
                    foreach($unread as $u) {
                        if($u['order_id'] == $row['order_id'] && strpos($u['type'], 'invoice') === false) {
                            $is_dup = true; break;
                        }
                    }
                    if (!$is_dup) {
                        $type = ($row['approval_status'] == 'approved') ? 'approved' : 'rejected';
                        $approved_orders[] = [
                            'order_id' => $row['order_id'],
                            'quotation_no' => $row['quotation_no'],
                            'invoice_no' => $row['invoice_no'],
                            'read_id' => $row['order_id'] . '_quotation',
                            'type' => $type,
                            'message' => null,
                            'section' => $row['section'],
                            'cus_name' => $row['cus_name'],
                            'order_date' => $row['order_date'],
                            'created_at' => $row['order_date']
                        ];
                    }
                }
            }
        }
    }
    $stmt->close();
}

// Merge unread notifications: notifications first, then approved orders
$unread = array_merge($unread, $approved_orders);

$unread_count = count($unread);

// recent_read: keep previous behavior (from notifications_read -> orders)
$recent_read = [];
$read_query = "SELECT nr.order_id as read_id_val, o.order_id, o.section, o.order_date, o.quotation_no, o.invoice_no, c.cus_name, nr.read_at, o.approval_status, o.invoice_approval_status
               FROM notifications_read nr
               JOIN orders o ON nr.order_id COLLATE utf8mb4_unicode_ci LIKE CONCAT(o.order_id COLLATE utf8mb4_unicode_ci, '_%')
               LEFT JOIN customers c ON o.cus_id = c.cus_id
               WHERE nr.user_id = ?
               ORDER BY nr.read_at DESC
               LIMIT 10";
$stmt2 = $conn->prepare($read_query);
if ($stmt2) {
    $stmt2->bind_param('i', $user_id);
    if ($stmt2->execute()) {
        $res2 = $stmt2->get_result();
        if ($res2) {
            while ($r = $res2->fetch_assoc()) {
                // Determine type from the suffix in read_id_val
                $is_invoice = (strpos($r['read_id_val'], '_invoice') !== false);
                
                if ($is_invoice) {
                    // ถ้า invoice_approval_status เป็น NULL → ไม่แสดง
                    if (empty($r['invoice_approval_status'])) {
                        continue;
                    }
                    $type = ($r['invoice_approval_status'] == 'rejected') ? 'invoice_rejected' : 'invoice_approved';
                } else {
                    // ถ้า approval_status เป็น NULL → ไม่แสดง
                    if (empty($r['approval_status'])) {
                        continue;
                    }
                    $type = ($r['approval_status'] == 'rejected') ? 'rejected' : 'approved';
                }

                $recent_read[] = [
                    'order_id' => $r['order_id'],
                    'quotation_no' => $r['quotation_no'],
                    'invoice_no' => $r['invoice_no'],
                    'read_id' => $r['read_id_val'],
                    'type' => $type,
                    'section' => $r['section'],
                    'cus_name' => $r['cus_name'],
                    'order_date' => $r['order_date'],
                    'read_at' => $r['read_at']
                ];
            }
        }
    }
    $stmt2->close();
}

echo json_encode([
    'unread_count' => $unread_count,
    'unread' => $unread,
    'recent_read' => $recent_read
]);
