<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../includes/db_con.php';

try {
    // ดึงข้อมูลสกุลเงินและอัตราแลกเปลี่ยนล่าสุด (ยกเว้นเงินกีบ)
    $sql = "SELECT c.currencys_id, c.currencys_name, c.currencys_fullname, c.currencys_symbol, r.rate_amount, r.rate_id
            FROM currencys c
            JOIN rates r ON c.currencys_id = r.currencys_id
            WHERE c.currencys_id != 'CUR_1' 
            AND r.rate_datetime = (
                SELECT MAX(rate_datetime) 
                FROM rates 
                WHERE currencys_id = c.currencys_id
            )
            GROUP BY c.currencys_symbol
            ORDER BY c.currencys_name";
    $result = $conn->query($sql);
    $currencies = [];
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $currencies[] = [
                'id' => $row['currencys_id'],
                'name' => $row['currencys_name'],
                'symbol' => $row['currencys_symbol'],
                'rate' => floatval($row['rate_amount']),
                'rate_id' => $row['rate_id']
            ];
        }
    }
    
    // เพิ่มข้อมูล debug
    error_log("Latest rate currencies found: " . count($currencies));
    foreach ($currencies as $currency) {
        error_log("Currency: " . $currency['name'] . " (" . $currency['symbol'] . ") Rate: " . $currency['rate']);
    }
    
    echo json_encode([
        'success' => true,
        'data' => $currencies,
        'message' => 'ดึงข้อมูลสกุลเงิน ' . count($currencies) . ' สกุล (อัตราล่าสุด)'
    ]);

} catch (Exception $e) {
    error_log("Error in get_currencies.php: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'เกิดข้อผิดพลาดในการดึงข้อมูลสกุลเงิน: ' . $e->getMessage()
    ]);
}

$conn->close();
?>