<?php
// ไม่ต้องส่ง JSON header เพราะจะแสดง HTML

// เชื่อมต่อฐานข้อมูล
require_once '../includes/db_con.php';

try {
    // รับพารามิเตอร์จาก URL
    $order_id = isset($_GET['order_id']) ? $_GET['order_id'] : '';
    $token = isset($_GET['token']) ? $_GET['token'] : '';
    $action = isset($_GET['action']) ? $_GET['action'] : ''; // 'approve' หรือ 'reject'
    
    if (empty($order_id) || empty($token) || empty($action)) {
        throw new Exception('ข้อมูลไม่ครบถ้วน');
    }
    
    // ตรวจสอบ token (ใช้ MD5 ของ order_id + secret key)
    $secret_key = 'sokxay_secret_2024'; // เปลี่ยนเป็น key ของคุณ
    $expected_token = md5($order_id . $secret_key);
    
    if ($token !== $expected_token) {
        throw new Exception('Token ไม่ถูกต้อง');
    }
    
    // ตรวจสอบว่ามี order นี้หรือไม่ และดึงข้อมูลสถานะพื้นฐาน
    $check_stmt = $conn->prepare("SELECT order_id, approval_status, not_approve_reason FROM orders WHERE order_id = ?");
    $check_stmt->bind_param("s", $order_id);
    $check_stmt->execute();
    $result = $check_stmt->get_result();
    
    if ($result->num_rows == 0) {
        throw new Exception('ไม่พบออเดอร์นี้');
    }
    
    $order = $result->fetch_assoc();

    // พยายามอ่านคอลัมน์ approval_changed_at หากมีในฐานข้อมูล (เพื่อรองรับ schema เก่า)
    $existing_time = null;
    $col_check = $conn->query("SHOW COLUMNS FROM orders LIKE 'approval_changed_at'");
    if ($col_check && $col_check->num_rows > 0) {
        $time_stmt = $conn->prepare("SELECT approval_changed_at FROM orders WHERE order_id = ? LIMIT 1");
        $time_stmt->bind_param("s", $order_id);
        $time_stmt->execute();
        $time_res = $time_stmt->get_result();
        if ($time_res && $time_res->num_rows > 0) {
            $r = $time_res->fetch_assoc();
            $existing_time = $r['approval_changed_at'];
        }
        $time_stmt->close();
    }
    
    // ถ้าสถานะใน DB ตรงกับ action ที่ผู้ใช้กด ให้แสดงข้อความพร้อมเวลาที่บันทึกไว้
    $existing_status = $order['approval_status'];
    $existing_reason = $order['not_approve_reason'] ?? '';
    //$existing_time already retrieved above (or null if column missing)

    // ถ้าสถานะใน DB เป็น already approved และผู้ใช้พยายามกด 'reject' -> ห้ามเปลี่ยน
    if ($existing_status === 'approved' && $action === 'reject') {
        $when = $existing_time ? date('d/m/Y H:i:s', strtotime($existing_time)) : 'ไม่ระบุเวลา';
        showApprovalPage('ບໍ່ສາມາດປະຕິເສດ', 'ຫົວໜ້າໄດ້ອະນຸມັດໄປແລ້ວ ບໍ່ສາມາດ ປະຕິເສດໄດ້ เมื่อ ' . $when, 'error');
        exit();
    }

    if ($existing_status === 'approved' && $action === 'approve') {
        $when = $existing_time ? date('d/m/Y H:i:s', strtotime($existing_time)) : 'ไม่ระบุเวลา';
        showApprovalPage('ອະນຸມັດແລ້ວ', 'ຫົວໜ້າໄດ້ອະນຸມັດໃບສະເໜີລາຄານີ້ໄປແລ້ວ เมื่อ ' . $when, 'success');
        exit();
    }

    // ถ้าสถานะใน DB เป็น 'rejected' และผู้ใช้พยายามกด 'approve' -> ห้ามเปลี่ยน
    if ($existing_status === 'rejected' && $action === 'approve') {
        $when = $existing_time ? date('d/m/Y H:i:s', strtotime($existing_time)) : 'ไม่ระบุเวลา';
        $msg = 'ຫົວໜ້າໄດ້ປະຕິເສດກ່ອນແລ້ວ';
        if (!empty($existing_reason)) {
            $msg .= ' ຍ້ອນເຫດ: ' . htmlspecialchars($existing_reason);
        }
        $msg .= ' ເມື່ອ ' . $when . '. ບໍ່ສາມາດ ອະນຸມັດໄດ້.';
        showApprovalPage('ບໍ່ສາມາດອະນຸມັດ', $msg, 'error');
        exit();
    }

    if ($existing_status === 'rejected' && $action === 'reject') {
        $when = $existing_time ? date('d/m/Y H:i:s', strtotime($existing_time)) : 'ไม่ระบุเวลา';
        $msg = 'ຫົວໜ້າໄດ້ປະຕິເສດ ການອະນຸມັດໃບສະເໜີລາຄານີ້ໄປແລ້ວ';
        if (!empty($existing_reason)) {
            $msg .= ' ຍ້ອນເຫດ: ' . htmlspecialchars($existing_reason);
        }
        $msg .= ' เมื่อ ' . $when;
        showApprovalPage('ປະຕິເສດແລ້ວ', $msg, 'error');
        exit();
    }

    // อัปเดตสถานะการอนุมัติ (ถ้า action เป็น approve ให้เป็น 'approved' มิฉะนั้นถ้าเป็น reject จะถูกจัดการโดย submit_rejection)
    $new_status = ($action === 'approve') ? 'approved' : 'pending';
    // ตรวจสอบว่ามีคอลัมน์ approval_changed_at หรือไม่ เพื่อให้รองรับ schema เก่า
    $col_check2 = $conn->query("SHOW COLUMNS FROM orders LIKE 'approval_changed_at'");
    if ($col_check2 && $col_check2->num_rows > 0) {
        $update_stmt = $conn->prepare("UPDATE orders SET approval_status = ?, not_approve_reason = NULL, approval_changed_at = NOW() WHERE order_id = ?");
    } else {
        $update_stmt = $conn->prepare("UPDATE orders SET approval_status = ?, not_approve_reason = NULL WHERE order_id = ?");
    }
    $update_stmt->bind_param("ss", $new_status, $order_id);
    
    if ($update_stmt->execute()) {
        if ($action === 'approve') {
            // อนุมัติ
            showApprovalPage(
                'ອະນຸມັດສຳເລັດ!', 
                'ໃບສະເໜີລາຄາເລກທີ່ ' . htmlspecialchars($order_id) . ' ໄດ້ຮັບການອະນຸມັດແລ້ວ',
                'success'
            );

            // สร้างการแจ้งเตือนสำหรับผู้ที่เกี่ยวข้อง (ตัวอย่าง: ผู้สร้างออเดอร์)
            try {
                // ดึง user_id ของผู้สร้างออเดอร์
                $owner_stmt = $conn->prepare("SELECT user_id FROM orders WHERE order_id = ? LIMIT 1");
                $owner_stmt->bind_param("s", $order_id);
                $owner_stmt->execute();
                $owner_res = $owner_stmt->get_result();
                $notify_user_id = null;
                if ($owner_res && $owner_res->num_rows > 0) {
                    $row = $owner_res->fetch_assoc();
                    $notify_user_id = !empty($row['user_id']) ? (int)$row['user_id'] : null;
                }
                $owner_stmt->close();

                // ถ้าไม่พบผู้ใช้เจ้าของ ให้ใช้ admin (id=1) เป็น fallback
                if (empty($notify_user_id)) {
                    $notify_user_id = 1;
                }

                $notif_type = 'quotation_approved';
                $notif_message = 'ໃບສະເໜີລາຄາ ' . $order_id . ' ໄດ້ຮັບການອະນຸມັດແລ້ວ';

                // ตรวจสอบว่า table `notifications` มีอยู่
                $check_table = $conn->query("SHOW TABLES LIKE 'notifications'");
                if ($check_table && $check_table->num_rows > 0) {
                    $ins = $conn->prepare("INSERT INTO notifications (`order_id`,`user_id`,`type`,`message`,`created_at`) VALUES (?,?,?,?,NOW())");
                    if ($ins) {
                        $ins->bind_param("siss", $order_id, $notify_user_id, $notif_type, $notif_message);
                        $ins->execute();
                        $ins->close();

                        // ลบสถานะ "อ่านแล้ว" ออก เพื่อให้แจ้งเตือนเด้งใหม่
                        $del_read = $conn->prepare("DELETE FROM notifications_read WHERE order_id = ? AND user_id = ?");
                        if ($del_read) {
                            $del_read->bind_param("si", $order_id, $notify_user_id);
                            $del_read->execute();
                            $del_read->close();
                        }
                    }
                }
            } catch (Exception $e) {
                // ไม่บล็อก flow ถ้ามีปัญหาในการบันทึกแจ้งเตือน
                error_log('Notification insert failed: ' . $e->getMessage());
            }

        } else {
            // ไม่อนุมัติ - แสดงฟอร์มกรอกเหตุผล
            showRejectForm($order_id, $token);
        }
    } else {
        throw new Exception('ไม่สามารถอัปเดตสถานะได้');
    }
    
    $check_stmt->close();
    $update_stmt->close();
    $conn->close();
    
} catch (Exception $e) {
    showApprovalPage('ເກີດຂໍ້ຜິດພາດ', $e->getMessage(), 'error');
}

function showApprovalPage($title, $message, $type = 'success') {
    $color = ($type === 'success') ? '#28a745' : (($type === 'error') ? '#dc3545' : '#ffc107');
    $icon = ($type === 'success') ? '✓' : (($type === 'error') ? '✗' : '!');
    ?>
    <!DOCTYPE html>
    <html lang="lo">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo htmlspecialchars($title); ?></title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: 'Noto Sans Lao', Arial, sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .container {
                background: white;
                padding: 40px;
                border-radius: 15px;
                box-shadow: 0 10px 40px rgba(0,0,0,0.2);
                max-width: 500px;
                width: 100%;
                text-align: center;
            }
            .icon {
                width: 80px;
                height: 80px;
                background: <?php echo $color; ?>;
                color: white;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 48px;
                margin: 0 auto 20px;
            }
            h1 {
                color: #333;
                margin-bottom: 15px;
                font-size: 28px;
            }
            p {
                color: #666;
                font-size: 16px;
                line-height: 1.6;
            }
            .btn {
                display: inline-block;
                margin-top: 20px;
                padding: 12px 30px;
                background: <?php echo $color; ?>;
                color: white;
                text-decoration: none;
                border-radius: 5px;
                font-weight: bold;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="icon"><?php echo $icon; ?></div>
            <h1><?php echo htmlspecialchars($title); ?></h1>
            <p><?php echo htmlspecialchars($message); ?></p>
        </div>
    </body>
    </html>
    <?php
    exit();
}

function showRejectForm($order_id, $token) {
    ?>
    <!DOCTYPE html>
    <html lang="lo">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>ບໍ່ອະນຸມັດ - ກະລຸນາລະບຸເຫດຜົນ</title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: 'Noto Sans Lao', Arial, sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .container {
                background: white;
                padding: 40px;
                border-radius: 15px;
                box-shadow: 0 10px 40px rgba(0,0,0,0.2);
                max-width: 500px;
                width: 100%;
            }
            h1 {
                color: #333;
                margin-bottom: 20px;
                font-size: 24px;
                text-align: center;
            }
            .form-group {
                margin-bottom: 20px;
            }
            label {
                display: block;
                margin-bottom: 8px;
                color: #555;
                font-weight: bold;
            }
            textarea {
                width: 100%;
                padding: 12px;
                border: 2px solid #ddd;
                border-radius: 5px;
                font-family: 'Noto Sans Lao', Arial, sans-serif;
                font-size: 14px;
                resize: vertical;
                min-height: 120px;
            }
            textarea:focus {
                outline: none;
                border-color: #667eea;
            }
            .btn {
                width: 100%;
                padding: 14px;
                background: #dc3545;
                color: white;
                border: none;
                border-radius: 5px;
                font-size: 16px;
                font-weight: bold;
                cursor: pointer;
                transition: background 0.3s;
            }
            .btn:hover {
                background: #c82333;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <h1>ບໍ່ອະນຸມັດໃບສະເໜີລາຄາ</h1>
            <form method="POST" action="submit_rejection.php">
                <input type="hidden" name="order_id" value="<?php echo htmlspecialchars($order_id); ?>">
                <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
                
                <div class="form-group">
                    <label>ກະລຸນາລະບຸເຫດຜົນທີ່ບໍ່ອະນຸມັດ:</label>
                    <textarea name="reason" required placeholder="ເຫດຜົນ..."></textarea>
                </div>
                
                <button type="submit" class="btn">ສົ່ງເຫດຜົນ</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit();
}
