<?php
// หน้าอนุมัติ/ปฏิเสธสำหรับ Invoice (อัปเดต invoice_approval_status)
require_once '../includes/db_con.php';

try {
    $order_id = isset($_GET['order_id']) ? $_GET['order_id'] : '';
    $token = isset($_GET['token']) ? $_GET['token'] : '';
    $action = isset($_GET['action']) ? $_GET['action'] : ''; // 'approve' or 'reject'

    if (empty($order_id) || empty($token) || empty($action)) throw new Exception('ข้อมูลไม่ครบถ้วน');

    $secret_key = 'sokxay_secret_2024';
    $expected_token = md5($order_id . $secret_key);
    if ($token !== $expected_token) throw new Exception('Token ไม่ถูกต้อง');

    $check_stmt = $conn->prepare("SELECT order_id, invoice_approval_status, invoice_not_approve_reason FROM orders WHERE order_id = ?");
    $check_stmt->bind_param('s', $order_id);
    $check_stmt->execute();
    $result = $check_stmt->get_result();
    if ($result->num_rows == 0) throw new Exception('ไม่พบออเดอร์นี้');
    $order = $result->fetch_assoc();
    // ดึงเวลาการเปลี่ยนสถานะถ้ามี (รองรับ schema เก่า)
    $existing_time = null;
    $col_check = $conn->query("SHOW COLUMNS FROM orders LIKE 'approval_changed_at'");
    if ($col_check && $col_check->num_rows > 0) {
        $time_stmt = $conn->prepare("SELECT approval_changed_at FROM orders WHERE order_id = ? LIMIT 1");
        $time_stmt->bind_param("s", $order_id);
        $time_stmt->execute();
        $time_res = $time_stmt->get_result();
        if ($time_res && $time_res->num_rows > 0) {
            $r = $time_res->fetch_assoc();
            $existing_time = $r['approval_changed_at'];
        }
        $time_stmt->close();
    }

    $existing_status = $order['invoice_approval_status'];
    $existing_reason = $order['invoice_not_approve_reason'] ?? '';
    // หากสถานะใน DB เป็น 'approved' และผู้ใช้พยายาม 'reject' ให้บล็อกการกระทำนี้
    if ($existing_status === 'approved' && $action === 'reject') {
        $when = $existing_time ? date('d/m/Y H:i:s', strtotime($existing_time)) : 'ไม่ระบุเวลา';
        showApprovalPage('ບໍ່ສາມາດປະຕິເສດ', 'ຫົວໜ້າໄດ້ອະນຸມັດໄປແລ້ວ ບໍ່ສາມາດ ປະຕິເສດໄດ້ เมื่อ ' . $when, 'error');
        exit();
    }

    if ($existing_status === 'approved' && $action === 'approve') {
        $when = $existing_time ? date('d/m/Y H:i:s', strtotime($existing_time)) : 'ไม่ระบุเวลา';
        showApprovalPage('ອະນຸມັດແລ້ວ', 'ໃບເກັບເງິນນີ້ໄດ້ຮັບການອະນຸມັດແລ້ວ เมื่อ ' . $when, 'success');
        exit();
    }

    // หากสถานะใน DB เป็น 'rejected' และผู้ใช้พยายาม 'approve' ให้บล็อกการกระทำนี้
    if ($existing_status === 'rejected' && $action === 'approve') {
        $when = $existing_time ? date('d/m/Y H:i:s', strtotime($existing_time)) : 'ไม่ระบุเวลา';
        $msg = 'ຫົວໜ້າໄດ້ປະຕິເສດກ່ອນແລ້ວ';
        if (!empty($existing_reason)) $msg .= ' ຍ້ອນເຫດ: ' . htmlspecialchars($existing_reason);
        $msg .= ' ເມື່ອ ' . $when . '. ບໍ່ສາມາດ ອະນຸມັດໄດ້.';
        showApprovalPage('ບໍ່ສາມາດອະນຸມັດ', $msg, 'error');
        exit();
    }

    if ($existing_status === 'rejected' && $action === 'reject') {
        $when = $existing_time ? date('d/m/Y H:i:s', strtotime($existing_time)) : 'ไม่ระบุเวลา';
        $msg = 'ຫົວໜ້າໄດ້ປະຕິເສດ ການອະນຸມັດໃບເກັບເງິນນີ້ໄປແລ້ວ';
        if (!empty($existing_reason)) $msg .= ' ຍ້ອນເຫດ: ' . htmlspecialchars($existing_reason);
        $msg .= ' เมื่อ ' . $when;
        showApprovalPage('ປະຕິເສດແລ້ວ', $msg, 'error');
        exit();
    }

    $new_status = ($action === 'approve') ? 'approved' : 'pending';

    // เตรียม SQL อัปเดตโดยคำนึงถึงว่ามีคอลัมน์ approval_changed_at หรือไม่
    $col_check2 = $conn->query("SHOW COLUMNS FROM orders LIKE 'approval_changed_at'");
    if ($col_check2 && $col_check2->num_rows > 0) {
        $update_stmt = $conn->prepare("UPDATE orders SET invoice_approval_status = ?, invoice_not_approve_reason = NULL, approval_changed_at = NOW() WHERE order_id = ?");
    } else {
        $update_stmt = $conn->prepare("UPDATE orders SET invoice_approval_status = ?, invoice_not_approve_reason = NULL WHERE order_id = ?");
    }
    $update_stmt->bind_param('ss', $new_status, $order_id);
    if ($update_stmt->execute()) {
        if ($action === 'approve') {
            showApprovalPage('ອະນຸມັດສຳເລັດ!', 'ໃບເກັບເງິນເລກທີ່ ' . htmlspecialchars($order_id) . ' ໄດ້ຮັບການອະນຸມັດແລ້ວ', 'success');

            // สร้างการแจ้งเตือนสำหรับผู้ที่เกี่ยวข้อง (ตัวอย่าง: ผู้สร้างออเดอร์)
            try {
                // ดึง user_id ของผู้สร้างออเดอร์
                $owner_stmt = $conn->prepare("SELECT user_id FROM orders WHERE order_id = ? LIMIT 1");
                $owner_stmt->bind_param("s", $order_id);
                $owner_stmt->execute();
                $owner_res = $owner_stmt->get_result();
                $notify_user_id = null;
                if ($owner_res && $owner_res->num_rows > 0) {
                    $row = $owner_res->fetch_assoc();
                    $notify_user_id = !empty($row['user_id']) ? (int)$row['user_id'] : null;
                }
                $owner_stmt->close();

                // ถ้าไม่พบผู้ใช้เจ้าของ ให้ใช้ admin (id=1) เป็น fallback
                if (empty($notify_user_id)) {
                    $notify_user_id = 1;
                }

                $notif_type = 'invoice_approved';
                $notif_message = 'ໃບເກັບເງິນ ' . $order_id . ' ໄດ້ຮັບການອະນຸມັດແລ້ວ';

                // ตรวจสอบว่า table `notifications` มีอยู่
                $check_table = $conn->query("SHOW TABLES LIKE 'notifications'");
                if ($check_table && $check_table->num_rows > 0) {
                    $ins = $conn->prepare("INSERT INTO notifications (`order_id`,`user_id`,`type`,`message`,`created_at`) VALUES (?,?,?,?,NOW())");
                    if ($ins) {
                        $ins->bind_param("siss", $order_id, $notify_user_id, $notif_type, $notif_message);
                        $ins->execute();
                        $ins->close();

                        // ลบสถานะ "อ่านแล้ว" ออก เพื่อให้แจ้งเตือนเด้งใหม่
                        $del_read = $conn->prepare("DELETE FROM notifications_read WHERE order_id = ? AND user_id = ?");
                        if ($del_read) {
                            $del_read->bind_param("si", $order_id, $notify_user_id);
                            $del_read->execute();
                            $del_read->close();
                        }
                    }
                }
            } catch (Exception $e) {
                // ไม่บล็อก flow ถ้ามีปัญหาในการบันทึกแจ้งเตือน
                error_log('Notification insert failed: ' . $e->getMessage());
            }

        } else {
            showRejectForm($order_id, $token);
        }
    } else {
        throw new Exception('ไม่สามารถอัปเดตสถานะได้');
    }

    $check_stmt->close();
    $update_stmt->close();
    $conn->close();

} catch (Exception $e) {
    showApprovalPage('ເກີດຂໍ້ຜິດພາດ', $e->getMessage(), 'error');
}

function showApprovalPage($title, $message, $type = 'success') {
    $color = ($type === 'success') ? '#28a745' : (($type === 'error') ? '#dc3545' : '#ffc107');
    $icon = ($type === 'success') ? '✓' : (($type === 'error') ? '✗' : '!');
    ?>
    <!DOCTYPE html>
    <html lang="lo">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo htmlspecialchars($title); ?></title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body { font-family: 'Noto Sans Lao', Arial, sans-serif; background: #f7f7f7; min-height: 100vh; display:flex; align-items:center; justify-content:center; }
            .container { background:#fff; padding:40px; border-radius:10px; box-shadow:0 8px 30px rgba(0,0,0,0.12); text-align:center; max-width:640px; }
            .icon { width:80px; height:80px; margin:0 auto 16px; display:flex; align-items:center; justify-content:center; font-size:40px; color:#fff; border-radius:50%; background:<?php echo $color; ?>; }
            h1 { margin-top:12px; margin-bottom:8px; }
            p { color:#555; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="icon"><?php echo $icon; ?></div>
            <h1><?php echo htmlspecialchars($title); ?></h1>
            <p><?php echo htmlspecialchars($message); ?></p>
        </div>
    </body>
    </html>
    <?php
    exit();
}

function showRejectForm($order_id, $token) {
    ?>
    <!DOCTYPE html>
    <html lang="lo">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>ບໍ່ອະນຸມັດ - ກະລຸນາລະບຸເຫດຜົນ</title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body { font-family: 'Noto Sans Lao', Arial, sans-serif; background:#f7f7f7; min-height:100vh; display:flex; align-items:center; justify-content:center; }
            .container { background:white; padding:30px; border-radius:10px; box-shadow:0 8px 30px rgba(0,0,0,0.12); width:90%; max-width:600px; }
            h1 { margin-bottom:12px; }
            .form-group { margin-bottom:12px; }
            textarea { width:100%; min-height:120px; padding:10px; border-radius:6px; border:1px solid #ddd; }
            .btn { padding:10px 14px; border-radius:6px; border:none; background:#dc3545; color:white; cursor:pointer; }
        </style>
    </head>
    <body>
        <div class="container">
            <h1>ບໍ່ອະນຸມັດໃບເກັບເງິນ</h1>
            <form method="POST" action="submit_rejection.php">
                <input type="hidden" name="order_id" value="<?php echo htmlspecialchars($order_id); ?>">
                <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
                <input type="hidden" name="type" value="invoice">
                <div class="form-group">
                    <label>ເຫດຜົນ:</label>
                    <textarea name="reason" required></textarea>
                </div>
                <div style="text-align:right;"><button type="submit" class="btn">ສົ່ງເຫດຜົນ</button></div>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit();
}

?>
