<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

session_start();

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'ไม่ได้รับอนุญาต']);
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once '../includes/db_con.php';

try {
    // รับข้อมูล JSON
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('ข้อมูลไม่ถูกต้อง');
    }
    
    $cus_name = $input['cus_name'] ?? '';
    $cus_tel = $input['cus_tel'] ?? '';
    $cus_address = $input['cus_address'] ?? '';
    
    if (empty($cus_name)) {
        throw new Exception('กรุณาใส่ชื่อลูกค้า');
    }
    
    // ตรวจสอบว่ามีลูกค้าชื่อนี้แล้วหรือไม่
    $check_stmt = $conn->prepare("SELECT cus_id FROM customers WHERE cus_name = ?");
    $check_stmt->bind_param("s", $cus_name);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    
    if ($check_result->num_rows > 0) {
        throw new Exception('มีลูกค้านี้ในระบบแล้ว');
    }
    
    // เพิ่มลูกค้าใหม่ (ปล่อยให้ trigger สร้าง cus_id)
    $stmt = $conn->prepare("INSERT INTO customers (cus_name, cus_tel, cus_address) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $cus_name, $cus_tel, $cus_address);
    
    if ($stmt->execute()) {
        // ดึง cus_id ที่ถูกสร้างโดย trigger
        $new_cus_id = $conn->insert_id;
        $get_cus_stmt = $conn->prepare("SELECT cus_id FROM customers WHERE id = ?");
        $get_cus_stmt->bind_param("i", $new_cus_id);
        $get_cus_stmt->execute();
        $cus_result = $get_cus_stmt->get_result();
        $cus_row = $cus_result->fetch_assoc();
        $generated_cus_id = $cus_row['cus_id'];
        
        echo json_encode([
            'success' => true,
            'message' => 'เพิ่มลูกค้าสำเร็จ',
            'customer_id' => $generated_cus_id,
            'customer_name' => $cus_name,
            'customer_tel' => $cus_tel
        ]);
    } else {
        throw new Exception('ไม่สามารถเพิ่มลูกค้าได้');
    }
    
    $stmt->close();
    $check_stmt->close();
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
?>