<?php
session_start();
// ini_set('display_errors', 1);
// error_reporting(E_ALL);
// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once 'includes/db_con.php';

// ข้อมูลผู้ใช้
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'ผู้ใช้';

// จัดการการส่งฟอร์ม
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // การลบข้อมูล
    if (isset($_POST['action']) && $_POST['action'] == 'delete') {
        $id = intval($_POST['id']);
        if (empty($id)) {
            echo json_encode(['success' => false, 'message' => 'ລະຫັດຫົວໜ່ວຍບໍ່ຖືກຕ້ອງ']);
            exit();
        }

        try {
            // ตรวจสอบว่ามีสินค้าอ้างอิงถึงหน่วยนี้หรือไม่ (ตรวจหลายชื่อตารางคอลัมน์เป็นไปได้)
            $productCols = [];
            $colsRes = $conn->query("SHOW COLUMNS FROM products");
            if ($colsRes) {
                while ($col = $colsRes->fetch_assoc()) {
                    $productCols[] = $col['Field'];
                }
            }

            $count = 0;
            if (!empty($productCols)) {
                // ดึงข้อมูล unit เพื่อใช้ตรวจสอบ
                $stmtUnit = $conn->prepare("SELECT * FROM units WHERE id = ?");
                $stmtUnit->bind_param("i", $id);
                $stmtUnit->execute();
                $unit = $stmtUnit->get_result()->fetch_assoc();
                $stmtUnit->close();

                if ($unit) {
                    $conds = [];
                    $params = [];
                    foreach ($productCols as $col) {
                        if (in_array($col, ['unit', 'unit_id', 'pro_unit'])) {
                            $conds[] = "$col = ?";
                            // ถ้าคอลัมน์เป็น unit_id ให้เปรียบเทียบกับ unit_id ของตาราง units
                            if ($col === 'unit_id') {
                                $params[] = $unit['unit_id'];
                            } else {
                                $params[] = $unit['unit_name'];
                            }
                        }
                    }

                    if (!empty($conds)) {
                        $sql = "SELECT COUNT(*) as count FROM products WHERE " . implode(' OR ', $conds);
                        $checkStmt = $conn->prepare($sql);
                        // สร้าง dynamic bind
                        $types = str_repeat('s', count($params));
                        $checkStmt->bind_param($types, ...$params);
                        $checkStmt->execute();
                        $countRes = $checkStmt->get_result()->fetch_assoc();
                        $count = intval($countRes['count']);
                        $checkStmt->close();
                    }
                }
            }

            if ($count > 0) {
                echo json_encode(['success' => false, 'message' => 'ບໍ່ສາມາດລຶບຫົວໜ່ວຍນີ້ໄດ້ ເພາະມີສິນຄ້າແທກຢູ່']);
                exit();
            }

            // ถ้าไม่มีการอ้างอิง ให้ลบ
            $delete_stmt = $conn->prepare("DELETE FROM units WHERE id = ?");
            $delete_stmt->bind_param("i", $id);

            if ($delete_stmt->execute()) {
                echo json_encode(['success' => true, 'message' => 'ລຶບຫົວໜ່ວຍສຳເລັດແລ້ວ']);
            } else {
                echo json_encode(['success' => false, 'message' => 'ເກີດຂໍ້ຜິດພາດໃນການລຶບ']);
            }
            $delete_stmt->close();
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage()]);
        }
        exit();
    }

    // การแก้ไขข้อมูล
    if (isset($_POST['action']) && $_POST['action'] == 'edit') {
        $id = intval($_POST['id']);
        $unit_name = trim($_POST['unit_name']);

        if (empty($id) || empty($unit_name)) {
            $message = 'ກະລຸນາໃສ່ຂໍ້ມູນໃຫ້ຄົບຖ້ວນ';
            $message_type = 'error';
        } else {
            try {
                // ตรวจสอบชื่อซ้ำ (ยกเว้น ID ปัจจุบัน)
                $check_stmt = $conn->prepare("SELECT id FROM units WHERE unit_name = ? AND id != ?");
                $check_stmt->bind_param("si", $unit_name, $id);
                $check_stmt->execute();

                if ($check_stmt->get_result()->num_rows > 0) {
                    $message = 'ມີຫົວໜ່ວຍນີ້ໃນລະບົບແລ້ວ';
                    $message_type = 'error';
                } else {
                    // อัปเดตข้อมูล
                    $update_stmt = $conn->prepare("UPDATE units SET unit_name = ? WHERE id = ?");
                    $update_stmt->bind_param("si", $unit_name, $id);

                    if ($update_stmt->execute()) {
                        $message = 'ແກ້ໄຂຫົວໜ່ວຍສຳເລັດແລ້ວ';
                        $message_type = 'success';
                    } else {
                        $message = 'ເກີດຂໍ້ຜິດພາດໃນການແກ້ໄຂ';
                        $message_type = 'error';
                    }
                    $update_stmt->close();
                }
                $check_stmt->close();
            } catch (Exception $e) {
                $message = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
                $message_type = 'error';
            }
        }
    }
    // การเพิ่มข้อมูลใหม่
    else {
        $unit_name = trim($_POST['unit_name']);

        if (empty($unit_name)) {
            $message = 'ກະລຸນາໃສ່ຊື່ຫົວໜ່ວຍ';
            $message_type = 'error';
        } else {
            try {
                // ตรวจสอบว่ามีหน่วยนี้แล้วหรือไม่ (ตามชื่อ)
                $check_stmt = $conn->prepare("SELECT id FROM units WHERE unit_name = ?");
                $check_stmt->bind_param("s", $unit_name);
                $check_stmt->execute();

                if ($check_stmt->get_result()->num_rows > 0) {
                    $message = 'ມີຫົວໜ່ວຍນີ້ໃນລະບົບແລ້ວ';
                    $message_type = 'error';
                } else {
                    // เพิ่มหน่วยใหม่ (unit_id จะถูกสร้างโดย trigger ในฐานข้อมูล)
                    $insert_stmt = $conn->prepare("INSERT INTO units (unit_name) VALUES (?)");
                    $insert_stmt->bind_param("s", $unit_name);

                    if ($insert_stmt->execute()) {
                        $message = 'ເພີ່ມຫົວໜ່ວຍສຳເລັດແລ້ວ';
                        $message_type = 'success';

                        // ล้างข้อมูลในฟอร์ม
                        $_POST = [];
                    } else {
                        $message = 'ເກີດຂໍ້ຜິດພາດໃນການເພີ່ມຫົວໜ່ວຍ';
                        $message_type = 'error';
                    }
                    $insert_stmt->close();
                }
                $check_stmt->close();
            } catch (Exception $e) {
                $message = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
                $message_type = 'error';
            }
        }
    }
}

// ดึงข้อมูลหน่วยทั้งหมด
$units_query = "SELECT * FROM units ORDER BY unit_name";
$units_result = $conn->query($units_query);

// เตรียมตัวนับสินค้าที่อ้างอิงหน่วย (ถ้ามีคอลัมน์ที่เกี่ยวข้อง)
$product_counts = [];
$product_cols = [];
$colsRes = $conn->query("SHOW COLUMNS FROM products");
if ($colsRes) {
    while ($c = $colsRes->fetch_assoc()) {
        $product_cols[] = $c['Field'];
    }
}

if ($units_result && !empty($product_cols)) {
    while ($u = $units_result->fetch_assoc()) {
        $count = 0;
        $conds = [];
        $params = [];
        foreach ($product_cols as $col) {
            if (in_array($col, ['unit', 'unit_id', 'pro_unit'])) {
                $conds[] = "$col = ?";
                if ($col === 'unit_id') $params[] = $u['unit_id'];
                else $params[] = $u['unit_name'];
            }
        }

        if (!empty($conds)) {
            $sql = "SELECT COUNT(*) as count FROM products WHERE " . implode(' OR ', $conds);
            $checkStmt = $conn->prepare($sql);
            $types = str_repeat('s', count($params));
            $checkStmt->bind_param($types, ...$params);
            $checkStmt->execute();
            $count = intval($checkStmt->get_result()->fetch_assoc()['count']);
            $checkStmt->close();
        }

        $product_counts[$u['unit_id']] = $count;
    }
    // reset pointer to reuse in rendering
    $units_result->data_seek(0);
}
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sokxay Bill - ເພີ່ມຫົວໜ່ວຍ (Unit)</title>
    <link rel="icon" type="image/png" href="/sokxay/wayha.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/forms.css">
    <style>
        /* reuse some modal styles from types page */
        .modal { display:none; position:fixed; z-index:1000; left:0; top:0; width:100%; height:100%; background:rgba(0,0,0,0.5); overflow:auto; }
        .modal-content { background:#fff; margin:5% auto; padding:0; border-radius:8px; width:90%; max-width:600px; box-shadow:0 4px 20px rgba(0,0,0,0.15); }
        .modal-header { background:var(--primary-color); color:#fff; padding:20px; border-radius:8px 8px 0 0; display:flex; justify-content:space-between; align-items:center; }
        .modal-body { padding:20px; }
        .modal-footer { background:#f8f9fa; padding:15px 20px; border-radius:0 0 8px 8px; display:flex; justify-content:flex-end; gap:10px; }
        .unit-code { background:#e3f2fd; color:#1976d2; padding:4px 8px; border-radius:4px; font-family:monospace; font-weight:600; }
    </style>
</head>
<body>
    <div class="app-container">
        <?php include 'includes/sidebar.php'; ?>

        <main class="main-content">
            <header class="content-header">
                <div class="header-left">
                    <h1 class="page-title">ຫົວໜ່ວຍ (Unit)</h1>
                    <p class="page-subtitle">ຈັດການຫົວໜ່ວຍສິນຄ້າ</p>
                </div>
                <div class="header-right">
                    <button class="btn-primary" onclick="openAddModal()"><i class="fas fa-plus"></i> ເພີ່ມຫົວໜ່ວຍ</button>
                </div>
            </header>

            <div class="content-body">
                <div class="list-container">
                    <div class="list-card">
                        <div class="list-header">
                            <h3><i class="fas fa-list"></i> ລາຍການຫົວໜ່ວຍ</h3>
                        </div>

                        <div class="table-container">
                            <?php if ($units_result && $units_result->num_rows > 0): ?>
                                <table class="data-table">
                                    <thead>
                                        <tr>
                                            <th>ລະຫັດ</th>
                                            <th>ຊື່ຫົວໜ່ວຍ</th>
                                            <th>ຈຳນວນສິນຄ້າ</th>
                                            <th>ການກະທຳ</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($unit = $units_result->fetch_assoc()):
                                            $product_count = $product_counts[$unit['unit_id']] ?? 0;
                                        ?>
                                            <tr>
                                                <td><span class="unit-code"><?php echo htmlspecialchars($unit['unit_id']); ?></span></td>
                                                <td><?php echo htmlspecialchars($unit['unit_name']); ?></td>
                                                <td><span class="product-count"><i class="fas fa-box"></i> <?php echo $product_count; ?> ລາຍການ</span></td>
                                                <td>
                                                    <div class="action-buttons">
                                                        <button class="btn-action btn-edit" onclick="editUnit(<?php echo $unit['id']; ?>)"><i class="fas fa-edit"></i></button>
                                                        <button class="btn-action btn-delete" onclick="deleteUnit(<?php echo $unit['id']; ?>, <?php echo $product_count; ?>)" <?php echo $product_count>0? 'disabled title="ບໍ່ສາມາດລຶບໄດ້"':''; ?>><i class="fas fa-trash"></i></button>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <div class="no-data">
                                    <i class="fas fa-boxes"></i>
                                    <p>ຍັງບໍ່ມີຫົວໜ່ວຍໃນລະບົບ</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Add Modal -->
    <div id="addModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2><i class="fas fa-box"></i> ເພີ່ມຫົວໜ່ວຍ</h2>
                <span class="close" onclick="closeAddModal()">&times;</span>
            </div>
            <div class="modal-body">
                <form id="addForm" method="POST" class="data-form">
                    <div class="form-row">
                        <div class="form-group full-width">
                            <label for="modal_unit_name"><i class="fas fa-ruler"></i> ຊື່ຫົວໜ່ວຍ <span class="required">*</span></label>
                            <input type="text" id="modal_unit_name" name="unit_name" placeholder="ເຊັ່ນ: ຊິ້ນ, ແບດ, ແກຣມ" required>
                            <small>ລະຫັດຈະຖືກສ້າງອັດຕະໂນມັດ</small>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-secondary" onclick="closeAddModal()"><i class="fas fa-times"></i> ຍົກເລີກ</button>
                <button type="button" class="btn-primary" onclick="submitForm()"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2><i class="fas fa-edit"></i> ແກ້ໄຂຫົວໜ່ວຍ</h2>
                <span class="close" onclick="closeEditModal()">&times;</span>
            </div>
            <div class="modal-body">
                <form id="editForm" method="POST" class="data-form">
                    <input type="hidden" name="action" value="edit">
                    <input type="hidden" id="edit_id" name="id">
                    <div class="form-row">
                        <div class="form-group full-width">
                            <label for="edit_unit_name"><i class="fas fa-ruler"></i> ຊື່ຫົວໜ່ວຍ <span class="required">*</span></label>
                            <input type="text" id="edit_unit_name" name="unit_name" placeholder="ເຊັ່ນ: ຊິ້ນ" required>
                            <small>ແກ້ໄຂຊື່ຫົວໜ່ວຍ</small>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-secondary" onclick="closeEditModal()"><i class="fas fa-times"></i> ຍົກເລີກ</button>
                <button type="button" class="btn-primary" onclick="submitEditForm()"><i class="fas fa-save"></i> ບັນທຶກ</button>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="js/sidebar.js"></script>
    <script>
        function openAddModal(){ document.getElementById('addModal').style.display='block'; document.getElementById('addForm').reset(); }
        function closeAddModal(){ document.getElementById('addModal').style.display='none'; }
        function openEditModal(){ document.getElementById('editModal').style.display='block'; }
        function closeEditModal(){ document.getElementById('editModal').style.display='none'; }

        function submitForm(){
            const form = document.getElementById('addForm');
            const formData = new FormData(form);
            fetch(window.location.href, { method: 'POST', body: formData })
            .then(res => res.text())
            .then(html => {
                if (html.includes('ເພີ່ມຫົວໜ່ວຍສຳເລັດແລ້ວ')) {
                    Swal.fire({ icon:'success', title:'ສຳເລັດ!', text:'ເພີ່ມຫົວໜ່ວຍສຳເລັດແລ້ວ', timer:2000, showConfirmButton:false }).then(()=>location.reload());
                } else {
                    const temp = document.createElement('div'); temp.innerHTML = html;
                    const alertDiv = temp.querySelector('.alert-error');
                    const err = alertDiv ? alertDiv.textContent.trim() : 'ເກີດຂໍ້ຜິດພາດ';
                    Swal.fire({ icon:'error', title:'ຜິດພາດ', text:err });
                }
            }).catch(()=>{
                Swal.fire({ icon:'error', title:'ຜິດພາດ', text:'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ' });
            });
        }

        function editUnit(id){
            fetch('get_unit_data.php?id='+id).then(r=>r.json()).then(data=>{
                if (data.success){
                    document.getElementById('edit_id').value = data.unit.id;
                    document.getElementById('edit_unit_name').value = data.unit.unit_name;
                    openEditModal();
                } else {
                    // fallback: read from table row
                    const row = document.querySelector(`button[onclick="editUnit(${id})"]`).closest('tr');
                    const cells = row.querySelectorAll('td');
                    const name = cells[1].textContent.trim();
                    document.getElementById('edit_id').value = id;
                    document.getElementById('edit_unit_name').value = name;
                    openEditModal();
                }
            }).catch(()=>{
                const row = document.querySelector(`button[onclick="editUnit(${id})"]`).closest('tr');
                const cells = row.querySelectorAll('td');
                const name = cells[1].textContent.trim();
                document.getElementById('edit_id').value = id;
                document.getElementById('edit_unit_name').value = name;
                openEditModal();
            });
        }

        function submitEditForm(){
            const form = document.getElementById('editForm');
            const formData = new FormData(form);
            fetch(window.location.href, { method:'POST', body: formData }).then(r=>r.text()).then(html=>{
                if (html.includes('ແກ້ໄຂຫົວໜ່ວຍສຳເລັດແລ້ວ')){
                    Swal.fire({ icon:'success', title:'ສຳເລັດ!', text:'ແກ້ໄຂຫົວໜ່ວຍສຳເລັດແລ້ວ', timer:2000, showConfirmButton:false }).then(()=>location.reload());
                } else {
                    const temp = document.createElement('div'); temp.innerHTML = html;
                    const alertDiv = temp.querySelector('.alert-error');
                    const err = alertDiv ? alertDiv.textContent.trim() : 'ເກີດຂໍ້ຜິດພາດ';
                    Swal.fire({ icon:'error', title:'ຜິດພາດ', text:err });
                }
            }).catch(()=>{
                Swal.fire({ icon:'error', title:'ຜິດພາດ', text:'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ' });
            });
        }

        function deleteUnit(id, productCount){
            if (productCount>0){
                Swal.fire({ title:'ບໍ່ສາມາດລຶບໄດ້', text:'ຫົວໜ່ວຍນີ້ມີສິນຄ້າ '+productCount+' ລາຍການ', icon:'warning', confirmButtonText:'ຕົກລົງ' });
                return;
            }

            Swal.fire({ title:'ຢືນຢັນ', text:'ທ່ານຕ້ອງການລຶບຫົວໜ່ວຍນີ້ບໍ່?', icon:'warning', showCancelButton:true, confirmButtonColor:'#d33', cancelButtonColor:'#6c757d', confirmButtonText:'ລຶບ', cancelButtonText:'ຍົກເລີກ' }).then((result)=>{
                if (result.isConfirmed){
                    const fd = new FormData(); fd.append('action','delete'); fd.append('id', id);
                    fetch(window.location.href, { method:'POST', body: fd }).then(r=>r.json()).then(data=>{
                        if (data.success){ Swal.fire({ icon:'success', title:'ສຳເລັດ!', text:data.message, timer:2000, showConfirmButton:false }).then(()=>location.reload()); }
                        else { Swal.fire({ icon:'error', title:'ຜິດພາດ', text:data.message }); }
                    }).catch(()=>{ Swal.fire({ icon:'error', title:'ຜິດພາດ', text:'ເກີດຂໍ້ຜິດພາດ' }); });
                }
            });
        }

        <?php if ($message_type === 'success'): ?>
            Swal.fire({ icon:'success', title:'ສຳເລັດ!', text:'<?php echo $message; ?>', timer:3000, showConfirmButton:false });
        <?php elseif ($message_type === 'error'): ?>
            Swal.fire({ icon:'error', title:'ຜິດພາດ', text:'<?php echo $message; ?>' });
        <?php endif; ?>
    </script>
</body>
</html>
