<?php
session_start();

// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once 'includes/db_con.php';

// ข้อมูลผู้ใช้
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'ผู้ใช้';

// จัดการการส่งฟอร์ม
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // การลบข้อมูล
    if (isset($_POST['action']) && $_POST['action'] == 'delete') {
        $id = intval($_POST['id']);
        
        if (empty($id)) {
            echo json_encode(['success' => false, 'message' => 'ລະຫັດໝາຍເຫດບໍ່ຖືກຕ້ອງ']);
            exit();
        }
        
        try {
            // ตรวจสอบว่ามีการใช้งานใน orders หรือ products หรือไม่
            $check_orders = $conn->prepare("SELECT COUNT(*) as count FROM orders WHERE remark_id = (SELECT remark_id FROM remark WHERE id = ?)");
            $check_orders->bind_param("i", $id);
            $check_orders->execute();
            $result_orders = $check_orders->get_result()->fetch_assoc();

            $check_products = $conn->prepare("SELECT COUNT(*) as count FROM products WHERE remark_id = (SELECT remark_id FROM remark WHERE id = ?)");
            $check_products->bind_param("i", $id);
            $check_products->execute();
            $result_products = $check_products->get_result()->fetch_assoc();
            
            if ($result_orders['count'] > 0 || $result_products['count'] > 0) {
                echo json_encode(['success' => false, 'message' => 'ບໍ່ສາມາດລຶບໝາຍເຫດນີ້ໄດ້ ເພາະມີການ usage ໃນລະບົບ']);
                exit();
            }
            
            // ลบข้อมูล
            $delete_stmt = $conn->prepare("DELETE FROM remark WHERE id = ?");
            $delete_stmt->bind_param("i", $id);
            
            if ($delete_stmt->execute()) {
                echo json_encode(['success' => true, 'message' => 'ລຶບໝາຍເຫດສຳເລັດແລ້ວ']);
            } else {
                echo json_encode(['success' => false, 'message' => 'ເກີດຂໍ້ຜິດພາດໃນການລຶບ']);
            }
            $delete_stmt->close();
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage()]);
        }
        exit();
    }
    
    // การแก้ไขข้อมูล
    if (isset($_POST['action']) && $_POST['action'] == 'edit') {
        $id = intval($_POST['id']);
        $remark_text = trim($_POST['remark_text']);
        
        if (empty($id) || empty($remark_text)) {
            $message = 'ກະລຸນາໃສ່ຂໍ້ມູນໃຫ້ຄົບຖ້ວນ';
            $message_type = 'error';
        } else {
            try {
                // ตรวจสอบชื่ซ้ำ (ยกเว้น ID ปัจจุบัน)
                $check_stmt = $conn->prepare("SELECT id FROM remark WHERE remark_text = ? AND id != ?");
                $check_stmt->bind_param("si", $remark_text, $id);
                $check_stmt->execute();
                
                if ($check_stmt->get_result()->num_rows > 0) {
                    $message = 'ມີໝາຍເຫດນີ້ໃນລະບົບແລ້ວ';
                    $message_type = 'error';
                } else {
                    // อัปเดตข้อมูล
                    $update_stmt = $conn->prepare("UPDATE remark SET remark_text = ? WHERE id = ?");
                    $update_stmt->bind_param("si", $remark_text, $id);
                    
                    if ($update_stmt->execute()) {
                        $message = 'ແກ້ໄຂໝາຍເຫດສຳເລັດແລ້ວ';
                        $message_type = 'success';
                    } else {
                        $message = 'ເກີດຂໍ້ຜິດພາດໃນການແກ້ໄຂ';
                        $message_type = 'error';
                    }
                    $update_stmt->close();
                }
                $check_stmt->close();
            } catch (Exception $e) {
                $message = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
                $message_type = 'error';
            }
        }
    }
    // การเพิ่มข้อมูลใหม่
    else {
        $remark_text = trim($_POST['remark_text']);
        
        if (empty($remark_text)) {
            $message = 'ກະລຸນາໃສ່ເນື້ອຫາໝາຍເຫດ';
            $message_type = 'error';
        } else {
            try {
                // ตรวจสอบว่ามี remark นี้แล้วหรือไม่
                $check_stmt = $conn->prepare("SELECT id FROM remark WHERE remark_text = ?");
                $check_stmt->bind_param("s", $remark_text);
                $check_stmt->execute();
                
                if ($check_stmt->get_result()->num_rows > 0) {
                    $message = 'ມີໝາຍເຫດນີ້ໃນລະບົບແລ້ວ';
                    $message_type = 'error';
                } else {
                    // เพิ่ม remark ใหม่ (remark_id จะถูก auto-generate โดย trigger)
                    $insert_stmt = $conn->prepare("INSERT INTO remark (remark_text) VALUES (?)");
                    $insert_stmt->bind_param("s", $remark_text);
                    
                    if ($insert_stmt->execute()) {
                        $message = 'ເພີ່ມໝາຍເຫດສຳເລັດແລ້ວ';
                        $message_type = 'success';
                        
                        // ล้างข้อมูลในฟอร์ม
                        $_POST = [];
                    } else {
                        $message = 'ເກີດຂໍ້ຜິດພາດໃນການເພີ່ມໝາຍເຫດ';
                        $message_type = 'error';
                    }
                    $insert_stmt->close();
                }
                $check_stmt->close();
            } catch (Exception $e) {
                $message = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
                $message_type = 'error';
            }
        }
    }
}

// ดึงข้อมูล remark ทั้งหมด
$remark_query = "SELECT * FROM remark ORDER BY remark_text";
$remark_result = $conn->query($remark_query);

// นับจำนวนการใช้งานใน orders และ products
$usage_count_query = "
    SELECT r.remark_id, 
           (SELECT COUNT(*) FROM orders o WHERE o.remark_id = r.remark_id) + 
           (SELECT COUNT(*) FROM products p WHERE p.remark_id = r.remark_id) as usage_count
    FROM remark r
";
$usage_count_result = $conn->query($usage_count_query);
$usage_data = [];
if ($usage_count_result->num_rows > 0) {
    while ($row = $usage_count_result->fetch_assoc()) {
        $usage_data[$row['remark_id']] = $row['usage_count'];
    }
}
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sokxay Bill - ເພີ່ມໝາຍເຫດ</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="/sokxay/wayha.png">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/forms.css">
    
    <style>
        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            overflow: auto;
        }
        
        .modal-content {
            background-color: #fff;
            margin: 5% auto;
            padding: 0;
            border-radius: 8px;
            width: 90%;
            max-width: 600px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            animation: modalSlideIn 0.3s ease;
        }
        
        @keyframes modalSlideIn {
            from { opacity: 0; transform: translateY(-50px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .modal-header {
            background: var(--primary-color);
            color: white;
            padding: 20px;
            border-radius: 8px 8px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .modal-header h2 {
            margin: 0;
            font-size: 20px;
        }
        
        .close {
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            opacity: 0.7;
            transition: opacity 0.3s;
        }
        
        .close:hover {
            opacity: 1;
        }
        
        .modal-body {
            padding: 20px;
        }
        
        .modal-footer {
            background: #f8f9fa;
            padding: 15px 20px;
            border-radius: 0 0 8px 8px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }
        
        .type-code {
            background: #e3f2fd;
            color: #1976d2;
            padding: 4px 8px;
            border-radius: 4px;
            font-family: monospace;
            font-weight: 600;
        }
        
        .type-info {
            display: flex;
            flex-direction: column;
        }
        
        .type-name {
            font-weight: 600;
            color: var(--text-color);
        }
        
        .product-count {
            color: #6c757d;
            font-size: 14px;
        }
        
        .product-count i {
            margin-right: 5px;
            color: #28a745;
        }
        
        .btn-action:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .full-width {
            flex: 1 1 100%;
        }
        
        /* Button States Fix */
        .btn-primary:active,
        .btn-primary:focus,
        .btn-primary.active {
            background: var(--primary-color) !important;
            color: white !important;
            border-color: var(--primary-color) !important;
            box-shadow: 0 0 0 3px rgba(13, 110, 253, 0.25) !important;
        }
        
        .btn-secondary:active,
        .btn-secondary:focus,
        .btn-secondary.active {
            background: #6c757d !important;
            color: white !important;
            border-color: #6c757d !important;
            box-shadow: 0 0 0 3px rgba(108, 117, 125, 0.25) !important;
        }
        
        button:focus {
            outline: none !important;
        }
    </style>
</head>
<body>
    <div class="app-container">
        <?php include 'includes/sidebar.php'; ?>

        <!-- Main Content Area -->
        <main class="main-content">
            <!-- Header -->
            <header class="content-header">
                <div class="header-left">
                    <h1 class="page-title">ໝາຍເຫດ</h1>
                    <p class="page-subtitle">ຈັດການໝາຍເຫດໃນລະບົບ</p>
                </div>
                
                <div class="header-right">
                    <button class="btn-primary" onclick="openAddModal()">
                        <i class="fas fa-plus"></i>
                        ເພີ່ມໝາຍເຫດ
                    </button>
                </div>
            </header>

            <!-- Content Body -->
            <div class="content-body">
                <div class="list-container">
                    <!-- Remark List -->
                    <div class="list-card">
                        <div class="list-header">
                            <h3><i class="fas fa-list"></i> ລາຍການໝາຍເຫດ</h3>
                        </div>
                        
                        <div class="table-container">
                            <?php if ($remark_result->num_rows > 0): ?>
                                <table class="data-table">
                                    <thead>
                                        <tr>
                                            <th>ລະຫັດ</th>
                                            <th>ເນື້ອຫາໝາຍເຫດ</th>
                                            <th>ການນຳໃຊ້</th>
                                            <th>ການກະທຳ</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        while ($remark = $remark_result->fetch_assoc()): 
                                            $usage_count = $usage_data[$remark['remark_id']] ?? 0;
                                        ?>
                                            <tr>
                                                <td>
                                                    <span class="type-code"><?php echo htmlspecialchars($remark['remark_id']); ?></span>
                                                </td>
                                                <td>
                                                    <div class="type-info">
                                                        <span class="type-name"><?php echo htmlspecialchars($remark['remark_text']); ?></span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="product-count">
                                                        <i class="fas fa-link"></i>
                                                        <?php echo $usage_count; ?> ລາຍການ
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="action-buttons">
                                                        <button class="btn-action btn-edit" onclick="editRemark(<?php echo $remark['id']; ?>)">
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                        <button class="btn-action btn-delete" 
                                                                onclick="deleteRemark(<?php echo $remark['id']; ?>, <?php echo $usage_count; ?>)"
                                                                <?php echo $usage_count > 0 ? 'disabled title="ບໍ່ສາມາດລຶບໝາຍເຫດທີ່ມີການນຳໃຊ້ຢູ່"' : ''; ?>>
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <div class="no-data">
                                    <i class="fas fa-sticky-note"></i>
                                    <p>ຍັງບໍ່ມີໝາຍເຫດໃນລະບົບ</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Add Remark Modal -->
    <div id="addModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2><i class="fas fa-plus-circle"></i> ເພີ່ມໝາຍເຫດໃໝ່</h2>
                <span class="close" onclick="closeAddModal()">&times;</span>
            </div>
            
            <div class="modal-body">
                <form id="addForm" method="POST" class="data-form">
                    <div class="form-row">
                        <div class="form-group full-width">
                            <label for="modal_remark_text">
                                <i class="fas fa-pen"></i>
                                ເນື້ອຫາໝາຍເຫດ <span class="required">*</span>
                            </label>
                            <textarea 
                                   id="modal_remark_text" 
                                   name="remark_text" 
                                   rows="3"
                                   placeholder="ໃສ່ເນື້ອຫາໝາຍເຫດ..."
                                   required></textarea>
                            <small>ໃສ່ຂໍ້ຄວາມໝາຍເຫດ - ລະຫັດຈະຖືກສ້າງອັດຕະໂນມັດ</small>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group full-width">
                            <div style="background: #e8f4fd; border: 1px solid #bee5eb; padding: 15px; border-radius: 8px;">
                                <h4 style="margin: 0 0 10px 0; color: #0c5460; font-size: 14px;">
                                    <i class="fas fa-info-circle"></i> ຂໍ້ມູນການໃຊ້ງານ
                                </h4>
                                <ul style="margin: 0; padding-left: 20px; color: #0c5460; font-size: 13px;">
                                    <li>ລະຫັດໝາຍເຫດ (Remark ID) ຈະຖືກສ້າງອັດຕະໂນມັດ</li>
                                    <li>ຮູບແບບ: REM_1, REM_2, REM_3, ...</li>
                                    <li>ສາມາດນຳໄປໃຊ້ໃນການອອກບິນ ຫຼື ເພີ່ມສິນຄ້າໄດ້</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn-secondary" onclick="closeAddModal()">
                    <i class="fas fa-times"></i>
                    ຍົກເລີກ
                </button>
                <button type="button" class="btn-primary" onclick="submitForm()">
                    <i class="fas fa-save"></i>
                    ບັນທຶກ
                </button>
            </div>
        </div>
    </div>

    <!-- Edit Remark Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2><i class="fas fa-edit"></i> ແກ້ໄຂໝາຍເຫດ</h2>
                <span class="close" onclick="closeEditModal()">&times;</span>
            </div>
            
            <div class="modal-body">
                <form id="editForm" method="POST" class="data-form">
                    <input type="hidden" name="action" value="edit">
                    <input type="hidden" id="edit_id" name="id">
                    
                    <div class="form-row">
                        <div class="form-group full-width">
                            <label for="edit_remark_text">
                                <i class="fas fa-pen"></i>
                                ເນື້ອຫາໝາຍເຫດ <span class="required">*</span>
                            </label>
                            <textarea 
                                   id="edit_remark_text" 
                                   name="remark_text" 
                                   rows="3"
                                   placeholder="ໃສ່ເນື້ອຫາໝາຍເຫດ..."
                                   required></textarea>
                            <small>ແກ້ໄຂເນື້ອຫາໝາຍເຫດ - ລະຫັດຈະບໍ່ມີການປ່ຽນແປງ</small>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group full-width">
                            <div style="background: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; border-radius: 8px;">
                                <h4 style="margin: 0 0 10px 0; color: #856404; font-size: 14px;">
                                    <i class="fas fa-exclamation-triangle"></i> ຂໍ້ມູນການແກ້ໄຂ
                                </h4>
                                <ul style="margin: 0; padding-left: 20px; color: #856404; font-size: 13px;">
                                    <li>ລະຫັດໝາຍເຫດ (Remark ID) ບໍ່ສາມາດແກ້ໄຂໄດ້</li>
                                    <li>ການແກ້ໄຂຈະມີຜົນກັບທຸກລາຍການທີ່ໃຊ້ໝາຍເຫດນີ້</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn-secondary" onclick="closeEditModal()">
                    <i class="fas fa-times"></i>
                    ຍົກເລີກ
                </button>
                <button type="button" class="btn-primary" onclick="submitEditForm()">
                    <i class="fas fa-save"></i>
                    ບັນທຶກການແກ້ໄຂ
                </button>
            </div>
        </div>
    </div>

    <!-- Sweet Alert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Sidebar JavaScript -->
    <script src="js/sidebar.js"></script>
    
    <script>
        // Modal Functions
        function openAddModal() {
            document.getElementById('addModal').style.display = 'block';
            document.getElementById('addForm').reset();
        }
        
        function closeAddModal() {
            document.getElementById('addModal').style.display = 'none';
        }
        
        function submitForm() {
            const form = document.getElementById('addForm');
            const formData = new FormData(form);
            
            fetch(window.location.href, {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(html => {
                if (html.includes('ເພີ່ມໝາຍເຫດສຳເລັດແລ້ວ')) {
                    Swal.fire({
                        icon: 'success',
                        title: 'ສຳເລັດ!',
                        text: 'ເພີ່ມໝາຍເຫດສຳເລັດແລ້ວ',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    const tempDiv = document.createElement('div');
                    tempDiv.innerHTML = html;
                    const alertDiv = tempDiv.querySelector('.alert-error');
                    const errorMessage = alertDiv ? alertDiv.textContent.trim() : 'ເກີດຂໍ້ຜິດພາດ';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'ຜິດພາດ',
                        text: errorMessage
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'ຜິດພາດ',
                    text: 'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ'
                });
            });
        }
        
        // Close modal when clicking outside
        window.addEventListener('click', function(event) {
            const addModal = document.getElementById('addModal');
            const editModal = document.getElementById('editModal');
            
            if (event.target === addModal) {
                closeAddModal();
            }
            if (event.target === editModal) {
                closeEditModal();
            }
        });

        // Edit Remark Function
        function editRemark(id) {
            // ดึงข้อมูลจาก server
            fetch('get_remark_data.php?id=' + id)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // ใส่ข้อมูลในฟอร์ม
                        document.getElementById('edit_id').value = data.remark.id;
                        document.getElementById('edit_remark_text').value = data.remark.remark_text;
                        
                        // เปิด modal
                        document.getElementById('editModal').style.display = 'block';
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'ຜິດພາດ',
                            text: 'ບໍ່ສາມາດດຶງຂໍ້ມູນໝາຍເຫດໄດ້'
                        });
                    }
                })
                .catch(error => {
                    // Fallback: ดึงข้อมูลจากตารางเพื่อใส่ในฟอร์มแก้ไข
                    const row = document.querySelector(`button[onclick="editRemark(${id})"]`).closest('tr');
                    const cells = row.querySelectorAll('td');
                    const remarkText = cells[1].querySelector('.type-name').textContent.trim();
                    
                    // ใส่ข้อมูลในฟอร์ม
                    document.getElementById('edit_id').value = id;
                    document.getElementById('edit_remark_text').value = remarkText;
                    
                    // เปิด modal
                    document.getElementById('editModal').style.display = 'block';
                });
        }
        
        // Close Edit Modal
        function closeEditModal() {
            document.getElementById('editModal').style.display = 'none';
        }
        
        // Submit Edit Form
        function submitEditForm() {
            const form = document.getElementById('editForm');
            const formData = new FormData(form);
            
            fetch(window.location.href, {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(html => {
                if (html.includes('ແກ້ໄຂໝາຍເຫດສຳເລັດແລ້ວ')) {
                    Swal.fire({
                        icon: 'success',
                        title: 'ສຳເລັດ!',
                        text: 'ແກ້ໄຂໝາຍເຫດສຳເລັດແລ້ວ',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    const tempDiv = document.createElement('div');
                    tempDiv.innerHTML = html;
                    const alertDiv = tempDiv.querySelector('.alert-error');
                    const errorMessage = alertDiv ? alertDiv.textContent.trim() : 'ເກີດຂໍ້ຜິດພາດ';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'ຜິດພາດ',
                        text: errorMessage
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'ຜິດພາດ',
                    text: 'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ'
                });
            });
        }
        
        // Delete Remark Function
        function deleteRemark(id, usageCount) {
            if (usageCount > 0) {
                Swal.fire({
                    title: 'ບໍ່ສາມາດລຶບໄດ້',
                    text: 'ໝາຍເຫດນີ້ມີການນຳໃຊ້ ' + usageCount + ' ລາຍການ ກະລຸນາລຶບການນຳໃຊ້ກ່ອນ',
                    icon: 'warning',
                    confirmButtonText: 'ຕົກລົງ'
                });
                return;
            }

            Swal.fire({
                title: 'ຢືນຢັນການລຶບ',
                text: "ຕ້ອງການລຶບໝາຍເຫດນີ້ບໍ່?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'ລຶບ',
                cancelButtonText: 'ຍົກເລີກ'
            }).then((result) => {
                if (result.isConfirmed) {
                    // ส่งคำขอลบ
                    const formData = new FormData();
                    formData.append('action', 'delete');
                    formData.append('id', id);
                    
                    fetch(window.location.href, {
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'ສຳເລັດ!',
                                text: data.message,
                                timer: 2000,
                                showConfirmButton: false
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'ຜິດພາດ',
                                text: data.message
                            });
                        }
                    })
                    .catch(error => {
                        Swal.fire({
                            icon: 'error',
                            title: 'ຜິດພາດ',
                            text: 'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ'
                        });
                    });
                }
            });
        }

        // Show success message if exists
        <?php if ($message_type === 'success'): ?>
            Swal.fire({
                icon: 'success',
                title: 'ສຳເລັດ!',
                text: '<?php echo $message; ?>',
                timer: 3000,
                showConfirmButton: false
            });
        <?php elseif ($message_type === 'error'): ?>
            Swal.fire({
                icon: 'error',
                title: 'ຜິດພາດ',
                text: '<?php echo $message; ?>'
            });
        <?php endif; ?>
    </script>
</body>
</html>
