<?php
session_start();
// ปิด error display ใน production
ini_set('display_errors', 1);
error_reporting(E_ALL);
// ตรวจสอบการล็อกอิน
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// เชื่อมต่อฐานข้อมูล
require_once 'includes/db_con.php'; 

// ข้อมูลผู้ใช้
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'ผู้ใช้';

// ดึงข้อมูลสกุลเงินทั้งหมด
$currencys_query = "SELECT * FROM currencys ORDER BY currencys_name";
$currencys_result = $conn->query($currencys_query);

// จัดการการส่งฟอร์ม
$message = '';
$message_type = '';

// จัดการการแก้ไขข้อมูลอัตรา
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'edit') {
    $rate_id_edit = intval($_POST['rate_id_edit']);
    $currencys_id = trim($_POST['currencys_id']);
    $rate_amount = trim($_POST['rate_amount']);
    
    // ใช้วันที่และเวลาปัจจุบันอัตโนมัติ
    $rate_date = date('Y-m-d');
    $rate_time = date('H:i:s');
    
    if (empty($rate_id_edit) || empty($currencys_id) || empty($rate_amount)) {
        $message = 'ກະລຸນາໃສ່ຂໍ້ມູນໃຫ້ຄົບຖ້ວນ';
        $message_type = 'error';
    } elseif (!is_numeric($rate_amount) || $rate_amount <= 0) {
        $message = 'ກະລຸນາໃສ່ອັດຕາແລກປ່ຽນທີ່ຖືກຕ້ອງ';
        $message_type = 'error';
    } else {
        try {
            // รวมวันที่และเวลาปัจจุบัน
            $rate_datetime = $rate_date . ' ' . $rate_time;
            
            // อัปเดตข้อมูลอัตราแลกปลี่ยน
            $update_stmt = $conn->prepare("UPDATE rates SET currencys_id = ?, rate_amount = ?, rate_date = ?, rate_datetime = ? WHERE id = ?");
            $update_stmt->bind_param("sdssi", $currencys_id, $rate_amount, $rate_date, $rate_datetime, $rate_id_edit);
            
            if ($update_stmt->execute()) {
                $message = 'ແກ້ໄຂອັດຕາແລກປ່ຽນສຳເລັດແລ້ວ';
                $message_type = 'success';
            } else {
                $message = 'ເກີດຂໍ້ຜິດພາດໃນການແກ້ໄຂອັດຕາແລກປ່ຽນ: ' . $conn->error;
                $message_type = 'error';
            }
            $update_stmt->close();
        } catch (Exception $e) {
            $message = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
            $message_type = 'error';
        }
    }
} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $currencys_id = trim($_POST['currencys_id']);
    $rate_amount = trim($_POST['rate_amount']);
    
    // ใช้วันที่และเวลาปัจจุบันอัตโนมัติ
    $rate_date = date('Y-m-d');
    $rate_time = date('H:i:s');
    
    if (empty($currencys_id) || empty($rate_amount)) {
        $message = 'ກະລຸນາໃສ່ຂໍ້ມູນໃຫ້ຄົບຖ້ວນ';
        $message_type = 'error';
    } elseif (!is_numeric($rate_amount) || $rate_amount <= 0) {
        $message = 'ກະລຸນາໃສ່ອັດຕາແລກປ່ຽນທີ່ຖືກຕ້ອງ';
        $message_type = 'error';
    } else {
        try {
            // รวมวันที่และเวลาปัจจุบัน
            $rate_datetime = $rate_date . ' ' . $rate_time;
            
            // เพิ่มอัตราแลกปลี่ยนใหม่ (rate_id จะถูก auto-generate โดย trigger)
            $insert_stmt = $conn->prepare("INSERT INTO rates (currencys_id, rate_amount, rate_date, rate_datetime) VALUES (?, ?, ?, ?)");
            $insert_stmt->bind_param("sdss", $currencys_id, $rate_amount, $rate_date, $rate_datetime);
            
            if ($insert_stmt->execute()) {
                $message = 'ເພີ່ມອັດຕາແລກປ່ຽນສຳເລັດແລ້ວ';
                $message_type = 'success';
                
                // ล้างข้อมูลในฟอร์ม
                $_POST = [];
            } else {
                $message = 'ເກີດຂໍ້ຜິດພາດໃນການເພີ່ມອັດຕາແລກປ່ຽນ: ' . $conn->error;
                $message_type = 'error';
            }
            $insert_stmt->close();
        } catch (Exception $e) {
            $message = 'ເກີດຂໍ້ຜິດພາດ: ' . $e->getMessage();
            $message_type = 'error';
        }
    }
}

// ดึงข้อมูลอัตราแลกปลี่ยนทั้งหมดพร้อมข้อมูลสกุลเงิน
$rates_query = "SELECT r.*, c.currencys_name, c.currencys_symbol, c.currencys_fullname, 
                      COALESCE(r.rate_datetime, CONCAT(r.rate_date, ' 00:00:00')) as display_datetime
               FROM rates r 
               LEFT JOIN currencys c ON r.currencys_id = c.currencys_id 
               ORDER BY display_datetime DESC, r.id DESC";
$rates_result = $conn->query($rates_query);

// ดึงอัตราแลกปลี่ยนล่าสุดของแต่ละสกุลเงิน
$latest_rates_query = "SELECT r.*, c.currencys_name, c.currencys_symbol, c.currencys_fullname,
                              COALESCE(r.rate_datetime, CONCAT(r.rate_date, ' 00:00:00')) as display_datetime
                      FROM rates r 
                      LEFT JOIN currencys c ON r.currencys_id = c.currencys_id 
                      WHERE r.id IN (
                          SELECT MAX(id) FROM rates GROUP BY currencys_id
                      )
                      ORDER BY c.currencys_name";
$latest_rates_result = $conn->query($latest_rates_query);
?>

<!DOCTYPE html>
<html lang="lo">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sokxay Bill - ເພີ່ມອັດຕາແລກປ່ຽນ</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="/sokxay/wayha.png">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Lao:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/forms.css">
    
    <style>
        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            overflow: auto;
        }
        
        .modal-content {
            background-color: #fff;
            margin: 5% auto;
            padding: 0;
            border-radius: 8px;
            width: 90%;
            max-width: 600px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            animation: modalSlideIn 0.3s ease;
        }
        
        @keyframes modalSlideIn {
            from { opacity: 0; transform: translateY(-50px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .modal-header {
            background: var(--primary-color);
            color: white;
            padding: 20px;
            border-radius: 8px 8px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .modal-header h2 {
            margin: 0;
            font-size: 20px;
        }
        
        .close {
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            opacity: 0.7;
            transition: opacity 0.3s;
        }
        
        .close:hover {
            opacity: 1;
        }
        
        .modal-body {
            padding: 20px;
        }
        
        .modal-footer {
            background: #f8f9fa;
            padding: 15px 20px;
            border-radius: 0 0 8px 8px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }
        
        .btn-suggestion {
            background: #17a2b8;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            font-size: 12px;
            cursor: pointer;
            margin-top: 5px;
        }
        
        .suggestion-list {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin: 20px 0;
        }
        
        .suggestion-item {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 10px;
            border-radius: 6px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .suggestion-item:hover {
            background: #e9ecef;
            border-color: #007bff;
        }
        
        .rate-info-box {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }
        
        .rate-info-box h4 {
            margin: 0 0 15px 0;
            color: #495057;
        }
        
        .rate-info-box ul {
            margin: 0;
            padding-left: 20px;
        }
        
        .rate-info-box li {
            margin-bottom: 5px;
            color: #6c757d;
        }
        
        .rate-code {
            background: #e3f2fd;
            color: #1976d2;
            padding: 4px 8px;
            border-radius: 4px;
            font-family: monospace;
            font-weight: 600;
        }
        
        .rate-amount {
            font-weight: 600;
            color: #28a745;
            font-size: 16px;
        }
        
        .rate-date {
            color: #6c757d;
        }
        
        /* Button States Fix */
        .btn-primary:active,
        .btn-primary:focus,
        .btn-primary.active {
            background: var(--primary-color) !important;
            color: white !important;
            border-color: var(--primary-color) !important;
            box-shadow: 0 0 0 3px rgba(13, 110, 253, 0.25) !important;
        }
        
        .btn-secondary:active,
        .btn-secondary:focus,
        .btn-secondary.active {
            background: #6c757d !important;
            color: white !important;
            border-color: #6c757d !important;
            box-shadow: 0 0 0 3px rgba(108, 117, 125, 0.25) !important;
        }
        
        button:focus {
            outline: none !important;
        }
        
        /* Rate Cards Animation */
        .current-rates-grid {
            display: grid; 
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); 
            gap: 20px;
        }
        
        .rate-card {
            transition: all 0.3s ease !important;
            cursor: pointer;
        }
        
        .rate-card:hover {
            transform: translateY(-8px) !important;
            box-shadow: 0 8px 25px rgba(0,0,0,0.2) !important;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .current-rates-grid {
                grid-template-columns: 1fr !important;
                gap: 15px !important;
            }
            
            .rate-card {
                padding: 15px !important;
            }
        }
        
        /* Kip symbol styling */
        .kip-symbol {
            font-family: "Noto Sans Lao", sans-serif;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="app-container">
        <?php include 'includes/sidebar.php'; ?>

        <!-- Main Content Area -->
        <main class="main-content">
            <!-- Header -->
            <header class="content-header">
                <div class="header-left">
                    <h1 class="page-title">ອັດຕາແລກປ່ຽນ</h1>
                    <p class="page-subtitle">ຈັດການອັດຕາແລກປ່ຽນເງິນ</p>
                </div>
                
                <div class="header-right">
                    <button class="btn-primary" onclick="openAddModal()">
                        <i class="fas fa-plus"></i>
                        ເພີ່ມອັດຕາແລກປ່ຽນ
                    </button>
                </div>
            </header>

            <!-- Content Body -->
            <div class="content-body">
                <!-- Current Rates Summary -->
                <div class="list-container">
                    <div class="list-card" style="margin-bottom: 20px;">
                        <div class="list-header">
                            <h3><i class="fas fa-calculator"></i> ຕາຕະລາງຄຳນວນເງິນກີບ</h3>
                            <p style="color: #6c757d; font-size: 14px; margin: 5px 0 0 0;">ອັດຕາແລກປ່ຽນປັດຈຸບັນ ແລະ ການຄຳນວນເປັນເງິນກີບ</p>
                        </div>
                        
                        <div style="padding: 20px;">
                            <div class="current-rates-grid">
                                <?php if ($latest_rates_result && $latest_rates_result->num_rows > 0): ?>
                                    <?php while ($latest = $latest_rates_result->fetch_assoc()): ?>
                                        <div class="rate-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); transition: transform 0.3s ease; position: relative; overflow: hidden;" 
                                             onmouseover="this.style.transform='translateY(-5px)'" 
                                             onmouseout="this.style.transform='translateY(0)'">
                                            <!-- Background decoration -->
                                            <div style="position: absolute; top: -20px; right: -20px; width: 100px; height: 100px; background: rgba(255,255,255,0.1); border-radius: 50%;"></div>
                                            
                                            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px; position: relative; z-index: 1;">
                                                <span style="font-size: 28px; font-weight: bold; text-shadow: 0 2px 4px rgba(0,0,0,0.3);"><?php echo htmlspecialchars($latest['currencys_symbol']); ?></span>
                                                <span style="font-size: 11px; opacity: 0.8; background: rgba(255,255,255,0.2); padding: 4px 8px; border-radius: 12px;">
                                                    <i class="fas fa-clock"></i> 
                                                    <?php 
                                                    $datetime = $latest['display_datetime'];
                                                    echo date('d/m/Y H:i', strtotime($datetime));
                                                    ?>
                                                </span>
                                            </div>
                                            
                                            <div style="margin-bottom: 12px; position: relative; z-index: 1;">
                                                <span style="font-size: 14px; opacity: 0.9; background: rgba(255,255,255,0.2); padding: 2px 8px; border-radius: 8px;"><?php echo htmlspecialchars($latest['currencys_name']); ?></span>
                                            </div>
                                            
                                            <!-- Main rate display -->
                                            <div style="background: rgba(255,255,255,0.15); padding: 15px; border-radius: 10px; margin-bottom: 15px; position: relative; z-index: 1;">
                                                <div style="text-align: center;">
                                                    <div style="font-size: 16px; opacity: 0.9; margin-bottom: 8px;">
                                                        1 <?php echo htmlspecialchars($latest['currencys_symbol']); ?> =
                                                    </div>
                                                    <div style="font-size: 24px; font-weight: 700; color: #fff; text-shadow: 0 2px 4px rgba(0,0,0,0.3);">
                                                        <?php echo number_format($latest['rate_amount'], 0); ?> <span style="font-size: 18px;" class="kip-symbol">₭</span>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- Calculation examples -->
                                            <div style="border-top: 1px solid rgba(255,255,255,0.3); padding-top: 12px; position: relative; z-index: 1;">
                                                <div style="font-size: 12px; opacity: 0.9; margin-bottom: 6px;">
                                                    <i class="fas fa-calculator" style="margin-right: 5px;"></i>ຕົວຢ່າງການຄຳນວນ:
                                                </div>
                                                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 8px; font-size: 11px; opacity: 0.8;">
                                                    <div style="background: rgba(255,255,255,0.1); padding: 6px; border-radius: 6px; text-align: center;">
                                                        10 <?php echo htmlspecialchars($latest['currencys_symbol']); ?><br>
                                                        <strong><?php echo number_format($latest['rate_amount'] * 10, 0); ?> ₭</strong>
                                                    </div>
                                                    <div style="background: rgba(255,255,255,0.1); padding: 6px; border-radius: 6px; text-align: center;">
                                                        100 <?php echo htmlspecialchars($latest['currencys_symbol']); ?><br>
                                                        <strong><?php echo number_format($latest['rate_amount'] * 100, 0); ?> ₭</strong>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div style="font-size: 10px; opacity: 0.6; margin-top: 8px; text-align: right; position: relative; z-index: 1;">
                                                Rate ID: <?php echo htmlspecialchars($latest['rate_id']); ?>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <div style="text-align: center; padding: 40px; color: #6c757d;">
                                        <i class="fas fa-info-circle" style="font-size: 48px; margin-bottom: 15px;"></i>
                                        <p>ຍັງບໍ່ມີອັດຕາແລກປ່ຽນໃນລະບົບ</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="list-container">
                    <!-- Rates List -->
                    <div class="list-card">
                        <div class="list-header">
                            <h3><i class="fas fa-list"></i> ລາຍການອັດຕາແລກປ່ຽນ</h3>
                        </div>
                        
                        <div class="table-container">
                            <?php if ($rates_result->num_rows > 0): ?>
                                <table class="data-table">
                                    <thead>
                                        <tr>
                                            <th>ລະຫັດອັດຕາ</th>
                                            <th>ສະກຸນເງິນ</th>
                                            <th>ອັດຕາ</th>
                                            <th>ວັນທີ່ แລະ ເວລາ</th>
                                            <th>ການກະທຳ</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($rate = $rates_result->fetch_assoc()): ?>
                                            <tr>
                                                <td>
                                                    <span class="rate-code"><?php echo htmlspecialchars($rate['rate_id']); ?></span>
                                                </td>
                                                <td>
                                                    <div style="display: flex; align-items: center; gap: 8px;">
                                                        <span class="currency-symbol" style="background: #e8f4fd; color: #0056b3; padding: 2px 6px; border-radius: 4px; font-size: 12px;">
                                                            <?php echo htmlspecialchars($rate['currencys_symbol'] ?? 'N/A'); ?>
                                                        </span>
                                                        <span><?php echo htmlspecialchars($rate['currencys_name'] ?? 'N/A'); ?></span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="rate-amount">
                                                        <?php echo number_format($rate['rate_amount'], 2); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="rate-date">
                                                        <i class="fas fa-calendar-alt"></i>
                                                        <?php 
                                                        $datetime = $rate['display_datetime'];
                                                        echo date('d/m/Y H:i', strtotime($datetime));
                                                        ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="action-buttons">
                                                        <button class="btn-action btn-edit" onclick="editRate(<?php echo $rate['id']; ?>)">
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                        <button class="btn-action btn-delete" onclick="deleteRate(<?php echo $rate['id']; ?>)">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <div class="no-data">
                                    <i class="fas fa-exchange-alt"></i>
                                    <p>ຍັງບໍ່ມີອັດຕາແລກປ່ຽນໃນລະບົບ</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Add Rate Modal -->
    <div id="addModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2><i class="fas fa-exchange-alt"></i> ເພີ່ມອັດຕາແລກປ່ຽນໃໝ່</h2>
                <span class="close" onclick="closeAddModal()">&times;</span>
            </div>
            
            <div class="modal-body">
                <form id="addForm" method="POST" class="data-form">
                    <div class="form-row">
                        <div class="form-group">
                            <label for="modal_currencys_id">
                                <i class="fas fa-coins"></i>
                                ເລືອກສະກຸນເງິນ <span class="required">*</span>
                            </label>
                            <select id="modal_currencys_id" 
                                    name="currencys_id" 
                                    required>
                                <option value="">-- ເລືອກສະກຸນເງິນ --</option>
                                <?php 
                                // Reset pointer
                                $currencys_result->data_seek(0);
                                while ($currency = $currencys_result->fetch_assoc()): 
                                ?>
                                    <option value="<?php echo htmlspecialchars($currency['currencys_id']); ?>">
                                        <?php echo htmlspecialchars($currency['currencys_symbol']); ?> - <?php echo htmlspecialchars($currency['currencys_name']); ?>
                                        <?php if ($currency['currencys_fullname']): ?>
                                            (<?php echo htmlspecialchars($currency['currencys_fullname']); ?>)
                                        <?php endif; ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                            <small>ເລືອກສະກຸນເງິນທີ່ຕ້ອງການຕັ້ງອັດຕາແລກປ່ຽນ</small>
                        </div>
                        
                        <div class="form-group">
                            <label for="modal_rate_amount">
                                <i class="fas fa-calculator"></i>
                                ອັດຕາແລກປ່ຽນ <span class="required">*</span>
                            </label>
                            <input type="number" 
                                   id="modal_rate_amount" 
                                   name="rate_amount" 
                                   step="0.01"
                                   min="0"
                                   placeholder="ເຊັ່ນ: 21500.00"
                                   required>
                            <small>ໃສ່ອັດຕາແລກປ່ຽນຕໍ່ 1 ຫົວໜ່ວຍຂອງສະກຸນເງິນທີ່ເລືອກ = ເທົ່າໃດ LAK</small>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <div class="rate-info-box">
                                <h4><i class="fas fa-info-circle"></i> ຂໍ້ມູນການໃຊ້ງານ</h4>
                                <ul>
                                    <li>ອັດຕາແລກປ່ຽນຈະຖືກສ້າງ Rate ID ອັດຕະໂນມັດ</li>
                                    <li>ວັນທີ່ແລະເວລາຈະຖືກບັນທຶກອັດຕະໂນມັດຈາກເຊີບເວີ</li>
                                    <li>ລະບົບຈະໃຊ້ວັນທີ່ແລະເວລາປັດຈຸບັນ</li>
                                    <li>ສາມາດມີອັດຕາຫຼາຍອັດຕາສຳລັບວັນທີ່ຕ່າງກັນ</li>
                                    <li>ລະບົບຈະໃຊ້ອັດຕາລ່າສຸດເປັນຫຼັກ</li>
                                    <li>ຕົວຢ່າງ: 1 USD = 21,500 LAK</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn-secondary" onclick="closeAddModal()">
                    <i class="fas fa-times"></i>
                    ຍົກເລີກ
                </button>
                <button type="button" class="btn-primary" onclick="submitForm()">
                    <i class="fas fa-save"></i>
                    ບັນທຶກອັດຕາ
                </button>
            </div>
        </div>
    </div>

    <!-- Edit Rate Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2><i class="fas fa-edit"></i> ແກ້ໄຂອັດຕາແລກປ່ຽນ</h2>
                <span class="close" onclick="closeEditModal()">&times;</span>
            </div>
            
            <div class="modal-body">
                <form id="editForm" method="POST" class="data-form">
                    <input type="hidden" name="action" value="edit">
                    <input type="hidden" id="edit_rate_id" name="rate_id_edit">
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label for="edit_currencys_id">
                                <i class="fas fa-coins"></i>
                                ເລືອກສະກຸນເງິນ <span class="required">*</span>
                            </label>
                            <select id="edit_currencys_id" 
                                    name="currencys_id" 
                                    required>
                                <option value="">-- ເລືອກສະກຸນເງິນ --</option>
                                <?php 
                                // Reset pointer for edit modal
                                $currencys_result->data_seek(0);
                                while ($currency = $currencys_result->fetch_assoc()): 
                                ?>
                                    <option value="<?php echo htmlspecialchars($currency['currencys_id']); ?>">
                                        <?php echo htmlspecialchars($currency['currencys_symbol']); ?> - <?php echo htmlspecialchars($currency['currencys_name']); ?>
                                        <?php if ($currency['currencys_fullname']): ?>
                                            (<?php echo htmlspecialchars($currency['currencys_fullname']); ?>)
                                        <?php endif; ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                            <small>ເລືອກສະກຸນເງິນທີ່ຕ້ອງການແກ້ໄຂ</small>
                        </div>
                        
                        <div class="form-group">
                            <label for="edit_rate_amount">
                                <i class="fas fa-calculator"></i>
                                ອັດຕາແລກປ່ຽນ <span class="required">*</span>
                            </label>
                            <input type="number" 
                                   id="edit_rate_amount" 
                                   name="rate_amount" 
                                   step="0.01"
                                   min="0"
                                   placeholder="ເຊັ່ນ: 21500.00"
                                   required>
                            <small>ໃສ່ອັດຕາແລກປ່ຽນຕໍ່ 1 ຫົວໜ່ວຍຂອງສະກຸນເງິນທີ່ເລືອກ = ເທົ່າໃດ LAK</small>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <div class="rate-info-box">
                                <h4><i class="fas fa-info-circle"></i> ຂໍ້ມູນການແກ້ໄຂ</h4>
                                <ul>
                                    <li>ການແກ້ໄຂຈະອັບເດດຂໍ້ມູນທັນທີ</li>
                                    <li>ວັນທີ່ແລະເວລາຈະຖືກອັບເດດອັດຕະໂນມັດ</li>
                                    <li>Rate ID ຈະບໍ່ມີການປ່ຽນແປງ</li>
                                    <li>ສາມາດແກ້ໄຂສະກຸນເງິນແລະອັດຕາເທົ່ານັ້ນ</li>
                                    <li>ຕົວຢ່າງ: 1 USD = 21,500 LAK</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn-secondary" onclick="closeEditModal()">
                    <i class="fas fa-times"></i>
                    ຍົກເລີກ
                </button>
                <button type="button" class="btn-primary" onclick="submitEditForm()">
                    <i class="fas fa-save"></i>
                    ບັນທຶກການແກ້ໄຂ
                </button>
            </div>
        </div>
    </div>

    <!-- Sweet Alert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Sidebar JavaScript -->
    <script src="js/sidebar.js"></script>
    
    <script>
        // Modal Functions
        function openAddModal() {
            document.getElementById('addModal').style.display = 'block';
            document.getElementById('addForm').reset();
        }
        
        function closeAddModal() {
            document.getElementById('addModal').style.display = 'none';
        }
        
        function submitForm() {
            const form = document.getElementById('addForm');
            const formData = new FormData(form);
            
            fetch(window.location.href, {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(html => {
                if (html.includes('ເພີ່ມອັດຕາແລກປ່ຽນສຳເລັດແລ້ວ')) {
                    Swal.fire({
                        icon: 'success',
                        title: 'ສຳເລັດ!',
                        text: 'ເພີ່ມອັດຕາແລກປ່ຽນສຳເລັດແລ້ວ',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    const tempDiv = document.createElement('div');
                    tempDiv.innerHTML = html;
                    const alertDiv = tempDiv.querySelector('.alert-error');
                    const errorMessage = alertDiv ? alertDiv.textContent.trim() : 'ເກີດຂໍ້ຜິດພາດ';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'ຜິດພາດ',
                        text: errorMessage
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'ຜິດພາດ',
                    text: 'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ'
                });
            });
        }
        
        // Close modal when clicking outside
        window.addEventListener('click', function(event) {
            const addModal = document.getElementById('addModal');
            const editModal = document.getElementById('editModal');
            
            if (event.target === addModal) {
                closeAddModal();
            }
            
            if (event.target === editModal) {
                closeEditModal();
            }
        });

        // Edit Rate Function
        function editRate(id) {
            // ดึงข้อมูลอัตราแลกปลี่ยนจากตาราง
            const row = document.querySelector(`button[onclick="editRate(${id})"]`).closest('tr');
            const cells = row.querySelectorAll('td');
            
            // ดึงข้อมูลจาก server
            fetch('get_rate_data.php?id=' + id)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // เติมข้อมูลในฟอร์มแก้ไข
                        document.getElementById('edit_rate_id').value = data.rate.id;
                        document.getElementById('edit_currencys_id').value = data.rate.currencys_id;
                        document.getElementById('edit_rate_amount').value = data.rate.rate_amount;
                        
                        // เปิด modal
                        document.getElementById('editModal').style.display = 'block';
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'ຜິດພາດ',
                            text: 'ບໍ່ສາມາດດຶງຂໍ້ມູນອັດຕາແລກປ່ຽນໄດ້'
                        });
                    }
                })
                .catch(error => {
                    // Fallback: ใช้ข้อมูลจากตารางที่แสดงอยู่
                    document.getElementById('edit_rate_id').value = id;
                    
                    // หาค่า currencys_id จากข้อมูลที่แสดงในตาราง
                    const currencyText = cells[1].textContent.trim();
                    const currencySelect = document.getElementById('edit_currencys_id');
                    
                    // หาค่าที่ตรงกันใน select options
                    for (let option of currencySelect.options) {
                        if (option.text.includes(currencyText.split(' - ')[1])) {
                            currencySelect.value = option.value;
                            break;
                        }
                    }
                    
                    // เติมข้อมูลอื่นๆ
                    const rateAmount = cells[2].textContent.trim().replace(/,/g, '');
                    document.getElementById('edit_rate_amount').value = parseFloat(rateAmount);
                    
                    // เปิด modal
                    document.getElementById('editModal').style.display = 'block';
                });
        }
        
        // Close Edit Modal
        function closeEditModal() {
            document.getElementById('editModal').style.display = 'none';
        }
        
        // Submit Edit Form
        function submitEditForm() {
            const form = document.getElementById('editForm');
            const formData = new FormData(form);
            
            fetch(window.location.href, {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(html => {
                if (html.includes('ແກ້ໄຂອັດຕາແລກປ່ຽນສຳເລັດແລ້ວ')) {
                    Swal.fire({
                        icon: 'success',
                        title: 'ສຳເລັດ!',
                        text: 'ແກ້ໄຂອັດຕາແລກປ່ຽນສຳເລັດແລ້ວ',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    const tempDiv = document.createElement('div');
                    tempDiv.innerHTML = html;
                    const alertDiv = tempDiv.querySelector('.alert-error');
                    const errorMessage = alertDiv ? alertDiv.textContent.trim() : 'ເກີດຂໍ້ຜິດພາດ';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'ຜິດພາດ',
                        text: errorMessage
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'ຜິດພາດ',
                    text: 'ເກີດຂໍ້ຜິດພາດໃນການສົ່ງຂໍ້ມູນ'
                });
            });
        }
        
        // Delete Rate Function
        function deleteRate(id) {
            Swal.fire({
                title: 'ຢືນຢັນການລຶບ',
                text: "ຕ້ອງການລຶບອັດຕານີ້ບໍ່?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'ລຶບ',
                cancelButtonText: 'ຍົກເລີກ'
            }).then((result) => {
                if (result.isConfirmed) {
                    // TODO: Implement delete functionality
                    Swal.fire({
                        title: 'ກຳລັງພັດທະນາ',
                        text: 'ຟັງຊັ້ນລຶບກຳລັງພັດທະນາ',
                        icon: 'info',
                        confirmButtonText: 'ຕົກລົງ'
                    });
                }
            });
        }

        // Show success message if exists
        <?php if ($message_type === 'success'): ?>
            Swal.fire({
                icon: 'success',
                title: 'ສຳເລັດ!',
                text: '<?php echo $message; ?>',
                timer: 3000,
                showConfirmButton: false
            });
        <?php elseif ($message_type === 'error'): ?>
            Swal.fire({
                icon: 'error',
                title: 'ຜິດພາດ',
                text: '<?php echo $message; ?>'
            });
        <?php endif; ?>
    </script>

    <style>
        .btn-suggestion {
            background: #17a2b8;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            font-size: 12px;
            cursor: pointer;
            margin-top: 5px;
        }

        .suggestion-list {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin: 20px 0;
        }

        .suggestion-item {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 10px;
            border-radius: 6px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .suggestion-item:hover {
            background: #e9ecef;
            border-color: #007bff;
        }

        .rate-info-box {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }

        .rate-info-box h4 {
            margin: 0 0 15px 0;
            color: #495057;
        }

        .rate-info-box ul {
            margin: 0;
            padding-left: 20px;
        }

        .rate-info-box li {
            margin-bottom: 5px;
            color: #6c757d;
        }

        .rate-code {
            background: #e3f2fd;
            color: #1976d2;
            padding: 4px 8px;
            border-radius: 4px;
            font-family: monospace;
            font-weight: 600;
        }

        .rate-amount {
            font-weight: 600;
            color: #28a745;
            font-size: 16px;
        }

        .rate-date {
            color: #6c757d;
        }
    </style>
</body>
</html>